//-*-c++-*-
#ifndef TULIP_LAYOUTPROXY_H
#define TULIP_LAYOUTPROXY_H


#include "PropertyProxy.h"
#include "MethodFactory.h"
#include "TemplateFactory.h"

class PropertyContext;
class SuperGraph;

///
class LayoutProxy:public PropertyProxy<PointType,LineType>
{
  ///
  friend class Layout;

public:
  ///
  static TemplateFactory<LayoutFactory,Layout,PropertyContext *> factory;

private:
  ///
  //  Coord max,min;
  STL_EXT_NS::hash_map<int,Coord> max,min;
  ///
  STL_EXT_NS::hash_map<int,bool> minMaxOk;
  ///
  void computeMinMax(SuperGraph * sg=NULL);
  ///
  Layout *currentLayout;

public:
  ///
  LayoutProxy (PropertyContext *context);
  ///
  LayoutProxy ();
  ///
  ~LayoutProxy();
  ///
  bool select(std::string , std::string &);
  ///
  bool computeOtherLayout(std::string , std::string &);

  //=======================================
  //Functions for extra layout information
  Coord getMax(SuperGraph *sg=0);
  Coord getMin(SuperGraph *sg=0);

  //============================================
  //Functions for layout modification
  ///
  void center();
  ///
  void normalize() _DEPRECATED;
  ///
  void perfectAspectRatio();
  ///
  void reset_handler();
  ///
  void recompute_handler();
  ///
  void resetBoundingBox();
  ///
  void clone_handler(PropertyProxy<PointType,LineType> &);
  
  virtual void setNodeValue_handler(const node n);
  virtual void setEdgeValue_handler(const edge e);
  virtual void setAllNodeValue_handler();
  virtual void setAllEdgeValue_handler();


};

#endif










