//-*-c++-*-
#ifndef TULIP_INTPROXY_H
#define TULIP_INTPROXY_H

#include "PropertyProxy.h"
#include "MethodFactory.h"
#include "TemplateFactory.h"

class Ggraph;
class PropertyContext;

///
class IntProxy:public PropertyProxy<IntType,IntType>
{ 
  ///
  friend class Int;

public:
  static TemplateFactory<IntFactory,Int,PropertyContext *> factory;

private:
  ///
  int maxN,minN,maxE,minE;
  ///
  bool minMaxOk;
  ///
  void computeMinMax();
  ///
  Int *currentInt;

public :
  ///
  IntProxy (PropertyContext *context);
  ///
  ~IntProxy();
  ///
  bool select(std::string , std::string &);
  
  //==========================================
  //Fonction apportant des informations 
  //supplmentaire sur la mtrique
  ///
  IntType::RealType  getNodeMin();
  ///
  IntType::RealType  getNodeMax();
  ///
  IntType::RealType  getEdgeMin();
  ///
  IntType::RealType  getEdgeMax();
  ///
  void reset_handler();
  ///
  void recompute_handler();
  ///
  void clone_handler(PropertyProxy<IntType,IntType> &);
};



#endif

