#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cmath>
#include <tulip/Size.h>
#include <tulip/Coord.h>
#include "tulip/Glyph.h"

Glyph::Glyph(GlyphContext *gc)
{
  if (gc!=NULL) {
    superGraph=gc->superGraph;
    glGraph=gc->glGraph;
    LOF=gc->LOF;
    LOD=gc->LOD;
  }
  else {
    (void *)superGraph = (void *)glGraph = (void *)NULL;
    LOD=LOF=0;
  }
}

Glyph::~Glyph()
{
}

void Glyph::setLOF(int n) {
  LOF = ((n<0) ? 0 : ((n > 10) ? 10 : n));
}

int Glyph::getLOF() {return LOF;}

void Glyph::setLOD(int n) {
  LOD = ((n<0) ? 0 : ((n > 10) ? 10 : n));
}

int Glyph::getLOD() {return LOD;}

void Glyph::setMaterial(const Color &C) {
  float color[4] = { 0.0, 0.0, 0.0, 1.0 };
  color[0]=((float)C.getR())/255;
  color[1]=((float)C.getG())/255;
  color[2]=((float)C.getB())/255;
  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, color);
}

Coord Glyph::getAnchor(const Coord &nodeCenter, const Coord &from, const Size &scale) const
{
   Coord anchor = from - nodeCenter;
   //it would be more "correct" to apply the following computation
   //however this is the way we can get edges not connected in direction of the center
   //of the glyph, depending of its scale ratio
   //anchor /= Coord(scale.getW(), scale.getH(), scale.getD());
   anchor = this->getAnchor(anchor);
   anchor *= Coord(scale.getW(), scale.getH(), scale.getD());
   anchor += nodeCenter;
   return anchor;
}

Coord Glyph::getAnchor(const Coord &vector) const
{
  Coord anchor = vector;
  /* anchor must be on the surface of a sphere centered on nodecenter, radius is 0.5 */
  anchor *= (0.5 / anchor.norm());
  return anchor;
}
