#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tulip/SubGraph.h>
#include <tulip/Cluster.h>
#include <tulip/LayoutProxy.h>
#include "tulip/GlGraph.h"

DataSet GlGraph::getParameters() const
{
  TRACE_EXEC();
  DataSet data;

  data.set("glyphTable", getGlyphTable());

  //Color
  data.set("backgroundColor", backgroundColor);
  //bool
  data.set("_viewArrow", _viewArrow);
  data.set("_viewLabel", _viewLabel);
  data.set("_viewKey", _viewKey);
  data.set("_viewStrahler", _viewStrahler);
  data.set("_viewAutoScale", _viewAutoScale);
  data.set("_incrementalRendering", _incrementalRendering);
  data.set("_edgeColorInterpolate", _edgeColorInterpolate);
  data.set("_edge3D", _edge3D);

  //unsigned int
  data.set("_viewOrtho", _viewOrtho);
  data.set("_FontsType", _FontsType);

  //int
  data.set("SupergraphId", _superGraph->getId());
  
  //Coord
  data.set("sceneTranslation", getSceneTranslation());
  data.set("sceneRotation", getSceneRotation());
  data.set("cameraEyes", cameraEyes);
  data.set("cameraCenter", cameraCenter);
  data.set("cameraUp", cameraUp);
  data.set("cameraZoomFactor", cameraZoomFactor);
  data.set("distCam", distCam);

  return data;
}

static SuperGraph *findSuperGraphById(SubGraph *rootsubgraph, const int id)
{
  SubGraph *subgraph = rootsubgraph;
  if (subgraph->getAssociatedSuperGraph()->getId() == id)
    return subgraph->getAssociatedSuperGraph();

  std::list<SubGraph *> *list = subgraph->getSubGraphChildren();
  for (std::list<SubGraph *>::const_iterator l= list->begin();
       l != list->end();
       ++l)
    {
      subgraph = *l;
      if (subgraph != rootsubgraph) {
	SuperGraph *sg = findSuperGraphById(subgraph, id);
	if (sg != NULL) return sg;
      }
    }

  return NULL;
}

void GlGraph::setParameters(const DataSet data)
{
  TRACE_EXEC();
  int id;
  if (data.get<int>("SupergraphId", id)) {
    Cluster *cluster=_superGraph->getClusterTree();
    SubGraph *subgraph=cluster->getRootSubGraph();
    SuperGraph *sg = findSuperGraphById(subgraph, id);
    if (sg != NULL) {
      setSuperGraph(sg);
      LayoutProxy *tmp = getProxy<LayoutProxy>(sg, "viewLayout");
      if (tmp != elementLayout) this->init();
    }
  }
  
  GlyphTableString glyphtab;
  if (data.get<GlyphTableString>("glyphTable", glyphtab)) setGlyphTable(glyphtab);

  Color color;
  if (data.get<Color>("backgroundColor", color)) backgroundColor=color;

  bool b;
  if (data.get<bool>("_viewArrow", b)) _viewArrow=b;
  if (data.get<bool>("_viewLabel", b)) _viewLabel=b;
  if (data.get<bool>("_viewKey", b)) _viewKey=b;
  if (data.get<bool>("_viewStrahler", b)) _viewStrahler=b;
  if (data.get<bool>("_viewAutoScale", b)) _viewAutoScale=b;
  if (data.get<bool>("_incrementalRendering", b)) _incrementalRendering=b;
  if (data.get<bool>("_edgeColorInterpolate", b)) _edgeColorInterpolate=b;
  if (data.get<bool>("_edge3D", b)) _edge3D=b;

  unsigned int ui;
  if (data.get<unsigned int>("_viewOrtho", ui)) _viewOrtho=ui;
  if (data.get<unsigned int>("_FontsType", ui)) _FontsType=ui;

  this->goodScale();

  //restore all view parameters or none
  Coord st,sr,ce,cc,cu;
  double czf;
  GLfloat dc;

  if (data.get<Coord>("sceneTranslation", st)
      && data.get<Coord>("sceneRotation", sr)
      && data.get<Coord>("cameraEyes", ce)
      && data.get<Coord>("cameraCenter", cc)
      && data.get<Coord>("cameraUp", cu)
      && data.get<double>("cameraZoomFactor", czf)
      &&data.get<GLfloat>("distCam", dc))
    {
      setSceneTranslation(st);
      setSceneRotation(sr);
      cameraEyes = ce; cameraCenter = cc; cameraUp = cu;
      cameraZoomFactor = czf;
      distCam = dc;
    }
}
//====================================================
Camera GlGraph::getCamera() const {
  return Camera(cameraCenter,cameraEyes,cameraUp,cameraZoomFactor);
}
void GlGraph::setCamera(const Camera &cam) {
  cameraCenter=cam.center;
  cameraEyes=cam.eyes;
  cameraUp=cam.up;
  cameraZoomFactor=cam.zoomFactor;
}
//====================================================
bool GlGraph::isViewKey()const {return (_viewKey);}
void GlGraph::setViewKey(bool b){_viewKey=b;}
//====================================================
unsigned int GlGraph::fontsType()const {return (_FontsType);}
void GlGraph::setFontsType(unsigned int i){_FontsType=i;}
//====================================================
bool GlGraph::isIncrementalRendering() const {return (_incrementalRendering);}
void GlGraph::setIncrementalRendering(const bool b) {
  strategy->MakeCurrent();
  strategy->setDoubleBuffering(b);
  _incrementalRendering=b;
}
//====================================================
bool GlGraph::isViewArrow() const {return (_viewArrow);}
void GlGraph::setViewArrow(const bool b){_viewArrow=b;}
//====================================================
bool GlGraph::isViewOrtho() const {return (_viewOrtho);}
void GlGraph::setViewOrtho(const bool b){_viewOrtho=b;}
//====================================================
bool GlGraph::isViewStrahler() const {return (_viewStrahler);}
void GlGraph::setViewStrahler(const bool b){
  _viewStrahler=b;
  if (b) buildOrderedList();
}
//====================================================
bool GlGraph::isEdged3D() const {return _edge3D;}
void GlGraph::setEdge3D(const bool b) {_edge3D=b;}
//====================================================
bool GlGraph::isViewLabel()const {return (_viewLabel);}
void GlGraph::setViewLabel(const bool b){_viewLabel=b;}
//====================================================
bool GlGraph::isEdgeColorInterpolate()const {return (_edgeColorInterpolate);}
void GlGraph::setEdgeColorInterpolate(const bool b){_edgeColorInterpolate=b;}
//====================================================
//Fonction de paramtrage de la fentre openGl
//====================================================
Color GlGraph::getBackgroundColor() const {return backgroundColor;}
void GlGraph::setBackgroundColor(int r,int v,int b){
  backgroundColor.set(r,v,b);
}
//====================================================
void GlGraph::getWinParameters(int *winX, int *winY, int *winW, int *winH, GLint *vp[4])
{
  *winX = this->winX;
  *winY = this->winY;
  *winW = this->winW;
  *winH = this->winH;
  for (int i=0; i<4; ++i)
    (*vp)[i]=this->vp[i];
}
