#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <sstream>
#include <GL/gl.h>
#include <GL/glu.h>

#include <tulip/SelectionProxy.h>
#include <tulip/StringProxy.h>
#include <tulip/MetricProxy.h>
#include <tulip/IntProxy.h>
#include <tulip/LayoutProxy.h>
#include <tulip/SizesProxy.h>
#include "tulip/GlLines.h"
#include "tulip/GlGraph.h"
#include "tulip/Glyph.h"

using namespace std;

//this is used to sort node or edges from a select buffer according to their depth
template<class Element>
struct lessElementZ : public std::binary_function<Element, Element, bool> {
  GLuint (*v)[4];
  GLint hits;
  bool operator()(Element e1, Element e2) {
    GLuint z1, z2;
    for (int i=0; i<hits; ++i) {
      if (e1.id == v[i][3]) z1 = v[i][1]/2 + v[i][2]/2;
      if (e2.id == v[i][3]) z2 = v[i][1]/2 + v[i][2]/2;
    }
    return z1 < z2;
  }
};

//=====================================================
//Selection d'objet dans le monde 3D
//=====================================================
void GlGraph::initDoSelect(GLint x, GLint y, GLint w,GLint h) {
  strategy->MakeCurrent();
  selectBuf=new GLuint[(_superGraph->numberOfEdges()+_superGraph->numberOfNodes())][4];
  glSelectBuffer((_superGraph->numberOfEdges()+_superGraph->numberOfNodes())*4 , (GLuint *)selectBuf);
  glRenderMode(GL_SELECT);
  glInitNames();
  glPushName(~0);
  glViewport(0, 0, winW, winH);
  glGetIntegerv(GL_VIEWPORT, vp);
  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  gluPickMatrix(x, y, w, h, vp);
  initProjection(false);

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glPolygonMode(GL_FRONT, GL_FILL);
  glDisable(GL_LIGHTING);
  initModelView();
}
//=====================================================
void GlGraph::endSelect() {
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
  glMatrixMode(GL_PROJECTION);
  glPopMatrix();
  glRenderMode(GL_RENDER);
}

//=====================================================
bool GlGraph::doNodeSelect(GLint x, GLint y,const int w , const int h, set<node> &sNode) {
  GLint hits;
  initDoSelect(x,y,w,h);
  makeNodeSelect(0);
  glFlush();
  hits = glRenderMode(GL_RENDER);
  if (hits <= 0) {delete [] selectBuf; endSelect(); return false;}
  while(hits>0) {
    node tmp;
    tmp.id = selectBuf[hits-1][3];
    sNode.insert(tmp);
    hits--;
  }
  delete [] selectBuf;
  endSelect();
  return true;
}
//=====================================================
bool GlGraph::doNodeSelect(const int x, const int y, vector<node> &vNode)
{
  GLint hits;
  initDoSelect(x,y,4,4);
  makeNodeSelect(0);
  glFlush();
  hits = glRenderMode(GL_RENDER);
  if (hits <= 0) {delete [] selectBuf; endSelect(); return false;}
  struct lessElementZ<node> comp;
  comp.v = selectBuf;
  comp.hits = hits;
  while(hits>0) {
    node tmp;
    tmp.id = selectBuf[hits-1][3];
    vNode.push_back(tmp);
    hits--;
  }
  sort(vNode.begin(), vNode.end(), comp);
  delete [] selectBuf;
  endSelect();
  return true;
}
//=====================================================
bool GlGraph::doEdgeSelect(GLint x, GLint y,const int w , const int h, set<edge> &sEdge)
{
  GLint hits;
  initDoSelect(x,y,w,h);
  makeEdgeSelect(0);
  glFlush();
  hits = glRenderMode(GL_RENDER);
  if (hits <= 0) {delete [] selectBuf; endSelect(); return false;}
  while(hits>0) {
    edge tmp;
    tmp.id = selectBuf[hits-1][3];;
    sEdge.insert(tmp);
    hits--;
  }
  delete [] selectBuf;
  endSelect();
  return true;
}
//=====================================================
bool GlGraph::doEdgeSelect(const int x, const int y, vector<edge> &vEdge)
{
  GLint hits;
  initDoSelect(x,y,4,4);
  makeEdgeSelect(0);
  glFlush();
  hits = glRenderMode(GL_RENDER);
  if (hits <= 0) {delete [] selectBuf; endSelect(); return false;}
  struct lessElementZ<edge> comp;
  comp.v = selectBuf;
  comp.hits = hits;
  while(hits>0) {
    edge tmp;
    tmp.id = selectBuf[hits-1][3];;
    vEdge.push_back(tmp);
    hits--;
  }
  sort(vEdge.begin(), vEdge.end(), comp);
  delete [] selectBuf;
  endSelect();
  return true;
}
//=====================================================
void GlGraph::doSelect(const int x, const int y, const int w ,const int h,
                       set<node> &sNode, set<edge> &sEdge)
{
#ifndef NDEBUG
  cerr << "bool GlGraph::doSelectALL" << endl;
#endif
  strategy->timerStop();
  glPushAttrib(GL_ALL_ATTRIB_BITS); 
  doNodeSelect(x,y,w,h,sNode);
  doEdgeSelect(x,y,w,h,sEdge);
  glPopAttrib();
  strategy->timerStart(0);
  //  cerr << "bool GlGraph::doSelect End" << endl;
}

bool GlGraph::doSelect(GLint x, GLint y, Tulip::AtomType &type ,node &n, edge &e )
{
#ifndef NDEBUG
  cerr << __PRETTY_FUNCTION__ << endl;
#endif
  strategy->timerStop();
  glPushAttrib(GL_ALL_ATTRIB_BITS); 
  bool result;
  vector<node> tmpSetNode;
  result=doNodeSelect(x+2, winH-y-2, tmpSetNode);
  if (result){
    n=(*(tmpSetNode.begin()));
    type = Tulip::NODE;
  }
  else { 
    type = Tulip::EDGE;
    vector<edge> tmpSetEdge;
    result=doEdgeSelect(x+2, winH-y-2, tmpSetEdge);
    if (result) e=(*(tmpSetEdge.begin()));
  }
  glPopAttrib();
  strategy->timerStart(0);
  return result;
  //  cerr << "bool GlGraph::doSelect End" << endl;
}
//====================================lines================
//Construction des objets avec affectation de nom
//======================================================================
//Placement des sommets du graphe  l'index i=startIndex..startIndex+n-1
void GlGraph::makeNodeSelect(int startIndex)
{
  glMatrixMode(GL_MODELVIEW);
  int i=startIndex;
  Coord tmpCoord;
  Iterator<node> *itN=_superGraph->getNodes();
  for (;itN->hasNext();) {
    node itv=itN->next();
    glLoadName(itv.id);
    tmpCoord=elementLayout->getNodeValue(itv);	  
    glPushMatrix();
    glTranslatef( tmpCoord.getX() , tmpCoord.getY() , tmpCoord.getZ() );
    Size nSize=elementSize->getNodeValue(itv);
    glScalef(nSize.getW(), nSize.getH(), nSize.getD());

    int index = elementShape->getNodeValue(itv);
    if (glyphTable.find(index) == glyphTable.end())
      index=0;
    glyphTable[index]->draw(itv);

    glPopMatrix();
    ++i;
  }delete itN;
}
//=================================================================
//Placement des artes du graphe  l'index i=startIndex..startIndex+n-number_of_edges
void GlGraph::makeEdgeSelect(int startIndex) {
  glMatrixMode(GL_MODELVIEW);
  int i=startIndex;
  Coord tmpCoord;
  Coord tmpCoord2;
  Color tmp(255,255,255,100);
  Iterator<edge> *itE=_superGraph->getEdges();
  for (;itE->hasNext();) {
    edge ite=itE->next();
    glLoadName(ite.id);
    tmpCoord=elementLayout->getNodeValue(_superGraph->source(ite));
    tmpCoord2=elementLayout->getNodeValue(_superGraph->target(ite));
    LineType::RealType &lCoord=elementLayout->getEdgeValue(ite);
    Coord startCoord = (lCoord.size() == 0 ? tmpCoord2 : lCoord.front());
    Coord finalCoord = (lCoord.size() == 0 ? tmpCoord : lCoord.back());
    drawEdge(startCoord, finalCoord, tmpCoord, lCoord, tmpCoord2,
             tmp, tmp, elementSize->getEdgeValue(ite), elementShape->getEdgeValue(ite), true);
    ++i;
  }delete itE;
}
//====================================================
/*
void GlGraph::selectItem(GLint x, GLint y) {
  bool result;
  Tulip::AtomType type;
  node tmpNode;
  edge tmpEdge;
  MetricProxy *metric=getProxy<MetricProxy>(_superGraph,"viewMetric");
  result=doSelect(x,y,type,tmpNode,tmpEdge);
  if (result==true) {
    stringstream str;
    if (type == NODE) {
      str << "\nNode id :" << tmpNode.id;
      if (metric!=NULL) {
	str << "\n" << metric->getName() << ": ";
	str << metric->getNodeValue(tmpNode);
      }
      str << "\nLabel :" << elementLabel->getNodeValue(tmpNode).c_str();
      str << strategy->outputGetText();
      strategy->outputSetText(str.str());
    }
    else if (type == EDGE) {
      str << "\nEdge selected";
      str << "\nLabel :";
      str << elementLabel->getEdgeValue(tmpEdge).c_str();
      str << strategy->outputGetText();
      strategy->outputSetText(str.str());
    }
  }
}
*/
//====================================================
/*
void GlGraph::addSelection(GLint x, GLint y) {
  Observable::holdObservers();
  bool result;
  Tulip::AtomType type;
  bool i;
  node tmpNode;
  edge tmpEdge;
  result=doSelect(x,y,type,tmpNode,tmpEdge);
  if (result) {
    if (type == NODE)
      {
	  i=elementSelected->getNodeValue(tmpNode);
	  if (!i)
	    elementSelected->setNodeValue(tmpNode, true);
	  else
	    elementSelected->setNodeValue(tmpNode, false);
	}
      else  if (type == EDGE)
	{
	  i=elementSelected->getEdgeValue(tmpEdge);
	  if (!i)
	    elementSelected->setEdgeValue(tmpEdge, true);
	  else
	    elementSelected->setEdgeValue(tmpEdge, false);
	}   
    }
  Observable::unholdObservers();
}
*/
//====================================================
/*
void GlGraph::initAndSelect(GLint x, GLint y)
{
  //cerr << "GlGraph::initAndSelect" << endl;
  Observable::holdObservers();
  bool result;
  Tulip::AtomType type;
  node tmpNode;
  edge tmpEdge;
  elementSelected->setAllNodeValue(false);
  elementSelected->setAllEdgeValue(false);
  result=doSelect(x,y,type,tmpNode,tmpEdge);
  if (result==true) {
    if (type == NODE)
      elementSelected->setNodeValue(tmpNode, true);
    else if (type == EDGE)
      elementSelected->setEdgeValue(tmpEdge, true);
  }
  Observable::unholdObservers();
}  
*/
