#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <GL/glut.h>
#include <cmath>

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

#include <tulip/TlpTools.h>
#include "tulip/GlGraph.h"
#include "tulip/GlFonts.h"
#include "tulip/Glyph.h"

const Color colorSelect2= Color(255, 102, 255, 255);
//====================================================
void SetMat(const Color &C) {
  float color[4];
  color[0]=((float)C.getR())/255.0;
  color[1]=((float)C.getG())/255.0;
  color[2]=((float)C.getB())/255.0;
  color[3]=1.0;
  glMaterialfv( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, color );
}
//==================================================
///Build the open gl display list
void GlGraph::updateList() {
#ifndef NDEBUG
  cerr << "GlGraph::updalist "<< endl;
#endif
  //  strategy->MakeCurrent();

  metaGraphDL = makeCubeWireObject();
  objectCone = makeConeObject();
  selectionDL = makeSelectionObject();
  GlFonts::setTextureFont(TlpTools::TulipLibDir + "/tlp/bitmaps/" + "Fonts.bmp");
 
  //Ajouter le chargement de nouvelle forme :
  //Dfini utilisateur 3DS, VRML, ect
  //Fichier image, gif anim ect.
  //  cerr << "GlGraph::updalist Ok"<< endl;
}
//==================================================
void GlGraph::setGlyphTable(const GlyphTableString &v) {
  GlyphContext gc = GlyphContext(&_superGraph, this);
  GlyphTableGlyph glyphTable;

  for(GlyphTableString::const_iterator i = v.begin(); i != v.end(); ++i) {
    Glyph *glyph = glyphFactory.getObject(i->second, &gc);
    if (glyph != NULL) {
      glyphTable[i->first] = glyph;
    }
    else {
      cerr << "Warning: unknown glyph """ << i->second << """ at index "<< i->first <<" , using """ << glyphFactory.objMap.begin()->second->getName() << """ instead"<< endl;
      glyphTable[i->first] = glyphFactory.getObject(glyphFactory.objMap.begin()->first, &gc);
    }
  }
  this->setGlyphTable(glyphTable);
}
//==================================================
void GlGraph::setGlyphTable(const GlyphTableGlyph &v) {
  GlyphContext gc = GlyphContext(&_superGraph, this);

  //delete old glyphtable
  for(GlyphTableGlyph::const_iterator i = glyphTable.begin(); i != glyphTable.end(); ++i)
    delete i->second;
  
  this->glyphTable = v;
  int index = 0;
  for(GlyphTableGlyph::const_iterator i = v.begin(); i != v.end(); ++i)
    if (i->first >= index) index = i->first + 1;

  for(TemplateFactory<GlyphFactory,Glyph,GlyphContext *>::ObjectCreator::const_iterator it = glyphFactory.objMap.begin();
      it != glyphFactory.objMap.end();
      ++it) {
    GlyphTableGlyph::const_iterator i;
    
    for(i=glyphTable.begin(); i!=glyphTable.end(); ++i) {
      if (i->second->getName() == it->first) break;
    }
    if (i==glyphTable.end()) {       
      Glyph *glyph = glyphFactory.getObject(it->first, &gc);
      glyphTable[index++] = glyph;
    }
  }
}
//================================================================================
GlyphTableString GlGraph::getGlyphTable() const {
  GlyphTableString v;
  for(GlyphTableGlyph::const_iterator i=glyphTable.begin(); i != glyphTable.end(); ++i) {
    v[i->first] = i->second->getName();
  }
  return v;
}
//=========================================================================================================
//Calcul 3D,
//=========================================================================================================
//Calcul de la matrice de transformation pour le positionnement des flches sur les artes
void GlGraph::makeArrowMatrix(GLfloat *matrix, const Coord A, const Coord B, GLfloat sx, GLfloat sy, GLfloat sz) {
  GLfloat  xa,ya,za,xb,yb,zb;
  A.get(xa,ya,za);
  B.get(xb,yb,zb);

  //Coordonnes du centre
  GLfloat xm,ym,zm;
  //Vecteur AB
  GLfloat xab,yab,zab;
  //Vecteur V
  GLfloat xv,yv,zv;
  //Vecteur W
  GLfloat xw,yw,zw;

  //Calcul de M
  //  xm=(xa+xb)/2;ym=(ya+yb)/2;zm=(za+zb)/2;
  xm=xb;ym=yb;zm=zb;
  
  //Calcul de AB
  xab=xb-xa; if (fabs(xab)<0.001) xab=0;
  yab=yb-ya; if (fabs(yab)<0.001) yab=0;
  zab=zb-za; if (fabs(zab)<0.001) zab=0;

  //Normalisation de AB
  GLdouble dv,dab,dw;
  dab=sqrt(xab*xab + yab*yab 
+ zab*zab );
  if (fabs(dab)>0.0001) {
    xab=sx*xab/dab; yab=sx*yab/dab; zab=sx*zab/dab;
  }
  
  //  cerr << __FUNCTION__ << ": AB=(" << xab << "," << yab << "," << zab << ")" << endl;

  //Calcul de V
  if (fabs(xab)>0.001) {
    if (fabs(yab)>fabs(zab)) { xv=yab; yv=-xab; zv=0;}
    else { xv=zab; yv=0; zv=-xab;}
  }
  else if (fabs(yab)>0.001) {
    xv=0; yv=zab; zv=-yab;
  }
  else {
    xv=-zab; yv=0; zv=0;
  }

  //Calcul de W
  xw= yv*zab - zv*yab;
  yw= zv*xab - xv*zab;
  zw= xv*yab - yv*xab;

  /*
  dv=sqrt(xv*xv + yv*yv + zv*zv );
  if (fabs(dv)>0.00001) {
  xv=sy*xv/dv; yv=sy*yv/dv; zv=sy*zv/dv;
  }
  */

  dw=sqrt( xw*xw + yw*yw + zw*zw);
  if (fabs(dw)>0.0001) {
    xw=sz*xw/dw;
    yw=sz*yw/dw;
    zw=sz*zw/dw;
  }

  //  cerr << __FUNCTION__ << ": V=(" << xv << "," << yv << "," << zv << ")" << endl;
  //  cerr << __FUNCTION__ << ": W=(" << xw << "," << yw << "," << zw << ")" << endl;
  //On construit la matrice
  matrix[0]=xw;   matrix[1]=yw;    matrix[2]=zw;    matrix[3]=0;
  matrix[4]=xv;   matrix[5]=yv;    matrix[6]=zv;    matrix[7]=0;
  matrix[8]=xab;  matrix[9]=yab;   matrix[10]=zab;  matrix[11]=0;
  matrix[12]=xm;  matrix[13]=ym;   matrix[14]=zm;   matrix[15]=1;
}
//==========================================================================================================
//Construction des displayList
//==========================================================================================================
GLuint GlGraph::makeCubeWireObject() {
#ifndef NDEBUG
  cerr << "GlGraph::makeCubeObject()" << endl;
#endif
  strategy->MakeCurrent();
  GLuint LList;
  LList = glGenLists( 1 );
  glNewList( LList, GL_COMPILE ); 
  glPushAttrib(GL_POLYGON_BIT);
  glutWireCube(1);
  glPopAttrib();
  glEndList();
  //  cerr << "GlGraph::makeCubeObject() Ok" << endl;
  return LList;
}
GLuint GlGraph::makeConeObject() {
#ifndef NDEBUG
  cerr << __PRETTY_FUNCTION__ << endl;
#endif
  strategy->MakeCurrent();
  GLuint LList;
  GLUquadricObj *quadObj; 
  quadObj = gluNewQuadric();
  LList = glGenLists( 1 );
  glNewList( LList, GL_COMPILE );    
  glTranslatef(0, 0, -1.0);
  gluQuadricDrawStyle(quadObj, GLU_FILL);
  gluQuadricNormals(quadObj, GLU_SMOOTH);
  glutSolidCone(0.5, 1.0, 8, 1);
  gluQuadricOrientation(quadObj, GLU_INSIDE);
  gluDisk(quadObj, 0.0, 0.5, 8, 1);
  glEndList();
  gluDeleteQuadric(quadObj);
  return LList;
}
//====================================================
//Selection display list building
//====================================================
GLuint GlGraph::makeSelectionObject() {
#ifndef NDEBUG
  cerr << __PRETTY_FUNCTION__ << endl;
#endif
  strategy->MakeCurrent();
  GLuint LList;
  glMatrixMode(GL_MODELVIEW);
  LList = glGenLists(1);
  glNewList( LList, GL_COMPILE );
  glEnable(GL_BLEND);
  glDepthMask(GL_FALSE);
  glBlendFunc(GL_DST_COLOR,GL_SRC_COLOR);
  SetMat(colorSelect2);
  glutSolidSphere(1,30,30);
  glDepthMask(GL_TRUE);
  glDisable(GL_BLEND);
  glEndList();

  //cerr << "GlGraph::makeObject OK"<< endl;
  return LList;
}
