#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>

#include "tulip/GlGraph.h"

//====================================================
void GlGraph::initProjection(bool reset){
  //  strategy->MakeCurrent();
  glMatrixMode(GL_PROJECTION);
  if (reset) glLoadIdentity();
  if (_viewOrtho) 
    glOrtho(-distCam/2/cameraZoomFactor,distCam/2/cameraZoomFactor,-distCam/2/cameraZoomFactor,distCam/2/cameraZoomFactor,1.0,distCam*2);
  else
    glFrustum(-1.0, 1.0, -1.0, 1.0, 1.0*cameraZoomFactor, distCam*2);
}
//====================================================
void GlGraph::initModelView(){
  //  strategy->MakeCurrent();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  gluLookAt(cameraEyes[0],cameraEyes[1],cameraEyes[2], cameraCenter[0],cameraCenter[1],cameraCenter[2],cameraUp[0],cameraUp[1],cameraUp[2]); 
  initLights();
  glRotatef( sceneRotation[0], 1.0, 0.0, 0.0 ); 
  glRotatef( sceneRotation[1], 0.0, 1.0, 0.0 ); 
  glRotatef( sceneRotation[2], 0.0, 0.0, 1.0 );
  glTranslatef(sceneTranslation[0],sceneTranslation[1],sceneTranslation[2]);
}
//====================================================
void GlGraph::initLights(){
  //  strategy->MakeCurrent();
  GLfloat pos[4];
  cameraEyes.get(pos[0],pos[1],pos[2]);
  pos[3]=1;
  GLfloat amb[4] = {0.3,0.3 , 0.3 ,0.3};
  GLfloat dif[4] = {1,1,1,1};
  GLfloat specular[4] = {0,0,0,1};
  GLfloat attC[3] = {1,1,1};
  GLfloat attL[3] = {0,0,0};
  GLfloat attQ[3] = {0,0,0};

  GLfloat spotExp[1]= {0};
  GLfloat spotCut[1]= {180};

  glEnable( GL_LIGHTING );
  glEnable( GL_LIGHT0 );

  glLightfv( GL_LIGHT0, GL_POSITION, pos );
  glLightfv( GL_LIGHT0, GL_AMBIENT, amb );
  glLightfv( GL_LIGHT0, GL_DIFFUSE, dif );
  glLightfv( GL_LIGHT0, GL_CONSTANT_ATTENUATION, attC );
  glLightfv( GL_LIGHT0, GL_LINEAR_ATTENUATION, attL );
  glLightfv( GL_LIGHT0, GL_QUADRATIC_ATTENUATION, attQ );
  glLightfv( GL_LIGHT0, GL_SPECULAR , specular);

}
//====================================================
void GlGraph::initGlParameter() {
  glEnable(GL_LINE_SMOOTH);
  glBlendFunc(GL_SRC_ALPHA,GL_ONE);
  glHint(GL_LINE_SMOOTH_HINT,GL_DONT_CARE);
  glLineWidth(1.0);
  //  glShadeModel(GL_SMOOTH);
  glEnable(GL_CULL_FACE);
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_NORMALIZE);
  // glEnable( GL_NORMALIZE );
  glDepthFunc(GL_LEQUAL );
  glPolygonMode(GL_FRONT, GL_FILL);
  //  glPushAttrib(GL_COLOR_BUFFER_BIT);
  glColorMask(1, 1, 1, 1);
  glIndexMask(~0);
  glClearColor(backgroundColor.getRGL(), backgroundColor.getGGL(), backgroundColor.getBGL(), 1.0);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glEnable( GL_LIGHTING );
  glEnable( GL_LIGHT0 );
  //  glPopAttrib();
}
