/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "header.h"

void hash_safe_insert(GHashTable *table, gchar *key, gchar *value){
    gpointer orig_key;
    gpointer orig_value;

    if (g_hash_table_lookup_extended(table, (gpointer) key, &orig_key, &orig_value)) {
        g_hash_table_remove(table, orig_key);
        g_free(orig_key);
        g_free(orig_value);
    }
    g_hash_table_insert(table, key, value);
}

gboolean free_gstr(gpointer key, gpointer value, gpointer user_data){
    if (key)       g_free(key);
    if (value)     g_free(value);
    if (user_data) g_free(user_data);

    return TRUE;
}

void free_hash(GHashTable *hash){
    if (!hash) return;
    g_hash_table_foreach_remove(hash, free_gstr, NULL);
    g_hash_table_destroy(hash);
}

