/*************************************************************************
 *	Time Traveling File Manager (TTFM)	
 *************************************************************************	
 *	Copyright (C) Sandeep Dilip Ranade 2005 - 2006 
 *************************************************************************	
 *	TTFM is free software; you can redistribute it 
 *	and/or modify it under the terms of the GNU General Public 
 *	License	as published by the Free Software Foundation; either 
 *	version 2, or (at your option) any later version.
 *
 *	TTFM is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with GNU CC; see the file COPYING.  If not, write to
 *	the Free Software Foundation, 59 Temple Place - Suite 330,
 *	Boston, MA 02111-1307, USA.
 *************************************************************************/ 
#include <qdir.h>
#include <qfileinfo.h> 
#include <qcolor.h>
#include <qtimer.h> 
#include <qprocess.h> 
#include <qstringlist.h> 
#include <qregexp.h> 
#include <about_ttfs_form.h>
#include <bookmark_form.h>
#include <qapplication.h>
#include <qfileinfo.h>
#include <qptrstack.h> 
#include <stdio.h>

#ifdef TTFS_DEBUG
#define PDEBUG(fmt, arg ...)    printf("ttfs: %s:"fmt, __FUNCTION__, ## arg);
#else
#define PDEBUG(fmt, arg...)
#endif

void bookmark_form::init()
{
	PDEBUG ("initing the bookmark_form\n");
}


void bookmark_form::do_add_bookmark()
{    
	status_bar->clear();
	PDEBUG ("Adding bookmark named[%s] for path [%s] in directory [%s]\n",
			(const char *) bm_name_line_edit->text(),  
			(const char *) bm_path_name->text(),
			(const char *) bm_dir_name->text());

	if (bm_name_line_edit->text() == "") {	
		status_bar->setText("Empty Name");
		return;
	}
	status_bar->clear();
	char buf[BUFSIZ];

	QRegExp regexp = QRegExp( "^[/|*|&|%|$|#|@|\"]'", true, false);
	QString valid = bm_name_line_edit->text();
	char invalid[] = {'/', '*', '&', '%', '#', '@', '"', '$', '^', 
		'`', '|', '?' };
	for (int i = 0; i < 12; i++) {
		int ret = valid.contains(invalid[i]);	
		PDEBUG ("contains returned %d for character %c\n", 
				ret, invalid[i]);
		if (ret != 0) {
			PDEBUG ("Invalid string .. contains %c\n", invalid[i]);
			status_bar->setText("Invalid Name (no"
					" /*^&%$#@\"`| allowed) ");
			return;
		}
	}
	PDEBUG ("Creating link\n");
	status_bar->setText("Valid Name");
	// ln -s <target> <link name>
	snprintf(buf, BUFSIZ, "ln -s %s \"%s%s\" ", 
			(const char *) bm_path_name->text(),
			(const char *) bm_dir_name->text(), 
			(const char *) bm_name_line_edit->text());
	PDEBUG ("cmdline: %s\n", buf);
	int ret = system(buf);
	PDEBUG ("system returned %d\n", ret);
	if (ret != 0) {
		status_bar->setText("Failed to create bookmark");
		return;
	}
	bookmark_form::close();
}
