/*
 * class InfoAST (derived from CommonAST):
 * An AST node class providing additional line and column information
 *
 * Copyright (C) 2001 Michael Schmitt <schmitt@itm.mu-luebeck.de>
 *
 *    Institute for Telematics,
 *    Medical University of Luebeck,
 *    Ratzeburger Allee 160,
 *    23538 Luebeck,
 *    Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef INC_InfoAST_hpp__
#define INC_InfoAST_hpp__

#include <map>
#include "antlr/CommonAST.hpp"

ANTLR_BEGIN_NAMESPACE(antlr)

typedef RefCount< ANTLR_USE_NAMESPACE(std)string > RefString;


class InfoAST : public CommonAST 
{
  public:

    InfoAST();
    InfoAST( RefToken t );

    void initialize( int t, const ANTLR_USE_NAMESPACE(std)string& txt );
    void initialize( RefAST t );
    void initialize( RefToken t );

    int getLine() const;
    void setLine( int line );

    int getColumn() const;
    void setColumn( int column );

    const ANTLR_USE_NAMESPACE(std)string &getFilename() const;

  static RefAST factory(); // required for ANTLRs factory design pattern

  private:

  int         _line, _column; // Line and column of syntactic element to which AST node belongs
  RefString   _filename; // currently not used!!!

    static ANTLR_USE_NAMESPACE(std)map< RefString, RefString >   _filenames;
};


typedef ASTRefCount< InfoAST >   RefInfoAST; // ASTRefCount provides some java-like smart management of dynamic memory

ANTLR_END_NAMESPACE

#endif // INC_InfoAST_hpp__
