// inst.c - TMS9900 Series and GPL Instruction Table
//
// Copyright (c) 2001, Timothy M. Stark
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// TIMOTHY M STARK BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
// IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name of Timothy M Stark shall not
// be used in advertising or otherwise to promote the sale, use or other 
// dealings in this Software without prior written authorization from
// Timothy M Stark.
 
#include "ti99/defs.h"

// ********************************
// TMS9900 Series Assembly Language
// ********************************

#define A    "Add"
#define AB   "Add Bytes"
#define ABS  "Absolute Value"
#define AI   "Add Immediate"
#define ANDI "AND Immediate"
#define B    "Branch"
#define BL   "Branch and Link"
#define BLWP "Branch and Load Workplace Pointer"
#define C    "Compare"
#define CB   "Compare Bytes"
#define CI   "Compare Immediate"
#define CKOF "Clock Off"
#define CKON "Clock On"
#define CLR  "Clear"
#define COC  "Compare Ones Corresponding"
#define CZC  "Compare Zeros Corresponding"
#define DEC  "Decrement"
#define DECT "Decrement by Two"
#define DIV  "Divide"
#define IDLE "Computer Idle"
#define INC  "Increment"
#define INCT "Increment by Two"
#define INV  "Invert"
#define JEQ  "Jump if Equal"
#define JGT  "Jump if Greater Than"
#define JH   "Jump if High"
#define JHE  "Jump if High or Equal"
#define JL   "Jump if Low"
#define JLE  "Jump if Low or Equal"
#define JLT  "Jump if Less Than"
#define JMP  "Jump unconditionally"
#define JNC  "Jump if No Carry"
#define JNE  "Jump if Not Equal"
#define JNO  "Jump if No Overflow"
#define JOC  "Jump On Carry"
#define JOP  "Jump if Odd Parity"
#define LDCR "Load Communication Register"
#define LI   "Load Imemdiate"
#define LIMI "Load Interrupt Mask Immediate"
#define LREX "Load or Restart Execution"
#define LWPI "Load Workplace Pointer Immediate"
#define MOV  "Move"
#define MOVB "Move Bytes"
#define MPY  "Multiply"
#define NEG  "Negate"
#define NOP  "No Operation"
#define ORI  "OR Immediate"
#define RSET "Reset"
#define RT   "Return"
#define RTWP "Return Workplace Pointer"
#define S    "Subtract"
#define SB   "Subtract Bytes"
#define SBO  "Set Bit to One"
#define SBZ  "Set Bit to Zero"
#define SETO "Set to Ones"
#define SLA  "Shift Left Arithmetic"
#define SOC  "Set Ones Corresponding"
#define SOCB "Set Ones Corresponding Bytes"
#define SRA  "Shift Right Arithmetic"
#define SRC  "Shift Circular"
#define SRL  "Shift Right Logical"
#define STCR "Store Communication Register"
#define STST "Store Status Register"
#define STWP "Store Workplace Register"
#define SWPB "Swap Bytes"
#define SZC  "Set Zeros Corresponding"
#define SZCB "Set Zeros Corresponding Bytes"
#define TB   "Test Bit"
#define X    "Execute"
#define XOP  "Extended Operation"
#define XOR  "Exclusive OR"

TI99_INST ti99_Inst[] =
{
	{ "A",    A,    0xA000, 0xF000, 1, 0, INSNAME(ti99, A)    },
	{ "AB",   AB,   0xB000, 0xF000, 1, 0, INSNAME(ti99, AB)   },
	{ "ABS",  ABS,  0x0740, 0xFFC0, 6, 0, INSNAME(ti99, ABS)  },
	{ "AI",   AI,   0x0220, 0xFFF0, 8, 0, INSNAME(ti99, AI)   },
	{ "ANDI", ANDI, 0x0240, 0xFFF0, 8, 0, INSNAME(ti99, ANDI) },
	{ "B",    B,    0x0440, 0xFFC0, 6, 0, INSNAME(ti99, B)    },
	{ "BL",   BL,   0x0680, 0xFFC0, 6, 0, INSNAME(ti99, BL)   },
	{ "BLWP", BLWP, 0x0400, 0xFFC0, 6, 0, INSNAME(ti99, BLWP) },
	{ "C",    C,    0x8000, 0xF000, 1, 0, INSNAME(ti99, C)    },
	{ "CB",   CB,   0x9000, 0xF000, 1, 0, INSNAME(ti99, CB)   },
	{ "CI",   CI,   0x0280, 0xFFF0, 8, 0, INSNAME(ti99, CI)   },
	{ "CKOF", CKOF, 0x03C0, 0xFFFF, 7, 0, INSNAME(ti99, CKOF) },
	{ "CKON", CKON, 0x03A0, 0xFFFF, 7, 0, INSNAME(ti99, CKON) },
	{ "CLR",  CLR,  0x04C0, 0xFFC0, 6, 0, INSNAME(ti99, CLR)  },
	{ "COC",  COC,  0x2000, 0xFC00, 3, 0, INSNAME(ti99, COC)  },
	{ "CZC",  CZC,  0x2400, 0xFC00, 3, 0, INSNAME(ti99, CZC)  },
	{ "DEC",  DEC,  0x0600, 0xFFC0, 6, 0, INSNAME(ti99, DEC)  },
	{ "DECT", DECT, 0x0640, 0xFFC0, 6, 0, INSNAME(ti99, DECT) },
	{ "DIV",  DIV,  0x3C00, 0xFFC0, 9, 0, INSNAME(ti99, DIV)  },
	{ "IDLE", IDLE, 0x0340, 0xFFFF, 7, 0, INSNAME(ti99, IDLE) },
	{ "INC",  INC,  0x0580, 0xFFC0, 6, 0, INSNAME(ti99, INC)  },
	{ "INCT", INCT, 0x05C0, 0xFFC0, 6, 0, INSNAME(ti99, INCT) },
	{ "INV",  INV,  0x0540, 0xFFC0, 6, 0, INSNAME(ti99, INV)  },
	{ "JEQ",  JEQ,  0x1300, 0xFF00, 2, 0, INSNAME(ti99, JEQ)  },
	{ "JGT",  JGT,  0x1500, 0xFF00, 2, 0, INSNAME(ti99, JGT)  },
	{ "JH",   JH,   0x1B00, 0xFF00, 2, 0, INSNAME(ti99, JH)   },
	{ "JHE",  JHE,  0x1400, 0xFF00, 2, 0, INSNAME(ti99, JHE)  },
	{ "JL",   JL,   0x1A00, 0xFF00, 2, 0, INSNAME(ti99, JL)   },
	{ "JLE",  JLE,  0x1200, 0xFF00, 2, 0, INSNAME(ti99, JLE)  },
	{ "JLT",  JLT,  0x1100, 0xFF00, 2, 0, INSNAME(ti99, JLT)  },
	{ "JMP",  JMP,  0x1000, 0xFF00, 2, 0, INSNAME(ti99, JMP)  },
	{ "JNC",  JNC,  0x1700, 0xFF00, 2, 0, INSNAME(ti99, JNC)  },
	{ "JNE",  JNE,  0x1600, 0xFF00, 2, 0, INSNAME(ti99, JNE)  },
	{ "JNO",  JNO,  0x1900, 0xFF00, 2, 0, INSNAME(ti99, JNO)  },
	{ "JOC",  JOC,  0x1800, 0xFF00, 2, 0, INSNAME(ti99, JOC)  },
	{ "JOP",  JOP,  0x1C00, 0xFF00, 2, 0, INSNAME(ti99, JOP)  },
	{ "LDCR", LDCR, 0x3000, 0xFC00, 4, 0, INSNAME(ti99, LDCR) },
	{ "LI",   LI,   0x0200, 0xFFF0, 8, 0, INSNAME(ti99, LI)   },
	{ "LIMI", LIMI, 0x0300, 0xFFFF, 8, 0, INSNAME(ti99, LIMI) },
	{ "LREX", LREX, 0x03E0, 0xFFFF, 7, 0, INSNAME(ti99, LREX) },
	{ "LWPI", LWPI, 0x02E0, 0xFFFF, 8, 0, INSNAME(ti99, LWPI) },
	{ "MOV",  MOV,  0xC000, 0xF000, 1, 0, INSNAME(ti99, MOV)  },
	{ "MOVB", MOVB, 0xD000, 0xF000, 1, 0, INSNAME(ti99, MOVB) },
	{ "MPY",  MPY,  0x3800, 0xFFC0, 9, 0, INSNAME(ti99, MPY)  },
	{ "NEG",  NEG,  0x0500, 0xFFC0, 6, 0, INSNAME(ti99, NEG)  },
	{ "NOP",  NOP,  0x1000, 0xFFFF, 0, 0, NULL                },
	{ "ORI",  ORI,  0x0260, 0xFFF0, 8, 0, INSNAME(ti99, ORI)  },
	{ "RSET", RSET, 0x0360, 0xFFFF, 7, 0, INSNAME(ti99, RSET) },
	{ "RT",   RT,   0x045B, 0xFFFF, 0, 0, NULL                },
	{ "RTWP", RTWP, 0x0380, 0xFFFF, 7, 0, INSNAME(ti99, RTWP) },
	{ "S",    S,    0x6000, 0xF000, 1, 0, INSNAME(ti99, S)    },
	{ "SB",   SB,   0x7000, 0xF000, 1, 0, INSNAME(ti99, SB)   },
	{ "SBO",  SBO,  0x1D00, 0xFF00, 2, 0, INSNAME(ti99, SBO)  },
	{ "SBZ",  SBZ,  0x1E00, 0xFF00, 2, 0, INSNAME(ti99, SBZ)  },
	{ "SETO", SETO, 0x0700, 0xFFC0, 6, 0, INSNAME(ti99, SETO) },
	{ "SLA",  SLA,  0x0A00, 0xFF00, 5, 0, INSNAME(ti99, SLA)  },
	{ "SOC",  SOC,  0xE000, 0xF000, 1, 0, INSNAME(ti99, SOC)  },
	{ "SOCB", SOCB, 0xF000, 0xF000, 1, 0, INSNAME(ti99, SOCB) },
	{ "SRA",  SRA,  0x0800, 0xFF00, 5, 0, INSNAME(ti99, SRA)  },
	{ "SRC",  SRC,  0x0B00, 0xFF00, 5, 0, INSNAME(ti99, SRC)  },
	{ "SRL",  SRL,  0x0900, 0xFF00, 5, 0, INSNAME(ti99, SRL)  },
	{ "STCR", STCR, 0x3400, 0xFC00, 4, 0, INSNAME(ti99, STCR) },
	{ "STST", STST, 0x02C0, 0xFFF0, 8, 0, INSNAME(ti99, STST) },
	{ "STWP", STWP, 0x02A0, 0xFFF0, 8, 0, INSNAME(ti99, STWP) },
	{ "SWPB", SWPB, 0x06C0, 0xFFC0, 6, 0, INSNAME(ti99, SWPB) },
	{ "SZC",  SZC,  0x4000, 0xF000, 1, 0, INSNAME(ti99, SZC)  },
	{ "SZCB", SZCB, 0x5000, 0xF000, 1, 0, INSNAME(ti99, SZCB) },
	{ "TB",   TB,   0x1F00, 0xFF00, 2, 0, INSNAME(ti99, TB)   },
	{ "X",    X,    0x0480, 0xFFC0, 6, 0, INSNAME(ti99, X)    },
	{ "XOP",  XOP,  0x2C00, 0xFC00, 9, 0, INSNAME(ti99, XOP)  },
	{ "XOR",  XOR,  0x2800, 0xFC00, 3, 0, INSNAME(ti99, XOR)  },
	{ NULL }
};

// *****************************
// Graphics Programming Language
// *****************************

#if 0
GPL_INST gpl_Inst[] =
{
	{ "ABS",   ABS,   0x80, 0xFE, 5, 0 },
	{ "ADD",   ADD,   0xA0, 0xFC, 1, 0 },
	{ "ALL",   ALL,   0x07, 0xFF, 2, 0 },
	{ "AND",   AND,   0xB0, 0xFC, 1, 0 },
	{ "B",     B,     0x05, 0xFF, 2, 0 },
	{ "BACK",  BACK,  0x04, 0xFF, 2, 0 },
	{ "BR",    BR,    0x40, 0xE0, 4, 0 },
	{ "BS",    BS,    0x60, 0xE0, 4, 0 },
	{ "CALL",  CALL,  0x06, 0xFF, 2, 0 },
	{ "CARRY", CARRY, 0x0C, 0xFF, 3, 0 },
	{ "CASE",  CASE,  0x8A, 0xFE, 5, 0 },
	{ "CEQ",   CEQ,   0xD4, 0xFC, 1, 0 },
	{ "CGT",   CGT,   0xCC, 0xFC, 1, 0 },
	{ "CGE",   CGE,   0xD0, 0xFC, 1, 0 },
	{ "CH",    CH,    0xC4, 0xFC, 1, 0 },
	{ "CHE",   CHE,   0xC8, 0xFC, 1, 0 },
	{ "CLOG",  CLOG,  0xD8, 0xFC, 1, 0 },
	{ "CLR",   CLR,   0x86, 0xFE, 5, 0 },
	{ "COINC", COINC, 0xEC, 0xFC, 1, 0 },
	{ "CONT"   CONT,  0x10, 0xFF, 3, 0 },
	{ "CZ",    CZ,    0x8E, 0xFE, 5, 0 },
	{ "DEC",   DEC,   0x92, 0xFE, 5, 0 },
	{ "DECT",  DECT,  0x96, 0xFE, 5, 0 },
	{ "DIV",   DIV,   0xAC, 0xFC, 1, 0 },
	{ "EX",    EX,    0xC0, 0xFC, 1, 0 },
	{ "EXEC",  EXEC,  0x11, 0xFF, 3, 0 },
	{ "EXIT",  EXIT,  0x0B, 0xFF, 3, 0 },
	{ "FETCH", FETCH, 0x88, 0xFE, 5, 0 },
	{ "FMT",   FMT,   0x08, 0xFF, 0, 0 },
	{ "GT",    GT,    0x0A, 0xFF, 3, 0 },
	{ "H",     H,     0x09, 0xFF, 3, 0 },
	{ "I/O",   IO,    0xF4, 0xFC, 1, 0 },
	{ "INC",   INC,   0x90, 0xFE, 5, 0 },
	{ "INCT",  INCT,  0x94, 0xFE, 5, 0 },
	{ "INV",   INV,   0x84, 0xFE, 5, 0 },
	{ "MOVE",  MOVE,  0x20, 0xE0, 5, 0 },
	{ "MUL",   MUL,   0xA8, 0xFC, 1, 0 },
	{ "NEG",   NEG,   0x82, 0xFE, 5, 0 },
	{ "OR",    OR,    0xB4, 0xFC, 1, 0 },
	{ "OVF"    OVF,   0x0D, 0xFF, 3, 0 },
	{ "PARSE", PARSE, 0x0E, 0xFF, 2, 0 },
	{ "PUSH",  PUSH,  0x8C, 0xFE, 5, 0 },
	{ "RAND",  RAMD,  0x02, 0xFF, 2, 0 },
	{ "RTGR",  RTGR,  0x13, 0xFF, 3, 0 },
	{ "RTN",   RTN,   0x00, 0xFF, 3, 0 },
	{ "RTNB",  RTNB,  0x12, 0xFF, 3, 0 },
	{ "RTNC",  RTNC,  0x01, 0xFF, 3, 0 },
	{ "SCAN",  SCAN,  0x03, 0xFF, 3, 0 },
	{ "SLL",   SLL,   0xE0, 0xFC, 1, 0 },
	{ "SRA",   SRA    0xDC, 0xFC, 1, 0 },
	{ "SRL",   SRL,   0xE4, 0xFC, 1, 0 },
	{ "SRC",   SRC,   0xE8, 0xFC, 1, 0 },
	{ "ST",    ST,    0xBC, 0xFC, 1, 0 },
	{ "SUB",   SUB,   0xA4, 0xFC, 1, 0 },
	{ "SWGR",  SWGR,  0xF8, 0xFC, 1, 0 },
	{ "XML",   XML,   0x0F, 0xFF, 2, 0 },
	{ "XOR",   XOR,   0xB8, 0xFC, 1, 0 },
	{ NULL }
};
#endif 
