#include "cainfodialog.h"
#include "caresources.h"
#include "catrophy.h"


/** Constructor.
    \param title Dialog title
    \param text The info text.
    \param type Info type (Info, Warning)
    \param modal true: Dialog shown in addition to the current screen.
                 false: Dialog sown in new screen with new background (default).
    \param screen pointer to screen shown in the background if this dialog is modal.
                  zero if this dialog is not modal (default).
*/
CAInfoDialog::CAInfoDialog( const char* title,
                            const char* text,
                            InfoType type,
                            bool modal,
                            CAScreen* screen )
        : CADialog( modal, screen ) {
    if( CA_APP->debug ) std::cout << "CAInfoDialog() begin" << std::endl;

    this->title = title;
    this->type = type;
    textList.setList( text );

    switch( type ) {
    case Info:
        icon = CA_RES->misc_info;
        // CL_Surface::load( "resources/misc/info", CA_RES->resources );
        break;

    case Warning:
        icon = CA_RES->misc_caution;
        // CL_Surface::load( "resources/misc/caution", CA_RES->resources );
        break;

    default:
        icon = 0;
        break;
    }

    resize( 400, textList.count()*16 + 96 );

    if( CA_APP->debug ) std::cout << "CAInfoDialog() end" << std::endl;
}



/** Destructor.
*/
CAInfoDialog::~CAInfoDialog() {
    //delete icon;
}



/** Builds the info dialog screen.
*/
void
CAInfoDialog::buildScreen() {
    CADialog::buildScreen();

    int x = (icon ? 112 : 32);

    CA_RES->font_normal_14_white->print_left( left+x, top+32,
            title.get_string() );

    for( int i=0; i<textList.count(); ++i ) {
        CA_RES->font_normal_11_white->print_left( left+x, top+64+i*16,
                textList.getItem( i ) );
    }

    if( icon ) {
        icon->put_screen( left+32, top+32 );
    }
}



/** Called on key release.
*/
void
CAInfoDialog::on_button_release( CL_InputDevice *device, const CL_Key &key ) {
    switch( key.id ) {
    case CL_KEY_ENTER:
    case CL_KEY_ESCAPE:
        done = true;
        break;

    default:
        break;
    }
}

// EOF
