/*****************************************************************************
 * Zoltan Library for Parallel Applications                                  *
 * Copyright (c) 2000,2001,2002, Sandia National Laboratories.               *
 * For more info, see the README file in the top-level Zoltan directory.     *
 *****************************************************************************/
/*****************************************************************************
 * CVS File Information :
 *    $RCSfile: lb_point_assign.c,v $
 *    $Author: kddevin $
 *    $Date: 2003/02/01 00:51:37 $
 *    $Revision: 1.6 $
 ****************************************************************************/


#ifdef __cplusplus
/* if C++, define the rest of this header file as extern C */
extern "C" {
#endif


#include "zz_const.h"


/****************************************************************************/
int Zoltan_LB_Point_Assign (
 ZZ *zz,
 double *x,
 int *proc)
{
/* Returns processor to which a point should be assigned. */
  char *yo = "Zoltan_LB_Point_Assign";
  if (zz->LB.Point_Assign == NULL) {
    /* function not supported by current decomposition method */
    ZOLTAN_PRINT_ERROR(zz->Proc, yo, 
                   "Point_Assign not supported by chosen partitioning method.");
    return ZOLTAN_FATAL;  
  }

  if (zz->LB.PartDist != NULL) {
    ZOLTAN_PRINT_ERROR(zz->Proc, yo, 
      "Non-uniform distribution of partitions over processors is specified; "
      "use Zoltan_LB_Point_PP_Assign.");
    return ZOLTAN_FATAL;
  }

  /* call appropriate method; pass proc in partition argument for greater
   * efficiency within LB.Point_Assign (Zoltan is partition-based). */
  return zz->LB.Point_Assign(zz, x, NULL, proc); 
}

/****************************************************************************/
int Zoltan_LB_Point_PP_Assign (
 ZZ *zz,
 double *x,
 int *proc,
 int *part)
{
/* Returns processor and partition to which a point should be assigned. */
  char *yo = "Zoltan_LB_Point_PP_Assign";
  if (zz->LB.Point_Assign == NULL) {
    /* function not supported by current decomposition method */
     ZOLTAN_PRINT_ERROR(zz->Proc, yo, 
                   "Point_Assign not supported by chosen partitioning method.");
     return ZOLTAN_FATAL ;   
  }

  return zz->LB.Point_Assign(zz, x, proc, part);  /* call appropriate method */
}


#ifdef __cplusplus
} /* closing bracket for extern "C" */
#endif
