// -*- c++ -*-

// @HEADER
// ***********************************************************************
//
//              PyTrilinos: Python Interface to Trilinos
//                 Copyright (2005) Sandia Corporation
//
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// Questions? Contact Bill Spotz (wfspotz@sandia.gov)
//
// ***********************************************************************
// @HEADER

%module(package="PyTrilinos.LOCA") Abstract

%{
// LOCA includes
#include "LOCA_Abstract_Group.H"
#include "LOCA_TurningPoint_MooreSpence_AbstractGroup.H"
#include "LOCA_TurningPoint_MooreSpence_FiniteDifferenceGroup.H"
#include "LOCA_TurningPoint_MinimallyAugmented_AbstractGroup.H"
#include "LOCA_TurningPoint_MinimallyAugmented_FiniteDifferenceGroup.H"
#include "LOCA_Pitchfork_MooreSpence_AbstractGroup.H"
#include "LOCA_Hopf_MooreSpence_AbstractGroup.H"
#include "LOCA_Hopf_MooreSpence_FiniteDifferenceGroup.H"
%}

// Ignore/renames
%ignore *::operator=;

// Import LOCA interfaces
%import "LOCA.Continuation.i"
%import "LOCA.MultiContinuation.i"
%import "LOCA.Homotopy.i"
%import "LOCA.TimeDependent.i"
%import "LOCA.Bifurcation.i"

// Import NOX headers
%import "NOX_Abstract_Group.H"
%import "NOX_StatusTest_Generic.H"

// LOCA interface includes
%include "LOCA_Abstract_Group.H"
%include "LOCA_TurningPoint_MooreSpence_AbstractGroup.H"
%include "LOCA_TurningPoint_MooreSpence_FiniteDifferenceGroup.H"
%include "LOCA_TurningPoint_MinimallyAugmented_AbstractGroup.H"
%include "LOCA_TurningPoint_MinimallyAugmented_FiniteDifferenceGroup.H"
%include "LOCA_Pitchfork_MooreSpence_AbstractGroup.H"
%include "LOCA_Hopf_MooreSpence_AbstractGroup.H"
%include "LOCA_Hopf_MooreSpence_FiniteDifferenceGroup.H"
