
#ifndef _IFELSEIFELSEBLOCKRTC_H
#define _IFELSEIFELSEBLOCKRTC_H

#include "BlockRTC.hh"
#include "ConditionalBlockRTC.hh"
#include "NormalBlockRTC.hh"
#include "TokenizerRTC.hh"

#include <string>
#include <map>
#include <list>

namespace PG_RuntimeCompiler {

/**
 * A IfElseifElseBlock represents a complete set of associated if, else if,
 * and else statements. 
 */

class IfElseifElseBlock : public Block
{
 public:

  /**
   * Constructor -> The constructor contructs the parent Block with vars, 
   *                size, and curr.
   *
   * @param vars  - A map of already active variables
   * @param lines - The array of strings that represent the lines of the code. 
   * @param errs  - A string containing the errors that have been generated by
   *                the compiling of lines. If errs is not empty, then the 
   *                program has not compiled succesfully
   */
  IfElseifElseBlock(std::map<std::string, Variable*> vars, Tokenizer& lines, 
		    std::string& errs);

  /**
   * Destructor -> The destructor deletes _if, all the _elseifs, and _else.
   */
  ~IfElseifElseBlock();

  /**
   * execute -> This method executes this IfElseifElseBlock. The _if 
   *            ConditionalBlock is checked. If it has run, thats all we need 
   *            to do. Otherwise we have to loop through the _elseifs. If any 
   *            one of them executes, we are done. If the _if block has not 
   *            run and none of the _elseifs have run, then we run the _else 
   *            block, assuming there is one. 
   */
  Value* execute();
  
  /**
   * operator<< -> Prints all the related blocks
   */
  std::ostream& operator<<(std::ostream& os) const;

 private:

  ConditionalBlock* _if; //!< The block of code following the if(...) statement

  std::list<ConditionalBlock*> _elseifs; //!< A list of all the else if blocks

  NormalBlock* _else; //!< the block of code following the else { statement
};
  
}

#endif
