/*
 * Copyright (C) 2007 Arnaud Ysmal <wiidevel@stacktic.org>
 *
 * tmii.h (TransferMii)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
 
#ifndef _TMII_H
#define _TMII_H
#include <bluetooth/bluetooth.h>

#define FIRST_BLOCK 0x0fca
#define SECOND_BLOCK 0x12ba
#define BLOCK_SIZE 0x2f0

#define FIRST_MII 0x8
#define MII_SIZE 0x4a
#define MII_NB 0xa
#define MII_NAME_LENGTH_CHAR 0xa
#define MII_NAME_LENGTH_BYTE 0x14
#define MII_NAME_OFFSET 0x2
#define MII_CREATOR_LENGTH_CHAR 0xa
#define MII_CREATOR_LENGTH_BYTE 0x14
#define MII_CREATOR_OFFSET 0x36
#define MAC_OFFSET 0x1c
#define MAC_SUM 0xc2

#ifndef TRUE

#define TRUE 1
#define FALSE 0

#define swap16(x) ((((x)&0xFF00)>>8) | (((x)&0xFF)<<8)) 

#endif

#define miiAddress(n) (&(miiblock.miis[n-1]))

typedef char bool;

typedef struct mii_s {
	uint16_t hdr;
	uint16_t name[MII_NAME_LENGTH_CHAR];
	uint8_t height;
	uint8_t weight;
	uint8_t miiID[4];
	uint8_t wiiMAC[4];
	uint8_t data[22];
	uint16_t creator[MII_CREATOR_LENGTH_CHAR];
} mii_t;

typedef struct block_s {
	uint8_t id[4];
	uint16_t parade;
	uint16_t unk;
	mii_t miis[10];
	uint16_t crc;
} block_t;

/* filefunctions */
bool fileRead(char *miifile);
bool fileWrite(char *miifile, int slot);
bool fileInfo(char *miifile);

/* others */
bool parseMacAddress(char* macaddr);
void crcCheck(void);
void beu16toascii(uint16_t *src, char *dest);
void asciitobeu16(char *src, uint16_t *dest);



/* wiimotefunctions */
bool wiimoteRead(void);
bool wiimoteWrite(void);
int nextEmptySlot(void);
void wiimoteDisconnect(void);
bool wiimoteConnect(void);

/* miifunctions */
bool getMii(unsigned char *miibuf, int slot);

bool getMiiCreator(uint16_t *creatorsname, int slot);
bool setMiiCreator(uint16_t *creatorsname, int slot);
bool getMiiCreatorAscii(char *creatorsname, int slot);
bool setMiiCreatorAscii(char *creatorsname, int slot);

bool getMiiName(uint16_t *miisname, int slot);
bool setMiiName(uint16_t *miisname, int slot);
bool getMiiNameAscii(char *miisname, int slot);
bool setMiiNameAscii(char *miisname, int slot);

bool getMiiSex(int slot);
bool setMiiSex(char sex, int slot);

bool listMiis(void);
bool addMii(char* miifile, int slot);
bool delMii(int slot);
bool setMacAddress(int slot);
bool miiIsEmpty(int slot);
bool miiSeemsValid(int slot);
bool getMiiMacAddress(unsigned char *macaddr, int slot);
bool setCreatorName(char *creatorsname, int slot);
bool setMiiName(uint16_t *miisname, int slot);

extern mii_t mii;
extern block_t miiblock;

extern bool wm_auto_update;
extern bool wm_read;
extern bool wm_connected;
extern bool wm_update;

extern bdaddr_t ba;

#endif
