/***************************************************************************
                          utils.c  -  description
                             -------------------
    begin                : Fri Jun 15 2001
    copyright            : (C) 2001 by Pierre-Michel THEVENY
    email                : pmt@mnhn.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "utils.h"


/***************************************************************************
*  Function extracted from support.c from GLADE
***************************************************************************/

GtkWidget *
lookup_widget (GtkWidget * widget, const gchar * widget_name)
{
    GtkWidget *parent, *found_widget;

    g_return_val_if_fail (widget != NULL, NULL);
    g_return_val_if_fail (widget_name != NULL, NULL);

    for (;;)
    {
        if (GTK_IS_MENU (widget))
            parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
        else
            parent = widget->parent;
        if (parent == NULL)
            break;
        widget = parent;
    }

    found_widget = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (widget),
                   widget_name);
    if (!found_widget)
        g_warning ("Widget not found: %s", widget_name);
    return found_widget;
}


/***************************************************************************
* GtK signal function used to destroy widget when has focus grab
 ***************************************************************************/

void
destroy_grab_widget (GtkWidget * widget, gpointer data)
{
    g_return_if_fail (widget != NULL);
    gtk_grab_remove (widget);
    gtk_widget_destroy (widget);
}
