/***************************************************************************
                          help.c  -  description
                             -------------------
    begin                : Sat Jun 9 2001
    copyright            : (C) 2001 by Pierre-Michel THEVENY
    email                : pmth@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <stdlib.h>

#include "help.h"
#include "msg.h"
#include "utils.h"


/***************************************************************************
* Display a dialog box with About message in and Ok button
 ***************************************************************************/

void
display_about (void)
{
    gchar *buffer = NULL;

    buffer =
        g_strdup_printf (_
                         ("TPTIME is a calculator-like program that performs conversions between Gregorian date "
                          "and Julian days, modified Julian days, and truncated Julian days with the different origins "
                          "used by TOPEX/POSEIDON and other satellites (NASA, CNES, CCSDS). It also provides "
                          "date of given cycle, pass of TOPEX/POSEIDON, and vice-versa.\n\n"
                          "This is version: %s\n\n"
                          "(c) 2001 Pierre-Michel THEVENY\nDistribued under GPL without any warranty\n\n"
                          "Author: Pierre-Michel THEVENY <pmth@free.fr>\n\n"),
                         VERSION);

    display_msg (buffer);
    g_free (buffer);
}


/***************************************************************************
* Display Help message or the manual if a browser is present
 ***************************************************************************/

void
display_help (void)
{
    gchar *buffer = NULL;
    gchar *browser = NULL;

    /* Try if there is a HTML browser defined for Help */
    browser = getenv ("HELP_BROWSER");

    /* If not, try if there is a normal HTML browser defined */
    if (browser == NULL)
    {
        browser = getenv ("BROWSER");
    }

    /* No browser defined, just display path of doc dir */
    if (browser == NULL)
    {
        buffer =
            g_strdup_printf (_
                             ("TPTIME is a calculator-like program that performs conversions between Gregorian date "
                              "and Julian days, modified Julian days, and truncated Julian days with the different origins "
                              "used by TOPEX/POSEIDON and other satellites (NASA, CNES, CCSDS). It also provides "
                              "date of given cycle, pass of TOPEX/POSEIDON, and vice-versa.\n\n"
                              "You can find the manual in the directory %s\n\n"
                              "To browse it directly, you must set the HELP_BROWSER or BROWSER environment variable to a valid HTML browser.\n\n"
                              "(c) 2001 Pierre-Michel THEVENY\nDistribued under GPL without any warranty\n"),
                             PACKAGE_DOC_DIR);

        display_msg (buffer);
        g_free (buffer);
    }

    /* Ok, a browser is defined : calling it to display help */
    else
    {
        buffer =
            g_strdup_printf ("%s  file://%s/%s", browser, PACKAGE_DOC_DIR,
                             HELP_FILE);
        g_free (browser);
        system (buffer);
        g_free (buffer);
    }
}
