/* SPDX-License-Identifier: BSD-2-Clause */
#include <errno.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#include <cmocka.h>

#include "attrs.h"
#include "parser.h"

/* yaml file processed with xxd -i */
static unsigned char _attrs_yaml[] = {
  0x2d, 0x2d, 0x2d, 0x0a, 0x21, 0x21, 0x6d, 0x61, 0x70, 0x20, 0x7b, 0x0a,
  0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x30,
  0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20,
  0x22, 0x33, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69,
  0x6e, 0x74, 0x20, 0x22, 0x32, 0x35, 0x36, 0x22, 0x0a, 0x20, 0x20, 0x3a,
  0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x33, 0x22, 0x2c, 0x0a,
  0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32,
  0x35, 0x37, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x73, 0x74,
  0x72, 0x20, 0x22, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21,
  0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x35, 0x38, 0x22, 0x0a, 0x20, 0x20,
  0x3a, 0x20, 0x21, 0x21, 0x73, 0x74, 0x72, 0x20, 0x22, 0x33, 0x39, 0x33,
  0x31, 0x33, 0x32, 0x33, 0x37, 0x33, 0x32, 0x36, 0x35, 0x33, 0x33, 0x33,
  0x39, 0x33, 0x35, 0x33, 0x39, 0x33, 0x39, 0x36, 0x32, 0x36, 0x36, 0x33,
  0x39, 0x36, 0x35, 0x33, 0x33, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20,
  0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x36, 0x31, 0x22, 0x0a,
  0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22,
  0x74, 0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21,
  0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x36, 0x33, 0x22, 0x0a, 0x20,
  0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x66,
  0x61, 0x6c, 0x73, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21,
  0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x36, 0x34, 0x22, 0x0a, 0x20,
  0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x74,
  0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21,
  0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x36, 0x35, 0x22, 0x0a, 0x20, 0x20,
  0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x66, 0x61,
  0x6c, 0x73, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21,
  0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x37, 0x32, 0x22, 0x0a, 0x20, 0x20,
  0x3a, 0x20, 0x21, 0x21, 0x73, 0x74, 0x72, 0x20, 0x22, 0x22, 0x2c, 0x0a,
  0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32,
  0x37, 0x33, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x73, 0x74,
  0x72, 0x20, 0x22, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21,
  0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x39, 0x37, 0x22, 0x0a, 0x20, 0x20,
  0x3a, 0x20, 0x21, 0x21, 0x73, 0x74, 0x72, 0x20, 0x22, 0x22, 0x2c, 0x0a,
  0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x33,
  0x35, 0x34, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f,
  0x6f, 0x6c, 0x20, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20,
  0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x33, 0x35,
  0x35, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f,
  0x6c, 0x20, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20,
  0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x33, 0x35, 0x36,
  0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c,
  0x20, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f,
  0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x33, 0x35, 0x37, 0x22,
  0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20,
  0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20,
  0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x33, 0x35, 0x38, 0x22, 0x0a,
  0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x34,
  0x31, 0x36, 0x30, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21,
  0x69, 0x6e, 0x74, 0x20, 0x22, 0x35, 0x31, 0x34, 0x22, 0x0a, 0x20, 0x20,
  0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x74, 0x72,
  0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69,
  0x6e, 0x74, 0x20, 0x22, 0x35, 0x32, 0x38, 0x22, 0x0a, 0x20, 0x20, 0x3a,
  0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x66, 0x61, 0x6c,
  0x73, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69,
  0x6e, 0x74, 0x20, 0x22, 0x31, 0x30, 0x37, 0x33, 0x37, 0x34, 0x32, 0x33,
  0x35, 0x34, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x73, 0x74,
  0x72, 0x20, 0x22, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21,
  0x69, 0x6e, 0x74, 0x20, 0x22, 0x31, 0x30, 0x37, 0x33, 0x37, 0x34, 0x33,
  0x33, 0x36, 0x30, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x73,
  0x65, 0x71, 0x20, 0x5b, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x69,
  0x6e, 0x74, 0x20, 0x22, 0x34, 0x31, 0x36, 0x31, 0x22, 0x2c, 0x0a, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x34, 0x31,
  0x36, 0x32, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x69,
  0x6e, 0x74, 0x20, 0x22, 0x34, 0x31, 0x36, 0x33, 0x22, 0x2c, 0x0a, 0x20,
  0x20, 0x5d, 0x2c, 0x0a, 0x7d, 0x0a
};
static unsigned int _attrs_yaml_len = 774;

static void test_attr_parser_good(void **state) {
    (void) state;

    attr_list *attrs = NULL;

    bool res = parse_attributes_from_string(_attrs_yaml, _attrs_yaml_len,
            &attrs);
    assert_true(res);
    assert_non_null(attrs);
    assert_int_equal(attr_list_get_count(attrs), 20);

    attr_list_free(attrs);
}

static unsigned char _config_yaml[] = {
  0x21, 0x21, 0x6d, 0x61, 0x70, 0x20, 0x7b, 0x0a, 0x20, 0x20, 0x3f, 0x20,
  0x21, 0x21, 0x73, 0x74, 0x72, 0x20, 0x22, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
  0x2d, 0x69, 0x6e, 0x69, 0x74, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21,
  0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22,
  0x2c, 0x0a, 0x7d, 0x0a, 0x0a
};
static unsigned int _config_yaml_len = 53;

static void test_config_parser_good(void **state) {
    (void) state;

    token_config config = { 0 };
    bool res = parse_token_config_from_string(_config_yaml, _config_yaml_len,
            &config);
    assert_true(res);
    assert_true(config.is_initialized);
    assert_null(config.tcti);
}

unsigned char _home_wcrobert_empty_seq_yaml[] = {
  0x21, 0x21, 0x6d, 0x61, 0x70, 0x20, 0x7b, 0x0a, 0x20, 0x20, 0x3f, 0x20,
  0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x30, 0x22, 0x0a, 0x20, 0x20,
  0x3a, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x34, 0x22, 0x2c,
  0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22,
  0x31, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f,
  0x6c, 0x20, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20,
  0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x22, 0x0a,
  0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22,
  0x74, 0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21,
  0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x33, 0x22, 0x0a, 0x20, 0x20, 0x3a,
  0x20, 0x21, 0x21, 0x73, 0x74, 0x72, 0x20, 0x22, 0x22, 0x2c, 0x0a, 0x20,
  0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x31, 0x37,
  0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x73, 0x74, 0x72, 0x20,
  0x22, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e,
  0x74, 0x20, 0x22, 0x31, 0x33, 0x34, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20,
  0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x66, 0x61, 0x6c, 0x73,
  0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e,
  0x74, 0x20, 0x22, 0x32, 0x35, 0x36, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20,
  0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x33, 0x31, 0x22, 0x2c, 0x0a,
  0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32,
  0x35, 0x38, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x73, 0x74,
  0x72, 0x20, 0x22, 0x36, 0x35, 0x36, 0x36, 0x36, 0x35, 0x33, 0x30, 0x36,
  0x32, 0x33, 0x32, 0x36, 0x36, 0x36, 0x31, 0x33, 0x30, 0x33, 0x30, 0x36,
  0x31, 0x36, 0x31, 0x36, 0x31, 0x36, 0x32, 0x33, 0x39, 0x33, 0x33, 0x22,
  0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20,
  0x22, 0x32, 0x35, 0x39, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21,
  0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x2c,
  0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22,
  0x32, 0x36, 0x30, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62,
  0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a,
  0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32,
  0x36, 0x31, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f,
  0x6f, 0x6c, 0x20, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20,
  0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x36,
  0x32, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f,
  0x6c, 0x20, 0x22, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x22, 0x2c, 0x0a, 0x20,
  0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x36,
  0x33, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f,
  0x6c, 0x20, 0x22, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x22, 0x2c, 0x0a, 0x20,
  0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x36,
  0x34, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f,
  0x6c, 0x20, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20,
  0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x36, 0x36,
  0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c,
  0x20, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f,
  0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x36, 0x38, 0x22,
  0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20,
  0x22, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f,
  0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x32, 0x37, 0x32, 0x22,
  0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x73, 0x74, 0x72, 0x20, 0x22,
  0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74,
  0x20, 0x22, 0x32, 0x37, 0x33, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21,
  0x21, 0x73, 0x74, 0x72, 0x20, 0x22, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f,
  0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x33, 0x35, 0x33, 0x22,
  0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22,
  0x33, 0x32, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69,
  0x6e, 0x74, 0x20, 0x22, 0x33, 0x35, 0x34, 0x22, 0x0a, 0x20, 0x20, 0x3a,
  0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x66, 0x61, 0x6c,
  0x73, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69,
  0x6e, 0x74, 0x20, 0x22, 0x33, 0x35, 0x35, 0x22, 0x0a, 0x20, 0x20, 0x3a,
  0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x74, 0x72, 0x75,
  0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e,
  0x74, 0x20, 0x22, 0x33, 0x35, 0x36, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20,
  0x21, 0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x74, 0x72, 0x75, 0x65,
  0x22, 0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74,
  0x20, 0x22, 0x33, 0x35, 0x37, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21,
  0x21, 0x62, 0x6f, 0x6f, 0x6c, 0x20, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22,
  0x2c, 0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20,
  0x22, 0x33, 0x35, 0x38, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21,
  0x69, 0x6e, 0x74, 0x20, 0x22, 0x34, 0x32, 0x32, 0x34, 0x22, 0x2c, 0x0a,
  0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x33,
  0x36, 0x38, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f,
  0x6f, 0x6c, 0x20, 0x22, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x22, 0x2c, 0x0a,
  0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x33,
  0x36, 0x39, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f,
  0x6f, 0x6c, 0x20, 0x22, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x22, 0x2c, 0x0a,
  0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x33,
  0x37, 0x30, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f,
  0x6f, 0x6c, 0x20, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x2c, 0x0a, 0x20,
  0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x35, 0x31,
  0x34, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f,
  0x6c, 0x20, 0x22, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x22, 0x2c, 0x0a, 0x20,
  0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x35, 0x32,
  0x38, 0x22, 0x0a, 0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x62, 0x6f, 0x6f,
  0x6c, 0x20, 0x22, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x22, 0x2c, 0x0a, 0x20,
  0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x31, 0x30,
  0x37, 0x33, 0x37, 0x34, 0x32, 0x33, 0x35, 0x33, 0x22, 0x0a, 0x20, 0x20,
  0x3a, 0x20, 0x21, 0x21, 0x73, 0x65, 0x71, 0x20, 0x5b, 0x5d, 0x2c, 0x0a,
  0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x31,
  0x30, 0x37, 0x33, 0x37, 0x34, 0x32, 0x33, 0x35, 0x34, 0x22, 0x0a, 0x20,
  0x20, 0x3a, 0x20, 0x21, 0x21, 0x73, 0x74, 0x72, 0x20, 0x22, 0x22, 0x2c,
  0x0a, 0x20, 0x20, 0x3f, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22,
  0x31, 0x30, 0x37, 0x33, 0x37, 0x34, 0x33, 0x33, 0x36, 0x30, 0x22, 0x0a,
  0x20, 0x20, 0x3a, 0x20, 0x21, 0x21, 0x73, 0x65, 0x71, 0x20, 0x5b, 0x0a,
  0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x69, 0x6e, 0x74, 0x20, 0x22, 0x34,
  0x32, 0x32, 0x36, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x5d, 0x2c, 0x0a, 0x7d,
  0x0a, 0x22, 0x0a
};
unsigned int _home_wcrobert_empty_seq_yaml_len = 1155;

static void test_config_parser_empty_seq(void **state) {
    (void) state;

    attr_list *attrs = NULL;

    bool res = parse_attributes_from_string(_attrs_yaml, _attrs_yaml_len,
            &attrs);
    assert_true(res);
    assert_non_null(attrs);
    assert_int_equal(attr_list_get_count(attrs), 20);

    attr_list_free(attrs);
}

int main(int argc, char* argv[]) {
    (void) argc;
    (void) argv;

    const struct CMUnitTest tests[] = {
        cmocka_unit_test(test_config_parser_empty_seq),
        cmocka_unit_test(test_attr_parser_good),
        cmocka_unit_test(test_config_parser_good),
    };

    return cmocka_run_group_tests(tests, NULL, NULL);
}
