/*
 *  TouchFreezeApp.cpp
 *
 *  Copyright (C) 2007, 2008  Stefan Kombrink
 *  Copyright (C) 2008 Pau Garcia i Quiles
 *
 *  This file is part of TouchFreeze.
 *
 *  TouchFreeze is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TouchFreeze is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with touchfreeze; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *  On Debian GNU/Linux systems, the complete text of the GNU General
 *  Public License can be found in the /usr/share/common-licenses/GPL file.
 */




#include <QtGui>

#include "TouchFreezeApp.h"
#include "TouchFreezeUI.h"

#include "SynDaemon.h"

#include <QString>
#include <QProcess>

TouchFreezeApp::TouchFreezeApp( int argc, char* argv[] ) : QApplication( argc, argv )
{
  int delay = 500;
  if ( argc == 2 )
    delay = atoi( argv[1] );

  qDebug( "typing delay is %i ms", delay );
  QString msg = tr( "setting typing delay to" ) + QString( "%1" ).arg( delay ) + tr( "milliseconds." );

  if ( !QSystemTrayIcon::isSystemTrayAvailable() )
  {
     qDebug( "there's no system tray. Use KDE or GNOME, please!" );
     quit();
  }

  mUI = new TouchFreezeUI();
  setActiveWindow( mUI );

  mSynDaemon = new SynDaemon( this, delay );

  connect( mSynDaemon, SIGNAL( startTyping() ), this, SLOT( onStartTyping() ) );
  connect( mSynDaemon, SIGNAL( stopTyping() ), this, SLOT( onStopTyping() ) );

  QString driverStr="0.14.6"; //FIXME!!
  mClientPath="/usr/bin/synclient"; //FIXME!!!

  //FIXME!! catch current touchpad state

  mUI->setup( driverStr, mClientPath, delay );

  connect( mUI, SIGNAL( delayChanged( unsigned int ) ), this, SLOT( onDelayChanged( unsigned int ) ) );
}

TouchFreezeApp::~TouchFreezeApp()
{
    // FIXME!! restore initial touch pad state
}


void TouchFreezeApp::setTouchpad(bool on)
{
  if (on) enableTouchpad();
  else disableTouchpad();
}

void TouchFreezeApp::enableTouchpad()
{
  qDebug( "enable touchpad" );
  QProcess p( this );

  QProcess::execute( mClientPath + " TouchpadOff=0" );
  mSynDaemon->setTouchPadExplicitlyDisabledByUser(false);
  mUI->setEnabledIcon();
}

void TouchFreezeApp::disableTouchpad()
{
  qDebug( "disable touchpad" );

  QProcess::execute( mClientPath + " TouchpadOff=1" );
  mSynDaemon->setTouchPadExplicitlyDisabledByUser(true);
  mUI->setDisabledIcon();
}

void TouchFreezeApp::onStartTyping()
{
  qDebug( "start typing" );

  QProcess::execute( mClientPath + " TouchpadOff=2" ); 
}

void TouchFreezeApp::onStopTyping()
{
  qDebug( "stop typing" );
  QProcess::execute( mClientPath + " TouchpadOff=0" ); //FIXME!! restore original state!
}

void TouchFreezeApp::onDelayChanged( unsigned int delay )
{
  qDebug( "delay is %d ms", delay );
  mSynDaemon->setDelay( delay );
}

