#ifndef _torsmo_h_
#define _torsmo_h_

#include "config.h"
#include <stdio.h>

#define ERR(s, varargs...) \
  fprintf(stderr, "torsmo: " s "\n", ##varargs)

/* critical error */
#define CRIT_ERR(s, varargs...) \
  { fprintf(stderr, "torsmo: " s "\n", ##varargs); exit(EXIT_FAILURE); }

struct net_stat {
  const char *dev;
  long long last_read_recv, last_read_trans;
  long long recv, trans;
  double recv_speed, trans_speed;
};

struct fs_stat {
  int fd;
  char *path;
  long long size;
  long long avail;
};

/* system dependant */

void prepare_update(void);
double get_uptime(void);
void update_meminfo(void);
void update_net_stats(void);
void update_cpu_usage(void);
int get_total_processes(void);
int get_running_processes(void);

void get_load_average(double v[3]);

int open_i2c_sensor(const char *dev, const char *type, int n, int *div);
double get_i2c_info(int fd, int arg);

int open_acpi_temperature(const char *name);
double get_acpi_temperature(int fd);
char* get_acpi_ac_adapter(void);
char* get_acpi_fan(void);
void get_battery_stuff(char *buf, unsigned int n, int b);

/* fs-stuff is possibly system dependant (fs.c) */

void update_fs_stats(void);
struct fs_stat *prepare_fs_stat(const char *path);
void clear_fs_stats(void);

/* in torsmo.c */

extern double current_update_time, last_update_time;

extern int no_buffers;

/* memory information in kilobytes */
extern unsigned int mem, memmax, swap, swapmax, bufmem, buffers, cached;

extern double cpu_usage;

double get_time(void);
FILE *open_file(const char *file, int *reported);
void format_seconds(char *buf, unsigned int n, long t);
void format_seconds_short(char *buf, unsigned int n, long t);

struct net_stat *get_net_stat(const char *dev);

#endif
