#!/usr/bin/make -f
# Sample debian/rules that uses debhelper.
# GNU copyright 1997 to 1999 by Joey Hess.

TARGET=__TARGET__
TARGET_ARCH=__TARGET_ARCH__
PACKAGE=gcc-__TARGET__

DEB_BUILD_GNU_TYPE      := $(shell dpkg-architecture -qDEB_BUILD_GNU_TYPE)
DEB_HOST_GNU_TYPE       := $(shell dpkg-architecture -qDEB_HOST_GNU_TYPE)
DEB_HOST_ARCH           := $(shell dpkg-architecture -qDEB_HOST_ARCH)
DEB_TARGET_ARCH		:= __TARGET_ARCH__

CONFARGS = -v \
        --enable-languages=c \
        --prefix=/usr \
        --infodir=/usr/share/info \
        --mandir=/usr/share/man \
        --with-gxx-include-dir=/usr/$(TARGET)/include/g++ \
        --enable-shared \
	--with-as=/usr/$(TARGET)/bin/as \
        --with-gnu-as \
	--with-ld=/usr/$(TARGET)/bin/ld \
        --with-gnu-ld \
        --with-system-zlib \
        --enable-long-long \
        --enable-nls \
        --without-included-gettext \
        --disable-checking \
        --build=$(DEB_BUILD_GNU_TYPE) \
        --host=$(DEB_HOST_GNU_TYPE) \
        --target=$(TARGET)
#CONFARGS += --with-newlib # enable newlib support

patch_stamp=patch-stamp
srcdir=src
include /usr/src/toolchain/patches/gcc/rules.patch

# Uncomment this to turn on verbose mode.
#export DH_VERBOSE=1

# This is the debhelper compatability version to use.
export DH_COMPAT=3

unpack: unpack-stamp
unpack-stamp:
	tar xjf /usr/src/toolchain/gcc.tar.bz2
	mv gcc-* src
ifneq "$(findstring --with-newlib, $(CONFARGS))" ""
	tar xjf /usr/src/toolchain/newlib.tar.bz2 newlib-*/newlib
	mv newlib-*/newlib src
	rmdir newlib-*
endif
	mkdir build

	touch unpack-stamp

configure: configure-stamp
configure-stamp: unpack-stamp patch-stamp
	dh_testdir
	# Add here commands to configure the package.
	cd build && env CC="gcc" ../src/configure $(CONFARGS) 
	touch configure-stamp

build: configure-stamp build-stamp
build-stamp:
	dh_testdir

	# Add here commands to compile the package.
	cd build && $(MAKE) includedir=/usr/$(TARGET)/include/
	#/usr/bin/docbook-to-man debian/$(PACKAGE).sgml > $(PACKAGE).1

	touch build-stamp

clean:
	dh_testdir
	dh_testroot
	rm -f build-stamp configure-stamp unpack-stamp

	# Add here commands to clean up after the build process.
	#-$(MAKE) clean
	rm -rf src build patch-stamp*

	dh_clean

install: build
	dh_testdir
	dh_testroot
	dh_clean -k
	dh_installdirs

	# Add here commands to install the package into debian/$(PACKAGE).
	cd build && $(MAKE) install DESTDIR=$(CURDIR)/debian/$(PACKAGE)/

	mv debian/$(PACKAGE)/usr/share/man/man1/cpp.1 \
	debian/$(PACKAGE)/usr/share/man/man1/$(TARGET)-cpp.1
	mv debian/$(PACKAGE)/usr/share/man/man1/gcov.1 \
	debian/$(PACKAGE)/usr/share/man/man1/$(TARGET)-gcov.1
	cd debian/$(PACKAGE)/usr/ && \
	/usr/src/toolchain/scripts/tpkg-gcc-rm-common-files
	ln -s gccbug-3.2.1.gz debian/$(PACKAGE)/usr/share/man/man1/$(TARGET)-gccbug.1.gz

# Build architecture-independent files here.
binary-indep: build install
# We have nothing to do by default.

# Build architecture-dependent files here.
binary-arch: build install
	dh_testdir
	dh_testroot
#	dh_installdebconf	
	dh_installdocs -n
#	dh_installexamples
#	dh_installmenu
#	dh_installlogrotate
#	dh_installemacsen
#	dh_installpam
#	dh_installmime
#	dh_installinit
#	dh_installcron
	dh_installman
	dh_installinfo
	dh_undocumented
	dh_installchangelogs 
	dh_link
#	dh_strip -Xlibgcc -Xlibstdc++
#	__TARGET__-strip --strip-debug $(shell find debian/$(PACKAGE)/ -name libgcc\*) \
#                         $(shell find debian/$(PACKAGE)/ -name libstdc++\*)
	dh_compress
	dh_fixperms
#	dh_makeshlibs
	dh_installdeb
#	dh_perl
	dh_shlibdeps -Xlibgcc_s -Xlibstdc++

	dh_gencontrol
	dh_md5sums
	dh_builddeb

binary: binary-indep binary-arch
.PHONY: build clean binary-indep binary-arch binary install configure
