# $Id: register.tcl,v 1.21 2005/01/17 22:15:11 aleksey Exp $

namespace eval register {
    set winid 0
}

proc register::open {jid args} {
    variable winid

    set sw .register$winid
    toplevel $sw
    wm group $sw .
    set title [format [::msgcat::mc "Register in %s"] $jid]
    wm title $sw $title
    wm iconname $sw $title
    wm transient $sw .
    if {$::tcl_platform(platform) == "macintosh"} {
        catch { unsupported1 style $sw floating sideTitlebar }
    } elseif {$::aquaP} {
        ::tk::unsupported::MacWindowStyle style $sw dBoxProc
    }
    wm resizable $sw 0 0

    ButtonBox $sw.bbox -spacing 0 -padx 10 -default 0
    $sw.bbox add -text [::msgcat::mc "OK"] -command [list register::register $sw $jid] \
        -state disabled
    $sw.bbox add -text [::msgcat::mc "Cancel"] -command [list destroy $sw]
    bind $sw <Return> "ButtonBox::invoke $sw.bbox default"
    bind $sw <Escape> "ButtonBox::invoke $sw.bbox 1"
    pack $sw.bbox -padx 2m -pady 2m -anchor e -side bottom

    Separator::create $sw.sep -orient horizontal
    pack $sw.sep -side bottom -fill x -pady 1m

    frame $sw.fields
    pack $sw.fields -expand yes -fill both -padx 2m -pady 2m

    wm withdraw $sw

    jlib::send_iq get \
	[jlib::wrapper:createtag query \
	     -vars [list xmlns jabber:iq:register]] \
	-to $jid -command [list register::recv_fields $sw $jid]
    
    incr winid
}


proc register::recv_fields {sw jid res child} {
    debugmsg register "$res $child"

    if {![cequal $res OK]} {
	destroy $sw
	MessageDlg ${sw}_err -aspect 50000 -icon error \
	    -message [format [::msgcat::mc "Registration: %s"] \
			  [error_to_string $child]] \
	    -type user -buttons ok -default 0 -cancel 0
	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    if {[cequal [jlib::wrapper:getattr $vars xmlns] jabber:iq:register]} {
	data::fill_fields $sw.fields $children
    }

    $sw.bbox itemconfigure 0 -state normal
    wm deiconify $sw

    foreach child [winfo children $sw.fields] {
        if {[cequal [winfo class $child] Entry] && \
		[cequal [$child cget -state] normal]} {
	    focus $child
	    break
	}
    }
}


proc register::register {sw jid} {
    variable data

    set f $sw.fields
    set restags [data::get_tags $sw.fields]

    jlib::send_iq set [jlib::wrapper:createtag query \
			   -vars [list xmlns jabber:iq:register] \
			   -subtags $restags] \
	-to $jid -command [list register::recv_result $sw $jid]
}


proc register::recv_result {sw jid res child} {
    variable data

    debugmsg register "$res $child"
    
    set result [::msgcat::mc "Registration is successful!"]

    if {![cequal $res OK]} {
	set result [error_to_string $child]
    }

    label $sw.result -text $result
    pack $sw.result -expand yes -fill both -after $sw.fields -anchor nw \
	-padx 1c -pady 1c
    pack forget $sw.fields

    pack forget $sw.bbox
    ButtonBox $sw.bbox1 -spacing 0 -padx 10 -default 0
    $sw.bbox1 add -text [::msgcat::mc "Close"] -command [list destroy $sw]
    bind $sw <Return> "ButtonBox::invoke $sw.bbox1 default"
    bind $sw <Escape> "ButtonBox::invoke $sw.bbox1 0"
    pack $sw.bbox1 -padx 2m -pady 2m -anchor e -side bottom -before $sw.sep

}


hook::add postload_hook \
    [list browser::register_ns_handler jabber:iq:register register::open \
    -desc [list * [::msgcat::mc "Register"]]]
hook::add postload_hook \
    [list disco::browser::register_feature_handler jabber:iq:register register::open \
    -desc [list * [::msgcat::mc "Register"]]]
