# $Id: taskbar.tcl,v 1.13 2005/04/25 23:56:56 aleksey Exp $

if {![cequal $::interface tk]} return

namespace eval taskbar {
    variable saved_state
    variable balloon ""
    variable tray    ""

    variable icon    ""
    variable pos     0

    array set s2p    [list blank       0 \
			   available   1 \
			   away	       2 \
			   chat	       3 \
			   dnd	       4 \
			   xa	       5 \
		           unavailable 6 \
			   invisible   7 \
			   browser     8 \
			   group       9 \
			   browser32   10 \
			   group32     11 \
			   available32 12 \
			   message1    13 \
			   message2    14 \
			   message3    15]
  
    array set mouse  [list 1down 0 \
			   3down 0 \
			   menu  ""]

    custom::defvar options(winico_blinks) 0 \
	[::msgcat::mc "When you have unread messages the taskbar icon will start to blink."] \
	-group IFace -type boolean
}

proc taskbar::load {} {
    global   curuserstatus

    variable tray

    variable icon
    variable pos
    variable s2p
    variable mouse
    variable saved_state [wm state .]

    if {[catch { package require Winico }]} {
        return
    }

    set icon [winico createfrom [pixmap docking tkabber.ico]]
    winico taskbar add $icon -pos [set pos $s2p(unavailable)] \
	   -text     [balloon_text]    \
	   -callback [list [namespace current]::callback %m %i %x %y]
    winico setwindow . $icon small $s2p(unavailable)
    winico setwindow . $icon big $s2p(available32)

    set m [set mouse(menu) .tray]
    menu $m -title "Tkabber" -tearoff $ifacetk::options(show_tearoffs) \
	-postcommand [list [namespace current]::post $m]
    $m add command -label [::msgcat::mc "About"] \
	-command ::ifacetk::about_window
    $m add separator
    $m add cascade -label [::msgcat::mc "Presence"] \
	-menu [menu [set pm $m.presence] \
		   -tearoff $ifacetk::options(show_tearoffs)]
    if {$ifacetk::options(show_tearoffs)} {
	set i 1
    } else {
	set i 0
    }
    for {} {$i <= [[set p .presence.button.menu] index end]} {incr i} {
        $pm add command -label [lindex [$p entryconfigure $i -label] 4] \
                        -command  [lindex [$p entryconfigure $i -command] 4]
    }
    $m add command -label [::msgcat::mc "Log in..."] -command ifacetk::login_dialog
    $m add command -label [::msgcat::mc "Log out"]   -command logout
    $m add command -label [::msgcat::mc "Log out with reason..."]  -command show_logout_dialog
    $m add separator
    $m add command -label [::msgcat::mc "Hide Main Window"]  -command "set [namespace current]::saved_state \[wm state .\]
	    wm state . withdrawn"
    $m add command -label [::msgcat::mc "Show Main Window"]  -command "wm state . \$[namespace current]::saved_state
	    wm deiconify ."
    $m add separator
    $m add command -label [::msgcat::mc "Quit"]  -command quit

    set tray ""
    foreach var [list curuserstatus tabcolors] {
        trace variable ::$var w [namespace current]::update
    }

    bind Toplevel <Map> [list [namespace current]::win_icon_setup %W Toplevel]

    foreach tag [list Chat JBrowser JDisco] {
	bind $tag <Map> [list [namespace current]::win_icon_setup %W $tag]
    }

    hook::add quit_hook [namespace current]::quit
}

hook::add finload_hook [namespace current]::taskbar::load

proc taskbar::win_icon_setup {w tag} {
    global usetabbar
    variable icon
    variable s2p

    if {[winfo toplevel $w] != $w} {
	return
    }

    switch -- $tag {
	Chat {
	    set small group
	    set big group32
	}
	JBrowser -
	JDisco {
	    set small browser
	    set big browser32
	}
	default {
	    set small available
	    set big available32
	}
    }
    winico setwindow $w $icon small $s2p($small)
    winico setwindow $w $icon big $s2p($big)
}

proc taskbar::quit {} {
    variable icon

    if {![cequal $icon ""]} {
	winico taskbar delete $icon
    }
}

proc taskbar::callback {event unused x y} {
    variable saved_state
    variable icon
    variable pos
    variable s2p
    variable mouse

    switch -- $event {
	WM_MOUSEMOVE -
	default {
	    set mouse(1down) 0
	    set mouse(3down) 0
	}

	WM_LBUTTONDOWN {
	    set mouse(1down) 1
	}

	WM_RBUTTONDOWN {
	    set mouse(3down) 1
	}

	WM_LBUTTONUP {
	    if {$mouse(1down)} {
                switch -- [wm state .] {
		    zoomed -
                    normal  {
			set saved_state [wm state .]
			wm state . withdrawn
		    }
                    default {
			wm state . $saved_state
			wm deiconify .
		    }
		}
	    }
	    set mouse(1down) 0
	}

	WM_RBUTTONUP {
	    if {$mouse(3down)} {
		tk_popup $mouse(menu) $x $y
	    }
	    set mouse(3down) 0
	}
    }
}

proc taskbar::balloon_text {} {
    global userstatusdesc textstatus

    if {![cequal $textstatus ""]} {
	return $textstatus
    }
    return $userstatusdesc
}


proc taskbar::post {m} {
    global curuserstatus

    switch -- [wm state .] {
	zoomed -
        normal {
            set state1 disabled
            set state2 normal
        }

        default {
            set state1 normal
            set state2 disabled
        }
    }
    if {$curuserstatus == "unavailable"} {
	set state0 disabled
    } else {
	set state0 normal
    }

    $m entryconfigure [$m index [::msgcat::mc "Presence"]] -state $state0
    $m entryconfigure [$m index [::msgcat::mc "Show Main Window"]] -state $state1
    $m entryconfigure [$m index [::msgcat::mc "Hide Main Window"]] -state $state2
}


proc taskbar::update {name1 {name2 ""} {op ""}} {
    global   curuserstatus tabcolors

    variable tray
    variable icon
    variable pos
    variable s2p

    switch -- [string trimleft $name1 :] {
        curuserstatus {
            if {[cequal $tray ""]} {
		winico taskbar modify $icon \
		       -pos [set pos $s2p($curuserstatus)] \
		       -text [balloon_text]
            }
	    winico setwindow . $icon small $s2p($curuserstatus)
        }

        tabcolors {
            toggle 0 1
        }
    }
}


proc taskbar::toggle {ff {firstP 0}} {
    global   curuserstatus tabcolors
    variable options
    variable tray
    variable icon
    variable pos
    variable s2p

    if {![cequal $tray ""]} {
        after cancel $tray
        set tray ""
    }

    set hitP 0
    foreach {k v} [array get tabcolors] {
        if {![winfo exists .nb.f$k]} {
            continue
        }
        if {(![cequal $v ""]) && ($v > $hitP)} {
            set hitP $v
        }
    }

    if {$hitP == 0} {
        update ::curuserstatus
        return
    }

    if {$options(winico_blinks)} {
	# make the taskbar icon blink
	set tray [after 500 [list [namespace current]::toggle [expr {!$ff}]]] 
	if {$ff} {
	    set pos $s2p(message$hitP)
	} else {
	    set pos $s2p(blank)
	}
    } else {
	set tray message
	set pos $s2p(message$hitP)
    }
    winico taskbar modify $icon -pos $pos -text [balloon_text]
}


proc taskbar::set_status {text} {
    variable balloon

    switch -- [wm state .] {
	zoomed -
        normal { }
        default {
            if {![cequal $balloon ""]} {
                after cancel $balloon
            }
            balloon::set_text $text
            balloon::show [winfo rootx .tray] [winfo rooty .tray]
            set balloon [after 15000 balloon::destroy]
        }
    }
}

hook::add set_status_hook [namespace current]::taskbar::set_status

proc taskbar::clear_status {} {
    variable balloon

    if {![cequal $balloon ""]} {
        after cancel $balloon
    }
    balloon::destroy
}

hook::add clear_status_hook [namespace current]::taskbar::clear_status

