# $Id: dockingtray.tcl,v 1.15 2005/03/27 20:31:12 aleksey Exp $

if {![cequal $::interface tk]} return

if {![info exists ::dockingtray] || !$::dockingtray} {
    return
}

if {[catch { package require Tk_Theme }]} {
    return
}

namespace eval dockingtray {
    variable balloon ""
    variable state   ""
    variable tray    ""

    variable icon
    array set icon {}
    
    variable options
    custom::defvar options(tray_blinks) 0 \
	[::msgcat::mc "When you have unread messages the systray icon will start to blink."] \
	-group IFace -type boolean
}

proc dockingtray::load {} {
    variable icon
    variable tray

    if {[winfo exists [set tw .tkabber-dock]]} {
        destroy $tw
    }
    theme:frame $tw -kdesystray
    if {[catch { image type trayblank }]} {
	image create photo trayblank -height 22 -width 22
	trayblank blank
    }

    bind $tw <Any-Enter>  \
	[list eval [list balloon::default_balloon $tw enter  %X %Y] \
	       \[[namespace current]::balloon_text\]]
    bind $tw <Any-Motion> \
        [list eval [list balloon::default_balloon $tw motion  %X %Y \
	       \[[namespace current]::balloon_text\]]]
    bind $tw <Any-Leave>  \
        [list balloon::default_balloon $tw leave  %X %Y]

    menubutton $tw.mb -borderwidth 0 -direction above -image trayblank \
	-highlightthickness 0 -padx 0 -pady 0 -menu [set m $tw.mb.menu]
    pack $tw.mb

    foreach tag [bind Menubutton] {
        if {[string first 1 $tag] >= 0} {
            regsub -all 1 $tag 3 new
            bind $tw.mb $new [bind Menubutton $tag]
            bind $tw.mb $tag break
        }
    }
    bind $tw.mb <ButtonRelease-1> {
        switch -- [wm state .] {
            normal  { wm state . withdrawn }
            default { wm state . normal }
        }
    }

    menu $m -title "Tkabber" -tearoff $ifacetk::options(show_tearoffs) \
	-postcommand "[namespace current]::post $m"
    $m add command -label [::msgcat::mc "About"] \
	-command ::ifacetk::about_window
    $m add separator
    $m add cascade -label [::msgcat::mc "Presence"] \
	-menu [menu [set pm $m.presence] \
		   -tearoff $ifacetk::options(show_tearoffs)]
    if {$ifacetk::options(show_tearoffs)} {
	set i 1
    } else {
	set i 0
    }
    for {} {$i <= [[set p .presence.button.menu] index end]} {incr i} {
        $pm add command -label [lindex [$p entryconfigure $i -label] 4] \
                        -command  [lindex [$p entryconfigure $i -command] 4]
    }
    $m add command -label [::msgcat::mc "Log in..."] -command ifacetk::login_dialog
    $m add command -label [::msgcat::mc "Log out"]   -command logout
    $m add command -label [::msgcat::mc "Log out with reason..."]  -command show_logout_dialog
    $m add separator
    $m add command -label [::msgcat::mc "Hide Main Window"]  -command "wm state . withdrawn"
    $m add command -label [::msgcat::mc "Show Main Window"]  -command "wm state . normal"
    $m add separator
    $m add command -label [::msgcat::mc "Quit"]  -command quit

    set tray ""
    foreach var [list curuserstatus tabcolors] {
        trace variable ::$var w "[namespace current]::update $tw.mb"
    }

    foreach {k v} [list available   available      \
			away        available-away \
			chat        available-chat \
			dnd         available-dnd  \
			xa          available-xa   \
		        unavailable unavailable    \
		        invisible   invisible      \
			message1    message-server \
			message2    message        \
			message3    message-personal] {
        set icon($k) [Bitmap::get [pixmap docking ${v}.gif]]
    }
}


proc dockingtray::balloon_text {} {
    global userstatusdesc textstatus

    if {![cequal $textstatus ""]} {
	return $textstatus
    }
    return $userstatusdesc
}


proc dockingtray::post {m} {
    switch -- [wm state .] {
        normal {
            set state1 disabled
            set state2 normal
        }

        default {
            set state1 normal
            set state2 disabled
        }
    }
    $m entryconfigure [$m index [::msgcat::mc "Show Main Window"]] -state $state1
    $m entryconfigure [$m index [::msgcat::mc "Hide Main Window"]] -state $state2
}


proc dockingtray::update {mb name1 {name2 ""} {op ""}} {
    global   curuserstatus tabcolors

    variable icon
    variable tray

    if {![winfo exists $mb]} {
	return
    }

    switch -- [string trimleft $name1 :] {
        curuserstatus {
            if {[cequal $tray ""]} {
                $mb configure -image $icon($curuserstatus)
            }
        }

        tabcolors {
            toggle $mb 0 1
        }
    }
}


proc dockingtray::toggle {mb ff {firstP 0}} {
    global   curuserstatus tabcolors
    variable options
    variable icon
    variable state
    variable tray

    if {![cequal $tray ""]} {
        after cancel $tray
        set tray ""
    }

    set hitP 0
    foreach {k v} [array get tabcolors] {
        if {![winfo exists .nb.f$k]} {
            continue
        }
        if {(![cequal $v ""]) && ($v > $hitP)} {
            set hitP $v
            break
        }
    }

    if {$hitP == 0} {
        set state [wm state .]
        update $mb ::curuserstatus
        return
    }

    set state [wm state .]
    if {$firstP} {
        set state $state
    } elseif {(![cequal $state normal]) \
		    && ([cequal $state normal])} {
        update $mb ::curuserstatus
        return
    }

    if {![winfo exists $mb]} {
	return
    }

    if {$options(tray_blinks)} {
	set tray [after 500 [list [namespace current]::toggle $mb [expr {!$ff}]]]
	if {$ff} {
	    set image $icon(message$hitP)
	} else {
	    set image trayblank
	}
    } else {
	set tray message
	set image $icon(message$hitP)
    }
    $mb configure -image $image

}


proc dockingtray::set_status {text} {
    variable balloon

    switch -- [wm state .] {
        normal { }
        default {
            if {![cequal $balloon ""]} {
                after cancel $balloon
            }
	    
	    if {![winfo exists .tkabber-dock]} {
		return
	    }
	    balloon::set_text $text
	    balloon::show [winfo rootx .tkabber-dock] \
                          [winfo rooty .tkabber-dock]
	    set balloon [after 15000 balloon::destroy]
        }
    }
}

hook::add set_status_hook [namespace current]::dockingtray::set_status

proc dockingtray::clear_status {} {
    variable balloon

    if {![cequal $balloon ""]} {
        after cancel $balloon
    }
    balloon::destroy
}

hook::add clear_status_hook [namespace current]::dockingtray::clear_status

hook::add finload_hook [namespace current]::dockingtray::load

