# $Id: avatars.tcl,v 1.2 2004/12/21 23:31:23 aleksey Exp $

if {![cequal $::interface tk]} return

namespace eval ::avatar {
    set options(announce) 0
    set options(share) 0
}

proc ::avatar::setup_menu {} {
    catch {
	#set m [.mainframe getmenu services]
	#for {set ind [$m index end]} {$ind > 0} {incr ind -1} {
	#    if {[$m type $ind] == "separator"} {
	#	break
	#    }
	#}
	set m [.mainframe getmenu plugins]
	set ind [$m index end]

	set mm .avatar_menu
	menu $mm -tearoff $ifacetk::options(show_tearoffs)
	$mm add checkbutton -label [::msgcat::mc "Announce"] \
	    -variable avatar::options(announce)
	$mm add checkbutton -label [::msgcat::mc "Allow downloading"] \
	    -variable avatar::options(share)
	$mm add command -label [::msgcat::mc "Send to server"] \
	    -command {avatar::store_on_server}

	$m insert $ind cascade -label [::msgcat::mc "Avatar"] \
	    -menu $mm
    }
}

hook::add finload_hook ::avatar::setup_menu

package require base64
package require sha1

proc ::avatar::load_file {filename} {
    variable avatar
    variable options

    image create photo user_avatar -file $filename
    set f [open $filename]
    fconfigure $f -translation binary
    set data [read $f]
    close $f

    set avatar(userhash) [sha1::sha1 $data]
    set avatar(userdata) [base64::encode $data]

    set options(announce) 1
    set options(share) 1
}

proc ::avatar::get_presence_x {acc connid status} {
    variable avatar
    variable options

    if {$options(announce) && [info exists avatar(userhash)]} {
	set children [jlib::wrapper:createtag hash -chdata $avatar(userhash)]
	lappend acc [jlib::wrapper:createtag x -vars {xmlns jabber:x:avatar} \
			 -subtags [list $children]]

    }
    return $acc
}

hook::add presence_xlist_hook ::avatar::get_presence_x

proc ::avatar::process_presence_x {connid from type xs} {
    foreach x $xs {
	jlib::wrapper:splitxml $x tag vars isempty chdata children
	if {[jlib::wrapper:getattr $vars xmlns] == "jabber:x:avatar"} {
	    set_hash $connid $from $children
	    break
	}
    }
}

hook::add presence_process_x_hook ::avatar::process_presence_x

proc ::avatar::insert_userinfo {tab connid jid editable} {
    set avatar_img [get_image $connid [get_jid_of_user $connid $jid]]
    if {$avatar_img != ""} {
	set avatar [$tab insert end avatar -text [::msgcat::mc "Avatar"]]

	set av [userinfo::pack_frame $avatar.avatar [::msgcat::mc "Avatar"]]
	label $av.a -image $avatar_img
	pack $av.a -expand yes -fill both
    }
}

hook::add userinfo_hook ::avatar::insert_userinfo 40

proc ::avatar::set_hash {connid jid children} {
    variable avatar

    debugmsg avatar "set hash $connid $jid $children"
    foreach child $children {
	jlib::wrapper:splitxml $child tag vars isempty chdata children1
	if {$tag == "hash"} {
	    set hash $chdata
	}
    }
    if {[info exists hash]} {
	if {![info exists avatar(hash,$connid,$jid)] || $hash != $avatar(hash,$connid,$jid)} {
	    set avatar(hash,$connid,$jid) $hash
	    set avatar(needupdate,$connid,$jid) 1
	}
    }
}


proc ::avatar::get_image {connid jid} {
    variable avatar

    debugmsg avatar "$jid; [array name avatar]"
    if {[info exists avatar(hash,$connid,$jid)]} {
	if {![info exists avatar(data,$connid,$jid)]} {
	    image create photo avatar$connid@$jid
	    get $connid $jid
	} elseif {$avatar(needupdate,$connid,$jid)} {
	    get $connid $jid
	}
	return avatar$connid@$jid
    } else {
	return ""
    }
}

proc ::avatar::get {connid jid} {
    variable avatar

    set avatar(needupdate,$connid,$jid) 0

    jlib::send_iq get \
	[jlib::wrapper:createtag query \
	     -vars {xmlns jabber:iq:avatar}] \
	-to $jid -command [list avatar::recv $connid $jid] \
	-connection $connid
}

proc ::avatar::recv {connid jid res child} {
    variable avatar

    if {![cequal $res OK]} {
	jlib::send_iq get [jlib::wrapper:createtag query \
			       -vars {xmlns storage:client:avatar}] \
	    -to [node_and_server_from_jid $jid] \
	    -command [list avatar::recv_from_serv $connid $jid] \
	    -connection $connid

	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children
    foreach child1 $children {
	jlib::wrapper:splitxml $child1 tag1 vars1 isempty1 chdata1 childrens1
	if {$tag1 == "data"} {
	    catch {
		set avatar(data,$connid,$jid) [base64::decode $chdata1]
		avatar$connid@$jid put $chdata1
	    }
	}
    }
}

proc ::avatar::recv_from_serv {connid jid res child} {
    variable avatar

    if {![cequal $res OK]} {
	# TODO
	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children
    foreach child1 $children {
	jlib::wrapper:splitxml $child1 tag1 vars1 isempty1 chdata1 children1
	if {$tag1 == "data"} {
	    catch {
		set avatar(data,$connid,$jid) [base64::decode $chdata1]
		avatar$connid@$jid put $chdata1
	    }
	}
    }
}

proc ::avatar::store_on_server {args} {
    variable avatar

    foreach {opt val} $args {
	switch -- $opt {
	    -connection { set connid $val }
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route ""]
    }

    if {![info exists avatar(userdata)]} {
	MessageDlg .avatar_error -aspect 50000 -icon error \
		-message [::msgcat::mc "No avatar to store"] -type user \
		-buttons ok -default 0 -cancel 0
	return
    }

    set restags \
	[list [jlib::wrapper:createtag data \
		   -chdata $avatar(userdata)]]
    set res [jlib::wrapper:createtag query \
		 -vars {xmlns storage:client:avatar} \
		 -subtags $restags]

    jlib::send_iq set $res -connection $connid
}


proc ::avatar::iq_reply {connid from child} {
    variable avatar
    variable options

    if {$options(share) && [info exists avatar(userdata)]} {
	set restags \
	    [list [jlib::wrapper:createtag data \
		       -chdata $avatar(userdata)]]
	set res [jlib::wrapper:createtag query \
		     -vars {xmlns jabber:iq:avatar} \
		     -subtags $restags]
    } else {
	return [list error cancel service-unavailable]
    }

    return [list result $res]
}

iq::register_handler get query jabber:iq:avatar ::avatar::iq_reply

