# $Id: iroster.tcl,v 1.35 2005/08/19 20:13:19 aleksey Exp $

Tree .faketree
foreach {k v} [list background       White \
		    foreground       Black] {
    if {[cequal [set t$k [option get .faketree $k Tree]] ""]} {
	set t$k $v
    }
}
destroy .faketree
Button .fakebutton
foreach {k v} [list background       Gray \
		    activeBackground LightGray] {
    if {[cequal [set b$k [option get .fakebutton $k Button]] ""]} {
	set b$k $v
    }
}
destroy .fakebutton

option add *Roster.cbackground           $tbackground       widgetDefault
option add *Roster.groupindent           22                 widgetDefault
option add *Roster.jidindent             24                 widgetDefault
option add *Roster.jidmultindent         40                 widgetDefault
option add *Roster.subjidindent          34                 widgetDefault
option add *Roster.groupiconindent        2                 widgetDefault
option add *Roster.subgroupiconindent    22                 widgetDefault
option add *Roster.iconindent             3                 widgetDefault
option add *Roster.subitemtype            1                 widgetDefault
option add *Roster.subiconindent         13                 widgetDefault
option add *Roster.textuppad              1	            widgetDefault
option add *Roster.textdownpad            1	            widgetDefault
option add *Roster.linepad                2	            widgetDefault
option add *Roster.foreground            $tforeground       widgetDefault
option add *Roster.jidfill               $tbackground       widgetDefault
option add *Roster.jidhlfill             $bactiveBackground widgetDefault
option add *Roster.jidborder             $tbackground       widgetDefault
option add *Roster.groupfill             $bbackground       widgetDefault
option add *Roster.groupcfill            $bbackground       widgetDefault
option add *Roster.grouphlfill           $bactiveBackground widgetDefault
option add *Roster.groupborder           $tforeground       widgetDefault
option add *Roster.stalkerforeground     #663333            widgetDefault
option add *Roster.unavailableforeground #666666            widgetDefault
option add *Roster.dndforeground         #666633            widgetDefault
option add *Roster.xaforeground          #004d80            widgetDefault
option add *Roster.awayforeground        #004d80            widgetDefault
option add *Roster.availableforeground   #0066cc            widgetDefault
option add *Roster.chatforeground        #0099cc            widgetDefault

unset tbackground tforeground bbackground bactiveBackground

namespace eval roster {
    custom::defgroup Roster [::msgcat::mc "Roster options."] -group Tkabber
    custom::defvar use_aliases 1 \
	[::msgcat::mc "Use aliases to show multiple users in one roster item."] \
	-type boolean -group Roster \
	-command [namespace current]::redraw_after_idle
    custom::defvar show_only_online 0 \
	[::msgcat::mc "Show only online users in roster."] \
	-type boolean -group Roster \
	-command [namespace current]::redraw_after_idle
    custom::defvar show_transport_icons 0 \
	[::msgcat::mc "Show native icons for transports/services in roster."] \
	-type boolean -group Roster \
	-command [namespace current]::redraw_after_idle
    custom::defvar show_transport_user_icons 0 \
	[::msgcat::mc "Show native icons for contacts, connected to transports/services in roster."] \
	-type boolean -group Roster \
	-command [namespace current]::redraw_after_idle
    custom::defvar options(nested) 0 \
	[::msgcat::mc "Enable nested roster groups."] \
	-type boolean -group Roster \
	-command [namespace current]::redraw_after_idle
    custom::defvar options(nested_delimiter) "::" \
	[::msgcat::mc "Default nested roster group delimiter."] \
	-type string -group Roster \
	-command [namespace current]::redraw_after_idle
    custom::defvar options(chats_group) 0 \
	[::msgcat::mc "Add chats group in roster."] \
	-type boolean -group Roster \
	-command [namespace current]::redraw_after_idle
    custom::defvar options(free_drop) 1 \
	[::msgcat::mc "Roster item may be dropped not only over group name\
but also over any item in group."] \
	-type boolean -group Roster
    custom::defvar options(show_subscription) 0 \
	[::msgcat::mc "Show subscription type in roster item tooltips."] \
	-type boolean -group Roster
    custom::defvar options(show_conference_user_info) 0 \
	[::msgcat::mc "Show detailed info on conference room members in roster item tooltips."] \
	-type boolean -group Roster

#   {jid1 {group1 1 group2 0} jid2 {group3 0 group4 0}}
    custom::defvar collapsed_group_list {} \
	[::msgcat::mc "Stored collapsed roster groups."] \
	-type string -group Hidden
#   {jid1 {group1 1 group2 0} jid2 {group3 0 group4 0}}
    custom::defvar show_offline_group_list {} \
	[::msgcat::mc "Stored show offline roster groups."] \
	-type string -group Hidden

    variable menu_item_idx 0

    variable undef_group_name $::roster::undef_group_name
    variable chats_group_name $::roster::chats_group_name
}

proc roster::get_group_lists {} {
    variable collapsed_group_list
    variable show_offline_group_list
    variable collapsed
    variable show_offline

    foreach {jid grlist} $collapsed_group_list {
	foreach {group val} $grlist {
	    set collapsed($jid,$group) $val
	}
    }
    foreach {jid grlist} $show_offline_group_list {
	foreach {group val} $grlist {
	    set show_offline($jid,$group) $val
	}
    }
}

hook::add finload_hook [namespace current]::roster::get_group_lists

proc roster::set_group_lists {connid} {
    variable collapsed_group_list
    variable show_offline_group_list
    variable collapsed
    variable show_offline
    variable roster
    variable options
    variable undef_group_name
    variable chats_group_name

    if {$connid == {}} {
	set connidlist [jlib::connections]
    } else {
	set connidlist [list $connid]
    }

    foreach connid $connidlist {
	if {[catch { set bare_jid [jlib::connection_bare_jid $connid] }]} {
	    continue
	}
	if {[catch { set groups [roster::get_groups $connid -raw 1] }]} {
	    continue
	}
	if {$options(nested)} {
	    set tmp {}
	    foreach group $groups {
		set tmp1 [::textutil::splitx $group $options(nested_delimiter)]
		for {set i 0} {$i < [llength $tmp1]} {incr i} {
		    lappend tmp [lrange $tmp1 0 $i]
		}
	    }
	    set groups [lrmdups $tmp]
	}
	lappend groups $undef_group_name $chats_group_name
	set tmpc {}
	set tmps {}
	foreach group $groups {
	    if {$options(nested)} {
		set grname [join $group $options(nested_delimiter)]
		set gid [list $connid $group]
	    } else {
		set grname [list $group]
		set gid [list $connid $grname]
	    }
	    if {[info exists roster(collapsed,$gid)]} {
		set collapsed($bare_jid,$grname) $roster(collapsed,$gid)
		lappend tmpc $grname $roster(collapsed,$gid)
	    }
	    if {[info exists roster(show_offline,$gid)]} {
		set show_offline($bare_jid,$grname) $roster(show_offline,$gid)
		lappend tmps $grname $roster(show_offline,$gid)
	    }
	}
	if {![lempty $tmpc]} {
	    while {[set idx [lsearch -exact $collapsed_group_list $bare_jid]] >= 0} {
		set collapsed_group_list \
		    [lreplace $collapsed_group_list $idx [expr {$idx + 1}]]
	    }
	    lappend collapsed_group_list $bare_jid $tmpc
	}
	if {![lempty $tmps]} {
	    while {[set idx [lsearch -exact $show_offline_group_list $bare_jid]] >= 0} {
		set show_offline_group_list \
		    [lreplace $show_offline_group_list $idx [expr {$idx + 1}]]
	    }
	    lappend show_offline_group_list $bare_jid $tmps
	}
	set custom::saved([namespace current]::collapsed_group_list) $collapsed_group_list
	set custom::saved([namespace current]::show_offline_group_list) $show_offline_group_list
	custom::store
    }
}

hook::add predisconnected_hook [namespace current]::roster::set_group_lists

proc roster::process_item {connid jid name groups subsc ask category subtype} {
    after cancel [namespace parent]::update_chat_titles
    after idle [namespace parent]::update_chat_titles
}

hook::add roster_item_hook [namespace current]::roster::process_item 90
hook::add roster_push_hook [namespace current]::roster::process_item 90

# TODO: get rid of roster::roster
proc roster::redraw {} {
    upvar #0 roster::aliases aliases
    variable roster
    variable rostericon
    variable options
    variable config
    variable show_only_online
    variable use_aliases
    variable show_transport_user_icons
    variable undef_group_name
    variable chats_group_name
    variable collapsed
    variable show_offline

    clear .roster 0
    
    set connections [jlib::connections]
    switch -- [llength $connections] {
	0 {
	    update_scrollregion .roster
	    return
	}
	1 {
	    set draw_connection 0
	    set gindent 0
	}
	default {
	    set draw_connection 1
	    set gindent 1
	}
    }

    foreach connid $connections {
        # Suppress display of aliases, but not if "main" JID is unavailable.
        # If main JID is unavailable, perform reordering of aliases.
        # Suppression means that aliases wont get a line in the roster for
	# themselves, but will be places as children under "main" JID element
	if {$use_aliases} {
	    foreach jid [array names aliases] {
		set status [get_user_status $connid $jid]
		if {$status == "unavailable"} {
		    # Need to look an alternative for main JID,
		    # which is offline.
		    set jidstatus [get_user_aliases_status_and_jid $connid $jid]
                    switch -- [lindex $jidstatus 1] {
                        unavailable {
                            # Main JID and all aliases are unavailable.
			    # Will skip them all
                        }
                        default {
                            # Make "most available" JID the main JID,
			    # put main JID into list of aliases
                            set new_jid [lindex $jidstatus 0]
                            set idx [lsearch -exact $aliases($jid) $new_jid]
                            set new_aliases [lreplace $aliases($jid) $idx $idx]
                            # If this already have some aliases defined,
			    # merge them in
                            if {[info exists aliases($new_jid)]} {
                                set new_aliases \
				    [lsort -unique -dictionary -index 0 \
					 [lappend new_aliases \
					      $aliases($new_jid)]]
                            }
                            set aliases($new_jid) $new_aliases
                            # Remove aliases of old "main" JID
                            set aliases($jid) {}
                        }
                    }
                }
                # Main JID is online, suppress alternatives
                foreach alias $aliases($jid) {
                    set ignore_jid($alias) ""
                }
            }
        }
        
	if {$draw_connection} {
	    if {![info exists roster(collapsed,[list connid $connid])]} {
		set roster(collapsed,[list connid $connid]) 0
	    }
	    addline .roster group \
		[jlib::connection_jid $connid] \
		[list connid $connid] [list connid $connid] 0
	    
	    if {$roster(collapsed,[list connid $connid])} {
		continue
	    }
	}

	if {[lempty [::roster::get_jids $connid]]} {
	    continue
	}
	set bare_jid [jlib::connection_bare_jid $connid]
	set groups {}
	array unset jidsingroup
	array unset jidsundergroup
	array unset groupsundergroup
	foreach jid [::roster::get_jids $connid] {
	    if {[info exists ignore_jid($jid)]} continue
	    set jid_groups [::roster::itemconfig $connid $jid -group]
	    if {![lempty $jid_groups]} {
		foreach group $jid_groups {
		    if {$options(nested)} {
			set sgroup [::textutil::splitx $group $options(nested_delimiter)]
		    } else {
			set sgroup [list $group]
		    }
		    lappend groups [list [join $sgroup "\u0000"] $sgroup]
		    lappend jidsingroup($sgroup) $jid
		    set deep [expr {[llength $sgroup] - 1}]
		    for {set i 0} {$i < $deep} {incr i} {
			set sgr [lrange $sgroup 0 $i]
			lappend groups [list [join $sgr "\u0000"] $sgr]
			lappend jidsundergroup($sgr) $jid
			lappend groupsundergroup($sgr) $sgroup
			if {![info exists jidsingroup($sgr)]} {
			    set jidsingroup($sgr) {}
			}
		    }
		    if {![info exists jidsundergroup($sgroup)]} {
			set jidsundergroup($sgroup) {}
		    }
		    if {![info exists groupsundergroup($sgroup)]} {
			set groupsundergroup($sgroup) {}
		    }
		}
	    } else {
		set sgroup [list $undef_group_name]
		lappend jidsingroup($sgroup) $jid
		set groupsundergroup($sgroup) {}
		if {![info exists jidsundergroup($sgroup)]} {
		    set jidsundergroup($sgroup) {}
		}
	    }
	}
	set groups [lsort -unique -dictionary -index 0 $groups]
	set ugroup [list $undef_group_name]
	if {[info exists jidsingroup($ugroup)]} {
	    lappend groups [list [join $ugroup "\u0000"] $ugroup]
	}
	if {$options(chats_group)} {
	    set cgroup [list $chats_group_name]
	    foreach chatid [array names chat::opened] {
		set cid [chat::get_connid $chatid]
		if {$cid == $connid} {
		    set jid [chat::get_jid $chatid]
		    lappend jidsingroup($cgroup) $jid
		    if {[cequal [roster::itemconfig $connid $jid -isuser] ""]} {
			roster::itemconfig $connid $jid -isuser 1
			roster::itemconfig $connid $jid \
			    -name [chat::get_nick $connid $jid chat]
			roster::itemconfig $connid $jid -subsc none
		    }
		}
	    }
	    if {[info exists jidsingroup($cgroup)]} {
		set groups [linsert $groups 0 [list [join $cgroup "\u0000"] $cgroup]]
	    }
	    set groupsundergroup($cgroup) {}
	    set jidsundergroup($cgroup) {}
	}
	foreach group $groups {
	    set group [lindex $group 1]
	    set gid [list $connid $group]
	    if {![info exists roster(show_offline,$gid)]} {
		if {$options(nested)} {
		    set gname [join $group $options(nested_delimiter)]
		} else {
		    set gname $group
		}
		if {[info exists show_offline($bare_jid,$gname)]} {
		    set roster(show_offline,$gid) $show_offline($bare_jid,$gname)
		} else {
		    set roster(show_offline,$gid) 0
		}
	    }
	}
	foreach group $groups {
	    set group [lindex $group 1]
	    set jidsingroup($group) [lrmdups $jidsingroup($group)]
	    set groupsundergroup($group) [lrmdups $groupsundergroup($group)]
	    set gid [list $connid $group]
	    if {![info exists roster(collapsed,$gid)]} {
		if {$options(nested)} {
		    set gname [join $group $options(nested_delimiter)]
		} else {
		    set gname $group
		}
		if {[info exists collapsed($bare_jid,$gname)]} {
		    set roster(collapsed,$gid) $collapsed($bare_jid,$gname)
		} else {
		    set roster(collapsed,$gid) 0
		}
	    }
	    set indent [expr {[llength $group] - 1}]
	    set collapse 0
	    set show_offline_users 0
	    set show_offline_group 0
	    foreach undergroup $groupsundergroup($group) {
		if {$roster(show_offline,[list $connid $undergroup])} {
		    set show_offline_group 1
		    break
		}
	    }
	    for {set i 0} {$i < $indent} {incr i} {
		set sgr [list $connid [lrange $group 0 $i]]
		if {$roster(collapsed,$sgr)} {
		    set collapse 1
		    break
		}
		if {$roster(show_offline,$sgr)} {
		    set show_offline_users 1
		    set show_offline_group 1
		}
	    }
	    incr indent $gindent
	    if {$collapse} continue
	    set group_name "[lindex $group end]"
	    set online 0
	    set users 0
	    set not_users 0
	    set sub_jids 0
	    foreach jid [concat $jidsingroup($group) $jidsundergroup($group)] {
		if {[::roster::itemconfig $connid $jid -isuser]} {
		    incr users
		    set status [get_user_aliases_status $connid $jid]
		    set jstat($jid) $status
		    if {$status != "unavailable"} {
			incr online
			set useronline($jid) 1
		    } else {
			set useronline($jid) 0
		    }
		} else {
		    incr not_users
		}
	    }
	    if {!$show_only_online || $show_offline_group || \
		    $roster(show_offline,$gid) || \
		    $online + $not_users + $sub_jids > 0} {
		if {$users} {
		    addline .roster group "$group_name ($online/$users)" \
			$gid $gid $indent
		} else {
		    addline .roster group $group_name \
			$gid $gid $indent
		}
	    }
	    if {!$roster(collapsed,$gid)} {
		set jid_names {}
		foreach jid $jidsingroup($group) {
		    lappend jid_names [list $jid [::roster::get_label $connid $jid]]
		}
		set jid_names [lsort -index 1 -dictionary $jid_names]
		foreach jid_name $jid_names {
		    lassign $jid_name jid name
		    if {$options(chats_group)} {
			set chatid [chat::chatid $connid $jid]
			if {[info exists chat::chats(messages,$chatid)] && \
				$chat::chats(messages,$chatid) > 0} {
			    append name " \[$chat::chats(messages,$chatid)\]"
			}
		    }
		    set cjid [list $connid $jid]
		    if {!$show_only_online || $show_offline_users || $roster(show_offline,$gid) || \
			    ![info exists useronline($jid)] || $useronline($jid)} {
			lassign [::roster::get_category_and_subtype $connid $jid] category type
			set jids [get_jids_of_user $connid $jid]
			set numjids [llength $jids]
			if {($numjids > 1) && ($config(subitemtype) > 0) && \
				$category == "user"} {
			    if {$config(subitemtype) & 1} {
				if {$category == "conference"} {
				    set numjids [expr {$numjids - 1}]
				}
				set label "$name ($numjids)"
			    } else {
				set label "$name"
			    }
			    addline .roster jid $label $cjid $gid $indent $jids
			    changeicon .roster $cjid [get_jid_icon $connid $jid]
			    changeforeground .roster $cjid [get_jid_foreground $connid $jid]
			    
			    if {!$roster(collapsed,$cjid)} {
				foreach subjid $jids {
				    set subjid_resource [resource_from_jid $subjid]
				    if {$subjid_resource != ""} {
					addline .roster jid2 \
					    $subjid_resource [list $connid $subjid] \
					    $gid $indent \
					    [list $subjid]
					changeicon .roster \
					    [list $connid $subjid] [get_jid_icon $connid $subjid]
					changeforeground .roster \
					    [list $connid $subjid] [get_jid_foreground $connid $subjid]
				    }
				}
			    }
			} else {
			    if {$numjids <= 1 && $category == "user" && \
				    !$show_transport_user_icons} {
				#set user [node_and_server_from_jid $jid]
				set status $jstat($jid)
				set subsc [::roster::itemconfig $connid $jid -subsc]
				if {([cequal $subsc from] || [cequal $subsc none]) && \
					$status == "unavailable"} {
				    set status stalker
				}
				addline .roster jid $name $cjid $gid $indent \
				    $jids \
				    $rostericon(user,$status) \
				    $config(${status}foreground)
			    } else {
				addline .roster jid $name $cjid $gid $indent $jids
				changeicon .roster $cjid [get_jid_icon $connid $jid]
				changeforeground .roster $cjid [get_jid_foreground $connid $jid]
			    }
			}
		    }
		}
	    }
	}
    }
    update_scrollregion .roster
}

proc roster::redraw_after_idle {args} {
    variable redraw_afterid

    if {[info exists redraw_afterid]} return

    if {![winfo exists .roster.canvas]} return

    set redraw_afterid \
	[after idle "[namespace current]::redraw
		     unset [namespace current]::redraw_afterid"]
}

# Callback
proc ::redraw_roster {args} {
    ifacetk::roster::redraw_after_idle
}

proc roster::get_jids_of_user {connid user} {
    upvar #0 roster::aliases aliases
    variable use_aliases

    if {$use_aliases && [info exists aliases($user)]} {
	set jids [::get_jids_of_user $connid $user]
	foreach alias $aliases($user) {
	    set jids [concat $jids [::get_jids_of_user $connid $alias]]
	}
	return $jids
    } else {
	return [::get_jids_of_user $connid $user]
    }
}

proc roster::get_user_aliases_status {connid user} {
    set jidstatus [get_user_aliases_status_and_jid $connid $user]
    return [lindex $jidstatus 1]
}

proc roster::get_user_aliases_status_and_jid {connid user} {
    upvar #0 roster::aliases aliases
    variable use_aliases

    if {$use_aliases && [info exists aliases($user)]} {
	set status [get_user_status $connid $user]
        set jid $user

	foreach alias $aliases($user) {
	    set new_status [max_status $status [get_user_status $connid $alias]]
            if {$status != $new_status} {
                set status $new_status
                set jid $alias
	}
	}
	return [list $jid $status]
    } else {
	return [list $user [get_user_status $connid $user]]
    }
}

proc roster::get_jid_foreground {connid jid} {
    lassign [::roster::get_category_and_subtype $connid $jid] category type

    switch -- $category {
	"" -
	user {
	    return [get_user_foreground $connid $jid]
	}
	conference {
	    if {[get_jid_status $connid $jid] != "unavailable"} {
		return available
	    } else {
		return unavailable
	    }
	}
	service {
	    return [get_service_foreground $connid $jid $type]
	}
	default {
	    return ""
	}
    }
}

proc roster::get_jid_icon {connid jid} {
    variable conferenceicon

    lassign [::roster::get_category_and_subtype $connid $jid] category type

    switch -- $category {
	"" {
	    return [get_user_icon $connid $jid]
	}
	user {
	    return [get_user_icon $connid $jid]
	}
	conference {
	    if {[get_jid_status $connid $jid] != "unavailable"} {
		return $conferenceicon(available)
	    }
	    return $conferenceicon(unavailable)
	}
	service {
		return [get_service_icon $connid $jid $type]
	}
	default {
	    return ""
	}
    }
}

proc roster::get_service_icon {connid service type} {
    variable show_transport_icons
    variable serviceicon
    variable rostericon

    if {$show_transport_icons} {
	switch -- $type {
	    jud {return $serviceicon(jud)}
	    sms {return $serviceicon(sms)}
	}
	if {![cequal [::roster::itemconfig $connid $service -subsc] none]} {
	    set status [get_user_status $connid $service]
	    set iconname serviceicon($type,$status)
	    if {[info exists $iconname]} {
		return [set $iconname]
	    } else {
		return $rostericon(user,$status)
	    }
	} else {
	    return $rostericon(user,stalker)
	}
    } else {
	if {![cequal [::roster::itemconfig $connid $service -subsc] none]} {
	    return $rostericon(user,[get_user_status $connid $service])
	} else {
	    return $rostericon(user,stalker)
	}
    }
}

proc roster::get_service_foreground {connid service type} {
    switch -- $type {
	jud {return ""}
	}
    if {![cequal [::roster::itemconfig $connid $service -subsc] none]} {
	return [get_user_status $connid $service]
    } else {
	return stalker
    }
}

proc roster::get_user_foreground {connid user} {
    set status [get_user_aliases_status $connid $user]

    set subsc [::roster::itemconfig $connid $user -subsc]
    if {[cequal $subsc ""]} {
	set subsc [::roster::itemconfig $connid \
		       [node_and_server_from_jid $user] -subsc]
    }

    if {([cequal $subsc from] || [cequal $subsc none]) && \
	    $status == "unavailable"} {
	return stalker
    } else {
	return $status
    }
}

proc roster::get_user_icon {connid user} {
    variable rostericon
    variable serviceicon
    variable show_transport_user_icons

    set status [get_user_aliases_status $connid $user]

    set subsc [::roster::itemconfig $connid $user -subsc]
    if {[cequal $subsc ""]} {
	set subsc [::roster::itemconfig $connid \
	               [node_and_server_from_jid $user] -subsc]
    }

    if {!([cequal $subsc from] || [cequal $subsc none]) || \
	    $status != "unavailable"} {
	if {$show_transport_user_icons} {
	    set service [server_from_jid $user]
	    lassign [::roster::get_category_and_subtype $connid $service] category type
	    switch -- $type {
		jud {return $serviceicon(jud)}
		sms {return $serviceicon(sms)}
	    }
	    if {[info exists serviceicon($type,$status)]} {
		return $serviceicon($type,$status)
	    } else {
		return $rostericon(user,$status)
	    }
	} else {
	    return $rostericon(user,$status)
	}
    } else {
	return $rostericon(user,stalker)
    }
}

proc roster::changeicon {w jid icon} {
    set c $w.canvas
    set tag [jid_to_tag $jid]

    $c itemconfigure jid$tag&&icon -image $icon
}

proc roster::changeforeground {w jid fg {color ""}} {
    variable config

    set c $w.canvas
    set tag [jid_to_tag $jid]
    if {$color == ""} {
	set color $config(${fg}foreground)
    }
    $c itemconfigure jid$tag&&text -fill $color
}

proc roster::create {w args} {
    variable iroster
    variable config

    set c $w.canvas
    
    set width 150
    set height 100
    set popupproc {}
    set grouppopupproc {}
    foreach {attr val} $args {
	switch -- $attr {
	    -width {set width $val}
	    -height {set height $val}
	    -popup {set popupproc $val}
	    -grouppopup {set grouppopupproc $val}
	}
    }

    frame $w -relief sunken -borderwidth $::tk_borderwidth -class Roster
    set sw [ScrolledWindow $w.sw]
    pack $sw -fill both -expand yes

    set config(groupindent)        [option get $w groupindent Roster] 
    set config(jidindent)          [option get $w jidindent   Roster]
    set config(jidmultindent)      [option get $w jidmultindent   Roster]
    set config(jid2indent)         [option get $w subjidindent Roster]
    set config(groupiconindent)    [option get $w groupiconindent  Roster]
    set config(subgroupiconindent) [option get $w subgroupiconindent  Roster]
    set config(iconindent)         [option get $w iconindent  Roster]
    set config(subitemtype)        [option get $w subitemtype  Roster]
    set config(subiconindent)      [option get $w subiconindent  Roster]
    set config(textuppad)          [option get $w textuppad   Roster]
    set config(textdownpad)        [option get $w textdownpad Roster]
    set config(linepad)	           [option get $w linepad     Roster]
    set config(background)  [option get $w cbackground Roster] 
    set config(jidfill)	    [option get $w jidfill     Roster]
    set config(jidhlfill)   [option get $w jidhlfill   Roster]
    set config(jidborder)   [option get $w jidborder   Roster]
    set config(jid2fill)    $config(jidfill)
    set config(jid2hlfill)  $config(jidhlfill)
    set config(jid2border)  $config(jidborder)
    set config(groupfill)   [option get $w groupfill   Roster]
    set config(groupcfill)  [option get $w groupcfill  Roster]
    set config(grouphlfill) [option get $w grouphlfill Roster]
    set config(groupborder) [option get $w groupborder Roster]
    set config(foreground)            [option get $w foreground  Roster]
    set config(stalkerforeground)     [option get $w stalkerforeground Roster]
    set config(unavailableforeground) [option get $w unavailableforeground Roster]
    set config(dndforeground)         [option get $w dndforeground Roster]
    set config(xaforeground)          [option get $w xaforeground Roster]
    set config(awayforeground)        [option get $w awayforeground Roster]
    set config(availableforeground)   [option get $w availableforeground Roster]
    set config(chatforeground)        [option get $w chatforeground Roster]

    canvas $w.canvas -bg $config(background) \
	-highlightthickness $::tk_highlightthickness \
	-scrollregion {0 0 0 0} \
	-width $width -height $height

    $sw setwidget $c

    set iroster($w,ypos) 1
    set iroster($w,width) 0
    set iroster($w,popup) $popupproc
    set iroster($w,grouppopup) $grouppopupproc

    bindscroll $w.canvas

    if {$w == ".roster"} {
	DropSite::register .roster.canvas -dropcmd [namespace current]::dropcmd \
	    -droptypes {JID}
	DragSite::register .roster.canvas -draginitcmd [namespace current]::draginitcmd
    }
}

proc roster::addline {w type text jid group indent {jids {}} {icon ""} {foreground ""}} {
    global font
    upvar #0 roster::aliases aliases
    variable roster
    variable rostericon
    variable iroster
    variable config
    variable use_aliases

    set c $w.canvas

    set tag [jid_to_tag $jid]
    set grouptag [jid_to_tag $group]

    set ypad 1
    set linespace [font metric $font -linespace]
    set lineheight [expr {$linespace + $ypad}]

    set uy $iroster($w,ypos)
    set ly [expr {$uy + $lineheight + $config(textuppad) + \
		      $config(textdownpad)}]

    set levindent [expr $config(groupindent)*$indent]

    if {$type == "group" && \
	[info exists roster(collapsed,$jid)] && \
	$roster(collapsed,$jid)} {
	set rfill $config(groupcfill)
    } else {
	set rfill $config(${type}fill)
    }

    $c create rectangle [expr {1 + $levindent}] $uy 10000 $ly -fill $rfill \
	-outline $config(${type}border) \
	-tags [list jid$tag group$grouptag $type rect]


    if {[cequal $type jid]} {
	lassign $jid connid jjid
	set isuser [::roster::itemconfig $connid $jjid -isuser]
	if {[cequal $isuser ""]} {
	    set isuser 1
	}

	set y [expr {($uy + $ly)/2}]
	set x [expr {$config(iconindent) + $levindent}]

	if {$icon == ""} {
	    $c create image $x $y -image $rostericon(user,unavailable) \
		-anchor w \
		-tags [list jid$tag group$grouptag $type icon]
	} else {
	    $c create image $x $y -image $icon \
		-anchor w \
		-tags [list jid$tag group$grouptag $type icon]
	}
	if {[llength $jids] > 1} {
	    if {[info exists roster(collapsed,$jid)] && !$roster(collapsed,$jid)} {
		set jid_state opened
	    } else {
		set roster(collapsed,$jid) 1
		set jid_state closed
	    }
	    if {$config(subitemtype) > 0} {
		if {($config(subitemtype) & 2) && $isuser} {
		    set y [expr {($uy + $ly)/2}]
		    set x [expr {$config(subgroupiconindent) + $levindent}]
		    $c create image $x $y -image $rostericon(group,$jid_state) -anchor w \
			-tags [list jid$tag group$grouptag $type group]
		}
	    }
	} else {
	    set roster(collapsed,$jid) 1
	}
    } elseif {[cequal $type jid2]} {
	#set jids [get_jids_of_user $jid]
	set y [expr {($uy + $ly)/2}]
	set x [expr {$config(subiconindent) + $levindent}]

	$c create image $x $y -image $rostericon(user,unavailable) -anchor w \
	    -tags [list jid$tag group$grouptag $type icon]
    } elseif {[cequal $type group]} {
	set y [expr {($uy + $ly)/2}]
	set x [expr {$config(groupiconindent) + $levindent}]
	if {[info exists roster(collapsed,$jid)] && $roster(collapsed,$jid)} {
	    set group_state closed
	} else {
	    set group_state opened
	}
	$c create image $x $y -image $rostericon(group,$group_state) -anchor w \
	    -tags [list jid$tag group$grouptag $type icon]
    }

    if {([cequal $type jid]) && ($config(subitemtype) > 0) && ($config(subitemtype) & 2)} {
	#set jids [get_jids_of_user $jid]
	if {$isuser && ([llength $jids] > 1)} {
	    set x [expr {$config(jidmultindent) + $levindent}]
	} else {
	    set x [expr {$config(jidindent) + $levindent}]
	}
    } else {
	set x [expr {$config(${type}indent) + $levindent}]
    }
    incr uy $config(textuppad)

    if {$foreground == ""} {
	if {[cequal $type jid] || [cequal $type jid2]} {
	    set foreground $config(unavailableforeground)
	} else {
	    set foreground $config(foreground)
	}
    }
    $c create text $x $uy -text $text -anchor nw -font $font \
	-fill $foreground -tags [list jid$tag group$grouptag $type text]

    set iroster($w,width) [max $iroster($w,width) \
			      [expr {$x + [font measure $font $text]}]]


    $c bind jid$tag <Any-Enter> \
	[list $c itemconfig jid$tag&&rect -fill $config(${type}hlfill)]
    $c bind jid$tag <Any-Leave> \
	[list $c itemconfig jid$tag&&rect -fill $rfill]

    set doubledjid  [double% $jid]

    $c bind jid$tag&&jid <Double-Button-1> \
	[list [namespace current]::jid_doubleclick $doubledjid]
    $c bind jid$tag&&jid2 <Double-Button-1> \
	[list [namespace current]::jid_doubleclick $doubledjid]

    set iroster($w,ypos) [expr {$ly + $config(linepad)}]

    if {[cequal $type jid] || [cequal $type jid2]} {
	set doubledjids [double% $jids]
	$c bind jid$tag <Any-Enter> \
	    +[list eval balloon::set_text \
		  \[[namespace current]::jids_popup_info \
		  [list $doubledjid] [list $doubledjids]\]]

	$c bind jid$tag <Any-Motion> \
	    [list eval balloon::on_mouse_move \
		 \[[namespace current]::jids_popup_info \
		 [list $doubledjid] [list $doubledjids]\] %X %Y]

	$c bind jid$tag <Any-Leave> {+ balloon::destroy}
	
	if {![cequal $iroster($w,popup) {}]} {
	    $c bind jid$tag <3> [list $iroster($w,popup) $doubledjid]
	}
    } else {
	if {$w == ".roster"} {
	    $c bind jid$tag&&group <Button-1> \
		[list [namespace current]::group_click $doubledjid]
	}

	if {![cequal $iroster($w,grouppopup) {}]} {
	    $c bind jid$tag&&group <3> \
		[list $iroster($w,grouppopup) $doubledjid]
	}
    }

    if {[cequal $type jid]} {
	if {$isuser \
		&& ([llength $jids] > 1)} {
	    if {$w == ".roster"} {
		$c bind jid$tag <Button-1> \
		    [list [namespace current]::user_singleclick $jid]
	    }
	}
    }
}

proc roster::clear {w {updatescroll 1}} {
    variable iroster

    $w.canvas delete rect||icon||text||group

    set iroster($w,ypos) 1
    set iroster($w,width) 0
    if {$updatescroll} {
	update_scrollregion $w
    }
}

proc roster::update_scrollregion {w} {
    variable iroster

    $w.canvas configure \
	-scrollregion [list 0 0 $iroster($w,width) $iroster($w,ypos)]
}

proc roster::jid_doubleclick {id} {
    lassign $id connid jid
    lassign [::roster::get_category_and_subtype $connid $jid] category subtype

    switch -- $category {
	conference {
	    if {[roster::itemconfig $connid $jid -subsc] == "bookmark"} {
		plugins::conferences::join_group $connid $jid
	    } else {
		global gr_nick
		join_group $jid \
		    -nick [get_group_nick $jid $gr_nick] \
		    -connection $connid
	    }
	}
	user -
	default {
	    if {[cequal $chat::options(default_message_type) chat]} {
		chat::open_to_user $connid $jid
	    } else {
		message::send_dialog -to $jid
	    }
	}
    }
}

proc roster::group_click {gid} {
    variable roster

    set roster(collapsed,$gid) [expr {!$roster(collapsed,$gid)}]
    redraw_after_idle
}

proc roster::jids_popup_info {id jids} {
    variable use_aliases

    lassign $id connid jid

    if {$jids == {}} {
	if {$use_aliases && [info exists aliases($jid)]} {
	    set jids [concat [list $jid] $aliases($jid)]
	} else {
	    set jids [list $jid]
	}
    }

    set text {}
    set i 0
    foreach j $jids {
	append text "\n[[namespace current]::user_popup_info $connid $j $i]"
	incr i
    }
    set text [string trimleft $text "\n"]
    return $text
}

proc roster::user_popup_info {connid user i} {
    variable options
    variable user_popup_info
    global statusdesc

    lassign [::roster::get_category_and_subtype $connid $user] category subtype
    set bare_user [node_and_server_from_jid $user]
    lassign [::roster::get_category_and_subtype $connid $bare_user] \
	category1 subtype1

    set name $user
    switch -- $category {
	conference {
	    set status $statusdesc([get_jid_status $connid $user])
	    set desc ""
	}
	user -
	default {
	    set status $statusdesc([get_user_status $connid $user])
	    set desc   [get_user_status_desc $connid $user]
	    if {[cequal $category1 conference] && $i > 0} {
		if {$options(show_conference_user_info)} {
		    set name "     [resource_from_jid $user]"
		} else {
		    set name "\t[resource_from_jid $user]"
		}
	    }
	}
    }

    if {(![string equal -nocase  $status $desc]) && (![cequal $desc ""])} {
	append status " ($desc)"
    }

    set subsc [::roster::itemconfig $connid $bare_user -subsc]
    if {($options(show_subscription) && ![cequal $subsc ""]) &&
	    !([cequal $category1 conference] && [cequal $category user])} {
	set subsc " \[$subsc\]"
    } else {
	set subsc ""
    }

    set user_popup_info "$name$subsc: $status"

    if {!([cequal $category1 conference] && $i > 0) || \
	    $options(show_conference_user_info)} {
	hook::run roster_user_popup_info_hook \
	    [namespace which -variable user_popup_info] $connid $user
    }

    return $user_popup_info
}

proc roster::switch_only_online {args} {
    variable show_only_online

    set show_only_online [expr {!$show_only_online}]
}

proc roster::is_online {connid jid} {
    if {[::roster::is_user $connid $jid]} {
	switch -- [get_user_aliases_status $connid $jid] {
	    unavailable {return 0}
	    default {return 1}
	}
    } else {
	return 1
    }
}

proc roster::remove_item_dialog {connid jid} {
    set res [MessageDlg .remove_item -aspect 50000 -icon question -type user \
	-buttons {yes no} -default 0 -cancel 1 \
	-message [format [::msgcat::mc "Are you sure to remove %s from roster?"] $jid]]
    if {$res == 0} {
	::roster::remove_item $connid $jid
    }
}

proc roster::update_chat_activity {args} {
    variable options

    if {$options(chats_group)} {
	redraw_after_idle
    }
}

hook::add open_chat_post_hook [namespace current]::roster::redraw_after_idle
hook::add close_chat_post_hook [namespace current]::roster::redraw_after_idle
hook::add draw_message_hook [namespace current]::roster::update_chat_activity
hook::add raise_chat_tab_hook [namespace current]::roster::update_chat_activity


###############################################################################

proc roster::dropcmd {target source X Y op type data} {
    variable options

    debugmsg roster "$target $source $X $Y $op $type $data"

    set c .roster.canvas

    set x [expr {$X-[winfo rootx $c]}]
    set y [expr {$Y-[winfo rooty $c]}]
    set xc [$c canvasx $x]
    set yc [$c canvasy $y]

    set tags [$c gettags [lindex [$c find closest $xc $yc] 0]]

    if {$options(free_drop) && ![cequal $tags ""]} {
	lassign [tag_to_jid [crange [lindex $tags 1] 5 end]] connid gr
	if {$connid == "connid"} {
	    set connid $gr
	    set gr {}
	}
    } elseif {[lcontain $tags group]} {
	lassign [tag_to_jid [crange [lindex $tags 0] 3 end]] connid gr
	if {$connid == "connid"} {
	    set connid $gr
	    set gr {}
	}
    } else {
	set connid [jlib::route ""]
	set gr {}
    }
    if {$options(nested)} {
	set gr [join $gr $options(nested_delimiter)]
    } else {
	set gr [lindex $gr 0]
    }

    debugmsg roster "GG: $gr; $tags"

    lassign $data jid category type name version fromgid

    if {[info exists fromgid]} {
	lassign $fromgid fromconnid fromgr 
	if {$options(nested)} {
	    set fromgr [join $fromgr $options(nested_delimiter)]
	} else {
	    set fromgr [lindex $fromgr 0]
	}
    }	

    if {![lcontain [::roster::get_jids $connid] $jid]} {
	if {$gr != {}} {
	    ::roster::itemconfig $connid $jid -category $category -subtype $type \
		-name $name -group [list $gr]
	} else {
	    ::roster::itemconfig $connid $jid -category $category -subtype $type \
		-name $name -group {}
	}
	lassign [::roster::get_category_and_subtype $connid $jid] ccategory ctype
	switch -- $ccategory {
	    user {
		jlib::send_presence -to $jid -type subscribe -connection $connid
	    }
	}
    } else {
	set groups [::roster::itemconfig $connid $jid -group]

	if {[info exists fromgid] && ($fromconnid == $connid)} {
	    set idx [lsearch -exact $groups $fromgr]
	    if {$idx >= 0} {
		set groups [lreplace $groups $idx $idx]
	    }
	}
	if {$gr != ""} {
	    lappend groups $gr
	    set groups [lrmdups $groups]
	    debugmsg roster $groups
	}

	::roster::itemconfig $connid $jid -category $category -subtype $type \
	    -name $name -group $groups
    }
    if {[::roster::itemconfig $connid $jid -subsc] == "bookmark"} {
	plugins::conferences::update_bookmark $connid $jid -groups $groups
    } else {
	::roster::send_item $connid $jid
    }
}

proc roster::draginitcmd {target x y top} {
    debugmsg roster "$target $x $y $top"

    balloon::destroy
    set c .roster.canvas

    set tags [$c gettags current]
    if {[lcontain $tags jid]} {
	set grouptag [crange [lindex $tags 1] 5 end]
	set gid [tag_to_jid $grouptag]
	set tag [crange [lindex $tags 0] 3 end]
	set cjid [tag_to_jid $tag]
	lassign $cjid connid jid

	set data [list $jid \
		      [::roster::itemconfig $connid $jid -category] \
		      [::roster::itemconfig $connid $jid -subtype] \
		      [::roster::itemconfig $connid $jid -name] {} \
		      $gid]

	debugmsg roster $data
	return [list JID {move} $data]
    } else {
	return {}
    }
}

###############################################################################

proc roster::popup_menu {id} {
    global curuser

    lassign $id connid jid
    set curuser $jid

    lassign [::roster::get_category_and_subtype $connid $jid] category subtype

    if {[roster::itemconfig $connid $jid -subsc] == "bookmark"} {
	set menu [plugins::conferences::popup_menu $connid $jid]
	common_menu $menu $connid $jid
    } else {
	switch -- $category {
	    conference {set menu [conference_popup_menu $connid $jid]}
	    user       {set menu [create_user_menu $connid $jid]}
	    service    {set menu [service_popup_menu $connid $jid]}
	    default    {set menu [jid_popup_menu $connid $jid]}
	}
    }

    tk_popup $menu [winfo pointerx .] [winfo pointery .]
}

proc roster::group_popup_menu {id} {
    variable options

    lassign $id connid name
    if {$options(nested)} {
	set name [join $name $options(nested_delimiter)]
    }
    if {$connid != "connid"} {
	tk_popup [create_group_popup_menu $connid $name] \
	    [winfo pointerx .] [winfo pointery .]
    }
}

proc roster::groupchat_popup_menu {id} {
    lassign $id connid jid
    tk_popup [create_groupchat_user_menu $connid $jid] \
	[winfo pointerx .] [winfo pointery .]
}

proc roster::add_menu_item {m label command jids} {
    variable menu_item_idx

    if {[llength $jids] == 0} {
	$m add command -label $label -command $command
    } elseif {[llength $jids] == 1} {
	set curuser $jids
	set com [subst -nobackslashes -nocommands $command]
	$m add command -label $label -command $com
    } else {
	set m2 [menu $m.[incr menu_item_idx] -tearoff 0]
	$m add cascad -label $label -menu $m2
	foreach jid $jids {
	    set curuser [list $jid]
	    set com [subst -nobackslashes -nocommands $command]
	    $m2 add command -label $jid -command $com
	}
    }
}

proc roster::collapse_item {cjid} {
    variable roster
    variable collapse_afterid

    unset collapse_afterid
    set roster(collapsed,$cjid) [expr {!$roster(collapsed,$cjid)}]
    redraw_after_idle
}

proc roster::user_singleclick {cjid} {
    variable collapse_afterid

    if {![info exists collapse_afterid]} {
	set collapse_afterid [after 300 [list [namespace current]::collapse_item $cjid]]
    } else {
	after cancel $collapse_afterid
	unset collapse_afterid
    }
}

proc roster::create_user_menu {connid user} {
    set jids [get_jids_of_user $connid $user]
    if {[winfo exists [set m .jidpopupmenu]]} {
	destroy $m
    }
    menu $m -tearoff 0
    add_menu_item $m [::msgcat::mc "Start chat"] \
	"chat::open_to_user $connid \$curuser" $jids
    add_menu_item $m [::msgcat::mc "Send message..."] \
	"message::send_dialog -to \$curuser -connection $connid" $jids
    add_menu_item $m [::msgcat::mc "Invite to conference..."] \
	"chat::invite_dialog \$curuser 0 -connection $connid" $jids
    $m add command -label [::msgcat::mc "Resubscribe"] \
	-command "jlib::send_presence -to \$curuser -type subscribe -connection $connid"

    hook::run roster_create_user_menu_hook $m $connid $jids

    $m add separator
    add_custom_presence_menu $m $connid $jids
    add_menu_item $m [::msgcat::mc "Send users..."] \
	"[namespace current]::send_users_dialog \$curuser -connection $connid" $jids
    # TODO: use ft::create_menu?
    if {$::ft::options(cascaded_menu)} {
	set mm [menu $m.filetransfer -tearoff 0]
	set flag 0
	if {$::ft::si::options(enable)} {
	    add_menu_item $mm [::msgcat::mc "via SI..."] \
		"ft::si::send_file_dialog \$curuser -connection $connid" $jids
	    set flag 1
	}
	if {$::ft::http::options(enable)} {
	    add_menu_item $mm [::msgcat::mc "via HTTP..."] \
		"ft::http::send_file_dialog \$curuser -connection $connid" $jids
	    set flag 1
	}
	if {$::ft::ftjl::options(enable)} {
	    add_menu_item $mm [::msgcat::mc "via Jidlink..."] \
		"ft::ftjl::send_file_dialog \$curuser -connection $connid" $jids
	    set flag 1
	}
	if {$flag} {
	    $m add cascad -label [::msgcat::mc "Send file"] -menu $mm
	}
    } else {
	if {$::ft::si::options(enable)} {
	    add_menu_item $m [::msgcat::mc "Send file via SI..."] \
		"ft::si::send_file_dialog \$curuser -connection $connid" $jids
	}
	if {$::ft::http::options(enable)} {
	    add_menu_item $m [::msgcat::mc "Send file via HTTP..."] \
		"ft::http::send_file_dialog \$curuser -connection $connid" $jids
	}
	if {$::ft::ftjl::options(enable)} {
	    add_menu_item $m [::msgcat::mc "Send file via Jidlink..."] \
		"ft::ftjl::send_file_dialog \$curuser -connection $connid" $jids
	}
    }


    $m add separator
    add_menu_item $m [::msgcat::mc "Show info"] \
	"userinfo::open \$curuser -connection [list $connid]" $jids
    $m add command -label [::msgcat::mc "Show history"] \
	-command {logger::show_log $curuser}
    $m add separator

    hook::run roster_create_user_menu_edit_hook $m $connid "\$curuser"

    $m add separator
    $m add command -label [::msgcat::mc "Remove item..."] \
	-command [list [namespace current]::remove_item_dialog $connid $user]

    return $m
}

namespace eval roster {
    set rostericon(user,available)   [Bitmap::get [pixmap roster available.gif]]
    set rostericon(user,away)        [Bitmap::get [pixmap roster available-away.gif]]
    set rostericon(user,chat)        [Bitmap::get [pixmap roster available-chat.gif]]
    set rostericon(user,dnd)         [Bitmap::get [pixmap roster available-dnd.gif]]
    set rostericon(user,xa)          [Bitmap::get [pixmap roster available-xa.gif]]
    set rostericon(user,unavailable) [Bitmap::get [pixmap roster unavailable.gif]]
    set rostericon(user,invisible)   [Bitmap::get [pixmap roster invisible.gif]]
    set rostericon(user,stalker)     [Bitmap::get [pixmap roster stalker.gif]]
    set rostericon(user,error)       [Bitmap::get [pixmap roster unavailable.gif]]

    set rostericon(group,opened)     [Bitmap::get [pixmap roster group-opened.gif]]
    set rostericon(group,closed)     [Bitmap::get [pixmap roster group-closed.gif]]

    set conferenceicon(available)    [Bitmap::get [pixmap roster conference-available.gif]]
    set conferenceicon(unavailable)  [Bitmap::get [pixmap roster conference-unavailable.gif]]

    set serviceicon(aim,available)   [Bitmap::get [pixmap services aim_online.xpm]]
    set serviceicon(aim,chat)        [Bitmap::get [pixmap services aim_chat.xpm]]
    set serviceicon(aim,away)        [Bitmap::get [pixmap services aim_away.xpm]]
    set serviceicon(aim,xa)          [Bitmap::get [pixmap services aim_xa.xpm]]
    set serviceicon(aim,dnd)         [Bitmap::get [pixmap services aim_dnd.xpm]]
    set serviceicon(aim,unavailable) [Bitmap::get [pixmap services aim_offline.xpm]]

    set serviceicon(icq,available)   [Bitmap::get [pixmap services icq_online.xpm]]
    set serviceicon(icq,chat)        [Bitmap::get [pixmap services icq_chat.xpm]]
    set serviceicon(icq,away)        [Bitmap::get [pixmap services icq_away.xpm]]
    set serviceicon(icq,xa)          [Bitmap::get [pixmap services icq_xa.xpm]]
    set serviceicon(icq,dnd)         [Bitmap::get [pixmap services icq_dnd.xpm]]
    set serviceicon(icq,unavailable) [Bitmap::get [pixmap services icq_offline.xpm]]

    set serviceicon(msn,available)   [Bitmap::get [pixmap services msn_online.xpm]]
    set serviceicon(msn,chat)        [Bitmap::get [pixmap services msn_chat.xpm]]
    set serviceicon(msn,away)        [Bitmap::get [pixmap services msn_away.xpm]]
    set serviceicon(msn,xa)          [Bitmap::get [pixmap services msn_xa.xpm]]
    set serviceicon(msn,dnd)         [Bitmap::get [pixmap services msn_dnd.xpm]]
    set serviceicon(msn,unavailable) [Bitmap::get [pixmap services msn_offline.xpm]]

    set serviceicon(x-gadugadu,available)   [Bitmap::get [pixmap services gg_online.gif]]
    set serviceicon(x-gadugadu,chat)        [Bitmap::get [pixmap services gg_chat.gif]]
    set serviceicon(x-gadugadu,away)        [Bitmap::get [pixmap services gg_away.gif]]
    set serviceicon(x-gadugadu,xa)          [Bitmap::get [pixmap services gg_xa.gif]]
    set serviceicon(x-gadugadu,dnd)         [Bitmap::get [pixmap services gg_dnd.gif]]
    set serviceicon(x-gadugadu,unavailable) [Bitmap::get [pixmap services gg_offline.gif]]

    set serviceicon(x-weather,available)   [Bitmap::get [pixmap services weather_online.gif]]
    set serviceicon(x-weather,chat)        [Bitmap::get [pixmap services weather_chat.gif]]
    set serviceicon(x-weather,away)        [Bitmap::get [pixmap services weather_away.gif]]
    set serviceicon(x-weather,xa)          [Bitmap::get [pixmap services weather_xa.gif]]
    set serviceicon(x-weather,dnd)         [Bitmap::get [pixmap services weather_dnd.gif]]
    set serviceicon(x-weather,unavailable) [Bitmap::get [pixmap services weather_offline.gif]]

    set serviceicon(yahoo,available)   [Bitmap::get [pixmap services yahoo_online.xpm]]
    set serviceicon(yahoo,chat)        [Bitmap::get [pixmap services yahoo_chat.xpm]]
    set serviceicon(yahoo,away)        [Bitmap::get [pixmap services yahoo_away.xpm]]
    set serviceicon(yahoo,xa)          [Bitmap::get [pixmap services yahoo_xa.xpm]]
    set serviceicon(yahoo,dnd)         [Bitmap::get [pixmap services yahoo_dnd.xpm]]
    set serviceicon(yahoo,unavailable) [Bitmap::get [pixmap services yahoo_offline.xpm]]

    set serviceicon(sms) [Bitmap::get [pixmap services sms.xpm]]
    set serviceicon(jud) [Bitmap::get [pixmap services jud.gif]]

    set serviceicon(rss,available)   [Bitmap::get [pixmap services rss_online.xpm]]
    set serviceicon(rss,chat)        [Bitmap::get [pixmap services rss_chat.xpm]]
    set serviceicon(rss,away)        [Bitmap::get [pixmap services rss_away.xpm]]
    set serviceicon(rss,xa)          [Bitmap::get [pixmap services rss_xa.xpm]]
    set serviceicon(rss,dnd)         [Bitmap::get [pixmap services rss_dnd.xpm]]
    set serviceicon(rss,unavailable) [Bitmap::get [pixmap services rss_offline.xpm]]
}

proc roster::common_menu {m connid jid} {
    $m add separator
    $m add command -label [::msgcat::mc "Show info"] \
	-command [list userinfo::open $jid -connection $connid]
    $m add command -label [::msgcat::mc "Show history"] \
	-command [list logger::show_log $jid]
    $m add separator

    hook::run roster_create_user_menu_edit_hook $m $connid $jid

    $m add separator
    $m add command -label [::msgcat::mc "Remove item..."] \
	-command [list [namespace current]::remove_item_dialog $connid $jid]
    return $m
}

proc roster::jid_popup_menu {connid jid} {
    if {[winfo exists [set m .jidpopupmenu]]} {
	destroy $m
    }
    menu $m -tearoff 0
    $m add command -label [::msgcat::mc "Start chat"] \
	-command [list chat::open_to_user $connid $jid]
    $m add command -label [::msgcat::mc "Send message..."] \
	-command [list message::send_dialog -to $jid -connection $connid]
    $m add command -label [::msgcat::mc "Invite to conference..."] \
	-command [list chat::invite_dialog $jid 0 -connection $connid]
    $m add command -label [::msgcat::mc "Resubscribe"] \
	-command [list jlib::send_presence \
		      -to $jid \
		      -type subscribe \
		      -connection $connid]
    $m add separator
    $m add command -label [::msgcat::mc "Send users..."] \
	-command [list [namespace current]::send_users_dialog $jid -connection $connid]
    ft::create_menu $m $jid -connection $connid
    common_menu $m $connid $jid
}

proc roster::conference_popup_menu {connid jid} {
    if {[winfo exists [set m .confpopupmenu]]} {
	destroy $m
    }
    menu $m -tearoff 0
    $m add command -label [::msgcat::mc "Join..."] \
	-command [list join_group_dialog \
		      -server [server_from_jid $jid] \
		      -group [node_from_jid $jid] \
		      -connection $connid]
    common_menu $m $connid $jid
}

proc roster::service_popup_menu {connid jid} {
    if {[winfo exists [set m .servicepopupmenu]]} {
	destroy $m
    }
    menu $m -tearoff 0
    # TODO
    $m add command -label [::msgcat::mc "Log in"] -command {
	switch -- $userstatus {
	    available { jlib::send_presence -to $curuser }
	    invisible { jlib::send_presence -to $curuser -type $userstatus }
	    default   { jlib::send_presence -to $curuser -show $userstatus }
	}
    }
    # TODO
    $m add command -label [::msgcat::mc "Log out"] -command {
	jlib::send_presence -to $curuser -type unavailable
    }
    hook::run service_popup_menu_hook $m $connid $jid
    common_menu $m $connid $jid
}

proc roster::create_groupchat_user_menu {connid jid} {
    if {[winfo exists [set m .groupchatpopupmenu]]} {
	destroy $m
    }
    menu $m -tearoff 0
    $m add command -label [::msgcat::mc "Start chat"] \
	-command [list chat::open_to_user $connid $jid]
    $m add command -label [::msgcat::mc "Send message..."] \
	-command {} -state disabled
    hook::run roster_create_groupchat_user_menu_hook $m $connid $jid
    $m add separator
    $m add command -label [::msgcat::mc "Send users..."] \
	-command [list [namespace current]::send_users_dialog $jid \
		       -connection $connid]
    ft::create_menu $m $jid -connection $connid
    $m add command -label [::msgcat::mc "Invite to conference..."] \
	-command [list chat::invite_dialog $jid 0 -connection $connid]
    $m add separator
    $m add command -label [::msgcat::mc "Show info"] \
	-command [list userinfo::open $jid -connection $connid]
    $m add command -label [::msgcat::mc "Show history"] \
	-command {} -state disabled
    return $m
}

proc roster::create_group_popup_menu {connid name} {
    variable options
    variable chats_group_name

    if {$name == $chats_group_name} {
	set state disabled
    } else {
	set state normal
    }

    if {[winfo exists [set m .grouppopupmenu]]} {
	destroy $m
    }
    if {$options(nested)} {
	set oname [::textutil::splitx $name $options(nested_delimiter)]
    } else {
	set oname $name
    }
    menu $m -tearoff 0
    $m add command -label [::msgcat::mc "Rename group..."] \
	-command [list [namespace current]::rename_group_dialog $connid $name] \
	-state $state
    $m add command \
	-label [::msgcat::mc "Send message to all users in group..."] \
	-command [list ::message::send_dialog \
		       -to $name -group 1 -connection $connid]
    $m add command \
	-label [::msgcat::mc "Resubscribe to all users in group..."] \
	-command [list ::roster::resubscribe_group $connid $name]
    $m add checkbutton -label [::msgcat::mc "Show offline users"] \
	-variable [namespace current]::roster(show_offline,[list $connid $oname]) \
	-command [list [namespace current]::redraw_after_idle]
    $m add command -label [::msgcat::mc "Remove group..."] \
	-command [list [namespace current]::remove_group_dialog $connid $name] \
	-state $state
    $m add command -label [::msgcat::mc "Remove all users in group..."] \
	-command [list [namespace current]::remove_users_group_dialog $connid $name]
    return $m
}

###############################################################################

proc roster::remove_group_dialog {connid name} {
    set res [MessageDlg .remove_item -aspect 50000 -icon question -type user \
		 -buttons {yes no} -default 0 -cancel 1 \
		 -message [format [::msgcat::mc "Are you sure to remove group '%s' from roster?\
\n(Users which are in this group only, will be in undefined group.)"] $name]]

    if {$res == 0} {
	roster::send_rename_group $connid $name ""
    }
}

proc roster::remove_users_group_dialog {connid name} {
    set res [MessageDlg .remove_item -aspect 50000 -icon question -type user \
		 -buttons {yes no} -default 0 -cancel 1 \
		 -message [format [::msgcat::mc "Are you sure to remove all users in group '%s' from roster?\
\n(Users which are in another groups too, will not be removed from the roster.)"] $name]]

    if {$res == 0} {
	roster::send_remove_users_group $connid $name
    }
}

proc roster::rename_group_dialog {connid name} {
    global new_roster_group_name

    set new_roster_group_name $name

    set w .roster_group_rename
    if {[winfo exists $w]} {
	destroy $w
    }
    
    Dialog $w -title [::msgcat::mc "Rename roster group"] \
	-separator 1 -anchor e -default 0 -cancel 1

    $w add -text [::msgcat::mc "OK"] -command \
	[list [namespace current]::confirm_rename_group $w $connid $name]
    $w add -text [::msgcat::mc "Cancel"] -command [list destroy $w]

    set p [$w getframe]
    
    label $p.lgroupname -text [::msgcat::mc "New group name:"]
    ecursor_entry [entry $p.groupname -textvariable new_roster_group_name]

    grid $p.lgroupname  -row 0 -column 0 -sticky e
    grid $p.groupname   -row 0 -column 1 -sticky ew

    focus $p.groupname
    $w draw
}

proc roster::confirm_rename_group {w connid name} {
    global new_roster_group_name
    variable roster

    destroy $w

    ::roster::send_rename_group $connid $name $new_roster_group_name

    set gid [list $connid $name]
    set newgid [list $connid $new_roster_group_name]

    if {[info exists roster(collapsed,$gid)]} {
	set roster(collapsed,$newgid) $roster(collapsed,$gid)
	unset roster(collapsed,$gid)
    }
    if {[info exists roster(show_offline,$gid)]} {
	set roster(show_offline,$newgid) $roster(show_offline,$gid)
	unset roster(show_offline,$gid)
    }
}
	
proc roster::add_group_by_jid_regexp_dialog {} {
    global new_roster_group_rname
    global new_roster_group_regexp

    set w .roster_group_add_by_jid_regexp
    if {[winfo exists $w]} {
	destroy $w
    }
    
    Dialog $w -title [::msgcat::mc "Add roster group by JID regexp"] \
	-separator 1 -anchor e -default 0 -cancel 1

    $w add -text [::msgcat::mc "OK"] -command "
	destroy [list $w]
	roster::add_group_by_jid_regexp \
	    \$new_roster_group_rname \$new_roster_group_regexp
    "
    $w add -text [::msgcat::mc "Cancel"] -command [list destroy $w]

    set p [$w getframe]
    
    label $p.lgroupname -text [::msgcat::mc "New group name:"]
    ecursor_entry [entry $p.groupname -textvariable new_roster_group_rname]
    label $p.lregexp -text [::msgcat::mc "JID regexp:"]
    ecursor_entry [entry $p.regexp -textvariable new_roster_group_regexp]

    grid $p.lgroupname -row 0 -column 0 -sticky e
    grid $p.groupname  -row 0 -column 1 -sticky ew
    grid $p.lregexp    -row 1 -column 0 -sticky e
    grid $p.regexp     -row 1 -column 1 -sticky ew

    focus $p.groupname
    $w draw
}

###############################################################################

proc roster::send_users_dialog {user args} {
    global send_uc

    foreach {opt val} $args {
	switch -- $opt {
	    -connection { set connid $val }
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route $user]
    }
    set jid [get_jid_of_user $connid $user]

    if {[cequal $jid ""]} {
        set jid $user
    }

    set gw .contacts
    catch { destroy $gw }

    if {[catch { set nick [::roster::get_label $connid $user] }]} {
	if {[catch { set nick [chat::get_nick $connid \
					      $user groupchat] }]} {
	    set nick $user
	}
    }

    set choices {}
    set balloons {}
    foreach c [jlib::connections] {
	foreach choice [lsort -dictionary $roster::roster(jids,$c)] {
	    if {![cequal $roster::roster(category,$c,$choice) conference]} {
		lappend choices [list $c $choice] [::roster::get_label $c $choice]
		lappend balloons [list $c $choice] $choice
	    }
	}
    }
    if {[llength $choices] == 0} {
        MessageDlg ${gw}_err -aspect 50000 -icon info \
	    -message [::msgcat::mc "No users in roster..."] -type user \
	    -buttons ok -default 0 -cancel 0
        return
    }

    CbDialog $gw [format [::msgcat::mc "Send contacts to %s"] $nick] \
	[list [::msgcat::mc "Send"] \
	      [list roster::send_users $gw $jid -connection $connid] \
	      [::msgcat::mc "Cancel"] \
	      [list destroy $gw]] \
	send_uc $choices $balloons
}

###############################################################################

proc roster::setup_import_export_menus {args} {
    set emenu [.mainframe getmenu export_roster]
    set imenu [.mainframe getmenu import_roster]

    if {[winfo exists $emenu]} {
	destroy $emenu
    }
    menu $emenu -tearoff 0

    if {[winfo exists $imenu]} {
	destroy $imenu
    }
    menu $imenu -tearoff 0

    if {[jlib::connections] == {}} {
	.mainframe setmenustate export_roster disabled
	.mainframe setmenustate import_roster disabled
    } else {
	.mainframe setmenustate export_roster normal
	.mainframe setmenustate import_roster normal
    }

    foreach c [jlib::connections] {
	set jid [jlib::connection_jid $c]
	set label [format [::msgcat::mc "Roster of %s"] $jid]
	set ecommand [list roster::export_to_file $c]
	set icommand [list roster::import_from_file $c]
	$emenu add command -label $label -command $ecommand
	$imenu add command -label $label -command $icommand
    }
}
hook::add connected_hook [namespace current]::roster::setup_import_export_menus
hook::add disconnected_hook [namespace current]::roster::setup_import_export_menus
hook::add finload_hook [namespace current]::roster::setup_import_export_menus

###############################################################################

proc roster::add_custom_presence_menu {m connid jids} {
    set mm [menu $m.custom_presence -tearoff 0]

    add_menu_item $mm [::msgcat::mc "Available"] \
	"send_custom_presence \$curuser available -connection $connid" $jids
    add_menu_item $mm [::msgcat::mc "Free to chat"] \
	"send_custom_presence \$curuser chat -connection $connid" $jids
    add_menu_item $mm [::msgcat::mc "Away"] \
	"send_custom_presence \$curuser away -connection $connid" $jids
    add_menu_item $mm [::msgcat::mc "Extended away"] \
	"send_custom_presence \$curuser xa -connection $connid" $jids
    add_menu_item $mm [::msgcat::mc "Do not disturb"] \
	"send_custom_presence \$curuser dnd -connection $connid" $jids
    add_menu_item $mm [::msgcat::mc "Unavailable"] \
	"send_custom_presence \$curuser unavailable -connection $connid" $jids

    $m add cascad -label [::msgcat::mc "Send custom presence"] -menu $mm
}

###############################################################################

