# $Id: time.tcl,v 1.3 2003/06/22 20:06:12 aleksey Exp $


proc iq_time {connid from child} {
    jlib::wrapper:splitxml $child tag vars isempty chdata children

    set curtime [clock seconds]
    set restags \
	[list [jlib::wrapper:createtag utc \
		   -chdata [clock format $curtime \
				-format "%Y%m%dT%T" -gmt true]] \
	     [jlib::wrapper:createtag tz -chdata \
		  [timezone $curtime]] \
	     [jlib::wrapper:createtag display \
		  -chdata [displaytime $curtime]]]
    
    set res [jlib::wrapper:createtag query \
		 -vars {xmlns jabber:iq:time} \
		 -subtags $restags]
    
    return [list result $res]
}

proc timezone {time} {
    global tcl_platform

    if {[cequal $tcl_platform(platform) "windows"]} {
	return [string trim [encoding convertfrom utf-8 \
		[encoding convertto [clock format $time -format "%Z%t"]]]]
    } else {
	return [clock format $time -format %Z]
    }
}

proc displaytime {time} {
    global tcl_platform

    if {[cequal $tcl_platform(platform) "windows"]} {
	return [encoding convertfrom utf-8 \
		[encoding convertto [clock format $time]]]
    } else {
	return [clock format $time]
    }
}

iq::register_handler get query jabber:iq:time \
    [namespace current]::iq_time

