/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "outputcontrol.h"
#include "ConfigFile.H"
#include "main.h"
#include <iostream>
#include <fstream>
#include <wx/config.h>
#include <wx/settings.h>
#include <wx/txtstrm.h>
#include <wx/wfstream.h>

BEGIN_EVENT_TABLE(TtOutputControl, wxTextCtrl)
  EVT_SET_FOCUS(TtOutputControl::onSetFocus)
  EVT_MOUSE_EVENTS(TtOutputControl::onMouse)
END_EVENT_TABLE()

TtOutputControl::TtOutputControl (wxWindow *parent)
  : wxTextCtrl(parent, 5, _T(""), wxDefaultPosition, wxDefaultSize,
	       wxNO_BORDER|wxTE_MULTILINE|wxTE_NOHIDESEL|wxTE_DONTWRAP|wxTE_READONLY/*|wxTE_RICH*/),
    localfont(0),
    textcolor(wxBLACK),
    bgcolor(wxWHITE),
    highlightCharPos(-1)
{
  wxFont* f = TtConfigFile::getPtr()->getMainWindowFont();
  setFont(*f);
  updateLook();
}

TtOutputControl::~TtOutputControl () {
  //empty descructor
}

/* This control is not allowed to have the focus!
 */
void TtOutputControl::onSetFocus (wxFocusEvent& event) {
  // no event skip
}
void TtOutputControl::onMouse (wxMouseEvent& event) {
  // no event skip
}

void TtOutputControl::updateLook () {
  wxTextAttr attribs(*(this->textcolor),
		     *(this->bgcolor),
		     *(this->localfont));
  SetDefaultStyle(attribs);
  SetStyle(0,GetLastPosition(),attribs);
  if (this->highlightCharPos>=0) {
    SetSelection(highlightCharPos,highlightCharPos+1);
  }
}

void TtOutputControl::setFont (wxFont& newFont) {
  if (newFont.GetEncoding() == wxFONTENCODING_ISO8859_1 ||
      newFont.GetEncoding() == wxFONTENCODING_ISO8859_15) {
    this->specialLineEndingChar=true;
  } else {
    this->specialLineEndingChar=false;
  }
  if (this->localfont != 0) {
    if (Hauptfenster::getPtr()->getLessonController() != 0 &&
	this->localfont->GetEncoding() != newFont.GetEncoding()) {
      LoadFile(this->fname);
    }
    delete this->localfont;
  }
  this->localfont = new wxFont(newFont);
  updateLook();
}

bool TtOutputControl::LoadFile (const wxString& filename) {
  Clear();

  if (filename.Length()==0) {
    return false;
  }
  wxFFileInputStream input(filename);
  if (!input.Ok()) {
    return false;
  }
  this->fname=filename;

  wxTextInputStream f(input);
  wxString lineEnding;
  if (this->specialLineEndingChar==true) {
    lineEnding << char(182);
  }
  lineEnding << _T('\n');
  wxString content;
  while(!input.Eof()) {
    content << f.ReadLine();
    content << lineEnding;
  }
  Freeze();
  *this << content;
  Thaw();
  highlightChar(0,0);
  return true;
}

void TtOutputControl::highlightChar (long line, long column) {
  this->highlightCharPos = XYToPosition(column,line);
  ShowPosition(this->highlightCharPos);
  SetSelection(this->highlightCharPos,this->highlightCharPos+1);
}

void TtOutputControl::Clear() {
  Freeze();
  wxTextCtrl::Clear();
  Thaw();
}
