/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "optionen.h"
#include "ConfigFile.H"
#include "wx/sizer.h"
#include "wx/config.h"

enum {
  BUTTON_SAVE = 43
};

BEGIN_EVENT_TABLE(ODialog, wxDialog)
  EVT_BUTTON(BUTTON_SAVE, ODialog::OnOK)
END_EVENT_TABLE()

ODialog::ODialog(wxWindow* parent)
  : wxDialog(parent, -1, _("Settings")/*,
	     wxDefaultPosition, wxSize(350,200),
	     wxDEFAULT_DIALOG_STYLE, _T("Settings")*/),
    descr1(this,-1, _("Language:")),
    descr2(this,-1, _("Keyboard layout:")),
    btnSave(this,BUTTON_SAVE, _("Save")),
    btnCancel(this,wxID_CANCEL, _("Cancel"))
{
  wxBoxSizer* dialogSizer = new wxBoxSizer(wxVERTICAL);
  wxGridSizer* optionSizer = new wxGridSizer(2,2,20,20);
  wxBoxSizer* buttonSizer = new wxBoxSizer(wxHORIZONTAL);
  
  wxString* l;

  /* These are the fields for the language settings
   */
  optionSizer->Add(&descr1,0,wxALIGN_LEFT);
  wxString langs[] = {
    _("German"),
    _("English")
  };
  this->selection1 = new wxComboBox(this, -1, _T(""), wxDefaultPosition,
				    wxDefaultSize, 2, langs,
				    wxCB_READONLY);
  l = TtConfigFile::getPtr()->getLanguage();
  if (*l == _T("german")) {
    this->selection1->SetSelection(0);
  } else {
    this->selection1->SetSelection(1);
  }
  optionSizer->Add(this->selection1);

  /* These are the fields for the keyboard layout settings
   */
  optionSizer->Add(&descr2,0,wxALIGN_LEFT);
  wxString maps[] = {
    _("German"),
    _("English")
  };
  this->selection2 = new wxComboBox(this, -1, _T(""), wxDefaultPosition,
				    wxDefaultSize, 2, maps,
				    wxCB_READONLY);
  l = TtConfigFile::getPtr()->getKeyboardLayout();
  if (*l == _T("german")) {
    this->selection2->SetSelection(0);
  } else {
    this->selection2->SetSelection(1);
  }
  optionSizer->Add(this->selection2);

  //finaly add all the options to the dialog
  dialogSizer->Add(optionSizer,0,wxALIGN_CENTER|wxALL,20);

  /* now the buttons
   */
  buttonSizer->Add(&this->btnSave,10,wxALIGN_CENTER|wxRIGHT,10);
  buttonSizer->Add(&this->btnCancel,10,wxALIGN_CENTER);
  //finally add the button to the dialog
  dialogSizer->Add(buttonSizer,0,
		   wxALIGN_CENTER|wxRIGHT|wxLEFT|wxBOTTOM,5);

  dialogSizer->SetSizeHints(this);
  SetSizer(dialogSizer);
  this->btnSave.SetFocus();
}

ODialog::~ODialog () {
  delete selection1;
  delete selection2;
}

void ODialog::OnOK (wxCommandEvent *event) {
  wxString l[] = {
    _T("german"),
    _T("english")
  };
  wxString* oldSel1 = TtConfigFile::getPtr()->getLanguage();
  wxString* oldSel2 = TtConfigFile::getPtr()->getKeyboardLayout();

  TtConfigFile::getPtr()->setLanguage(l[this->selection1->GetSelection()]);
  TtConfigFile::getPtr()->setKeyboardLayout(l[this->selection2->GetSelection()]);

  if (*oldSel1 != l[this->selection1->GetSelection()] ||
      *oldSel2 != l[this->selection2->GetSelection()]) {
    //note that this always refers to the comparison of
    //saved state against new saved state, NOT current application's state
    wxMessageBox(_("You may need to restart the program\nto let the new language setting take effect."),
		 _("Important!"), wxOK|wxICON_INFORMATION|wxCENTRE, this);
  }
  EndModal(wxID_OK);
}
