/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "main.h"
#include "lektion.h"
#include "kurs.h"
#include "info.h"
#include "optionen.h"
#include "auswahl.h"
#include "ConfigFile.H"
#include "../config.h"
#include <wx/fontdlg.h>
#include <wx/font.h>

// Icon
#if defined(__WXGTK__) || defined(__WXMOTIF__)
#  include "logo.xpm"
#endif

BEGIN_EVENT_TABLE(Hauptfenster, wxFrame)
  EVT_MENU(D_LektionLaden, Hauptfenster::OnLektionLaden)
  EVT_MENU(D_LPause, Hauptfenster::OnD_LektionPause)
  EVT_MENU(D_LektionBeenden, Hauptfenster::OnD_LBeenden)
  EVT_MENU(D_KLaden, Hauptfenster::OnD_KursLaden)
  EVT_MENU(D_Beenden, Hauptfenster::OnD_Beenden)
  EVT_MENU(C_RunContest, Hauptfenster::OnC_RunContest)
  EVT_MENU(C_ShowRanking, Hauptfenster::OnC_ShowRanking)
  EVT_MENU(C_EditContest, Hauptfenster::OnC_EditContest)
  EVT_MENU(O_SwitchBell, Hauptfenster::OnO_SwitchBell)
  EVT_MENU(O_Schriftwaehlen, Hauptfenster::OnO_Schriftwaehlen)
  EVT_MENU(O_Einstellungen, Hauptfenster::OnO_Einstellungen)
  EVT_MENU(Hilfe_Info,  Hauptfenster::OnHilfe_Info)
  EVT_SIZE(Hauptfenster::OnSize)
END_EVENT_TABLE()

IMPLEMENT_APP(tipptrainer)

bool tipptrainer::OnInit () {
  SetVendorName(_T("Pingos"));
  SetAppName(_T("Tipptrainer"));

  ::wxInitAllImageHandlers();

  // Internationalisierung
  wxString* lang = TtConfigFile::getPtr()->getLanguage();
  int syslang = wxLocale::GetSystemLanguage();
  LangDir l;
  if (*lang == _T("german")) {
    // only using wxLANGUAGE_GERMAN does not work
    switch (syslang) {
    case wxLANGUAGE_GERMAN_AUSTRIAN:
    case wxLANGUAGE_GERMAN_BELGIUM:
    case wxLANGUAGE_GERMAN_LIECHTENSTEIN:
    case wxLANGUAGE_GERMAN_LUXEMBOURG:
    case wxLANGUAGE_GERMAN_SWISS:
      m_locale.Init(syslang);
      break;
    default:
      m_locale.Init(wxLANGUAGE_GERMAN);
      break;
    }
    m_locale.AddCatalogLookupPathPrefix(l.GetFullPath());
    if (m_locale.AddCatalog(_T("tipptrainer")) == false) {
      // translation makes no sense
      // Maybe it should be in German? Has to be ASCII, though.
      ::wxLogError( wxString(_T("Could not load german gettext translation file.\n"))
		   +wxString(_T("This means that all texts that are not external resouces\n"))
		   +wxString(_T("will be English.")));
    }
  } else {
    // only using wxLANGUAGE_ENGLISH does not work
    switch (syslang) {
    case wxLANGUAGE_ENGLISH_UK:
    case wxLANGUAGE_ENGLISH_US:
    case wxLANGUAGE_ENGLISH_AUSTRALIA:
    case wxLANGUAGE_ENGLISH_BELIZE:
    case wxLANGUAGE_ENGLISH_BOTSWANA:
    case wxLANGUAGE_ENGLISH_CANADA:
    case wxLANGUAGE_ENGLISH_CARIBBEAN:
    case wxLANGUAGE_ENGLISH_DENMARK:
    case wxLANGUAGE_ENGLISH_EIRE:
    case wxLANGUAGE_ENGLISH_JAMAICA:
    case wxLANGUAGE_ENGLISH_NEW_ZEALAND:
    case wxLANGUAGE_ENGLISH_PHILIPPINES:
    case wxLANGUAGE_ENGLISH_SOUTH_AFRICA:
    case wxLANGUAGE_ENGLISH_TRINIDAD:
    case wxLANGUAGE_ENGLISH_ZIMBABWE:
      m_locale.Init(syslang);
      break;
    default:
      // we cannot make sure that the user actually want a locale
      // since the text language in this code in English,
      // none is really needed
      break;
    }
  }

  Hauptfenster *h = new Hauptfenster(); 
  SetTopWindow(h);
  h->Show(TRUE);
  return TRUE;
};

int tipptrainer::OnExit () {
  delete wxConfigBase::Set((wxConfigBase *) NULL);
  return 0;
}

Hauptfenster* Hauptfenster::localpointer = 0;

Hauptfenster::Hauptfenster ()
  : wxFrame((wxFrame *) NULL, -1, _T("PingoS Tipptrainer")),
    lcontrol(0)
{
  this->localpointer = this;
  SetIcon(wxICON(logo));
  SetTitle(_T("PingoS Tipptrainer ")+wxString::FromAscii(PACKAGE_VERSION));

  SetSize(TtConfigFile::getPtr()->getMainWindowSize());
  Move(TtConfigFile::getPtr()->getMainWindowPosition());

  // ****************************************** 
  // *Menus erzeugen
  // ******************************************
  MainMenu = new wxMenuBar;

  DateiMenu = new wxMenu;
  DateiMenu->Append(D_LPause, _("&Pause"),
		    _("Pauses the current lesson"));
  DateiMenu->Append(D_LektionBeenden, _("&Abort"),
		    _("Cancels the current lesson|class|contest"));
  DateiMenu->AppendSeparator();
  DateiMenu->Append(D_LektionLaden, _("&Lesson..."), /* never to be disabled */
		    _("Shows the lesson selection dialog"));
  DateiMenu->Append(D_KLaden, _("&Class..."), /* never to be disabled */
		    _("Show the class selection dialog"));
  DateiMenu->AppendSeparator();
  DateiMenu->Append(D_Beenden, _("E&xit"), /* never to be disabled */
		    _("Terminates the tipptrainer"));
  //default is an enabled menu item but not all should be
  DateiMenu->Enable(D_LektionBeenden, FALSE);
  DateiMenu->Enable(D_LPause, FALSE);


  ContestMenu = new wxMenu;
  ContestMenu->Append(C_RunContest,_("&Do the contest..."),
		      _("Runs the contest start wizard"));
  ContestMenu->Append(C_ShowRanking,_("Show Ranking..."),
		      _("Displays the ranking for the current contest"));
  ContestMenu->AppendSeparator();
  ContestMenu->Append(C_EditContest,_("Contest editor..."),
		      _("Select/add/remove/edit contests"));
  bool hasContests = TtConfigFile::getPtr()->contestsExist();
  ContestMenu->Enable(C_RunContest,hasContests);
  ContestMenu->Enable(C_ShowRanking,hasContests);

  OptionenMenu = new wxMenu;
  OptionenMenu->AppendCheckItem(O_SwitchBell,_("&Beep on error"),/* never to be disabled */
				_("Beep on type errors on/off"));
  OptionenMenu->Append(O_Schriftwaehlen, _("Select &font..."), /* never to be disabled */
		       _("Show the font selection dialog"));
  OptionenMenu->Append(O_Einstellungen, _("&Settings..."), /* never to be disabled */
		       _("Shows the settings dialog"));
  //setting defaults for some menu items
  OptionenMenu->Check(O_SwitchBell,TtConfigFile::getPtr()->getBellStatus());


  HilfeMenu = new wxMenu;
  HilfeMenu->Append(Hilfe_Info, _("A&bout..."),  /* never to be disabled */
		    _("Show information about the Tipptrainer team"));
  
  MainMenu->Append(DateiMenu, _("&File"));
  MainMenu->Append(ContestMenu, _("&Contest"));
  MainMenu->Append(OptionenMenu, _("&Options"));
  MainMenu->Append(HilfeMenu, _("&Help"));
  
  // Menubar dem Hauptfenster zuweisen
  SetMenuBar(MainMenu);

  // Statusbar erzeugen
  CreateStatusBar(4);
  int i[4]={-1, 100, 110, 100};
  SetStatusWidths(4, i);
  // Statusbartext setzten
  SetStatusText(_("Welcome to PingoS Tipptrainer"),0);
  SetStatusText(_T(""), 1);
  SetStatusText(_T(""),2);
  SetStatusText(_T(""),3);

  // SplitterWindow erzeugen
  sw = new wxSplitterWindow(this, 1);
  sw->SplitHorizontally(new TtOutputControl(sw),
			new TtInputControl(sw),
			TtConfigFile::getPtr()->getSashPosition(this->GetClientSize().y/2));
  Show(true);

  //show startup selection dialog
  Auswahldialog ad(this, -1,_T("PingoS Tipptrainer"));
  ad.Centre();
  wxCommandEvent* e = 0;
  switch (ad.ShowModal()) {
  case KL:
    e = new wxCommandEvent(wxEVT_COMMAND_MENU_SELECTED,
			   D_KLaden);
    break;
  case LL:
    e = new wxCommandEvent(wxEVT_COMMAND_MENU_SELECTED,
			   D_LektionLaden);
    break;
  case CS:
    e = new wxCommandEvent(wxEVT_COMMAND_MENU_SELECTED,
			   C_RunContest);
    break;
  default:
    break;
  };
  if (e != 0) {
    ProcessEvent(*e);
  }
}

Hauptfenster::~Hauptfenster () {
  TtConfigFile::getPtr()->setMainWindowSize(GetSize());
  TtConfigFile::getPtr()->setMainWindowPosition(GetPosition());
  TtConfigFile::getPtr()->setSashPosition(sw->GetSashPosition());
}

void Hauptfenster::OnHilfe_Info (wxCommandEvent& event) {
  Info_Dialog id(this);
  id.Centre();
  id.ShowModal();
}

void Hauptfenster::OnD_Beenden (wxCommandEvent& event) {
  Close();
}

void Hauptfenster::OnD_LBeenden (wxCommandEvent& event) {
  setLessonController(0);
}

void Hauptfenster::OnD_LektionPause (wxCommandEvent& event) {
  this->lcontrol->getLesson()->Pause();
}

void Hauptfenster::OnSize (wxSizeEvent& event) {
  event.Skip();
}

void Hauptfenster::OnO_Einstellungen (wxCommandEvent& event) {
  ODialog od(this);
  od.Center();
  od.ShowModal();
}

void Hauptfenster::OnLektionLaden (wxCommandEvent& event) {
  try {
    new Lektion();
  }
  catch (LessonController::Abbruch) {
  }
  catch (Lektion::LessonLoadedFailed) {
    setLessonController(0,false);
  }
}

void Hauptfenster::OnD_KursLaden (wxCommandEvent& event) {
  try {
    new Kurs(this);
  }
  catch (LessonController::Abbruch) {
    setLessonController(0,false);
  }
  catch (Kurs::DialogAborted) {
    setLessonController(0,false);
  }
  catch (Lektion::LessonLoadedFailed) {
    setLessonController(0,false);
  }
}

bool Hauptfenster::setLessonController(LessonController* c, bool deleteOld) {
  if (this->lcontrol == 0 || !deleteOld) {
    this->lcontrol=c;
  } else {
    if (this->lcontrol->runningLesson()) {
      wxString s;
      s.Printf(_("Abort current %s?"),this->lcontrol->getType().c_str());
      int answer = wxMessageBox(s,_("Abort request"),wxYES_NO,this);
      if (answer==wxYES) {
	delete this->lcontrol;
	this->lcontrol=c;
      } else {
	return false;
      }
    } else {
      delete this->lcontrol;
      this->lcontrol=c;
    }
  }
  DateiMenu->Enable(D_LektionBeenden, (this->lcontrol != 0));
  return true;
}

void Hauptfenster::OnO_Schriftwaehlen (wxCommandEvent& event) {
  wxFont* oldFont = TtConfigFile::getPtr()->getMainWindowFont();
  //we could do our own wxFontDialog but why?
  //somehow, the initial font stuff does not work :-(
  wxFont chosenFont = ::wxGetFontFromUser(this, *oldFont);
  if (chosenFont.Ok()) {
    this->GetInput()->setFont(chosenFont);
    this->GetOutput()->setFont(chosenFont);
    TtConfigFile::getPtr()->setMainWindowFont(chosenFont);
  }
  delete oldFont;
}

void Hauptfenster::OnO_SwitchBell (wxCommandEvent& WXUNUSED(event)) {
  TtConfigFile::getPtr()->toggleBellStatus();
}

void Hauptfenster::OnC_RunContest(wxCommandEvent& event){
  ContestDesc c = TtConfigFile::getPtr()->getContest(TtConfigFile::getPtr()->getSelectedContestId());
  try {
    new Contest(this,c);
  }
  catch(LessonController::Abbruch) {
    setLessonController(0,false);
  }
  catch (Lektion::LessonLoadedFailed) {
    setLessonController(0,false);
  }
}

#include "ContestRankingDlg.H"

void Hauptfenster::OnC_ShowRanking(wxCommandEvent& WXUNUSED(event)){
  ContestDesc c = TtConfigFile::getPtr()->getContest(TtConfigFile::getPtr()->getSelectedContestId());
  ContestRankingDlg ranking(this,c.title,c.dataFile,c.weight);
  ranking.ShowModal();
}

#include "ContestSelectDlg.H"

void Hauptfenster::OnC_EditContest(wxCommandEvent& WXUNUSED(event)){
  ContestSelectDlg* dialog = new ContestSelectDlg(this);
  dialog->ShowModal();
  bool hasContests = TtConfigFile::getPtr()->contestsExist();
  ContestMenu->Enable(C_RunContest,hasContests);
  ContestMenu->Enable(C_ShowRanking,hasContests);
}
