/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "ConfigFile.H"
#include "lektionsanweisung.h"
#include <wx/sizer.h>
#include <wx/statline.h>
#include <wx/image.h>
#include <wx/ffile.h>
#include <wx/config.h>

LessonStartDlg::LessonStartDlg(wxWindow* parent, int Lektion, wxString k,
			       wxWindowID id , const wxString& title, const wxPoint& pos, 
			       const wxSize& size , long style, const wxString& name)
  : wxDialog(parent, id, title, pos, size, style, name),
    lektion(Lektion)
{
  //read the picture path and add the picture
  wxString* tlayout = TtConfigFile::getPtr()->getKeyboardLayout();
  LessonDir f;
  f.AppendDir(*tlayout);
  wxString s(_T("lektion"));
  s << Lektion;
  f.SetName(s);
  f.SetExt(_T("png"));
  wxBitmap logo(f.GetFullPath(), wxBITMAP_TYPE_PNG);
  if (!logo.Ok()) {
    wxString error;
    error.Printf(_("Cannot load file %s"), f.GetFullName().c_str());
    ::wxLogError(error);
  }
  this->icon = new wxStaticBitmap(this, -1, logo);

  f.SetName(_T("lektion"));
  s.Empty();
  s << _T("a") << Lektion;
  f.SetExt(s);
  
  //load and insert the text
  wxString text;
  wxFFile file(f.GetFullPath());
  if (file.IsOpened()) {
    file.ReadAll(&text);
  } else {
    wxString error;
    error.Printf(_("Cannot load file %s"), f.GetFullName().c_str());
    ::wxLogError(error);
  }
  if (k!=_T("")) {
    text << _T("\n") << k;
  }

  //arrange the elements
  wxBoxSizer *dialogSizer = new wxBoxSizer(wxVERTICAL);
  dialogSizer->Add(icon, 0, wxLEFT|wxRIGHT|wxTOP|wxALIGN_CENTRE,10);
  dialogSizer->Add(CreateTextSizer(text),0,
		   wxEXPAND|wxLEFT|wxRIGHT|wxTOP,10);
  dialogSizer->Add(new wxStaticLine(this,-1),0,
		   wxEXPAND|wxLEFT|wxRIGHT|wxTOP,10);
  dialogSizer->Add(CreateButtonSizer(wxOK),0,
		   wxCENTRE|wxALL,10);
  dialogSizer->SetSizeHints(this);
  SetSizer(dialogSizer);
  Center();
}

LessonStartDlg::~LessonStartDlg () {
  delete this->icon;
}
