/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LEKTION_H
#define LEKTION_H

#include "LEntry.H"
#include "LessonController.H"
#include <wx/wx.h>
#include <wx/time.h>
#include <wx/textctrl.h>
#include <wx/timer.h>
#include <wx/config.h>

class Lektion : public LessonController {
public:
  //this will call the lesson chooser dialog
  //used by non-course lesson training (no LessonController)
  Lektion(LessonController* controller = 0, int id = wxID_ANY);
  //this will use a default lesson defined by index 'lesson'
  //needed for course mode
  Lektion(unsigned int lesson, LessonController* controller = 0, int id = wxID_ANY);
  //this allows to specify a specific file as lesson
  //needed for contest mode
  Lektion(const wxString& lessonFile, LessonController* controller = 0, int id = wxID_ANY);
  ~Lektion();

  //causes on constructor failure
  class LessonLoadedFailed {};

   // Ein neues Zeichen wurde eingegeben
  bool Eingabe(char c);
  // Der Buchstabe wurde das erste Mal richtig getippt ++m_richtig
  bool Richtig();

  // Ist das aktuelle Zeichen schonmal falsch eingeben worden?
  inline bool GetFalsch() { return m_falsch; };
  // Benutzer ist am Ende der Lektion angelangt
  bool LektionEnde();

  // Timer Ereignis
  void Notify();

  // Pause
  bool Pause();
  // Lektion abbrechen
  bool LektionAbbrechen();
  // Wirkliches Ende der Lektion?
  inline bool SetEnde() { m_eb = true; return true; };

  inline LEntry GetLessonData() { return LEntry(m_fehler,m_richtig,(time_t)sw.Time()/1000); };

  // welche Lektion ist eigentlich geladen?
  inline int GetLektion() { return m_lektion; }; 

private:
  //TO BE REPLACED: by an LEntry
  int m_fehler;
  int m_richtig;
  int m_return;
  int m_pos;

  LessonController* con;
  //not! the lesson index but the lesson "window" id
  //used when calling event pushing function of the
  //LessonController
  int lessonID;

  //the lesson index
  int m_lektion;

  //m_falsch wird bentigt, um zu registieren, ob der aktuelle
  //Buchstabe schonmal falsch eingeben wurde, um diesen dann rot darzustellen
  bool m_falsch;
  
  //m_eb wird bentigt um zu speichern ob die Lektion bis zum
  //Ende abgearbeitet wurde, oder ob sie vorher abgebrochen wurde
  bool m_eb;

  wxStopWatch sw;
  wxTimer timer;

  wxTextCtrl* m_input;
  wxTextCtrl* m_output;

  // Laden der Lektion
  bool LektionLaden();
  bool LektionLaden(unsigned int index);
  bool LektionLaden (const wxString& lessonFile);
  // Speichern des Ergebnisses
  bool ErgebnisSpeichern();
  // Lektionsanweisung anzeigen
  bool Lektionsanweisung(int l);

  void onLessonStart(wxCommandEvent& WXUNUSED(e));
  void onLessonAbort(wxCommandEvent& WXUNUSED(e));
  void onLessonFinish(wxCommandEvent& WXUNUSED(e));
  void onTimer(wxTimerEvent& WXUNUSED(e));

  DECLARE_EVENT_TABLE()
};

#endif
