/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "kurslaus.h"
#include "KLessonStatusSizer.H"
#include <wx/sizer.h>
#include <wx/statline.h>

BEGIN_EVENT_TABLE(kurslaus,wxDialog)
  EVT_BUTTON(wxID_ANY,kurslaus::onButton)
END_EVENT_TABLE()

kurslaus::kurslaus(wxWindow *parent, const LEntry& entry, const LKrit& krit)
  : wxDialog(parent, -1, _T(""))
{
  wxString t;
  t.Printf(_("Statistics for Lesson %d"), krit.getNummer());
  SetTitle(t);
  LessonDir f;
  f.SetFullName(_T("logo.png"));
  wxBitmap logo(f.GetFullPath(), wxBITMAP_TYPE_PNG);
  wxStaticBitmap *icon = new wxStaticBitmap(this, -1, logo);

  KLessonStatusSizer* statusSizer = new KLessonStatusSizer(this);
  statusSizer->setStatus(entry,krit);

  wxBoxSizer* subSizer = new wxBoxSizer(wxHORIZONTAL);
  subSizer->Add(icon,0,wxLEFT|wxRIGHT|wxTOP,10);
  subSizer->Add(statusSizer,0,wxALIGN_CENTER|wxRIGHT|wxTOP,10);

  wxBoxSizer* buttonSizer = new wxBoxSizer(wxHORIZONTAL);
  wxButton* b;
  if (entry <= krit) {
    buttonSizer->Add(b = new wxButton(this,NEXT_B,_("Next lesson")),10,wxALIGN_CENTER|wxRIGHT,10);
    b->SetFocus();
  }
  buttonSizer->Add(b = new wxButton(this,PREV_B,_("Repeat lesson")),10,wxALIGN_CENTER|wxRIGHT,10);
  if (entry > krit) {
    b->SetFocus();
  }
  buttonSizer->Add(new wxButton(this,wxID_CANCEL,_("Abort")),10,wxALIGN_CENTER);

  wxBoxSizer *topsizer = new wxBoxSizer(wxVERTICAL);
  topsizer->Add(subSizer);
  topsizer->Add(new wxStaticLine(this,-1),0,wxEXPAND|wxALL,10);
  topsizer->Add(buttonSizer,0,wxALIGN_CENTER|wxRIGHT|wxLEFT|wxBOTTOM,10);

  SetSizer(topsizer);
  topsizer->SetSizeHints(this);
  Center();
}

void kurslaus::onButton (wxCommandEvent& e){
  EndModal(e.GetId());
}
