/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "info.h"
#include "../config.h"
#include <wx/image.h>

BEGIN_EVENT_TABLE(Info_Dialog, wxDialog)
END_EVENT_TABLE()

Info_Dialog::Info_Dialog(wxWindow* parent)
  : wxDialog(parent, -1, _("About PingoS Tipptrainer")),
    BtnClose(this, wxID_CANCEL, _("Close"))
{
  wxBoxSizer* dialogSizer = new wxBoxSizer(wxVERTICAL);
  wxBoxSizer* topSizer = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer* bottomSizer = new wxBoxSizer(wxHORIZONTAL);

  LessonDir logopath;
  logopath.SetFullName(_T("logo.png"));
  this->logo = new wxBitmap(logopath.GetFullPath(), wxBITMAP_TYPE_PNG),
  this->canvas = new MyCanvas(this,this->logo,
			      wxDefaultPosition,
			      wxSize(this->logo->GetWidth(),
				     this->logo->GetHeight()));
  topSizer->Add(canvas,0,wxALIGN_CENTER|wxRIGHT,10);

  wxString msg;
  msg << _T("PingoS Tipptrainer\n")
      << _T("------------------\n")
      <<  _("Version") << _T(":      ") << wxString::FromAscii(PACKAGE_VERSION)
      << _T("\nhttp://www.pingos.org/tipptrainer/\n")
      <<  _("Licenced with the GPL 2.0")
      << _T("\n\n")
      <<  _("Authors:")
      << _T("\n")
      << _T("   Daniel Reith <DanR@gmx.de>\n")
      << _T("   Hendrik Sattler <pingos@hendrik-sattler.de>\n")
      << _T("   Heiko Degenhardt <hede@pingos.org>\n")
      << _T("   Torsten Hemm <T.Hemm@gmx.de>\n")
      << _T("   Andreas Kalbitz <felix@musik-workshop.de>\n")
      << _T("   Matthias Kleine <Matthias.Kleine@selflinux.de>\n")
      << _T("\n\n")
      <<  _("Please send feedback to") << _T("  ") << wxString::FromAscii(PACKAGE_BUGREPORT);

  this->message = new wxStaticText(this, -1, msg);
  topSizer->Add(this->message,1,wxALIGN_RIGHT|wxALL,10);
  
  bottomSizer->Add(&this->BtnClose,0,wxALL,10);

  dialogSizer->Add(topSizer,1,wxALIGN_TOP);
  dialogSizer->Add(bottomSizer,0,wxALIGN_CENTER);
  dialogSizer->SetSizeHints(this);
  
  //initialize the dialog behaviour
  SetSizer(dialogSizer);
  this->BtnClose.SetFocus();
}

Info_Dialog::~Info_Dialog () {
  delete this->logo;
  this->canvas->Destroy();
  this->message->Destroy();
}




BEGIN_EVENT_TABLE(MyCanvas, wxScrolledWindow)
    EVT_PAINT(MyCanvas::OnPaint)
END_EVENT_TABLE()

MyCanvas::MyCanvas(wxWindow* parent, wxBitmap* b, const wxPoint& pos, const wxSize& size)
  : wxScrolledWindow(parent, -1, pos, size) {

  logo = b;
}

MyCanvas::~MyCanvas () {
  //nothing to be done
}

void MyCanvas::OnPaint (wxPaintEvent& WXUNUSED(event)) {
  wxPaintDC dc(this);
  wxMemoryDC memDC;
  memDC.SelectObject(* logo);
  dc.Blit(0, 0, logo->GetWidth(), logo->GetHeight(), & memDC, 0, 0, wxCOPY, true);
  memDC.SelectObject(wxNullBitmap);
}
