/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LENTRY_H
#define LENTRY_H

#include <wx/datetime.h>

/* class LEntry
 * Diese Klasse reprsentiert die einzelnen Lektionen
 * innerhalb eines Kurses
 */
class LEntry {
public:
  LEntry(int fehler = 0, int richtig = 0, int zeit = 0);
  ~LEntry() {};

  void setFehler(unsigned int fehler) { this->falsch = fehler; };
  unsigned int getFehler() const { return this->falsch; };
  
  void setRichtig(unsigned int richtig) { this->richtig = richtig; };
  unsigned int getRichtig() const { return this->richtig; };
  
  void setZeit(time_t zeit) { this->zeit = zeit; };
  time_t getZeit() const { return this->zeit; };
  void setZeit(const wxString& zeit);
  wxString getZeitString () const { return wxDateTime(getZeit()).Format(_T("%X"),wxDateTime::TimeZone(wxDateTime::UTC)); };

  void setLine (unsigned int count) { this->line = count; };
  unsigned int getLine () { return this->line; };

  void setColumn (unsigned int count) { this->column = count; };
  unsigned int getColumn () { return this->column; };

  unsigned int getAnschlaege() const { return getRichtig()+getFehler(); };
  double getPromille() const;
  double getApM() const;

private:
  unsigned int falsch; //count of wrong inputs
  unsigned int richtig; //count of correct inputs
  time_t zeit; //time used for the lesson

  unsigned int line; //defines the line in a lesson
  unsigned int column; //defines the position in line
};

class LKrit; //forward declaration

bool operator> (const LEntry& entry, const LKrit& krit);
bool operator<= (const LEntry& entry, const LKrit& krit);

#endif
