/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTESTPROPDLG_H
#define CONTESTPROPDLG_H

#include "Contest.H"
#include <wx/wx.h>

class ContestPropDlg : public wxDialog {
public:
  ContestPropDlg (wxWindow* parent, const ContestDesc& cdata = ContestDesc());

  ContestDesc getContestDesc ();

private:
  ContestDesc settings;
  wxTextCtrl* title;
  wxTextCtrl* picture;
  wxTextCtrl* descr;
  wxTextCtrl* lesson;
  wxTextCtrl* data;
  wxSlider*   weight;

  wxSizer* wizardSettingsSizer ();
  wxSizer* lessonSettingsSizer ();
  wxSizer* buttonSizer ();
  wxSizer* sliderSizer ();

  void onSelectButton (wxCommandEvent& e);
  void onSaveButton (wxCommandEvent& e);

  DECLARE_EVENT_TABLE()
};

#endif
