##############################################################################
#
# Copyright (c) 2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import ir
import time
import os
import netsvc
import xmlrpclib

import wizard
from osv import osv

_import_form = '''<?xml version="1.0"?>
<form title="Initial import" />
'''

_import_fields = {}

_import_done_form = '''<?xml version="1.0"?>
<form title="Initial import">
<separator string="Taxes and languages succesfully imported" colspan="4" />
</form>'''

_import_done_fields = {}

def _do_import(self, cr, uid, data, context):
	website=osv.osv_pools.get('oscommerce.web').browse(cr, uid, [data['id']])[0]

	print "%s/tinyerp-syncro.php" % website.url
	server = xmlrpclib.ServerProxy("%s/tinyerp-syncro.php" % website.url)

	taxes = server.get_taxes()
	for tax in taxes:
		value={	'web_id'		: website.id,
				'oscommerce_id'	: tax[0],
				'name'			: tax[1]
			}
		osv.osv_pools.get('oscommerce.tax').create(cr, uid, value)

	languages = server.get_languages()
	for language in languages:
		value={	'web_id'		: website.id,
				'oscommerce_id'	: language[0],
				'name'			: language[1]
			}
		osv.osv_pools.get('oscommerce.lang').create(cr, uid, value)

	cr.commit()
	return {}

class wiz_oscommerce_initial(wizard.interface):

	states = {	'init'	: {	'actions'	: [_do_import],
							'result'	: {	'type'	: 'form',
											'arch'	: _import_done_form,
											'fields': _import_done_fields,
											'state'	: [('end', 'End')]
											}
							}
				}


wiz_oscommerce_initial('oscommerce.initial');
