# $Id: tinycdb.spec.in,v 1.2 2001/12/09 21:18:02 mjt Exp $
# tinycdb RPM spec file.
#
# This file is a part of tinycdb package by Michael Tokarev, mjt@corpit.ru.
# Public domain. 

Summary: A package for maintenance of constant databases
Name: tinycdb
Version: 0.73
Release: 1
Source: ftp://ftp.corpit.ru/pub/tinycdb/tinycdb-%version.tar.gz
Copyright: Public Domain
Group: System Environment/Libraries
Prefix: %{_prefix}
BuildRoot: %{_tmppath}/%{name}-root

%description
tinycdb is a small, fast and reliable utility set and subroutine
library for creating and reading constant databases. The database
structure is tuned for fast reading:

 - Successful lookups take normally just two disk accesses.
 - Unsuccessful lookups take only one disk access.
 - Small disk space and memory size requirements; a database
   uses 2048 bytes for the header and 24 bytes plus size of
   (key,value) per record.
 - Maximum database size is 4GB; individual record size is not
   otherwise limited.
 - Portable file format.
 - Fast creation of new databases.
 - No locking, updates are atomical.

This package contains both the utility and the development
files.

%prep
%setup -q

%build

make CFLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
%makeinstall
(cd $RPM_BUILD_ROOT && find . -type f) | \
 sed -e 's|\.||' -e 's|$|*|' > %name.files

%files -f %name.files
%defattr(-,root,root)

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
