/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 365 $
 * $Date: 2012-01-23 22:52:15 +0800 (Mon, 23 Jan 2012) $
 */
#ifndef INDII_GUI_HELP_HPP
#define INDII_GUI_HELP_HPP

#include "wx/html/helpctrl.h"

namespace indii {  
/**
 * Tint help.
 */
class Help {
public:
  /**
   * Initialize help system.
   */
  static void init(wxWindow* parent);

  /**
   * Terminate help system.
   */
  static void term();

  /**
   * Show help.
   *
   * @param section Section number. Default gives contents and welcome page.
   */
  static void show(const int section = 0);

private:
  /**
   * Help controller.
   */
  static wxHtmlHelpController* help;
  
  /**
   * Top-level frame for help window.
   *
   * @note Any of the wxHtmlHelp* classes causes a crash in Photoshop on Mac
   * on the second invocation of the plugin. Use something generic instead
   * and combine with wxHF_EMBEDDED
   */
  static wxDialog* frame;
  
  /**
   * Was the help file successfully loaded?
   */
  static bool haveHelp;
};
}

#endif
