/*
 * Copyright (C) 2004 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "layout-utils.h"
/* for MAX_NUM_HOURS */
#include "timer-applet.h"
/* for _() macro */
#include <libgnome/gnome-i18n.h>

GtkWidget *
create_group_box (GtkWidget *header_widget)
{
	GtkWidget *two_row_vbox;
	GtkWidget *two_column_hbox;
	GtkWidget *spacer_label;
	GtkWidget *content_vbox;
	
	two_row_vbox = gtk_vbox_new (FALSE, 6);
	two_column_hbox = gtk_hbox_new (FALSE, 0);
	spacer_label = gtk_label_new ("    ");
	content_vbox = gtk_vbox_new (FALSE, 6);
	
	gtk_box_pack_start (GTK_BOX (two_row_vbox), header_widget, FALSE, FALSE, 0);
	/* TO-DO: allow this to *not* expand if necessary - do this by packing in widget in content_vbox
	 * that will not expand & not fill
	 */
	gtk_box_pack_start (GTK_BOX (two_row_vbox), two_column_hbox, TRUE, TRUE, 0);
	
	gtk_box_pack_start (GTK_BOX (two_column_hbox), spacer_label, FALSE, FALSE, 0);
	/* TO-DO: allow this to *not* expand if necesssary */
	gtk_box_pack_start (GTK_BOX (two_column_hbox), content_vbox, TRUE, TRUE, 0);
	
	gtk_widget_show (spacer_label);
	gtk_widget_show (content_vbox);
	gtk_widget_show (two_column_hbox);
	
	g_object_set_data (G_OBJECT (two_row_vbox), "content-vbox", content_vbox);
	
	return two_row_vbox;
}

/*
GtkWidget *
create_group_box_with_label (const gchar *label)
{
	GtkWidget *label_widget;
	gchar *label_str;
	
	label_str = g_strdup_printf ("<span weight=\"bold\">%s</span>", label);
	label_widget = gtk_label_new (label_str);
	g_object_set (G_OBJECT (label_widget), "use-markup", TRUE, "xalign", 0.0, NULL);
	
	gtk_widget_show (label_widget);
	
	return create_group_box (label_widget);
}
*/

void
group_box_add_row_full (GtkWidget *group_box, GtkWidget *row_widget, gboolean expand, gboolean fill)
{
	GtkWidget *content_vbox;
	
	content_vbox = g_object_get_data (G_OBJECT (group_box), "content-vbox");
	
	gtk_box_pack_start (GTK_BOX (content_vbox), row_widget, expand, fill, 0);
}

void
group_box_add_row (GtkWidget *group_box, GtkWidget *row_widget)
{
	group_box_add_row_full (group_box, row_widget, FALSE, FALSE);
}

GtkWidget *
create_duration_chooser (void)
{
	GtkWidget *time_select_area;
	
	time_select_area = gtk_vbox_new (FALSE, 6);
	
	{
		GtkWidget *row_hbox;
		GtkWidget *label;
		GtkAdjustment *spin_adj;
		GtkWidget *spin_button;
		GtkSizeGroup *size_group;
		
		size_group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);

		g_object_set_data (G_OBJECT (time_select_area), "size-group", size_group);

		row_hbox = gtk_hbox_new (FALSE, 6);
		label = gtk_label_new_with_mnemonic (_("_Hours:"));
		g_object_set (G_OBJECT (label), "xalign", 0.0, NULL);
		gtk_size_group_add_widget (size_group, label);
		gtk_box_pack_start (GTK_BOX (row_hbox), label, FALSE, FALSE, 0);
		gtk_widget_show (label);
		spin_adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, MAX_NUM_HOURS, 1, 1, 1);
		spin_button = gtk_spin_button_new (spin_adj, 1.0, 0);
		g_object_set (G_OBJECT (spin_button), "activates-default", TRUE, NULL);
		gtk_label_set_mnemonic_widget (GTK_LABEL (label), spin_button);
		gtk_box_pack_start (GTK_BOX (row_hbox), spin_button, TRUE, TRUE, 0);
		gtk_widget_show (spin_button);
		gtk_box_pack_start (GTK_BOX (time_select_area), row_hbox, FALSE, FALSE, 0);
		gtk_widget_show (row_hbox);
		g_object_set_data (G_OBJECT (time_select_area), "spin-hours", spin_button);
		
		row_hbox = gtk_hbox_new (FALSE, 6);
		label = gtk_label_new_with_mnemonic (_("_Minutes:"));
		g_object_set (G_OBJECT (label), "xalign", 0.0, NULL);
		gtk_size_group_add_widget (size_group, label);
		gtk_box_pack_start (GTK_BOX (row_hbox), label, FALSE, FALSE, 0);
		gtk_widget_show (label);
		spin_adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 59, 1, 1, 1);
		spin_button = gtk_spin_button_new (spin_adj, 1.0, 0);
		g_object_set (G_OBJECT (spin_button), "activates-default", TRUE, NULL);
		gtk_label_set_mnemonic_widget (GTK_LABEL (label), spin_button);
		gtk_box_pack_start (GTK_BOX (row_hbox), spin_button, TRUE, TRUE, 0);
		gtk_widget_show (spin_button);
		gtk_box_pack_start (GTK_BOX (time_select_area), row_hbox, FALSE, FALSE, 0);
		gtk_widget_show (row_hbox);
		g_object_set_data (G_OBJECT (time_select_area), "spin-minutes", spin_button);
		
		row_hbox = gtk_hbox_new (FALSE, 6);
		label = gtk_label_new_with_mnemonic (_("_Seconds:"));
		g_object_set (G_OBJECT (label), "xalign", 0.0, NULL);
		gtk_size_group_add_widget (size_group, label);
		gtk_box_pack_start (GTK_BOX (row_hbox), label, FALSE, FALSE, 0);
		gtk_widget_show (label);
		spin_adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 59, 1, 1, 1);
		spin_button = gtk_spin_button_new (spin_adj, 1.0, 0);
		g_object_set (G_OBJECT (spin_button), "activates-default", TRUE, NULL);
		gtk_label_set_mnemonic_widget (GTK_LABEL (label), spin_button);
		gtk_box_pack_start (GTK_BOX (row_hbox), spin_button, TRUE, TRUE, 0);
		gtk_widget_show (spin_button);
		gtk_box_pack_start (GTK_BOX (time_select_area), row_hbox, FALSE, FALSE, 0);
		gtk_widget_show (row_hbox);
		g_object_set_data (G_OBJECT (time_select_area), "spin-seconds", spin_button);
	}
	
	return time_select_area;
}

GtkWidget *
duration_chooser_get_hours_spin (GtkWidget *duration_chooser)
{
	return g_object_get_data (G_OBJECT (duration_chooser), "spin-hours");
}

GtkWidget *
duration_chooser_get_minutes_spin (GtkWidget *duration_chooser)
{
	return g_object_get_data (G_OBJECT (duration_chooser), "spin-minutes");
}

GtkWidget *
duration_chooser_get_seconds_spin (GtkWidget *duration_chooser)
{
	return g_object_get_data (G_OBJECT (duration_chooser), "spin-seconds");
}

GtkSizeGroup *
duration_chooser_get_labels_size_group (GtkWidget *duration_chooser)
{
	return g_object_get_data (G_OBJECT (duration_chooser), "size-group");
}
