/*
 * Copyright (C) 2004 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "about-dialog.h"
#include <libgnomeui/libgnomeui.h>

void
about_dialog_show (GtkWidget **about_dialog_ptr)
{
	g_assert (about_dialog_ptr);
	
	if (*about_dialog_ptr) {
		gtk_window_present (GTK_WINDOW (*about_dialog_ptr));
		return;
	}

	{
		GdkPixbuf *pixbuf;
	
		static const gchar *authors[] = {
			"Jimmy Do <crispyleaves@gmail.com>",
			NULL
		};
		
		pixbuf = gdk_pixbuf_new_from_file (PIXMAPS_DIR "/timer-applet-icon.png", NULL);
		
		*about_dialog_ptr = gnome_about_new (_("Timer Applet"), VERSION,
			_("Copyright (c) 2004-2005 by Jimmy Do"),
			_("Released under the GNU General Public License.\n\n"
			"A timer applet for the perfect egg and beyond."),
				authors,
				NULL,
				NULL,
				pixbuf);
				
		if (pixbuf) {
			gdk_pixbuf_unref (pixbuf);
		}
		
		/* set *about_dialog_ptr to NULL when the about dialog gets destroyed */
		g_signal_connect (G_OBJECT (*about_dialog_ptr), "destroy", G_CALLBACK (gtk_widget_destroyed), about_dialog_ptr);
		gtk_widget_show (*about_dialog_ptr);
	}
}
