<?php // -*- coding:utf-8 -*-
// parameters:
// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated
// comments   : generate all comments (equal to close&module)
// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made
// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)
// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer
// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)
// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)
// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate langauage 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate langauage 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Your settings have been updated. <a href='tiki-admin.php?page=general'>Click here</a> or come back later see the changes. That is a known bug that will be fixed in the next release." => "Ваші установки поновлені.<a href='tiki-admin.php?page=general'>Натисніть тут</a> або поверніться пізніше, щоб побачити зміни. Це відома помилка, яка буде виправлена в наступній версії.",
"All Fields must be non empty" => "Всі поля мають бути заповненими",
"You do not have permission to write the mapfile" => "У Вас немає дозволів для запису файлу мапи",
"pageviews" => "переглядів",
"Invalid password.  You current password is required to change your email address." => "Пароль невірний. Для зміни адреси електронної пошти необхідно знати Ваш сучасний пароль.",
"note: those parameters are exclusive" => "зауваження: ці параметри виключні",
"Split a page into columns" => "Розділити сторінку на стовпчики",
"column" => "стовпчик",
"Insert theme styled aligned box on wiki page" => "Вставити стилізовану відповідно до теми рамку на сторінці вікі ",
"Reply to parent comment" => "Дати відповідь на коментар",
"compose message tpl" => "новий шаблон повідомлення",
"messages tpl" => "шаблон повідомлень",
"Fields to display:" => "Поля для показу:",
"View articles" => "Дивитись статті",
"PHPOpenTracker" => "PHPOpenTracker",
"Strict allows page names with only letters, numbers, underscore, dash, period and semicolon (dash, period and semicolon not allowed at the beginning and the end)." => "Жорстка схема дозволяє тільки створювати назви з літер, цифр, символа підкреслення, дефіса, крапки і крапки з комою (дефіс, крапка і крапка з комою не дозволяються на початку і в кінці).",
"Full adds accented characters." => "Повна схема додає також літери із знаками наголосу.",
"Complete allows <em>anything at all</em>.  I (<a\n    href=\"http:tikiwiki.org/tiki-index.php?page=UserPagerlpowell\">rlpowell</a>)\n    cannot guarantee that it is bug-free or secure." => "Повна схема дозволяє <em>будь які назви взагалі</em>.  Я (<a\n    href=\"http:tikiwiki.org/tiki-index.php?page=UserPagerlpowell\">rlpowell</a>)\n    не можу гарантувати, що цей варіант позбавлений помилок чи безпечний.",
"Note that this does not affect WikiWord recognition, only page names surrounded by (( and ))." => "Відмітьте, що це не впливає на розпізнавання слів WikiWord, тільки назви сторінок взяті в (( і )).",
"Enable watch by default for author" => "Дозволити слідкування за автором (неявно)",
"Enable watches when I am the editor" => "Дозволити слідкування коли я редактор",
"admin charts tpl" => "шабл. графіків адмін.",
"ChatAdmin" => "Адмін Балачок",
"ChatAdmin tpl" => "тпл. Адміна Балачок",
"admin content templates tpl" => "шабл. шаблонів адм. наповнення",
"admin ExternalWiki" => "Адмініструвати зовнішні Вікі",
"admin forums tpl" => "адмін шаблони форумів",
"admin hotwords tpl" => "адм. горячі слова tpl",
"admin HtmlPages" => "адмін. HtmlPages",
"admin HtmlPages tpl" => "адмін. HtmlPages tpl",
"WebMail accounts" => "Рахунки WebMail",
"admin mailin tpl" => "шабл. адмін. mailin",
"Edit tpl" => "Редаг. tpl",
"admin modules tpl" => "шабл. адмін. модулів",
"admin newsletters tpl" => "адмін шаблони листків новин",
"admin notifications tpl" => "admin notifications tpl",
"admin polls tpl" => "шабл. адмін. опитів",
"admin RSSmodules tpl" => "шабл. адмін. модулів RSS",
"admin structures tpl" => "шаблони адмністрування структур",
"admin surveys tpl" => "шаблони адміністрування опитів",
"admin topics tpl" => "шаблони адміністрування тем",
"admin groups tpl" => "шабл. адмін. груп",
"admin users tpl" => "шабл. адмін. користувачів",
"-1m" => "-1m",
"-7d" => "-7d",
"-1d" => "-1d",
"Publish/Event Date" => "Дата публікації/події",
"Remove Zones (you lose entered info for thebanner)" => "Стерти зони (Ви втратите інформацію про гасла)",
"For more information, please see <a\nhref=\"http:www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\non <a href=\"http:www.tikiwiki.org\">TikiWiki.org</a>." => "За додатвовою інформацією зверніться на <a\nhref=\"http:www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\non <a href=\"http:www.tikiwiki.org\">TikiWiki.org</a>.",
"file galleries tpl" => "шаблон галерей файлів",
"You can view the page by following this link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page}" => "Ви можете переглянути сторінку, слідуючи за цим посиланням:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page}",
"You can edit the page by following this link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page}" => "Ви можете відредагувати цю сторінку, слідуючи за цим посиланням:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page}&diff2={\$mail_last_version}" => "Ви можете переглянути відмінності від попередньої версії, слідуючи за цим\nпосиланням:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page}&diff2={\$mail_last_version}",
"MyTikiDoc" => "MyTikiDoc",
"Received Pages" => "Отримані сторінки",
"Send Objects" => "Відіслати об'єкти",
"Webmail Doc tpl" => "шабл. Документації Веб-пошти",
"Older Messages" => "Старіші листи",
"Skip to Content" => "Перейти до Змісту",
"change email" => "змінити ел. пошту",
"change password" => "змінити пароль",
"Edit this Repository:" => "Редагувати це сховище:",
"Create New Repository:" => "Створити нове сховище:",
"Use preg_replace or str_replace to filter text" => "Вживайте preg_replace або str_replace щоб відфільтровувати текст",
"Use case sensitive str_replace" => "Вживати str_replace з врахуванням малих/великих літер",
"HTLM preview" => "Попередній перегляд HTLM",
"Test file from repository (empty = configured start page)" => "Пробний файл із сховища (порожній = настроєно на стартову сторінку)",
"You are not permitted to edit someone else\\'s post!" => "Ви не маєте дозволу редагувати чужі повідомлення!",
"Only an admin can remove a thread." => "Тільки адмінстратор має право на видалення низки.",
"Name, path and start page are mandatory fields" => "Ім'я, маршрут доступу та стартова сторінка обов'язкові",
"Requested action in not supportted on repository" => "Запрошена дія не підтримується в цьому сховищі",
"Unexistant link" => "Неіснуюче посилання",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory" => "Не можу доступитись до URL: або помила в ULR, або майданчик зараз не працює. Не можливо додати URL до бази",
"Mus enter a name to add a site" => "Потрібно ввести назву щоб додати майданчик",
"updated by the phpwiki import process" => "поновлено процесон імпортування з phpwiki",
"created from phpwiki import" => "створено процесон імпортування з phpwiki",
"Wiki page" => "Сторінка Вікр",
"Unexistant gallery" => "Неіснуюча галерея",
"Your Tiki account information for" => "Інформація про рахунок Тікі для ",
"A password reminder email has been sent " => "Лист з нагадуванням пароля надісланий ",
"A new password has been sent " => "Новий пароль надісланий ",
"Unexistant version" => "Неіснуюча версія",
"Quiz time limit excedeed quiz cannot be computed" => "Обмеження по часу для цієї вікторини перевищене* Результат не можна обрахувати.",
"Upload was not successful (maybe a duplicate file)" => "Вивантаження неуспішне (можливо такий файл вже є)",
"Unexistant user" => "Неіснуючий користувач",
" new topic:" => " нова тема:",
"The user has choosen to make his information private" => "Користувач вирішив оголосити цю інформацію приватною",
"New article submitted at " => "Нова стаття подання о ",
"New message arrived from " => "Надійшло нове повідомлення від  ",
"Welcome to " => "Ласкаво просимо до ",
"Bye bye from " => "'Бувай' від ",
" at " => " в ",
"There is an error in the plugin data" => "В даних модуля присутня помилка",
"categorize" => "категоризувати",
"Posted comments" => "Опубліковані коментарі",
"reply to this" => "відповісти на це",
"parent" => "батьківський",
"Return to messages" => "Повернутись до повідомлень",
"Unflagg" => "Зняти прапорець",
"Set prefs" => "Встановити",
"In blog listing show user as" => "В списках журналів показувати користувача як",
"creation date" => "дата створення",
"last modification time" => "останній раз змінювався",
"CMS settings" => "Установки CMS",
"Update" => "Поновити",
"Set home forum" => "Встановити домашній форум",
"Time Zone" => "Часовий пояс",
"Server time zone" => "Часовий пояс сервера",
"Time Zone Map" => "Мапа часових поясів",
"Set feeds" => "Встановити потоки",
"Wiki Page Names" => "Назви сторінок Вікі",
"strict" => "чіткі",
"Warn on edit" => "Попереджати  при редагуванні",
"Users can vote only one item from this chart per period" => "Користувачі можуть приймати голосування тільки з одного пункту в цей час",
"Prevent users from voting same item more than one time" => "Не дозволяє користувачам голосувати більше одного разу з одного і того ж питання",
"half a second" => "пів-секунди",
"URL (use \$page to be replaced by the page name in the URL example: http:www.example.com/tiki-index.php?page=\$page)" => "URL (вживайте \$page там, де потрібно замінити на назву сторінви в URL приклад: http:www.example.com/tiki-index.php?page=\$page)",
"Threads can be voted" => "Можна голосувати за низки",
"Directory (include trailing slash)" => "Теці (включаючи останню косу)",
"Add all your site users to this newsletter (broadcast)" => "Додати всіх користувачів майданчка до цього листка новин (широкомовнення)",
"Add users" => "Додати користувачів",
"create new empty structure" => "створити нову порожню структ.",
"Create structure from tree" => "Створити структуру з дерева",
"Create New Survey:" => "Створити новий опит:",
"stat" => "стат.",
"Options (separated by commas used in dropdowns only)" => "Пункти (розділені комами тільки для випадаючих меню)",
"Add New Group" => "Додати нову групу",
"Edit this group:" => "Редагувати цю групу:",
"assign_perms" => "assign_perms",
"assign group" => "назначити групу",
"view info" => "перегляд інфо",
"File gals" => "Гал. файлів",
"Image gals" => "Гал. зображень",
"Content Templates" => "Шаблони вмісту",
"assgn" => "назначити",
"Click here to create a new backup" => "Натисніть тут, щоб створити нову резервну копію",
"Klick to enlarge" => "Натисніть щоб збільшити",
"You can include the image in an HTML or Tiki page using" => "Ви можете включити це зображення в HTML чи Tiki, скористувавшись",
"Calendars Panel" => "Панель календарів",
"Navigation Panel" => "Панель навігації",
"Hide Panels" => "Сховати панелі",
"Tiki Calendars" => "Календарі Тікі",
"hide from display" => "сховати від показу",
"today" => "сьогодні",
"+1d" => "+1д",
"+7d" => "+7д",
"+1m" => "+1м",
"browse by" => "перегляд за",
"If you change the calendar selection, please refresh to get the appropriated list in Category, Location and people (if applicable to the calendar you choose)." => "Якщо Ви змінюєте вибір календаря, поновіть, будь ласка, перегляд, щоб отримати відповідні пункти в Категоріях, Розташуваннях і людях (якщо це має застосування до календаря, якого Ви обрали)",
"from the list" => "із списку",
"choose" => "вибрати",
"with role" => "з роллю",
"Url" => "Url",
"You should first ask that a calendar is created, so you can create events attached to it." => "Спочатку потрібно попросити створити календар, після цього Ви можете створювати події, асоційовані з ним.",
"Use (:name:) for smileys" => "Для хихоньок використовуйте форму (:назва:)",
"use square brackets for an" => "вживати квадратні дужки для",
"link_description" => "link_description",
"Prevents parsing data" => "Забороняє обробку даних",
"wiki link" => "посилання вікі",
"heading" => "заголовок",
"horizontal ruler" => "горизонтальна риска",
"center" => "центр",
"Reuse question" => "Використовувати попередні запитання",
"Admin structures" => "Адміністувати структури",
"In parent page" => "На батьківській сторінці",
"someone from" => "дехто з",
"You can edit the page following this link:" => "Ви можете редагувати цю сторінку за адресою:",
"Diff:" => "Зміни:",
"The new page content is:" => "Новий вміст сторінки:",
"running" => "працює",
"Add scaled images size X x Y" => "Додати розмір X x Y",
"Import pages from a PHPWiki Dump" => "Імпорт сторінок з PHPWiki Dump",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "Маршрут до теки, де вивантажені дамп файли (відносно базової теки Вікі з заключною похилою включно приклад: dump/)",
"ver" => "вер",
"Newss from" => "Новини з",
"Show chart for the last " => "Показати діаграму за останні ",
"days (0=all)" => "днів (0=всі)",
"Control by Object" => "Керування по об'єктам",
"Control by category" => "Керування по категоріям",
"use filename" => "використовувати назву файла",
"You can include the image in an HTML/Tiki page using" => "У HTML або Вікі зображення можна включити таким виразом",
"remove bookmark" => "видалити закладку",
"All tasks" => "Всі завдання",
"mark as done" => "позначити зробленими",
"open tasks" => "відкриті завдання",
"Add or edit a task" => "Додати чи редагувати завдання",
"Start date" => "Дата початку",
"Completed" => "Завершено",
"FAQ Questions" => "Запитання ЧАП",
"FAQ Answers" => "Відповіді ЧАП",
"Show suggested questions/suggest a question" => "Показати запропоновані питання/запропонувати питання",
"Hide suggested questions" => "Сховати запропоновані питання",
"Tiki forums" => "Форуми Тікі",
"this post was reported" => "про цю публікацію повідомлено",
"report this post" => "повідомити про цю публікацію",
"Filters" => "Фільтри",
"checked" => "перевірено",
"unchecked" => "неперевірено",
"Mark as Flagged" => "Позначити прапорцем",
"MyTiki (click!)" => "МояТікі (клацнути)",
"Admin (click!)" => "Адмін (клацнути!)",
"Top Files" => "Найпопулярніші файли",
"More info about" => "Додаткова інформація про",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appeareance of the page, no versions are stored for this page." => "Пісочниця -- це сторінка, на якій Ви можете потренуватися для засвоєння прийомів редагування. Щоб побачити вигляд сторінки, скористайтесь попереднім переглядом. Версії не зберігаються на цій сторінці.",
"Use dbl click to edit pages" => "Для редагування сторінки двічі клацніть на ній",
"Change your email" => "Змінити поштову адресу",
"Change your password" => "Змінити пароль",
"Configure this page" => "Конфігурувати цю сторінку",
"topic:" => "тема:",
"forum topic" => "з теми",
"make_headings" => "make_headings",
"no description" => "немає опису",
"requested a reminder of the password for the" => "запросив нагадування паролю для",
"since this is your registered email address we inform that the" => "оскільки це Ваша зареєстрована адреса, ми повідомляємо Вам, що",
"password for this account is" => "пароль для даного рахунку",
"Information:" => "Інформація:",
"The page {\$mail_page} was changed by {\$mail_user} at\n{\$mail_date|tiki_short_datetime}" => "Сторінка {\$mail_page} була змінена {\$mail_user} в\n{\$mail_date|tiki_short_datetime}",
"Please" => "Будь ласка",
"log in" => "ввійти",
"to access full functionalities" => "щоб отримати повний доступ",
"Blog settings" => "Установки журналу",
"FAQs settings" => "Установки ЧАПів",
"FAQ comments" => "Коментарі до ЧАПів",
"Remind passwords by email" => "Нагадувати паролі поштою",
"LDAP Host" => "Машина LDAP",
"LDAP Port" => "Порт LDAP",
"Poll settings" => "Установки опитувань",
"Tag Name" => "Назва бирки",
"Restore the wiki" => "Відновити Вікі",
"Remove a tag" => "Прибрати бирку",
"Wiki comments settings" => "Установки коментарів до Вікі",
"Wiki page list configuration" => "Конфіґурація списку сторінок Вікі",
"Like pages" => "Схожі сторінки",
"Set" => "Встановити",
"Administration" => "Адміністрування",
"admin Drawings" => "Адмініструвати графічний редактор",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Вживайте {literal}{{/literal}ed id=name} чи {literal}{{/literal}ted id=name} якщо хочете вставити динамічну зону",
"Batch upload (CSV file)" => "Багатьох одразу (файл CSV)",
"italics" => "курсив",
"both" => "обоє",
"use ...page... to separate pages" => "вживайте ...page... для розділу сторінок",
"underlines text" => "підкреслений текст",
"Simple box" => "Проста рамка",
"Will display using the indicated HTML color" => "Текст буде відображено вказаним кольором HTML",
"Center" => "Центр",
"Will display the text centered" => "Текст буде відцентровано",
"Edit Submissions" => "Редагувати подання",
"time" => "час",
"Wiki quick help" => "Швидка підказка по Wiki ",
"Comparing versions" => "Порівняння версій",
"Diff to version" => "Різниця до версії",
"admin DynamicContent" => "адмін. ДинамічнийВміст",
"You have to create a gallery first!" => "Спочатку потрібно створити галерею!",
"perm" => "дозв",
"You do not have permission to write the template" => "У Вас немає дозволу розробляти шаблон",
"You have to provide a name to the image" => "Потрібно надати назву зображенню",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "This script cannot be called directly" => "This script cannot be called directly",
// "The text in RED is" => "The text in RED is",
// "character(s) too long - please edit it." => "character(s) too long - please edit it.",
// "Algeria" => "Algeria",
// "American_Samoa" => "American_Samoa",
// "Angola" => "Angola",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Bermuda" => "Bermuda",
// "Bolivia" => "Bolivia",
// "Brazil" => "Brazil",
// "Brunei" => "Brunei",
// "Canada" => "Canada",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman_Islands" => "Cayman_Islands",
// "Colombia" => "Colombia",
// "Cook_Islands" => "Cook_Islands",
// "Costa_Rica" => "Costa_Rica",
// "Croatia" => "Croatia",
// "Cuba" => "Cuba",
// "Cyprus" => "Cyprus",
// "Czech_Republic" => "Czech_Republic",
// "Denmark" => "Denmark",
// "Dominican_Republic" => "Dominican_Republic",
// "Ecuador" => "Ecuador",
// "Egypt" => "Egypt",
// "El_Salvador" => "El_Salvador",
// "Estonia" => "Estonia",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "France" => "France",
// "French_Polynesia" => "French_Polynesia",
// "Germany" => "Germany",
// "Greece" => "Greece",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Haiti" => "Haiti",
// "Honduras" => "Honduras",
// "Hungary" => "Hungary",
// "Chile" => "Chile",
// "China" => "China",
// "Iceland" => "Iceland",
// "India" => "India",
// "Indonesia" => "Indonesia",
// "Iran" => "Iran",
// "Iraq" => "Iraq",
// "Ireland" => "Ireland",
// "Israel" => "Israel",
// "Italy" => "Italy",
// "Ivory_Coast" => "Ivory_Coast",
// "Jamaica" => "Jamaica",
// "Japan" => "Japan",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Malta" => "Malta",
// "Marshall_Islands" => "Marshall_Islands",
// "Mauritius" => "Mauritius",
// "Mexico" => "Mexico",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands" => "Netherlands",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Nicaragua" => "Nicaragua",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "Norway" => "Norway",
// "Other" => "Other",
// "Pakistan" => "Pakistan",
// "Panama" => "Panama",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Phillippines" => "Phillippines",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto_Rico" => "Puerto_Rico",
// "Quatar" => "Quatar",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Samoa" => "Samoa",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon_Islands" => "Solomon_Islands",
// "Somalia" => "Somalia",
// "South_Africa" => "South_Africa",
// "South_Korea" => "South_Korea",
// "Spain" => "Spain",
// "Sri_Lanka" => "Sri_Lanka",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Surinam" => "Surinam",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Taiwan" => "Taiwan",
// "Thailand" => "Thailand",
// "Tonga" => "Tonga",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Turkey" => "Turkey",
// "Tuvalu" => "Tuvalu",
// "Ukraine" => "Ukraine",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_States" => "United_States",
// "Uruguay" => "Uruguay",
// "Vanuatu" => "Vanuatu",
// "Venezuela" => "Venezuela",
// "Wales" => "Wales",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "Bulgaria" => "Bulgaria",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "English British" => "English British",
// "Finnish" => "Finnish",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "This instance of activity is already complete" => "This instance of activity is already complete",
// "Fatal error: trying to send an instance to an activity but no transition found" => "Fatal error: trying to send an instance to an activity but no transition found",
// "Cannot add transition only split activities can have more than one outbound transition" => "Cannot add transition only split activities can have more than one outbound transition",
// " is non-interactive and non-autorouted but has no role assigned" => " is non-interactive and non-autorouted but has no role assigned",
// " is standalone but has transitions" => " is standalone but has transitions",
// " is not mapped" => " is not mapped",
// "Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Activity '.\$res['name'].' is standalone and is using the \$instance object",
// "Administration:" => "Administration:",
// "file gallery" => "file gallery",
// "image gallery" => "image gallery",
// "newsletter" => "newsletter",
// "survey" => "survey",
// "tracker" => "tracker",
// "wiki page" => "wiki page",
// "Cannot write to this file: " => "Cannot write to this file: ",
// "Use this thread to discuss the %s page." => "Use this thread to discuss the %s page.",
// "Line:" => "Line:",
// "Lines:" => "Lines:",
// "There was a problem with your upload." => "There was a problem with your upload.",
// "The file you are trying to upload is too big." => "The file you are trying to upload is too big.",
// "The file you are trying to upload was only partially uploaded." => "The file you are trying to upload was only partially uploaded.",
// "You must select a file for upload." => "You must select a file for upload.",
// "Continue" => "Continue",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "User Map Generated in:" => "User Map Generated in:",
// "Image Map Generated in:" => "Image Map Generated in:",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "%s is an empty archive file" => "%s is an empty archive file",
// "Invalid remote file on url %s" => "Invalid remote file on url %s",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "This poll is closed." => "This poll is closed.",
// "Forums last posts" => "Forums last posts",
// "tikiwiki logo" => "tikiwiki logo",
// "See other user's profile" => "See other user's profile",
// "Have your profile seen" => "Have your profile seen",
// "Make friends" => "Make friends",
// "Receive message" => "Receive message",
// "Read an article" => "Read an article",
// "Publish an article" => "Publish an article",
// "Have your article read" => "Have your article read",
// "Create new file gallery" => "Create new file gallery",
// "Upload new file to gallery" => "Upload new file to gallery",
// "Download other user's file" => "Download other user's file",
// "Have your file downloaded" => "Have your file downloaded",
// "Create a new image gallery" => "Create a new image gallery",
// "Upload new image to gallery" => "Upload new image to gallery",
// "See other user's gallery" => "See other user's gallery",
// "See other user's image" => "See other user's image",
// "Have your gallery seen by other user" => "Have your gallery seen by other user",
// "Have your image seen" => "Have your image seen",
// "Create new blog" => "Create new blog",
// "Post in a blog" => "Post in a blog",
// "Read other user's blog" => "Read other user's blog",
// "Have your blog read" => "Have your blog read",
// "Create a new wiki page" => "Create a new wiki page",
// "Edit an existing page" => "Edit an existing page",
// "Tracker" => "Tracker",
// "Unknown" => "Unknown",
// "Trackeritem" => "Trackeritem",
// "Directory category" => "Directory category",
// "Tracker item" => "Tracker item",
// "Link" => "Link",
// "The text is" => "The text is",
// "Text cut here" => "Text cut here",
// "Task" => "Task",
// "Start date:" => "Start date:",
// "End date:" => "End date:",
// "Friend" => "Friend",
// "km" => "km",
// "Last seen on " => "Last seen on ",
// "(idle for %s seconds)" => "(idle for %s seconds)",
// "User information - Click for more info" => "User information - Click for more info",
// "More info about \$other_user" => "More info about \$other_user",
// "(idle for \$idletime seconds)" => "(idle for \$idletime seconds)",
// "created from structure" => "created from structure",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
// "An error occured in a database query!" => "An error occured in a database query!",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "arts" => "arts",
// "Altering database table failed" => "Altering database table failed",
// "%d points" => "%d points",
// "Removed" => "Removed",
// "__WARNING__: No such module \$plugin! " => "__WARNING__: No such module \$plugin! ",
// "Create page:" => "Create page:",
// "index" => "index",
// "show" => "show",
// "hide" => "hide",
// "Updated" => "Updated",
// "Click here to confirm your action" => "Click here to confirm your action",
// "Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) detected. Operation blocked.",
// "Status:" => "Status:",
// "(unchanged)" => "(unchanged)",
// "Item Modification" => "Item Modification",
// "Item creation" => "Item creation",
// "field is not numeric" => "field is not numeric",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode.",
// "Checkbox options: put 1 if you need that next field is on the same row." => "Checkbox options: put 1 if you need that next field is on the same row.",
// "numeric field" => "numeric field",
// "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "Dropdown options: list of items separated with commas." => "Dropdown options: list of items separated with commas.",
// "User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login.",
// "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered.",
// "country selector" => "country selector",
// "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag",
// "jscalendar" => "jscalendar",
// "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels.",
// "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test",
// "header" => "header",
// "Category options: parentId" => "Category options: parentId",
// "item link" => "item link",
// "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing",
// "items list" => "items list",
// "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing",
// "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto.",
// "system" => "system",
// "pending" => "pending",
// "Added:" => "Added:",
// "Removed:" => "Removed:",
// "Remaining:" => "Remaining:",
// "Old:" => "Old:",
// "New:" => "New:",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "Include all post in a blog" => "Include all post in a blog",
// "Lists files in a directory" => "Lists files in a directory",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Takes regex expressions and parses the content between the REGEX tags and replaces the text.",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace.",
// "This data is put in a CODE caption." => "This data is put in a CODE caption.",
// "Missing url parameter for SNARF plugin." => "Missing url parameter for SNARF plugin.",
// "Displays browser client info" => "Displays browser client info",
// "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor",
// "linktext" => "linktext",
// "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor",
// "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage",
// "no such attachment on this page" => "no such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link.",
// "No pages links to" => "No pages links to",
// "One page links to" => "One page links to",
// "pages link to" => "pages link to",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "and" => "and",
// "Insert a division block on wiki page" => "Insert a division block on wiki page",
// "Displays a SWF on the wiki page" => "Displays a SWF on the wiki page",
// "Formula" => "Formula",
// "No formula specified." => "No formula specified.",
// "Impossible to render the graphic." => "Impossible to render the graphic.",
// "View graphic" => "View graphic",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Displays the text only if the language matchs" => "Displays the text only if the language matchs",
// "Displays a map" => "Displays a map",
// "Displays an miniquiz" => "Displays an miniquiz",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Provides a list of plugins on this wiki." => "Provides a list of plugins on this wiki.",
// "No arguments indicated" => "No arguments indicated",
// "Displays the output of a poll, fields are indicated with numeric ids." => "Displays the output of a poll, fields are indicated with numeric ids.",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// " wrote:" => " wrote:",
// "Quote:" => "Quote:",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage",
// "TikiSheet" => "TikiSheet",
// "Sheet Heading" => "Sheet Heading",
// "Edit Sheet" => "Edit Sheet",
// "List wiki pages" => "List wiki pages",
// "Last modified by" => "Last modified by",
// "Clickable Skype link" => "Clickable Skype link",
// "Split a page into rows and columns" => "Split a page into rows and columns",
// "row1col1" => "row1col1",
// "row1col2" => "row1col2",
// "row2col1" => "row2col1",
// "row2col2" => "row2col2",
// "Displays text in subscript." => "Displays text in subscript.",
// "Displays text between an html tag" => "Displays text between an html tag",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "Fields marked with a * are mandatory." => "Fields marked with a * are mandatory.",
// "All fields must be from the same tracker" => "All fields must be from the same tracker",
// "Filters the items of a tracker, fields are indicated with numeric ids." => "Filters the items of a tracker, fields are indicated with numeric ids.",
// "missing parameters" => "missing parameters",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays the output of a tracker content, fields are indicated with numeric ids." => "Displays the output of a tracker content, fields are indicated with numeric ids.",
// "missing tracker ID for plugin TRACKER" => "missing tracker ID for plugin TRACKER",
// "missing fields list" => "missing fields list",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Links to a translated content" => "Links to a translated content",
// "Displays the number of registered users" => "Displays the number of registered users",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored.<br />" => "A wildcard pattern of originating pages to be ignored.<br />",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated.<br />" => "The character, by which ignored patterns are separated.<br />",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list.<br />" => "Whether to include external wikis in the list.<br />",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Collect either originating or wanted pages in a cell and display them in the second column.<br />",
// "Switch-on debug output with details about the items.<br />" => "Switch-on debug output with details about the items.<br />",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />",
// "A custom filter for wanted pages to be listed (only used when level=>custom).<br />" => "A custom filter for wanted pages to be listed (only used when level=>custom).<br />",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output." => "End of debug output.",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Plugin " => "Plugin ",
// "failed" => "failed",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Sent box is full. Archive or delete some sent messages first if you want to send more messages.",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first." => "Archive is full. Delete some messages from archive first.",
// "move %s in %s" => "move %s in %s",
// "Please provide an Id" => "Please provide an Id",
// "no object here yet" => "no object here yet",
// "This module requires parameters trackerId and name set" => "This module requires parameters trackerId and name set",
// "Changes" => "Changes",
// "Changes since" => "Changes since",
// "new posts" => "new posts",
// "new articles" => "new articles",
// "new FAQs" => "new FAQs",
// "new blogs" => "new blogs",
// "new blog posts" => "new blog posts",
// "new image galleries" => "new image galleries",
// "new file galleries" => "new file galleries",
// "new polls" => "new polls",
// "new tracker items" => "new tracker items",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Invalid server key" => "Invalid server key",
// "monitor this blog" => "monitor this blog",
// "stop monitoring this blog" => "stop monitoring this blog",
// "Categorize" => "Categorize",
// "Tip: hold down CTRL to select multiple categories" => "Tip: hold down CTRL to select multiple categories",
// "Tip: uncheck the above checkbox to uncategorize this page/object" => "Tip: uncheck the above checkbox to uncategorize this page/object",
// "browse category" => "browse category",
// "reported:" => "reported:",
// "Posted messages" => "Posted messages",
// "Plain" => "Plain",
// "Threaded" => "Threaded",
// "Headers Only" => "Headers Only",
// "below your current threshold" => "below your current threshold",
// "Editing reply" => "Editing reply",
// "Reply to the selected post" => "Reply to the selected post",
// "Post new message" => "Post new message",
// "Comment on the selected post" => "Comment on the selected post",
// "Reply to parent post" => "Reply to parent post",
// "Post new reply" => "Post new reply",
// "Reply" => "Reply",
// "Posting replies" => "Posting replies",
// "HTML tags are not allowed inside posts" => "HTML tags are not allowed inside posts",
// "Perhaps you were looking for:" => "Perhaps you were looking for:",
// "There are no wiki pages similar to '{\$page}'" => "There are no wiki pages similar to '{\$page}'",
// "Create this page" => "Create this page",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Close Window" => "Close Window",
// "Last update from CVS" => "Last update from CVS",
// "RSS Wiki" => "RSS Wiki",
// "RSS Blogs" => "RSS Blogs",
// "RSS Articles" => "RSS Articles",
// "RSS Image Galleries" => "RSS Image Galleries",
// "RSS File Galleries" => "RSS File Galleries",
// "RSS Forums" => "RSS Forums",
// "RSS Maps" => "RSS Maps",
// "RSS Directories" => "RSS Directories",
// "RSS Calendars" => "RSS Calendars",
// "Information" => "Information",
// "New topic:" => "New topic:",
// "Topic:" => "Topic:",
// "You sent a request with the subject:" => "You sent a request with the subject:",
// "Use the subject to indicate the operation to apply:" => "Use the subject to indicate the operation to apply:",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in instructions" => "Tiki mail-in instructions",
// "Tiki mail-in auto-reply." => "Tiki mail-in auto-reply.",
// "Page not found:" => "Page not found:",
// "New message arrived from %s" => "New message arrived from %s",
// "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now.",
// "To login with your username and password, please follow this link:" => "To login with your username and password, please follow this link:",
// "Tiki User Account Activated" => "Tiki User Account Activated",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link:" => "To validate that account, please follow the link:",
// "best regards" => "best regards",
// "your Tikiwiki" => "your Tikiwiki",
// "Tiki User Registration Request" => "Tiki User Registration Request",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "You're invited to join my network of friends!" => "You're invited to join my network of friends!",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in.",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above." => "Important: The old password remains active if you don't click the link above.",
// "Your Tiki account information for %s" => "Your Tiki account information for %s",
// "New article submitted at %s" => "New article submitted at %s",
// "View the tracker item at:" => "View the tracker item at:",
// "Tracker was modified at" => "Tracker was modified at",
// "Your account request have been stored and will be activated by the admin as soon as possible." => "Your account request have been stored and will be activated by the admin as soon as possible.",
// "New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "View the article at:" => "View the article at:",
// "New article post at %s" => "New article post at %s",
// "New blog post at %s" => "New blog post at %s",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "Removed by" => "Removed by",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the page by following this link:" => "You can view the page by following this link:",
// "You can view a diff back to the previous version by following this link:" => "You can view a diff back to the previous version by following this link:",
// "The changes in this version follow below, followed after by the current full page text." => "The changes in this version follow below, followed after by the current full page text.",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "Wiki page %s changed" => "Wiki page %s changed",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Zoom out x4" => "Zoom out x4",
// "Zoom out x3" => "Zoom out x3",
// "Zoom out x2" => "Zoom out x2",
// "Query" => "Query",
// "Pan" => "Pan",
// "Zoom in x2" => "Zoom in x2",
// "Zoom in x3" => "Zoom in x3",
// "Zoom in x4" => "Zoom in x4",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
// "Go" => "Go",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Click on the map or click redraw" => "Click on the map or click redraw",
// "Layer" => "Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "you have requested to download the layer:" => "you have requested to download the layer:",
// "from\nthe mapfile:" => "from\nthe mapfile:",
// "Mapfiles" => "Mapfiles",
// "hits last 7 days" => "hits last 7 days",
// "Reload" => "Reload",
// "Mapfile History" => "Mapfile History",
// "Comparing version {\$old.version} with version {\$new.version}" => "Comparing version {\$old.version} with version {\$new.version}",
// "Version:" => "Version:",
// "Legend:" => "Legend:",
// "v=view" => "v=view",
// "c=compare" => "c=compare",
// "d=diff" => "d=diff",
// "Side-by-side diff" => "Side-by-side diff",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
// "older version" => "older version",
// "back to" => "back to",
// "index file (.shp):" => "index file (.shp):",
// "files to index (regexp):" => "files to index (regexp):",
// "Message Archive" => "Message Archive",
// "Edit template" => "Edit template",
// "messages" => "messages",
// "Archive is full!" => "Archive is full!",
// "download" => "download",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Mailbox is full! Delete or archive some messages if you want to receive more messages.",
// "move to archive" => "move to archive",
// "reply to" => "reply to",
// "find replied message" => "find replied message",
// "Sent" => "Sent",
// "Archive" => "Archive",
// "Auto-archive age for read messages:" => "Auto-archive age for read messages:",
// "Return to mailbox" => "Return to mailbox",
// "Unflag" => "Unflag",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Sent Messages" => "Sent Messages",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "receiver" => "receiver",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "Hide module contents" => "Hide module contents",
// "opp side" => "opp side",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module?" => "Are you sure you want to unassign this module?",
// "QuickTags" => "QuickTags",
// "Shoutbox Words" => "Shoutbox Words",
// "Referer stats" => "Referer stats",
// "Import PHPWiki Dump" => "Import PHPWiki Dump",
// "Admin dsn" => "Admin dsn",
// "System Admin" => "System Admin",
// "Security Admin" => "Security Admin",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number !" => "You forgot your Google ad_client number !",
// "MyTiki home" => "MyTiki home",
// "Monitor instances" => "Monitor instances",
// "User instances" => "User instances",
// "FriendsMenu" => "FriendsMenu",
// "Community" => "Community",
// "User list" => "User list",
// "Friendship Network" => "Friendship Network",
// "Dump" => "Dump",
// "Admin types" => "Admin types",
// "Maps" => "Maps",
// "ShtMenu" => "ShtMenu",
// "Trackers" => "Trackers",
// "List trackers" => "List trackers",
// "Admin trackers" => "Admin trackers",
// "Events" => "Events",
// "Send events" => "Send events",
// "Admin events" => "Admin events",
// "Ephemerides" => "Ephemerides",
// "Ephemerides Admin" => "Ephemerides Admin",
// "Charts Admin" => "Charts Admin",
// "Admin home" => "Admin home",
// "Integrator" => "Integrator",
// "DSN" => "DSN",
// "Mods Admin" => "Mods Admin",
// "TikiWiki Assistant" => "TikiWiki Assistant",
// "Thank you for installing TikiWiki" => "Thank you for installing TikiWiki",
// "Click the :: options in the Menu for more options." => "Click the :: options in the Menu for more options.",
// "Please, also see" => "Please, also see",
// "for more setup details." => "for more setup details.",
// "Note 1:" => "Note 1:",
// "You can remove this module in" => "You can remove this module in",
// "as well as assign or edit many others." => "as well as assign or edit many others.",
// "Note 2:" => "Note 2:",
// "The menu module installed by default is named" => "The menu module installed by default is named",
// "it is a \"custom module\" which includes menu ID " => "it is a \"custom module\" which includes menu ID ",
// "That menu is stored in database and it can be edited from " => "That menu is stored in database and it can be edited from ",
// "Do not mix this with the original <em>application_menu</em> module" => "Do not mix this with the original <em>application_menu</em> module",
// "That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"",
// "January" => "January",
// "February" => "February",
// "March" => "March",
// "April" => "April",
// "May" => "May",
// "June" => "June",
// "July" => "July",
// "August" => "August",
// "September" => "September",
// "October" => "October",
// "November" => "November",
// "December" => "December",
// "Last `\$module_rows` Sites" => "Last `\$module_rows` Sites",
// "Top \$module_rows Sites" => "Top \$module_rows Sites",
// "Current events" => "Current events",
// "Top `\$module_rows` topics" => "Top `\$module_rows` topics",
// "Last `\$module_rows` forum posts" => "Last `\$module_rows` forum posts",
// "Last forum posts" => "Last forum posts",
// "Last `\$module_rows` forum topics" => "Last `\$module_rows` forum topics",
// "Last `\$module_rows` actions" => "Last `\$module_rows` actions",
// "Last actions" => "Last actions",
// "Last `\$module_rows` articles" => "Last `\$module_rows` articles",
// "Last `\$module_rows` blog posts" => "Last `\$module_rows` blog posts",
// "Last `\$module_rows` Created blogs" => "Last `\$module_rows` Created blogs",
// "Last `\$module_rows` Created FAQs" => "Last `\$module_rows` Created FAQs",
// "Last `\$module_rows` Created Quizzes" => "Last `\$module_rows` Created Quizzes",
// "Last `\$module_rows` modified file galleries" => "Last `\$module_rows` modified file galleries",
// "Last `\$module_rows` Files" => "Last `\$module_rows` Files",
// "Last `\$module_rows` galleries" => "Last `\$module_rows` galleries",
// "Last `\$module_rows` Images" => "Last `\$module_rows` Images",
// "Last Images" => "Last Images",
// "Last `\$module_rows` modified events" => "Last `\$module_rows` modified events",
// "Last modifed events" => "Last modifed events",
// "Last `\$module_rows` changes" => "Last `\$module_rows` changes",
// "Last `\$module_rows` Modified Items" => "Last `\$module_rows` Modified Items",
// "Last `\$module_rows` Modified blogs" => "Last `\$module_rows` Modified blogs",
// "Last `\$module_rows` submissions" => "Last `\$module_rows` submissions",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "Last `\$module_rows` Items" => "Last `\$module_rows` Items",
// "Last `\$module_rows` visitors" => "Last `\$module_rows` visitors",
// "Last visitors" => "Last visitors",
// "Login through CAS" => "Login through CAS",
// "Login as admin" => "Login as admin",
// "pass" => "pass",
// "login" => "login",
// "Click here to register" => "Click here to register",
// "Click here if you've forgotten your password" => "Click here if you've forgotten your password",
// "Click here to login using the default security protocol" => "Click here to login using the default security protocol",
// "Click here to login using a secure protocol" => "Click here to login using a secure protocol",
// "local account" => "local account",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "RSS Feeds" => "RSS Feeds",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Articles RSS" => "Articles RSS",
// "Image Galleries RSS" => "Image Galleries RSS",
// "File Galleries RSS" => "File Galleries RSS",
// "Forums RSS" => "Forums RSS",
// "Maps RSS" => "Maps RSS",
// "Calendars" => "Calendars",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "Language: " => "Language: ",
// "Top `\$module_rows` articles" => "Top `\$module_rows` articles",
// "Top `\$module_rows` File Galleries" => "Top `\$module_rows` File Galleries",
// "Top `\$module_rows` files" => "Top `\$module_rows` files",
// "Top files" => "Top files",
// "Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
// "Top Forum Posters" => "Top Forum Posters",
// "Top `\$module_rows` games" => "Top `\$module_rows` games",
// "Top `\$module_rows` galleries" => "Top `\$module_rows` galleries",
// "Top `\$module_rows` Images" => "Top `\$module_rows` Images",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Top `\$module_rows` Pages" => "Top `\$module_rows` Pages",
// "Top `\$module_rows` Quizzes" => "Top `\$module_rows` Quizzes",
// "Most `\$module_rows` visited blogs" => "Most `\$module_rows` visited blogs",
// "Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` Visited FAQs",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "Upcoming events" => "Upcoming events",
// "Public tasks" => "Public tasks",
// "select" => "select",
// "User informations" => "User informations",
// "Group informations" => "Group informations",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Top users" => "Top users",
// "Whats related" => "Whats related",
// "on host" => "on host",
// "Last `\$module_rows` wiki comments" => "Last `\$module_rows` wiki comments",
// "Last wiki comments" => "Last wiki comments",
// " on page " => " on page ",
// "Click to see the ratings" => "Click to see the ratings",
// "[-]" => "[-]",
// "Structures:" => "Structures:",
// "show structures" => "show structures",
// "hide structures" => "hide structures",
// "Manage structures" => "Manage structures",
// "Are you sure you want to remove this module?" => "Are you sure you want to remove this module?",
// "Powered by" => "Powered by",
// "Execution time" => "Execution time",
// "Memory usage" => "Memory usage",
// "database queries used" => "database queries used",
// "Server load" => "Server load",
// "page id" => "page id",
// "3d browser" => "3d browser",
// "Parent page" => "Parent page",
// "Child" => "Child",
// "Add Page" => "Add Page",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Page last modified on" => "Page last modified on",
// "Contributors to this page" => "Contributors to this page",
// "translation" => "translation",
// "Made with" => "Made with",
// "powered by" => "powered by",
// "User List" => "User List",
// "Homework" => "Homework",
// "Assignments" => "Assignments",
// "Click" => "Click",
// "Watches" => "Watches",
// "Show/Hide Left Menus" => "Show/Hide Left Menus",
// "Show/Hide Right Menus" => "Show/Hide Right Menus",
// "Member list" => "Member list",
// "dump" => "dump",
// "List Trackers" => "List Trackers",
// "logout" => "logout",
// "The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page.",
// "Edit Summary" => "Edit Summary",
// "Anti-Bot verification code" => "Anti-Bot verification code",
// "Enter the code you see above" => "Enter the code you see above",
// "at tracker" => "at tracker",
// "RSS Trackers" => "RSS Trackers",
// "Location : " => "Location : ",
// "Trackback pings" => "Trackback pings",
// "Translate in" => "Translate in",
// "babelfish it" => "babelfish it",
// "Welcome to" => "Welcome to",
// "Click here to create it" => "Click here to create it",
// "Enlarge area height" => "Enlarge area height",
// "Reduce area height" => "Reduce area height",
// "Meta Tags" => "Meta Tags",
// "Site Identity" => "Site Identity",
// "Site Calendar" => "Site Calendar",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "i18n" => "i18n",
// "Tip" => "Tip",
// "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or",
// "Post level trackback pings" => "Post level trackback pings",
// "Not Installed" => "Not Installed",
// "Creation date" => "Creation date",
// "Last modification time" => "Last modification time",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Group calendar sticky popup" => "Group calendar sticky popup",
// "Group calendar item view tab" => "Group calendar item view tab",
// "Calendar manual selection of time/date" => "Calendar manual selection of time/date",
// "JsCalendar" => "JsCalendar",
// "Change settings" => "Change settings",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Print article" => "Print article",
// "Settings for page articles home" => "Settings for page articles home",
// "Fields to display on page" => "Fields to display on page",
// "Publish Date" => "Publish Date",
// "Expire Date" => "Expire Date",
// "Visible" => "Visible",
// "User identity features" => "User identity features",
// "Show user's info on mouseover" => "Show user's info on mouseover",
// "Picture" => "Picture",
// "Number of friends" => "Number of friends",
// "E-mail" => "E-mail",
// "Distance" => "Distance",
// "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or",
// "enable cool sites" => "enable cool sites",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site.",
// "tikiwiki.org help" => "tikiwiki.org help",
// "Multilingual" => "Multilingual",
// "Best language" => "Best language",
// "Template Viewing" => "Template Viewing",
// "Tiki Template Viewing" => "Tiki Template Viewing",
// "PHPLayers" => "PHPLayers",
// "PhpLayers Dynamic menus" => "PhpLayers Dynamic menus",
// "Use Tabs" => "Use Tabs",
// "Tiki Sheet" => "Tiki Sheet",
// "Site Logo and Identity" => "Site Logo and Identity",
// "Mobile" => "Mobile",
// "Google Maps" => "Google Maps",
// "Trackbacks Pings" => "Trackbacks Pings",
// "Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;>&rdquo; for quoting",
// "Referer Stats" => "Referer Stats",
// "Contact Us (Anonymous)" => "Contact Us (Anonymous)",
// "Redirect On Error" => "Redirect On Error",
// "always" => "always",
// "module decides" => "module decides",
// "never" => "never",
// "Users can Shade Modules" => "Users can Shade Modules",
// "User Watches Translations" => "User Watches Translations",
// "Users can Flip Columns" => "Users can Flip Columns",
// "user decides" => "user decides",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "To add/remove file galleries, go to \"File Galleries\" on the application menu, or",
// "Home Gallery" => "Home Gallery",
// "Allow same file to be uploaded more than once" => "Allow same file to be uploaded more than once",
// "Uploaded filenames must match regex" => "Uploaded filenames must match regex",
// "Uploaded filenames cannot match regex" => "Uploaded filenames cannot match regex",
// "Storing files in a directory" => "Storing files in a directory",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory.",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Change configuration" => "Change configuration",
// "File galleries search indexing" => "File galleries search indexing",
// "Leave command blank to delete handler" => "Leave command blank to delete handler",
// "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)",
// "Enable auto indexing on file upload or change" => "Enable auto indexing on file upload or change",
// "MIME Type" => "MIME Type",
// "System command" => "System command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Home Forum" => "Home Forum",
// "Forums features" => "Forums features",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Uses Slideshow" => "Uses Slideshow",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "Enable cache images to all galleries" => "Enable cache images to all galleries",
// "Images cache directory" => "Images cache directory",
// "Exterminator" => "Exterminator",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move" => "Move",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Change style only" => "Change style only",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "Detect browser language" => "Detect browser language",
// "PHP error reporting level for non-admin:" => "PHP error reporting level for non-admin:",
// "No error reporting" => "No error reporting",
// "Report all PHP errors" => "Report all PHP errors",
// "Report all errors except notices" => "Report all errors except notices",
// "Report PHP errors only for admin" => "Report PHP errors only for admin",
// "Default charset for sending mail:" => "Default charset for sending mail:",
// "Mail end of line:" => "Mail end of line:",
// "(standard)" => "(standard)",
// "(some Unix MTA)" => "(some Unix MTA)",
// "output compression is active." => "output compression is active.",
// "compression is handled by" => "compression is handled by",
// "Hide anonymous-only modules from registered users" => "Hide anonymous-only modules from registered users",
// "HTTPS Server" => "HTTPS Server",
// "Automatic (uses HTTPS variable)" => "Automatic (uses HTTPS variable)",
// "Allow anonymous users to \"Contact Us\"" => "Allow anonymous users to \"Contact Us\"",
// "Help URL" => "Help URL",
// "Please expect not found help-pages with the default-URL." => "Please expect not found help-pages with the default-URL.",
// "Any help with the documentation is welcome." => "Any help with the documentation is welcome.",
// "Favicon icon file name:" => "Favicon icon file name:",
// "Favicon icon MIME type:" => "Favicon icon MIME type:",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Locations separator" => "Locations separator",
// "Register this site at tikiwiki.org" => "Register this site at tikiwiki.org",
// "Click here for more details." => "Click here for more details.",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "I18n setup" => "I18n setup",
// "Best Language" => "Best Language",
// "Restrict available languages" => "Restrict available languages",
// "Available languages:" => "Available languages:",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// " as master" => " as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "IP" => "IP",
// "New" => "New",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// "Admin->Features" => "Admin->Features",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Users &amp; groups" => "Users &amp; groups",
// "Tiki and PAM" => "Tiki and PAM",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "... but need admin validation" => "... but need admin validation",
// "must be turned on and notification is sent to the admin's" => "must be turned on and notification is sent to the admin's",
// "inter-user message inbox" => "inter-user message inbox",
// "Use tracker for more user information" => "Use tracker for more user information",
// "Use tracker for more group information" => "Use tracker for more group information",
// " - Php GD library required" => " - Php GD library required",
// "Validate email address (may not work)" => "Validate email address (may not work)",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email",
// "Reg users can change password" => "Reg users can change password",
// "Restrict available themes" => "Restrict available themes",
// "Available styles:" => "Available styles:",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "Use challenge/response authentication" => "Use challenge/response authentication",
// "year" => "year",
// "Remember me name" => "Remember me name",
// "Remember me domain" => "Remember me domain",
// "Remember me path" => "Remember me path",
// "Protect against CSRF with a confirmation step" => "Protect against CSRF with a confirmation step",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "Highlight Group" => "Highlight Group",
// "choose a group ..." => "choose a group ...",
// "LDAP" => "LDAP",
// "Auth Type" => "Auth Type",
// "IMAP/POP3/LDAP Host" => "IMAP/POP3/LDAP Host",
// "IMAP/POP3/LDAP Port" => "IMAP/POP3/LDAP Port",
// "IMAP/POP3 BaseDSN" => "IMAP/POP3 BaseDSN",
// "LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(if set, this will override the Host and Port below)",
// "LDAP Group DN" => "LDAP Group DN",
// "LDAP Group Attribute" => "LDAP Group Attribute",
// "LDAP Group OC" => "LDAP Group OC",
// "LDAP Member Attribute" => "LDAP Member Attribute",
// "LDAP Member Is DN" => "LDAP Member Is DN",
// "LDAP Admin User" => "LDAP Admin User",
// "LDAP Admin Pwd" => "LDAP Admin Pwd",
// "PAM" => "PAM",
// "PAM service" => "PAM service",
// "Currently unused" => "Currently unused",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/.",
// "CAS server version" => "CAS server version",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "CAS server hostname" => "CAS server hostname",
// "CAS server port" => "CAS server port",
// "CAS server path" => "CAS server path",
// "Change CAS preferences" => "Change CAS preferences",
// "Full path to gdaltindex" => "Full path to gdaltindex",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "Generate User Map" => "Generate User Map",
// "<b>Item</b>" => "<b>Item</b>",
// "<b>Value</b>" => "<b>Value</b>",
// "Meta Keywords" => "Meta Keywords",
// "Meta Description" => "Meta Description",
// "Meta Author" => "Meta Author",
// "Geourl" => "Geourl",
// "geo.position" => "geo.position",
// "geo.region" => "geo.region",
// "geo.placename" => "geo.placename",
// "Robots" => "Robots",
// "meta robots" => "meta robots",
// "revisit after" => "revisit after",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Allow Anonymous Poll Voting" => "Allow Anonymous Poll Voting",
// "This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or" => "This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or",
// "Feed for mapfiles" => "Feed for mapfiles",
// "Feed for directories" => "Feed for directories",
// "Feed for individual tracker items" => "Feed for individual tracker items",
// "Feed for tracker items" => "Feed for tracker items",
// "Feed for upcoming calendar events" => "Feed for upcoming calendar events",
// "Default RDF version" => "Default RDF version",
// "Specification" => "Specification",
// "Documentation" => "Documentation",
// "Editor" => "Editor",
// "Webmaster" => "Webmaster",
// "Caching time :" => "Caching time :",
// "seconds (0 = cache inactive)" => "seconds (0 = cache inactive)",
// "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions." => "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions.",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "Search features" => "Search features",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Performance issues" => "Performance issues",
// "Search may show forbidden results. Much better performance though." => "Search may show forbidden results. Much better performance though.",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Settings for searching content" => "Settings for searching content",
// "Search refresh rate" => "Search refresh rate",
// "Minimum length of search word" => "Minimum length of search word",
// "Max. number of words containing a syllable" => "Max. number of words containing a syllable",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
// "Don't forget: to use feature you will need to enable it on" => "Don't forget: to use feature you will need to enable it on",
// "Custom Code" => "Custom Code",
// "Custom code" => "Custom code",
// "Site Breadcrumbs" => "Site Breadcrumbs",
// "Site breadcrumbs" => "Site breadcrumbs",
// "Site location bar" => "Site location bar",
// "at top of page" => "at top of page",
// "at top of center column" => "at top of center column",
// "Prefix breadcrumbs with 'Location:' label?" => "Prefix breadcrumbs with 'Location:' label?",
// "Larger font for" => "Larger font for",
// "entire location" => "entire location",
// "page name" => "page name",
// "Use page description:" => "Use page description:",
// "Site Search" => "Site Search",
// "Site search bar" => "Site search bar",
// "Site Logo" => "Site Logo",
// "Site logo" => "Site logo",
// "Site logo source" => "Site logo source",
// "Site logo background color" => "Site logo background color",
// "Site logo title (on mouse over)" => "Site logo title (on mouse over)",
// "Alt. description (e.g. for text browsers)" => "Alt. description (e.g. for text browsers)",
// "Site Ads and Banners" => "Site Ads and Banners",
// "Site ads and banners" => "Site ads and banners",
// "Site Menu" => "Site Menu",
// "Site menu bar" => "Site menu bar",
// "Note: This feature also requires phplayers to be turned on in Admin->Features" => "Note: This feature also requires phplayers to be turned on in Admin->Features",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Trackers attachments preferences" => "Trackers attachments preferences",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside TikiWiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside TikiWiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Trackers attachments" => "Trackers attachments",
// "Storage" => "Storage",
// "Change all to db" => "Change all to db",
// "Change all to file" => "Change all to file",
// "Unlimited" => "Unlimited",
// "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or",
// "Dumps" => "Dumps",
// "Generate dump" => "Generate dump",
// "Download last dump" => "Download last dump",
// "Create a Tag for the Current Wiki" => "Create a Tag for the Current Wiki",
// "Tag name" => "Tag name",
// "Restore the Wiki" => "Restore the Wiki",
// "Remove a Tag" => "Remove a Tag",
// "Wiki Comments Settings" => "Wiki Comments Settings",
// "Wiki Administration" => "Wiki Administration",
// "Manage attachment preferences" => "Manage attachment preferences",
// "Wiki Link Format" => "Wiki Link Format",
// "Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>.",
// "latin" => "latin",
// "english" => "english",
// "Wiki Page List Configuration" => "Wiki Page List Configuration",
// "Wiki 3D Browser Configuration" => "Wiki 3D Browser Configuration",
// "Enable wiki 3D browser" => "Enable wiki 3D browser",
// "Browser width" => "Browser width",
// "Browser height" => "Browser height",
// "Navigation depth" => "Navigation depth",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Existing page node color" => "Existing page node color",
// "Missing page node color" => "Missing page node color",
// "Load page on navigation" => "Load page on navigation",
// "Camera distance" => "Camera distance",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Field of view" => "Field of view",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Spring (connection) size" => "Spring (connection) size",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "HTML in Wiki Pages" => "HTML in Wiki Pages",
// "Wiki syntax used when a page contains HTML" => "Wiki syntax used when a page contains HTML",
// "partial" => "partial",
// "Wysiwyg editor" => "Wysiwyg editor",
// "default" => "default",
// "optional" => "optional",
// "Anonymous editors must input anti-bot code" => "Anonymous editors must input anti-bot code",
// "Similar" => "Similar",
// "Warn on edit conflict" => "Warn on edit conflict",
// "Edit idle timeout" => "Edit idle timeout",
// "Show page ID" => "Show page ID",
// "Footnotes" => "Footnotes",
// "Accept dashes and underscores in WikiWords" => "Accept dashes and underscores in WikiWords",
// "Use Wiki paragraph formatting" => "Use Wiki paragraph formatting",
// "Open page as structure" => "Open page as structure",
// "Use external link icons" => "Use external link icons",
// "User's Page" => "User's Page",
// "UserPage prefix" => "UserPage prefix",
// "Import HTML" => "Import HTML",
// "List authors" => "List authors",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "no (disabled)" => "no (disabled)",
// "Print Page" => "Print Page",
// "Search and replace" => "Search and replace",
// "unlimited" => "unlimited",
// "IP not displayed in history" => "IP not displayed in history",
// "Diff style" => "Diff style",
// "Only with last version" => "Only with last version",
// "Any 2 versions" => "Any 2 versions",
// "Wiki Watch" => "Wiki Watch",
// "Create watch for author on page creation" => "Create watch for author on page creation",
// "Enable watch events when I am the editor" => "Enable watch events when I am the editor",
// "Wiki attachments preferences" => "Wiki attachments preferences",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Spreadsheet" => "Spreadsheet",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "System" => "System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look &amp; feel" => "Look &amp; feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Help on Banning System" => "Help on Banning System",
// "Configure/Options" => "Configure/Options",
// "participants" => "participants",
// "subscription" => "subscription",
// "perso" => "perso",
// "Custom Participants" => "Custom Participants",
// "Custom Subscription List" => "Custom Subscription List",
// "Personal Calendar" => "Personal Calendar",
// "browse the category system" => "browse the category system",
// "Perms inherited from closest parent if possible or from global perms" => "Perms inherited from closest parent if possible or from global perms",
// "Assign permissions automatically" => "Assign permissions automatically",
// "recommended for best performance" => "recommended for best performance",
// "Edit permissions for this category" => "Edit permissions for this category",
// "View template" => "View template",
// "admin charts template" => "admin charts template",
// "Users can vote for only one item from this chart per period" => "Users can vote for only one item from this chart per period",
// "Prevent users from voting for the same item more than once" => "Prevent users from voting for the same item more than once",
// "Chat Admin" => "Chat Admin",
// "Chat Admin tpl" => "Chat Admin tpl",
// "Half a second" => "Half a second",
// "admin content templates template" => "admin content templates template",
// "use in events" => "use in events",
// "admin FortuneCookie" => "admin FortuneCookie",
// "admin FortuneCookie tpl" => "admin FortuneCookie tpl",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}.",
// "Help on Drawings" => "Help on Drawings",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link.",
// "Admin DSN" => "Admin DSN",
// "Use Admin DSN to define the database to be used by the SQL plugin." => "Use Admin DSN to define the database to be used by the SQL plugin.",
// "Create/edit dsn" => "Create/edit dsn",
// "dsn" => "dsn",
// "admin External Wikis" => "admin External Wikis",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)",
// "admin forums template" => "admin forums template",
// "Create new forum" => "Create new forum",
// "Edit existing forums" => "Edit existing forums",
// "Posts can be rated" => "Posts can be rated",
// "Send mails even when the post is generated by inbound mail" => "Send mails even when the post is generated by inbound mail",
// "Append a reply link to outbound mails" => "Append a reply link to outbound mails",
// "Edit Existing Forums" => "Edit Existing Forums",
// "coms" => "coms",
// "Assign Permissions (Active)" => "Assign Permissions (Active)",
// "Assign Permissions" => "Assign Permissions",
// "Click here to delete this forum" => "Click here to delete this forum",
// "admin hotwords template" => "admin hotwords template",
// "admin Html Pages" => "admin Html Pages",
// "admin Html Pages template" => "admin Html Pages template",
// "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones" => "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature.",
// "Edit Repository:" => "Edit Repository:",
// "Create New Repository" => "Create New Repository",
// "new repository" => "new repository",
// "Human readable repository name" => "Human readable repository name",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "File name of start page" => "File name of start page",
// "CSS file to load when browse this repository" => "CSS file to load when browse this repository",
// "Is repository visible to users" => "Is repository visible to users",
// "Can files from repository be cached" => "Can files from repository be cached",
// "Cacheable" => "Cacheable",
// "Are files from repository can be cached" => "Are files from repository can be cached",
// "Clear all cached pages of this repository" => "Clear all cached pages of this repository",
// "Clear cache" => "Clear cache",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Cache expiration" => "Cache expiration",
// "Human readable text description of repository" => "Human readable text description of repository",
// "configure this repository" => "configure this repository",
// "view this repository" => "view this repository",
// "Add new rule" => "Add new rule",
// "new rule" => "new rule",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Rule order" => "Rule order",
// "Text to search for" => "Text to search for",
// "Text to replace" => "Text to replace",
// "Is this regular expression or simple search/replacer" => "Is this regular expression or simple search/replacer",
// "Is case sensitive (for simple replacer)" => "Is case sensitive (for simple replacer)",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
// "Human readable text description of rule" => "Human readable text description of rule",
// "Check to enable this rule" => "Check to enable this rule",
// "Enabled" => "Enabled",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
// "Apply all rules" => "Apply all rules",
// "View source code after rules applied" => "View source code after rules applied",
// "Generate HTML preview" => "Generate HTML preview",
// "HTML preview" => "HTML preview",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
// "admin featured links" => "admin featured links",
// "admin featured links template" => "admin featured links template",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.",
// "Mail-in accounts" => "Mail-in accounts",
// "admin mailin template" => "admin mailin template",
// "Account" => "Account",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
// "article-put" => "article-put",
// "Article Topic" => "Article Topic",
// "Article Type" => "Article Type",
// "Allow anonymous acces" => "Allow anonymous acces",
// "Allow attachments" => "Allow attachments",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
// "Check automatically" => "Check automatically",
// "Frequency" => "Frequency",
// "mn" => "mn",
// "Show Quick Urls" => "Show Quick Urls",
// "Hide Quick Urls" => "Hide Quick Urls",
// "sorted section" => "sorted section",
// "separator" => "separator",
// "Choose" => "Choose",
// "admin menus template" => "admin menus template",
// "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:",
// "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "admin modules template" => "admin modules template",
// "parameters" => "parameters",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "phpLayersMenus" => "phpLayersMenus",
// "use phplayermenu" => "use phplayermenu",
// "structure" => "structure",
// "Add email:" => "Add email:",
// "Add user:" => "Add user:",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "admin newsletters template" => "admin newsletters template",
// "send newsletter" => "send newsletter",
// "archives" => "archives",
// "admin notifications template" => "admin notifications template",
// "Any wiki page is changed, even minor changes" => "Any wiki page is changed, even minor changes",
// "PHP error" => "PHP error",
// "No records found." => "No records found.",
// "admin polls template" => "admin polls template",
// "configure polls" => "configure polls",
// "Admin Quicktags" => "Admin Quicktags",
// "admin QuickTags" => "admin QuickTags",
// "tiki admin quicktags template" => "tiki admin quicktags template",
// "Create/Edit QuickTags" => "Create/Edit QuickTags",
// "label" => "label",
// "Insert (use 'text' for figuring the selection)" => "Insert (use 'text' for figuring the selection)",
// "Path to the tag icon" => "Path to the tag icon",
// "Insert" => "Insert",
// "Icon" => "Icon",
// "admin RSSmodules template" => "admin RSSmodules template",
// "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed.",
// "Score System" => "Score System",
// "security admin" => "security admin",
// "security admin tpl" => "security admin tpl",
// "edit tpl" => "edit tpl",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>.",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Setting" => "Setting",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "TikiWiki settings" => "TikiWiki settings",
// "Tiki variable" => "Tiki variable",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini.",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database.",
// "File checks" => "File checks",
// "State" => "State",
// "Admin Shoutbox Words" => "Admin Shoutbox Words",
// "admin shoutbox words" => "admin shoutbox words",
// "admin shoutbox words template" => "admin shoutbox words template",
// "Add Banned Word" => "Add Banned Word",
// "Are you sure you want to delete this word?" => "Are you sure you want to delete this word?",
// "admin structures template" => "admin structures template",
// "Structure ID" => "Structure ID",
// "dump tree" => "dump tree",
// "create webhelp" => "create webhelp",
// "view webhelp" => "view webhelp",
// "Alias" => "Alias",
// "create new structure" => "create new structure",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "administer surveys template" => "administer surveys template",
// "Create New Survey" => "Create New Survey",
// "active perms" => "active perms",
// "system admin" => "system admin",
// "system admin tpl" => "system admin tpl",
// "If your Tiki is acting weird, 1st thing to try it to clear your cache below. Also very important to clear your cache after an upgrade (by FTP/SSH if need be)." => "If your Tiki is acting weird, 1st thing to try it to clear your cache below. Also very important to clear your cache after an upgrade (by FTP/SSH if need be).",
// "Empty" => "Empty",
// "Templates compiler" => "Templates compiler",
// "Compile" => "Compile",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function!" => "Warning: Make a backup of your Database before using this function!",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Table" => "Table",
// "Field" => "Field",
// "Investigate" => "Investigate",
// "Fix it" => "Fix it",
// "admin topics template" => "admin topics template",
// "Remove with articles" => "Remove with articles",
// "Admin tracker" => "Admin tracker",
// "Edit this tracker" => "Edit this tracker",
// "View this tracker items" => "View this tracker items",
// "Edit tracker fields" => "Edit tracker fields",
// "Is column visible when listing tracker items?" => "Is column visible when listing tracker items?",
// "Column links to edit/view item?" => "Column links to edit/view item?",
// "Column is searchable?" => "Column is searchable?",
// "Field is public? (for use thru trackerlist plugin)" => "Field is public? (for use thru trackerlist plugin)",
// "Field is hidden?" => "Field is hidden?",
// "not hidden" => "not hidden",
// "visible by admin only" => "visible by admin only",
// "editable by admin only" => "editable by admin only",
// "Field is mandatory?" => "Field is mandatory?",
// "Tracker fields" => "Tracker fields",
// "isMain" => "isMain",
// "Tbl vis" => "Tbl vis",
// "Searchable" => "Searchable",
// "Public" => "Public",
// "Hidden" => "Hidden",
// "Mandatory" => "Mandatory",
// "Import/export trackers fields" => "Import/export trackers fields",
// "Edit fields for tracker" => "Edit fields for tracker",
// "Edit tracker" => "Edit tracker",
// "Create trackers" => "Create trackers",
// "Import/export" => "Import/export",
// "active permissions" => "active permissions",
// "Create/edit trackers" => "Create/edit trackers",
// "There are individual permissions set for this tracker" => "There are individual permissions set for this tracker",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL",
// "Show status" => "Show status",
// "Default status displayed in list mode" => "Default status displayed in list mode",
// "Show status to tracker admin only" => "Show status to tracker admin only",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker needs a text field named Subject" => "The tracker needs a text field named Subject",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
// "No change" => "No change",
// "Item creator can modify his items?" => "Item creator can modify his items?",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "Member of the default group of creator can modify items?" => "Member of the default group of creator can modify items?",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "Show creation date when listing tracker items?" => "Show creation date when listing tracker items?",
// "Show lastModif date when listing tracker items?" => "Show lastModif date when listing tracker items?",
// "What field is used for default sort?" => "What field is used for default sort?",
// "What is default sort order in list?" => "What is default sort order in list?",
// "ascending" => "ascending",
// "descending" => "descending",
// "Tracker items allow ratings?" => "Tracker items allow ratings?",
// "with values" => "with values",
// "and display rating results in listing?" => "and display rating results in listing?",
// "Tracker items allow comments?" => "Tracker items allow comments?",
// "and display comments in listing?" => "and display comments in listing?",
// "Tracker items allow attachments?" => "Tracker items allow attachments?",
// "and display attachments in listing?" => "and display attachments in listing?",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "filename" => "filename",
// "filesize" => "filesize",
// "filetype" => "filetype",
// "longdesc" => "longdesc",
// "Import/export trackers" => "Import/export trackers",
// "Import/Export CSV Data" => "Import/Export CSV Data",
// "Download CSV export" => "Download CSV export",
// "tracker_{\$trackerId}.csv" => "tracker_{\$trackerId}.csv",
// "Import file" => "Import file",
// "admin groups template" => "admin groups template",
// "Edit group" => "Edit group",
// "Members" => "Members",
// "Add a new group" => "Add a new group",
// "assign permissions" => "assign permissions",
// "Group Homepage" => "Group Homepage",
// "Use wiki page name or full URL" => "Use wiki page name or full URL",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker ..." => "choose a group tracker ...",
// "choose a field ..." => "choose a field ...",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker ..." => "choose a users tracker ...",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Group tracker item not found" => "Group tracker item not found",
// "Create item" => "Create item",
// "Members List" => "Members List",
// "remove from group" => "remove from group",
// "users in group" => "users in group",
// "List all members" => "List all members",
// "admin users template" => "admin users template",
// "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions",
// "Edit user" => "Edit user",
// "Change user preferences" => "Change user preferences",
// "edit account settings" => "edit account settings",
// "Assign Group" => "Assign Group",
// "edit included group" => "edit included group",
// "select all" => "select all",
// "Perform action with checked:" => "Perform action with checked:",
// "remove users and their userpages" => "remove users and their userpages",
// "manage group assignments" => "manage group assignments",
// "set default groups" => "set default groups",
// "Assign selected to" => "Assign selected to",
// "Remove selected from" => "Remove selected from",
// "the following groups:" => "the following groups:",
// "Tip: hold down CTRL to select multiple" => "Tip: hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "assign to groups" => "assign to groups",
// "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master",
// "Warning: changing the username will require the user to change his password" => "Warning: changing the username will require the user to change his password",
// "Registration" => "Registration",
// "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "Admin Article Types" => "Admin Article Types",
// "Article Types tpl" => "Article Types tpl",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
// "Rate" => "Rate",
// "Allow ratings by the author" => "Allow ratings by the author",
// "Show before publish date" => "Show before publish date",
// "non-admins can view before the publish date" => "non-admins can view before the publish date",
// "Show after expire date" => "Show after expire date",
// "non-admins can view after the expire date" => "non-admins can view after the expire date",
// "Heading only" => "Heading only",
// "No article body, heading only" => "No article body, heading only",
// "Allow comments for this type" => "Allow comments for this type",
// "Comment Can Rate Article" => "Comment Can Rate Article",
// "Allow comments to include a rating value" => "Allow comments to include a rating value",
// "Show image" => "Show image",
// "Show topic or own image" => "Show topic or own image",
// "Show avatar" => "Show avatar",
// "Show author's avatar" => "Show author's avatar",
// "Show author" => "Show author",
// "Show author name" => "Show author name",
// "Show publish date" => "Show publish date",
// "Show expire date" => "Show expire date",
// "Show reads" => "Show reads",
// "Show the number of times the article was read" => "Show the number of times the article was read",
// "Show size" => "Show size",
// "Show the size of the article" => "Show the size of the article",
// "Show topline" => "Show topline",
// "Show a small title over the title" => "Show a small title over the title",
// "Show subtitle" => "Show subtitle",
// "Show the subtitle" => "Show the subtitle",
// "Show source" => "Show source",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Image Caption" => "Show Image Caption",
// "Show a legend under the image" => "Show a legend under the image",
// "Show Language" => "Show Language",
// "Show the language" => "Show the language",
// "Creator can edit" => "Creator can edit",
// "The person who submits an article of this type can edit it" => "The person who submits an article of this type can edit it",
// "Delete" => "Delete",
// "Delete this type" => "Delete this type",
// "List of types" => "List of types",
// "Show lang" => "Show lang",
// "Classified" => "Classified",
// "Create a new type" => "Create a new type",
// "advanced feature" => "advanced feature",
// "level configuration" => "level configuration",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Available groups" => "Available groups",
// "assign perms to this group" => "assign perms to this group",
// "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead." => "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead.",
// "Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP.",
// "Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP.",
// "If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP.",
// "Directory batch upload" => "Directory batch upload",
// "available images" => "available images",
// "width" => "width",
// "height" => "height",
// "remove file extension from image name" => "remove file extension from image name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "convert sub directories to sub galleries" => "convert sub directories to sub galleries",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created",
// "use sub directory names as description" => "use sub directory names as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created",
// "Select a Gallery" => "Select a Gallery",
// "Mark entry as private:" => "Mark entry as private:",
// "Send trackback pings to:" => "Send trackback pings to:",
// "admin the category system" => "admin the category system",
// "admin category" => "admin category",
// "Browse in" => "Browse in",
// "Wiki pages" => "Wiki pages",
// "Trackers Items" => "Trackers Items",
// "Sheets" => "Sheets",
// "Hide subcategories objects" => "Hide subcategories objects",
// "Show subcategories objects" => "Show subcategories objects",
// "Upper level" => "Upper level",
// "list galleries" => "list galleries",
// "Directory batch" => "Directory batch",
// "subgallery" => "subgallery",
// "Subgallery" => "Subgallery",
// "hit" => "hit",
// "slideshow forward" => "slideshow forward",
// "Cyclic" => "Cyclic",
// "Direction" => "Direction",
// "Click to zoom" => "Click to zoom",
// "Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal degrees)",
// "Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal degrees)",
// "You can include the image in an HTML page using one of these lines" => "You can include the image in an HTML page using one of these lines",
// "You can include the image in a tiki page using one of these lines" => "You can include the image in a tiki page using one of these lines",
// "add item" => "add item",
// "Edit/Create" => "Edit/Create",
// "Date Selector" => "Date Selector",
// "click to navigate" => "click to navigate",
// "Focus:" => "Focus:",
// "change focus" => "change focus",
// "quarter" => "quarter",
// "semester" => "semester",
// "calendar view" => "calendar view",
// "list view" => "list view",
// "zoom" => "zoom",
// "Subscription List" => "Subscription List",
// "New Calendar Item" => "New Calendar Item",
// "Syntax error" => "Syntax error",
// "Format: mm/dd/yyyy hh:mm<br />..." => "Format: mm/dd/yyyy hh:mm<br />...",
// "See strtotime php function" => "See strtotime php function",
// "Format: mm/dd/yyy hh:mm<br />..." => "Format: mm/dd/yyy hh:mm<br />...",
// "save_to" => "save_to",
// "close" => "close",
// "click to view" => "click to view",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "CSV File" => "CSV File",
// "Assign permissions to category" => "Assign permissions to category",
// "Current permissions for this category" => "Current permissions for this category",
// "remove from this category &amp; all its children" => "remove from this category &amp; all its children",
// "remove from this category only" => "remove from this category only",
// "this category &amp; all its children" => "this category &amp; all its children",
// "this category only" => "this category only",
// "Assigning permissions for <b>all children</b> is recommended for best performance." => "Assigning permissions for <b>all children</b> is recommended for best performance.",
// "There are no channels setup, please contact a site admin" => "There are no channels setup, please contact a site admin",
// "Use (:smileyname:) for smileys" => "Use (:smileyname:) for smileys",
// "Automatic Page Breaks" => "Automatic Page Breaks",
// "click here to send us an email" => "click here to send us an email",
// "Create WebHelp" => "Create WebHelp",
// "You can browse the generated WebHelp here" => "You can browse the generated WebHelp here",
// "Top page" => "Top page",
// "You cannot add sites until Directory Categories are setup." => "You cannot add sites until Directory Categories are setup.",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "Name:" => "Name:",
// "URL:" => "URL:",
// "Categories:" => "Categories:",
// "directory admin related tpl" => "directory admin related tpl",
// "Admin Directory Sites" => "Admin Directory Sites",
// "Admin Directory Sites tpl" => "Admin Directory Sites tpl",
// "add a category" => "add a category",
// "Topline" => "Topline",
// "Subtitle" => "Subtitle",
// "Source" => "Source",
// "pixels" => "pixels",
// "Image caption" => "Image caption",
// "Expiration Date" => "Expiration Date",
// "Max impressions" => "Max impressions",
// "Remove Zones (you lose entered info for the banner)" => "Remove Zones (you lose entered info for the banner)",
// "Create Blog" => "Create Blog",
// "Allow trackback pings" => "Allow trackback pings",
// "Show user avatar" => "Show user avatar",
// "Edit Style Sheet" => "Edit Style Sheet",
// "Style Sheet" => "Style Sheet",
// "choose a stylesheet" => "choose a stylesheet",
// "For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>",
// "Bold text" => "Bold text",
// "underscores" => "underscores",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Centered text" => "Centered text",
// "colons" => "colons",
// "Underlined text" => "Underlined text",
// "equals" => "equals",
// "Text box" => "Text box",
// "One carat" => "One carat",
// "Will display using the indicated HTML color or color name" => "Will display using the indicated HTML color or color name",
// "for bullet lists" => "for bullet lists",
// "Headings" => "Headings",
// "make headings" => "make headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "JoinCapitalizedWords or use" => "JoinCapitalizedWords or use",
// "prevents referencing" => "prevents referencing",
// "use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!).",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "row" => "row",
// "col" => "col",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "Horizontal rule" => "Horizontal rule",
// "creates the editable drawing foo" => "creates the editable drawing foo",
// "to separate pages" => "to separate pages",
// "Wiki File Attachments" => "Wiki File Attachments",
// "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated.",
// "displays rss feed with id=n maximum=m items" => "displays rss feed with id=n maximum=m items",
// "Dynamic variables" => "Dynamic variables",
// "Inserts an editable variable" => "Inserts an editable variable",
// "Prevents wiki parsing of the enclosed data." => "Prevents wiki parsing of the enclosed data.",
// "Preformated sections" => "Preformated sections",
// "Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).",
// "Square Brackets" => "Square Brackets",
// "Use [[foo] to show [foo]." => "Use [[foo] to show [foo].",
// "Block Preformatting" => "Block Preformatting",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that.",
// "Table of contents" => "Table of contents",
// "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Quicktags" => "Quicktags",
// "table new" => "table new",
// "wiki link'" => "wiki link'",
// "rss feed" => "rss feed",
// "tagline" => "tagline",
// "New wms Metadata" => "New wms Metadata",
// "New Class" => "New Class",
// "New Projection" => "New Projection",
// "New Query" => "New Query",
// "New Scalebar" => "New Scalebar",
// "New Layer" => "New Layer",
// "New Label" => "New Label",
// "New Reference" => "New Reference",
// "New Legend" => "New Legend",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
// "New Mapfile" => "New Mapfile",
// "admin quicktags" => "admin quicktags",
// "browse image" => "browse image",
// "edit this quiz" => "edit this quiz",
// "admin quizzes" => "admin quizzes",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Passing Percentage" => "Passing Percentage",
// "%" => "%",
// "edit quiz questions" => "edit quiz questions",
// "edit quiz questions tpl" => "edit quiz questions tpl",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character.",
// "Input" => "Input",
// "From Points" => "From Points",
// "To Points" => "To Points",
// "Modify Structure" => "Modify Structure",
// "Current Node" => "Current Node",
// "Promote" => "Promote",
// "Demote" => "Demote",
// "Add pages to current node" => "Add pages to current node",
// "Structure Layout" => "Structure Layout",
// "Help on Articles" => "Help on Articles",
// "<b>*</b>=optional" => "<b>*</b>=optional",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "save only in the theme:" => "save only in the theme:",
// "Delete the copy in the theme:" => "Delete the copy in the theme:",
// "Edit Translation:" => "Edit Translation:",
// "edit translations" => "edit translations",
// "edit translations template" => "edit translations template",
// "View" => "View",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "Use this section to set the language of the version you are currently working on." => "Use this section to set the language of the version you are currently working on.",
// "Set of Translations" => "Set of Translations",
// "detach" => "detach",
// "add to the set" => "add to the set",
// "Select the article for which the current article is the translation." => "Select the article for which the current article is the translation.",
// "Translation of:" => "Translation of:",
// "Enter the name of the page for which the current page is the translation." => "Enter the name of the page for which the current page is the translation.",
// "Use rating" => "Use rating",
// "disable" => "disable",
// "There is no available poll template." => "There is no available poll template.",
// "You should ask an admin to create them." => "You should ask an admin to create them.",
// "an existing poll" => "an existing poll",
// "Search " => "Search ",
// "Case Insensitivity" => "Case Insensitivity",
// "replace" => "replace",
// "Try to convert HTML to wiki" => "Try to convert HTML to wiki",
// "Admin ephemerides" => "Admin ephemerides",
// "admin Ephemerides tpl" => "admin Ephemerides tpl",
// "All ephemerides" => "All ephemerides",
// "File Galleries tpl" => "File Galleries tpl",
// "sticky" => "sticky",
// "no feeling" => "no feeling",
// "frown" => "frown",
// "exclaim" => "exclaim",
// "idea" => "idea",
// "mad" => "mad",
// "neutral" => "neutral",
// "sad" => "sad",
// "happy" => "happy",
// "wink" => "wink",
// "convert to topic" => "convert to topic",
// "configure forum" => "configure forum",
// "Reported messages for" => "Reported messages for",
// "Reported by" => "Reported by",
// "friends tpl" => "friends tpl",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "refuse" => "refuse",
// "Waiting requests" => "Waiting requests",
// "Your friends" => "Your friends",
// "break friendship" => "break friendship",
// "Activity completed" => "Activity completed",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "auto routed" => "auto routed",
// "Expiration Time" => "Expiration Time",
// "Years" => "Years",
// "Months" => "Months",
// "Days" => "Days",
// "Minutes" => "Minutes",
// "Int" => "Int",
// "Routing" => "Routing",
// "inter" => "inter",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed.",
// "new minor" => "new minor",
// "new major" => "new major",
// "Act status" => "Act status",
// "Ended" => "Ended",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "run instance" => "run instance",
// "Executed" => "Executed",
// "Pop-up" => "Pop-up",
// "erase" => "erase",
// "Or upload a process using this form" => "Or upload a process using this form",
// "Switch construct" => "Switch construct",
// "Map process roles" => "Map process roles",
// "int" => "int",
// "routing" => "routing",
// "Instances" => "Instances",
// "run" => "run",
// "run activity" => "run activity",
// "Enter the name of this instance" => "Enter the name of this instance",
// "The name is not valid. Please, enter the name again" => "The name is not valid. Please, enter the name again",
// "monitor instances" => "monitor instances",
// "monitor workitems" => "monitor workitems",
// "Galaxia Monitor Instances" => "Galaxia Monitor Instances",
// "Galaxia Monitor Instances tpl" => "Galaxia Monitor Instances tpl",
// "List of instances" => "List of instances",
// "Not ended" => "Not ended",
// "No instances created yet" => "No instances created yet",
// "Valid" => "Valid",
// "being run" => "being run",
// "Monitor workitems" => "Monitor workitems",
// "List of workitems" => "List of workitems",
// "instance" => "instance",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "My activities" => "My activities",
// "Current Activity" => "Current Activity",
// "Assigned To" => "Assigned To",
// "exception instance" => "exception instance",
// "exceptions instance" => "exceptions instance",
// "send instance" => "send instance",
// "abort instance" => "abort instance",
// "grab instance" => "grab instance",
// "release instance" => "release instance",
// "No activities found" => "No activities found",
// "My instances" => "My instances",
// "No instances found" => "No instances found",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "user instances" => "user instances",
// "Galaxia User Instances" => "Galaxia User Instances",
// "Galaxia User Instances tpl" => "Galaxia User Instances tpl",
// "Inst Status" => "Inst Status",
// "Not defined" => "Not defined",
// "No instances defined yet" => "No instances defined yet",
// "Browsing Workitem" => "Browsing Workitem",
// "Workitem information" => "Workitem information",
// "rebuild cache" => "rebuild cache",
// "Geographic" => "Geographic",
// "Default sort order" => "Default sort order",
// "Fields to show during browsing the gallery" => "Fields to show during browsing the gallery",
// "Creation Date" => "Creation Date",
// "XY-Size" => "XY-Size",
// "Gallery Image" => "Gallery Image",
// "Parent gallery" => "Parent gallery",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "Owner of the gallery" => "Owner of the gallery",
// "Choose a filter" => "Choose a filter",
// "Make Map" => "Make Map",
// "Save clicked point" => "Save clicked point",
// "Save current view as default" => "Save current view as default",
// "Reset view to site-wide default" => "Reset view to site-wide default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal" => "Horizontal",
// "Vertical" => "Vertical",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Left" => "Left",
// "Right" => "Right",
// "Series" => "Series",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "excerpt" => "excerpt",
// "body" => "body",
// "Tiki installer" => "Tiki installer",
// "MultiTiki setup" => "MultiTiki setup",
// "To add a new virtual host" => "To add a new virtual host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "reload" => "reload",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "Please enter your database connection info" => "Please enter your database connection info",
// "Database type" => "Database type",
// "The type of database you intend to use" => "The type of database you intend to use",
// "Host:" => "Host:",
// "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki" => "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki",
// "If you use SQLite, insert the path and filename to your database file" => "If you use SQLite, insert the path and filename to your database file",
// "Database user" => "Database user",
// "Database password" => "Database password",
// "Database name" => "Database name",
// "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names" => "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names",
// "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above" => "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above",
// "Welcome to the installation &amp; upgrade script!" => "Welcome to the installation &amp; upgrade script!",
// "Install" => "Install",
// "Create database (clean install) with profile" => "Create database (clean install) with profile",
// "Descriptions of the available profiles" => "Descriptions of the available profiles",
// "Upgrade" => "Upgrade",
// "backup your database" => "backup your database",
// "with mysqldump or phpmyadmin before you proceed" => "with mysqldump or phpmyadmin before you proceed",
// "Update database using script" => "Update database using script",
// "For database update from 1.8 or later" => "For database update from 1.8 or later",
// "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script" => "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script",
// "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)" => "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)",
// "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions" => "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions",
// "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity" => "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity",
// "Do nothing and enter Tiki" => "Do nothing and enter Tiki",
// "Reset database connection settings" => "Reset database connection settings",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please enter your admin password to continue" => "Please enter your admin password to continue",
// "Print operations executed successfully" => "Print operations executed successfully",
// "Print operations failed" => "Print operations failed",
// "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application" => "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application",
// "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore" => "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore",
// "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!" => "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!",
// "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!" => "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!",
// "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at only 8 Megs" => "Tiki has detected your PHP memory limit at only 8 Megs",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Note" => "Note",
// "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation" => "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation",
// "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system" => "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system",
// "Now you may proceed by clicking one of these links" => "Now you may proceed by clicking one of these links",
// "Click here to disable the install script and proceed into tiki" => "Click here to disable the install script and proceed into tiki",
// "Click here to proceed into tiki without disabling the script" => "Click here to proceed into tiki without disabling the script",
// "Go back and run another install/upgrade script" => "Go back and run another install/upgrade script",
// "do not use your Back button in your browser!" => "do not use your Back button in your browser!",
// "Clear cached version and refresh cache" => "Clear cached version and refresh cache",
// "configure rules" => "configure rules",
// "edit repository" => "edit repository",
// "v" => "v",
// "ExpireDate" => "ExpireDate",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone.",
// "Max Impressions" => "Max Impressions",
// "Impressions" => "Impressions",
// "Help on Dynamic Content" => "Help on Dynamic Content",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block.",
// "Future vers" => "Future vers",
// "monitor this gallery" => "monitor this gallery",
// "stop monitoring this gallery" => "stop monitoring this gallery",
// "Dls" => "Dls",
// "games tpl" => "games tpl",
// "/" => "/",
// "Flash binary (.sqf or .dcr)" => "Flash binary (.sqf or .dcr)",
// "list quizzes tpl" => "list quizzes tpl",
// "edit quiz stats tpl" => "edit quiz stats tpl",
// "actions" => "actions",
// "take survey" => "take survey",
// "list trackers tpl" => "list trackers tpl",
// "users registered" => "users registered",
// "Distance (km)" => "Distance (km)",
// "Com" => "Com",
// "with checked" => "with checked",
// "Transcripts" => "Transcripts",
// "Accepted requests" => "Accepted requests",
// "transcripts" => "transcripts",
// "Offline operators" => "Offline operators",
// "be online" => "be online",
// "be offline" => "be offline",
// "Support chat transcripts" => "Support chat transcripts",
// "operator" => "operator",
// "Transcript" => "Transcript",
// "Mail-in feature" => "Mail-in feature",
// "User Calendar" => "User Calendar",
// "User Calendar Doc tpl" => "User Calendar Doc tpl",
// "User Calendar Doc" => "User Calendar Doc",
// "User Calendar Preferences Doc tpl" => "User Calendar Preferences Doc tpl",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>.",
// "TikiWiki Mods" => "TikiWiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example)." => "Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example).",
// "To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\")." => "To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\").",
// "all types" => "all types",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "install" => "install",
// "TikiWiki Mods Configuration" => "TikiWiki Mods Configuration",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "Last editor" => "Last editor",
// "Last modification" => "Last modification",
// "y" => "y",
// "subscribe" => "subscribe",
// "Sent edition" => "Sent edition",
// "Available Newsletters" => "Available Newsletters",
// "News from" => "News from",
// "Read the news" => "Read the news",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "rollback to this version" => "rollback to this version",
// "Source of version" => "Source of version",
// "s=source" => "s=source",
// "b=rollback" => "b=rollback",
// "No individual permissions; category or global permissions apply" => "No individual permissions; category or global permissions apply",
// "Current permissions for categories that this page belongs to" => "Current permissions for categories that this page belongs to",
// "No category permissions; global permissions apply" => "No category permissions; global permissions apply",
// "no avatar" => "no avatar",
// "icons" => "icons",
// "Any" => "Any",
// "atts" => "atts",
// "Number of voices" => "Number of voices",
// "List Attachments" => "List Attachments",
// "Note: Remember that this is only a preview, and has not yet been saved!" => "Note: Remember that this is only a preview, and has not yet been saved!",
// "add structure" => "add structure",
// "Edit quiz" => "Edit quiz",
// "Current Version" => "Current Version",
// "General Options" => "General Options",
// "Publication Date" => "Publication Date",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions." => "randomly selected questions.",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)." => "&nbsp question(s).",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz." => "Allow students to store partial results and return to quiz.",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue:" => "Prologue:",
// "Epilogue:" => "Epilogue:",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "P" => "P",
// "F" => "F",
// "Help on Communication Center" => "Help on Communication Center",
// "admin Referer stats" => "admin Referer stats",
// "admin Referer stats tpl" => "admin Referer stats tpl",
// "A valid email is mandatory to register" => "A valid email is mandatory to register",
// "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!" => "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!",
// "Tiki site registered" => "Tiki site registered",
// "You don't have permission to use this feature." => "You don't have permission to use this feature.",
// "Please register." => "Please register.",
// "Read this first!" => "Read this first!",
// "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites.",
// "Registering is voluntary." => "Registering is voluntary.",
// "Registering does not give you any benefits except one more link to your site." => "Registering does not give you any benefits except one more link to your site.",
// "You don't get any emails, we don't sell the data about your site." => "You don't get any emails, we don't sell the data about your site.",
// "Registering is just for us to get an overview of Tiki's usage." => "Registering is just for us to get an overview of Tiki's usage.",
// "If your site is private or inside your intranet, you should not register!" => "If your site is private or inside your intranet, you should not register!",
// "tikiwiki.org" => "tikiwiki.org",
// "Information about your site" => "Information about your site",
// "last version" => "last version",
// "Replicate" => "Replicate",
// "Slave" => "Slave",
// "Master" => "Master",
// "Change" => "Change",
// "Operations" => "Operations",
// "Operations Log" => "Operations Log",
// "trackers" => "trackers",
// "entire site" => "entire site",
// "wiki pages" => "wiki pages",
// "Apply content template" => "Apply content template",
// "sheets tpl" => "sheets tpl",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet:" => "Edit this sheet:",
// "create new sheet" => "create new sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "Graph" => "Graph",
// "Tiki Shoutbox" => "Tiki Shoutbox",
// "admin Tiki Shoutbox" => "admin Tiki Shoutbox",
// "admin Tiki Shoutbox tpl" => "admin Tiki Shoutbox tpl",
// "Change shoutbox general settings" => "Change shoutbox general settings",
// "auto-link urls" => "auto-link urls",
// "first" => "first",
// "big grin" => "big grin",
// "confused" => "confused",
// "cool" => "cool",
// "cry" => "cry",
// "eek" => "eek",
// "evil" => "evil",
// "lol" => "lol",
// "mr green" => "mr green",
// "razz" => "razz",
// "redface" => "redface",
// "rolleyes" => "rolleyes",
// "smile" => "smile",
// "surprised" => "surprised",
// "twisted" => "twisted",
// "arrow" => "arrow",
// "santa" => "santa",
// "CMS" => "CMS",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "pvs" => "pvs",
// "CMS Stats" => "CMS Stats",
// "Quizzes taken" => "Quizzes taken",
// "Usage chart image" => "Usage chart image",
// "Daily Usage" => "Daily Usage",
// "Last taken" => "Last taken",
// "SysLog" => "SysLog",
// "system logs" => "system logs",
// "system logs tpl" => "system logs tpl",
// "Thank you for your submission" => "Thank you for your submission",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
// "Control by Objects" => "Control by Objects",
// "Edit File:" => "Edit File:",
// "Batch upload" => "Batch upload",
// "You have to \ncreate a gallery first!" => "You have to \ncreate a gallery first!",
// "or use filename" => "or use filename",
// "Note: Maximum image size is limited to" => "Note: Maximum image size is limited to",
// "You can include the image in an Wiki page using" => "You can include the image in an Wiki page using",
// "Folder in" => "Folder in",
// "Homepage" => "Homepage",
// "Users HomePage" => "Users HomePage",
// "Create page" => "Create page",
// "This user is your friend" => "This user is your friend",
// "Request friendship from this user" => "Request friendship from this user",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "Personal Information" => "Personal Information",
// "General preferences" => "General preferences",
// "Other preferences" => "Other preferences",
// "use google map locator" => "use google map locator",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Change information" => "Change information",
// "Unavailable - please set your e-mail below" => "Unavailable - please set your e-mail below",
// "Does your mail reader need a special charset" => "Does your mail reader need a special charset",
// "Use double-click to edit pages" => "Use double-click to edit pages",
// "Account Information" => "Account Information",
// "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password",
// "Email address" => "Email address",
// "Confirm new password" => "Confirm new password",
// "Current password (required)" => "Current password (required)",
// "Change administrative info" => "Change administrative info",
// "Note author when reading his mail" => "Note author when reading his mail",
// "Auto-archive read messages after x days" => "Auto-archive read messages after x days",
// "My workflow" => "My workflow",
// "New task" => "New task",
// "Task list" => "Task list",
// "Admin mode off" => "Admin mode off",
// "Admin mode on" => "Admin mode on",
// "Task help" => "Task help",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "accepted by task user and creator" => "accepted by task user and creator",
// "accepted user and creator" => "accepted user and creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "not accepted by one user" => "not accepted by one user",
// "not accepted user" => "not accepted user",
// "Task is rejected by one user" => "Task is rejected by one user",
// "waiting for me" => "waiting for me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "waiting for other user" => "waiting for other user",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "admin mode" => "admin mode",
// "trash" => "trash",
// "empty trash" => "empty trash",
// "Edit task" => "Edit task",
// "red" => "red",
// "NOT accept" => "NOT accept",
// "remove from trash" => "remove from trash",
// "move into trash" => "move into trash",
// "Task saved" => "Task saved",
// "Edit Task" => "Edit Task",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "use start date and time" => "use start date and time",
// "use end date and time" => "use end date and time",
// "open / in process" => "open / in process",
// "waiting / not started" => "waiting / not started",
// "waiting" => "waiting",
// "shared for group" => "shared for group",
// "accepted by user" => "accepted by user",
// "no / rejected" => "no / rejected",
// "accepted by creator" => "accepted by creator",
// "Info" => "Info",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// "select one" => "select one",
// "undo trash" => "undo trash",
// "show:" => "show:",
// "received" => "received",
// "submitted" => "submitted",
// "shared" => "shared",
// "all shared tasks" => "all shared tasks",
// "completed (100%)" => "completed (100%)",
// "Public for group" => "Public for group",
// "User Watches tpl" => "User Watches tpl",
// "Add Watch" => "Add Watch",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "edit user files" => "edit user files",
// "Pos" => "Pos",
// "User_versions_for" => "User_versions_for",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "Before" => "Before",
// "After" => "After",
// "expires:" => "expires:",
// "pos" => "pos",
// "pre" => "pre",
// "permanency" => "permanency",
// "info/vote" => "info/vote",
// "View or vote items not listed in the chart" => "View or vote items not listed in the chart",
// "Answers" => "Answers",
// "add suggestion" => "add suggestion",
// "1 suggestion" => "1 suggestion",
// "suggestions" => "suggestions",
// "You have {\$unread} unread private messages" => "You have {\$unread} unread private messages",
// "reported messages:" => "reported messages:",
// "emot" => "emot",
// "pts" => "pts",
// "posts:" => "posts:",
// "Edit fields" => "Edit fields",
// " item found" => " item found",
// " items found" => " items found",
// "list attachments" => "list attachments",
// "View inserted item" => "View inserted item",
// "fields marked with a * are mandatory" => "fields marked with a * are mandatory",
// "Tracker item:" => "Tracker item:",
// "Filter Tracker Items" => "Filter Tracker Items",
// "more info" => "more info",
// "remove image" => "remove image",
// "Special Operations" => "Special Operations",
// "Details" => "Details",
// "Webmail Doc template" => "Webmail Doc template",
// "Edit mail account" => "Edit mail account",
// "%s enabled" => "%s enabled",
// "%s disabled" => "%s disabled",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Wiki Attachments" => "Wiki Attachments",
// "Article/CMS settings" => "Article/CMS settings",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "RSS settings" => "RSS settings",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Search settings" => "Search settings",
// "Score settings" => "Score settings",
// "Projects" => "Projects",
// "Projects configuration" => "Projects configuration",
// "Community settings" => "Community settings",
// "Site Identity features" => "Site Identity features",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Click here to delete this category" => "Click here to delete this category",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "moved %d images, %d errors occured." => "moved %d images, %d errors occured.",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Detected, Version:" => "Detected, Version:",
// "Not detected." => "Not detected.",
// "You cannot have a blank password" => "You cannot have a blank password",
// "All Fields except gdaltindex must be filled" => "All Fields except gdaltindex must be filled",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Repository name can't be an empty" => "Repository name can't be an empty",
// "Requested action is not supported on repository" => "Requested action is not supported on repository",
// "File not found " => "File not found ",
// "Requested action in not supported on repository" => "Requested action in not supported on repository",
// "Non-existent link" => "Non-existent link",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer!" => "Frequency should be a positive integer!",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "unsafe" => "unsafe",
// "register_globals should be off by default. See the php manual for details." => "register_globals should be off by default. See the php manual for details.",
// "safe" => "safe",
// "session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid should be off by default. See the php manual for details.",
// "upload_tmp_dir is probably within your TikiWiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your TikiWiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config.",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off.",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code.",
// "installed" => "installed",
// "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html.",
// "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement.",
// "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory.",
// "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts.",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "File is not readable. Unable to check." => "File is not readable. Unable to check.",
// "This is not a TikiWiki file. Check if this file was uploaded and if it is dangerous." => "This is not a TikiWiki file. Check if this file was uploaded and if it is dangerous.",
// "This is a modified File. Cannot check version. Check if it is dangerous." => "This is a modified File. Cannot check version. Check if it is dangerous.",
// "This file is from another TikiWiki version: " => "This file is from another TikiWiki version: ",
// " or " => " or ",
// "You have to provide a word" => "You have to provide a word",
// "You must specify a page name, it will be created if it doesn't exist." => "You must specify a page name, it will be created if it doesn't exist.",
// "You don't have permission to use this feature" => "You don't have permission to use this feature",
// "No Errors detected" => "No Errors detected",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "User %s already exists" => "User %s already exists",
// "New %s created with %s %s." => "New %s created with %s %s.",
// "Impossible to create new %s with %s %s." => "Impossible to create new %s with %s %s.",
// "%s %s successfully deleted." => "%s %s successfully deleted.",
// "%s %s removed from %s %s." => "%s %s removed from %s %s.",
// "%s <b>%s</b> successfully deleted." => "%s <b>%s</b> successfully deleted.",
// "%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> assigned to %s <b>%s</b>.",
// "%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> removed from %s <b>%s</b>.",
// "group <b>%s</b> set as the default group of user <b>%s</b>." => "group <b>%s</b> set as the default group of user <b>%s</b>.",
// "%s modified successfully." => "%s modified successfully.",
// "%s modification failed." => "%s modification failed.",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "rss feed disabled" => "rss feed disabled",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Last articles." => "Last articles.",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s." => "Could not read image %s.",
// "Image %s upload failed." => "Image %s upload failed.",
// "Image %s uploaded successfully." => "Image %s uploaded successfully.",
// "Image %s removed from Batch directory." => "Image %s removed from Batch directory.",
// "Impossible to remove image %s from Batch directory." => "Impossible to remove image %s from Batch directory.",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images." => "Incorrect directory chosen for batch upload of images.",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator." => "Please contact the website administrator.",
// "Invalid directory name" => "Invalid directory name",
// "Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs." => "Last posts to weblogs.",
// "Please login" => "Please login",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string!",
// "%m/%d" => "%m/%d",
// "Access Denied" => "Access Denied",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Upcoming events." => "Upcoming events.",
// "Start:" => "Start:",
// "End:" => "End:",
// "No category indicated" => "No category indicated",
// "Permission denied; you cannot assign permissions for this category" => "Permission denied; you cannot assign permissions for this category",
// "The passwords didn't match" => "The passwords didn't match",
// "ERROR: you must include a subject or a message at least" => "ERROR: you must include a subject or a message at least",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "Last sites." => "Last sites.",
// "Must enter a name to add a site. " => "Must enter a name to add a site. ",
// "Must enter a url to add a site. " => "Must enter a url to add a site. ",
// "URL already added to the directory. Duplicate site? " => "URL already added to the directory. Duplicate site? ",
// "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. ",
// "Must select a category. " => "Must select a category. ",
// "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory",
// "Site No validated yet" => "Site No validated yet",
// "No parent specified" => "No parent specified",
// "Last sites of directory \".\$rc[\"name\"].\" ." => "Last sites of directory \".\$rc[\"name\"].\" .",
// "Error : The file %s doesn't exist." => "Error : The file %s doesn't exist.",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "Invalid structure_id or page_ref_id" => "Invalid structure_id or page_ref_id",
// "You do not have permission to write the template:" => "You do not have permission to write the template:",
// "No object indicated" => "No object indicated",
// "No type indicated" => "No type indicated",
// "You have mistyped the anti-bot verification code; please try again." => "You have mistyped the anti-bot verification code; please try again.",
// "Can't import remote HTML page" => "Can't import remote HTML page",
// "Can't parse remote HTML page" => "Can't parse remote HTML page",
// "unknown error" => "unknown error",
// "cannot be found" => "cannot be found",
// "No permission to view the page" => "No permission to view the page",
// "No questions group indicated" => "No questions group indicated",
// "Tiki RSS feed for file galleries" => "Tiki RSS feed for file galleries",
// "Last files uploaded to the file galleries." => "Last files uploaded to the file galleries.",
// "Tiki RSS feed for the file gallery: " => "Tiki RSS feed for the file gallery: ",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums." => "Last topics in forums.",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship!" => "I have broken our friendship!",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request!" => "I have accepted your friendship request!",
// "I have refused your friendship request!" => "I have refused your friendship request!",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "You couldn't abort a instance" => "You couldn't abort a instance",
// "You couldn't exception a instance" => "You couldn't exception a instance",
// "No title indicated" => "No title indicated",
// "No comment indicated" => "No comment indicated",
// "No date indicated" => "No date indicated",
// "first uploaded image" => "first uploaded image",
// "last uploaded image" => "last uploaded image",
// "random image" => "random image",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "No valid renderer found. GD or PDFLib required." => "No valid renderer found. GD or PDFLib required.",
// "No sheet specified." => "No sheet specified.",
// "You must select a renderer." => "You must select a renderer.",
// "Invalid Series for current graphic." => "Invalid Series for current graphic.",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries." => "Last images uploaded to the image galleries.",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "updated from structured text import" => "updated from structured text import",
// "created from structured text import" => "created from structured text import",
// "Non-existent gallery" => "Non-existent gallery",
// "This gallery does not exist" => "This gallery does not exist",
// "The game file must have .swf or .dcr extension" => "The game file must have .swf or .dcr extension",
// "Please supply both files" => "Please supply both files",
// "You have to enable cookies to be able to login to this site" => "You have to enable cookies to be able to login to this site",
// "Unable to contact remote server." => "Unable to contact remote server.",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Account validated successfully." => "Account validated successfully.",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Sorry, you can't use this feature." => "Sorry, you can't use this feature.",
// "Maps feature is not correctly setup : Maps path is missing." => "Maps feature is not correctly setup : Maps path is missing.",
// "Please create a directory named \$map_path to hold your map files." => "Please create a directory named \$map_path to hold your map files.",
// "You do not have permission to write to the mapfile" => "You do not have permission to write to the mapfile",
// "I could not make a copy" => "I could not make a copy",
// "You dont have permission to do that" => "You dont have permission to do that",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available." => "List of maps available.",
// "You do not have permissions to create an index file" => "You do not have permissions to create an index file",
// "Invalid file name" => "Invalid file name",
// "Invalid files to index" => "Invalid files to index",
// "I do not know where is gdaltindex. Set correctly the Map feature" => "I do not know where is gdaltindex. Set correctly the Map feature",
// "I could not create the index file" => "I could not create the index file",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled." => "Your PHP installation does not have zlib enabled.",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes." => "You don't have permission to edit quizzes.",
// "Registered" => "Registered",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "Invalid username or activation code. Maybe this code has already been used." => "Invalid username or activation code. Maybe this code has already been used.",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "A password and your IP address reminder email has been sent " => "A password and your IP address reminder email has been sent ",
// "A new (and temporary) password and your IP address has been sent " => "A new (and temporary) password and your IP address has been sent ",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "changed '%s' from '%s' to '%s'" => "changed '%s' from '%s' to '%s'",
// "Non-existent version" => "Non-existent version",
// "Error Message" => "Error Message",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "No newsletters available." => "No newsletters available.",
// "Error: " => "Error: ",
// "Use this thread to discuss the page:" => "Use this thread to discuss the page:",
// "An error occurred." => "An error occurred.",
// "Notice: invalid variable value:" => "Notice: invalid variable value:",
// "This feature is for admins only" => "This feature is for admins only",
// "Quiz time limit exceeded quiz cannot be computed" => "Quiz time limit exceeded quiz cannot be computed",
// "empty" => "empty",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "File update was successful" => "File update was successful",
// "Could not find the file requested" => "Could not find the file requested",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "Usage" => "Usage",
// "The user has chosen to make his information private" => "The user has chosen to make his information private",
// "Invalid password.  Your current password is required to change administrative information" => "Invalid password.  Your current password is required to change administrative information",
// "Email is set to %s" => "Email is set to %s",
// "unicode" => "unicode",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries:" => "Task entries:",
// "Changes:" => "Changes:",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it!" => "Please read the task and work on it!",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "Non-existent user" => "Non-existent user",
// "Permission denied you cannot remove trackbacks" => "Permission denied you cannot remove trackbacks",
// "A SheetId is required." => "A SheetId is required.",
// "That tracker don't use extras." => "That tracker don't use extras.",
// "Tiki RSS feed for the wiki pages" => "Tiki RSS feed for the wiki pages",
// "Last modifications to the Wiki." => "Last modifications to the Wiki.",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"Wiki Home" => "Wiki Home",
"%A %d of %B, %Y" => "%A %d of %B, %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d of %B, %Y[%H:%M:%S %Z]",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"%a %d of %b, %Y" => "%a %d of %b, %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d of %b, %Y[%H:%M %Z]",
"%H:%M %Z" => "%H:%M %Z",
"wiki" => "wiki",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"author" => "author",
"Download Layer" => "Download Layer",
"Ip" => "Ip",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"phpinfo" => "phpinfo",
"WfMenu" => "WfMenu",
"GalMenu" => "GalMenu",
"ForMenu" => "ForMenu",
"DirMenu" => "DirMenu",
"FileGalMenu" => "FileGalMenu",
"QuizMenu" => "QuizMenu",
"TrkMenu" => "TrkMenu",
"SrvMenu" => "SrvMenu",
"EphMenu" => "EphMenu",
"ChartMenu" => "ChartMenu",
"AdmMenu" => "AdmMenu",
"UsrMenu" => "UsrMenu",
"pdf" => "pdf",
"dls" => "dls",
"URI" => "URI",
"RSS" => "RSS",
"Featured Help" => "Featured Help",
"XMLRPC API" => "XMLRPC API",
"Use direct pagination links" => "Use direct pagination links",
"Wiki_Tiki_Title" => "Wiki_Tiki_Title",
"PEAR::Auth" => "PEAR::Auth",
"LDAP Scope" => "LDAP Scope",
"LDAP Base DN" => "LDAP Base DN",
"LDAP User DN" => "LDAP User DN",
"LDAP User OC" => "LDAP User OC",
"MultiPrint" => "MultiPrint",
"x" => "x",
"ID" => "ID",
"URL" => "URL",
"tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
"Replies" => "Replies",
"url" => "url",
"wiki-get" => "wiki-get",
"wiki-put" => "wiki-put",
"wiki-append" => "wiki-append",
"Create new RSS module" => "Create new RSS module",
"Id" => "Id",
"+" => "+",
"tbheight" => "tbheight",
"cType" => "cType",
"SomeName" => "SomeName",
"hr" => "hr",
"canRepeat" => "canRepeat",
"timeLimit" => "timeLimit",
"maxScore" => "maxScore",
"id" => "id",
"#" => "#",
"If:SetNextact" => "If:SetNextact",
"ImportingPagesPhpWikiPageAdmin" => "ImportingPagesPhpWikiPageAdmin",
"tiki-import_phpwiki tpl" => "tiki-import_phpwiki tpl",
"UTC" => "UTC",
"pop" => "pop",
"tiki-mobile.php" => "tiki-mobile.php",
// ###
// ### end of possibly untranslated words
// ###

"Missing title or body when trying to post a comment" => "Не присутні або заголовок, або текст повідомлення",
"The copyright management feature is not enabled." => "Механізм керування правами копіювання не активовано.",
"You do not have permission to use this feature." => "У Вас немає дозволу на використання цієї функції.",
"You must supply all the information, including title and year." => "Ви маєте надати всю інформацію, заголовок та рік вклюючно.",
"You do not have permission to use this feature" => "Ви не маєте дозволу на використання цієї функції",
"This feature is disabled" => "Ця функція не активована",
"None" => "Немає",
"Chinese" => "Китайська",
"Czech" => "Чеська",
"Danish" => "Датська",
"German" => "Німецька",
"English" => "Англійська",
"Spanish" => "Іспанська",
"Greek" => "Грецька",
"French" => "Францзька",
"Italian" => "Італійська",
"Japanese" => "Японська",
"Dutch" => "Голандська",
"Norwegian" => "Норвезька",
"Polish" => "Польська",
"Russian" => "Російська",
"Swedish" => "Шведська",
"Ukrainian" => "Українська",
"Fatal error: cannot execute automatic activity \$activityId" => "Критична помилка: не можу виконати автоматичну дію \$activityId",
"Fatal error: setting next activity to an unexisting activity" => "Фатальна помилка: наступна подія неіснуючого типу ",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Фатальна помилка: nextActivity не має відповідності жодному кандидату в списку автоматичної зміни активностей",
"Fatal error: non-deterministic decision for autorouting activity" => "Критична помилка: невизначене рішення дії автомаршрутизації",
"Circular reference found some activity has a transition leading to itself" => "Колова залежність, деякі дії мають переходи, що ведуть до них самих",
"Process does not have a start activity" => "Процес не має початкової дії",
"Process does not have exactly one end activity" => "Процес не має точно однієї кінцевої дії",
"End activity is not reachable from start activity" => "Кінцева дія не досягається від початкової дії",
"Activity" => "Активність",
" is interactive but has no role assigned" => " інтерактивний, але не має призначеної ролі",
"Role" => "Роль",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Дія '.\$res['name'].' інтерактивна, отже вона має використовувати метод \$instance->complete() ",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Дія '.\$res['name'].' неітерактивна, отже вона має використовувати метод \$instance->complete()",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Дія '.\$res['name'].' -- це перемикач, отже має використовувати мето \$instance->setNextActivity(\$actname)",
"Process %d has been activated" => "Процес %d активізовано ",
"Process %d has been deactivated" => "Процес %d призупинено",
"Process %s %s imported" => "Процес %s %s імпортовано",
"Process %s removed" => "Процес %s видалено",
"Process %s has been updated" => "Процес %s поновлено",
"Process %s has been created" => "Процес %s створено",
"by" => " ",
"refresh" => "оновлення",
"locked" => "замкнено",
"locked by" => "замкнуто",
"continued" => "продовжено",
"in" => "в",
"new image uploaded by" => "нове зображення вивантажено ",
"uploaded by" => "вивантажено",
"new item in tracker" => "новий пункт в тракері",
"new subscriptions" => "нові підписки",
"not specified" => "не вказано",
"The file is not a CSV file or has not a correct syntax" => "Файл не є файлом з CVS або в його синтаксисі є помилки ",
"article" => "стаття",
"blog" => "журнал",
"directory" => "посилання",
"faq" => "чап",
"forum" => "форум",
"poll" => "опит",
"quiz" => "контрольн",
"image" => "зображення",
"calendar" => "календар",
"Cannot upload this file maximum upload size exceeded" => "Неможливо вивантажити файл: перевищений макс. розмір файла",
"Anonymous" => "Анонім",
"Newsletter subscription information at " => "Інформація про підписку на листок новин на  ",
"Cannot write to this file:" => "Неможливо запистувати в цей файл:",
"Home" => "Домівка",
"Blogs" => "Журнали",
"Blog" => "Журнал",
"previous page" => "попередня сторінка",
"next page" => "наступна сторінка",
"posted on" => "опубліковано в ",
"Articles" => "Статті",
"By:" => "Ким:",
"Read" => "Прочитані",
"List articles" => "Перелік статей",
"Forums" => "Форуми",
"Last post" => "Остання публікація",
"Invalid imagename (using filters for filenames)" => "Некоретна назва зображення (використовуються фільтри для назв файлів)",
"Errors detected" => "Трапилися помилки",
"Upload was not successful" => "Вивантаження успішне",
"No image yet, sorry." => "Ще немає зображення",
"unknown" => "невідомий",
"NONE" => "НІЧОГО",
"Wiki top pages" => "Популярні сторінки Вікі",
"Hits" => "Звернень",
"Most relevant pages" => "Найбільш відповідні сторінки",
"Relevance" => "Відповідність",
"Wiki last pages" => "Найновіші сторінки Вікі",
"Modified" => "Змінено",
"Forums last topics" => "Найновіші теми форумів",
"Topic date" => "Дата теми",
"Forums most read topics" => "Найчастіше читані теми форумів",
"Reads" => "Звернень",
"Forums best topics" => "Найкращі теми форумів",
"Score" => "Рахунок",
"Forums most visited forums" => "Найчастіше відвідувані форуми",
"Visits" => "Відвідувань",
"Forums with most posts" => "Форуми з найбільшою кількістю публікацій",
"Posts" => "Публікації",
"Wiki top galleries" => "Найкращі галереї Вікі",
"Wiki top file galleries" => "Найкращі файлові галереї Вікі",
"Wiki top images" => "Найкращі зображення Вікі",
"Wiki top files" => "Найпопулярніші файли Вікі",
"Downloads" => "Звантажень",
"Wiki last images" => "ц",
"Upload date" => "Дата вивантаження",
"Wiki last files" => "Найостанніші файли Вікі",
"Wiki top articles" => "Найпопулярніші статті Вікі",
"Most visited blogs" => "Найчастіше відвідувані журнали",
"Most active blogs" => "Найактивніші журнали",
"Blogs last posts" => "Останні публікації журналів",
"Post date" => "Дата публікації",
"Wiki top authors" => "Найпродуктивніші автори Вікі",
"Pages" => "Сторінок",
"Top article authors" => "Автори найпопулярніших статей",
"Login" => "Зареєструватись",
"Send message" => "Послати повідомлення",
"Attach file" => "Долучити файл",
"Image Gallery" => "Галерея зображень",
"Image" => "Зображення",
"Article" => "Стаття",
"Wiki" => "Вікі",
"Directory" => "Директорія",
"FAQ" => "ЧАП",
"Forum" => "Форум",
"File Gallery" => "Галерея файлів",
"Gallery" => "Галерея",
"File" => "Файл",
"Blog post" => "Публікація в журнал",
"help" => "підказка",
"from" => "від",
"for" => "для",
"Priority" => "Пріоритет",
"unlocked" => "відімкнено",
"Help" => "Підказка",
"You are banned from" => "Вам заборонено доступ до ",
"faqs" => "чап'ах",
"quizzes" => "контрольні",
"blogs" => "журналах",
"forums" => "форумах",
"games" => "ігри",
"picture not found" => "картинка не знайдена",
"drawing not found" => "креслення не знайдено",
"Click to edit dynamic variable" => "Клацніть, щоб редагувати динамічну змінну",
"Update variables" => "Поновити змінні",
"Created" => "Створено",
"new" => "нов",
"Unknown language" => "Невідома мова",
"Item" => "Пункт",
"Tracker was modified at " => "Тракер було змінено  ",
"text field" => "текстовий рядок",
"size" => "розмір",
"textarea" => "текстове поле",
"checkbox" => "кнопка",
"drop down" => "випадаюче меню",
"user selector" => "вибір користувача",
"group selector" => "вибір групи",
"date and time" => "дата й час",
"action" => "дія",
"category" => "категорія",
"email" => "пошта",
"open" => "відкрито",
"closed" => "закритий",
"message" => "повідомлення",
"child categories" => "дочірні категорії",
"objects in category" => "об'єкти в категорії",
"Date" => "Дата",
"Title" => "Заголовок",
"Author" => "Автор",
"Include a page" => "Включити сторінку",
"data" => "дані",
"one data per line" => "одне дане на рядок",
"Include an article" => "Включити статтю",
"comment" => "коментар",
"Displays the user Avatar" => "Показувати картинку користувача",
"username" => "ім'я користувача",
"List all pages which link to specific pages" => "Перелічити всі сторінки, які мають посилання на вказані сторінки",
"Page cannot be found" => "Сторінка не знайдена",
"Insert theme styled box on wiki page" => "Вставити стилізовану рамку на сторінці вікі",
"text" => "текст",
"Insert list of items for the current/given category into wiki page" => "Вставити список пунктів для даної/поточної категорії на сторінку вікі",
"Categories are disabled" => "Категорії заборонені",
"Display Tiki objects that have not been categorized" => "Показувати об'єкти Tiki, які не були поділені на категорії ",
"Insert the full category path for each category that this wiki page belongs to" => "Вставити повний маршрут до кожної категорії, до якої належить ця вікі",
"Centers the plugin content in the wiki page" => "Центрувати вміст модулів на сторінці вікі",
"Displays a snippet of code" => "Показує вирізки з коду",
"code" => "код",
"Insert copyright notices" => "Вставляти повідомлення про права розповсюдження",
"Example" => "Приклад",
"days" => "днів",
"hours" => "годин",
"minutes" => "хвилин",
"seconds" => "секунд",
"Creates a definition list" => "Створює список визначень",
"term" => "умови",
"definition" => "визначення",
"one definition per line" => "одне визначення на рядок",
"Displays the data using the TikiWiki odd/even table style" => "Показує дані з використанням стилів для парних/непарних рядків таблиць ТікіВікі",
"cells" => "комірки",
"heads and cells separated by ~|~" => "заголовки і комірки розділяються ~|~",
"Displays a graphical GAUGE" => "Показує графічний 'термометр'",
"description" => "опис",
"Feature disabled" => "Функція неактивована",
"Please choose a module" => "Виберіть модуль, будь-ласка",
"to be used as argument" => "для використання аргументом",
"Displays a module inlined in page" => "Показує модуль включений в сторінку",
"Sorry no such module" => "Немає такого модуля",
"Displays the data using a monospace font" => "Дані друкуються шрифтом фіксованої ширини",
"No version indicated" => "Не вказана версія",
"Automatically creates a link to the appropriate SourceForge object" => "Автоматично створює посилання на відповідний об'єкт на SourceForge",
"Sorts the plugin content in the wiki page" => "Сортування вмісту модуля на сторінці вікі",
"Missing db param" => "Відсутній параметр БД",
"Run a sql query" => "Виконати запит SQL",
"sql query" => "Запит SQL",
"Search the titles of all pages in this wiki" => "Шукати серед заголовків всіх статей на цій Вікі",
"No pages found for title search" => "Не знайдено сторінок з вказаними заголовками",
"One page found for title search" => "Знайдена одна сторінка відповідно до цього пошуку по заголовках",
" pages found for title search" => " сторінок знайдено відповідно до цього пошуку по заголовках",
"Save" => "Записати",
"at" => " о ",
"External Wiki" => "Зовнішній Вікі",
"valid" => "дійсні",
"You are not logged in" => "Ви не зареєструвались в системі",
"Permission denied" => "Немає дозволу",
"ERROR: Either the subject or body must be non-empty" => "ПОМИЛКА: Або тема, або текст повідомлення мають бути непорожніми",
"ERROR: No valid users to send the message" => "ПОМИЛКА: не вказано існуючих адресатів для відправки повідомлення",
"Invalid user" => "Невірне ім'я користувача",
"Message will be sent to: " => "Повідомлення буде надіслано: ",
"No more messages" => "Більше нема повідомлень ",
"edit" => "редагувати",
"Quick edit a Wiki page" => "Швидке редагування сторінки Вікі",
"Since your last visit" => "З часу Вашого останнього візиту",
"since" => "з",
"new comments" => "нові коментарі",
"wiki pages changed" => "змінені сторінки вікі",
"new images" => "нові зображення",
"new files" => "нові файли",
"new users" => "нові користувачі",
"no such file" => "немає такого файла",
"Error" => "Помилка",
"Invalid username or password" => "Невірне ім'я або пароль",
"List of attached files" => "Список долучених файлів",
"name" => "назва",
"desc" => "опис",
"uploaded" => "вивантажено",
"delete" => "стерти",
"Remove" => "Видалити",
"Upload file" => "Вивантажити файл",
"attach" => "долучити",
"debug" => "відладка",
"Fatal error" => "Критична помилка",
"Description:" => "Опис:",
"Created by" => "Створений ",
" on " => " в ",
"Last modified" => "Змінювалась",
"Post" => "Публікація",
"post" => "опублікувати",
"RSS feed" => "Потік RSS",
"Edit blog" => "Редагувати журнал",
"posts" => "публікацій",
"visits" => "відвідувані",
"Activity=" => "Активність=",
"show categories" => "показати категорії",
"hide categories" => "сховати категорії",
"categorize this object" => "категоризувати цей об'єкт",
"No categories defined" => "Немає визначених категорій",
"Admin categories" => "Адміністрування категорій",
"stars" => "зірочок",
"user level" => "рівень корист",
"private message" => "особисте повідомлення",
"send email to user" => "надіслати листа користувачені",
"user online" => "користувач активний",
"user offline" => "користувач не активний",
"on" => "вмикнути",
"score" => "рахунок",
"Vote" => "Голосувати",
"Edit" => "Редагувати",
"reply" => "відповісти",
"attachment" => "долучення",
"Moderator actions" => "Дії цензора",
"delete selected" => "видалити вибране",
"Move to topic:" => "Перейти до теми:",
"move" => "перемістити",
"queued:" => "в черзі:",
"Messages" => "Повідомлення",
"All" => "Всі",
"Style" => "Стиль",
"Sort" => "Впорядкувати",
"Newest first" => "Новіші напочатку",
"Oldest first" => "Старіші напочатку",
"Threshold" => "Поріг",
"Find" => "Знайти",
"set" => "встановити",
"Top" => "Найвище",
"Hide all" => "Сховати всі",
"replies" => "відповіді",
"prev" => "назад",
"Page" => "Сторінка",
"next" => "далі",
"new reply" => "нова відповіль",
"Editing comment" => "Редагування коментаря",
"Post new comment" => "Опублікувати новий коментар",
"Preview" => "Перегляд",
"preview" => "перегляд",
"cancel" => "скасувати",
"Required" => "Обов'язково",
"Rating" => "Популярність",
"Smileys" => "Хихоньки",
"Comment" => "Коментар",
"Posting comments" => "Публікування коментарів",
"Use" => "Використовувати",
"or" => "або",
"for links" => "для посилань",
"Go back" => "Назад",
"Return to home page" => "Повернутись на домашню сторінку",
"Copyrights" => "Права розмовсюдження",
"Year" => "Рік",
"Authors" => "Автори",
"up" => "вище",
"down" => "нижче",
"add" => "додати",
"Syntax" => "Синтаксис",
"Page generation debugging log" => "Журнал реєтрації помилок генерації сторінок",
"Features state" => "Стан можливостей",
"Total" => "Всього",
"features matched" => "відповідні можливості",
"Watchlist" => "Список нагляду",
"Hi {\$mail_user} has sent you this link:" => "Привіт, {\$mail_user} прислав(ла) посилання:",
"Blog post:" => "Публікація журналу:",
"at:" => "о:",
"Somebody or you tried to subscribe this email address at our site:" => "Хтось або Ви самі спробували підписати дану поштову адресу на нашому майданчику:",
"To the newsletter:" => "До листка новин:",
"In order to confirm your subscription you must access the following URL:" => "Для того, щоб підтвердити цю підписку, Вам потрібно зробити це за наступною адресою (URL):",
"A new message was posted to forum" => "Нове повідомлення подано в форум",
"Message" => "Повідомлення",
"Hi," => "Вітаю,",
"A new message was posted to you at {\$mail_machine}" => "Нове повідомлення для Вас було опубліковане на {\$mail_machine}",
"From" => "Від",
"Subject" => "Тема",
"Hi" => "Вітаємо",
"Enjoy the site!" => "Раді Вас вітати!",
"The user" => "Користувач",
"registered at your site" => "зареєстрований на Вашому майданчику",
"New user registration" => "Створення нового користувача",
"Bye bye!" => "На все добре",
"This email address has been removed to the list of subscriptors of:" => "Дана адреса ббула видалена зі списку підписки на:",
"Newsletter:" => "Листок новин:",
"You can unsubscribe from this newsletter following this link" => "Ви можете відписатись від цього листка новин за цим посиланням",
"Welcome to our newsletter!" => "Ласкаво просимо до нашого листка новин!",
"This email address has been added to the list of subscriptors of:" => "Дана поштова адреса додана до списку розсилки:",
"You can always cancel your subscription using:" => "Ви будь-якого часу можете скасувати свою підписку за допомогою:",
"Tiki email notification" => "Поштові сповіщення Тікі",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Нова стаття була надана {\$mail_user} до {\$mail_site} о {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Ви можете редагувати дане подання за наступною адресою:",
"Title:" => "Колонтитул:",
"Heading:" => "Заголовок:",
"Body:" => "Текст:",
"you or someone registered this email address at" => "Ви або хтось інший зареєстрував цю адресу в",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Якщо Ви бажаєте бути зареєстрованим користувачем, Вам потрібно скористуватись наступним посиланням при першому візиті:",
"Your Tiki information registration" => "Інформація про Вашу реєстрацію на Тікі",
"You will receive an email with information to login for the first time into this site" => "Ви отримаєте листа з інформацією про те, як зареєструватись (ввійти) на майднанчику вперше",
"If you don't want to receive these notifications follow this link:" => "Якщо Ви не хочете більше отримувати дані нагадування, скористайтесь наступним посиланням:",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Нова публікація журналу: {\$mail_title} від {\$mail_user} о {\$mail_date|tiki_short_datetime}",
"View the blog at:" => "Переглянути журнал за:",
"Name" => "Назва",
"File Description" => "Опис файлу",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Мапа {\$mail_page} була змінена {\$mail_user} в {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "Ви можете переглянути оновлену мапу, слідуючи за цим посиланням:",
"You can edit the map following this link:" => "Ви можете відредагувати мапу, слідуючи за цим посиланням:",
"Type" => "Тип",
"Size" => "Розмір",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Сторінка {\$mail_page} була змінена {\$mail_user} о {\$mail_date|tiki_short_datetime}",
"Comment:" => "Коментар:",
"The new page content follows below." => "Новий вміст сторінки йде далі.",
"New name" => "Нова назва",
"Thank you for you registration. You may log in now." => "Дякуємо за отримання доступу до майданчика. Тепер Ви можете зареєструватись.",
"click on the map to zoom or pan, do not drag" => "клацніть на мапі щоб збільшити, чи посунути її, не перетягуйте ",
"Scale" => "Масштаб",
"Redraw" => "Перемалювати",
"Comments" => "Коментарі",
"Last modification date" => "Дата останньої зміни",
"Overview" => "Огляд",
"Legend" => "Опис",
"Layer Manager" => "Менеджер рівнів",
"On" => "Вмик.",
"Label" => "Бирка",
"Download" => "Звантажити",
"Here are the files to download, do not forget to rename them:" => "Тут знаходяться файли для звантаження. Не забудьте змінити їх назви:",
"Mapfile" => "Файл мапи",
"Available mapfiles" => "Доступні файли мап",
"Actions" => "Дії",
"hits" => "перегл",
"monitor this map" => "слідкувати за цим файлом",
"stop monitoring this map" => "не слідкувати за цим файлом",
"No records found" => "Не знайдено записів",
"Create a new mapfile" => "Створити новий файл мапи",
"create" => "створити",
"Mapfile listing" => "Список файл мап",
"History" => "Історія",
"save" => "зберегти",
"You can view this map in your browser using" => "Ви можете переглянути цю мапу в переглядачі тенет",
"of" => "з",
"Version" => "Версія",
"compare" => "порівняння",
"current" => "поточний",
"Versions are identical" => "Версії ідентичні",
"User" => "Користувач",
"Action" => "Дія",
"view" => "перегляд",
"diff" => "різниці",
"Directories" => "Теки",
"Files" => "Файли",
"Upload From Disk:" => "Вивантажити з диску:",
"Upload Files" => "Вивантажити файли",
"Bytes maximum" => "Макс. байт",
"Create Directory:" => "Створити теку:",
"Create" => "Створити",
"Unread" => "Непрочитані",
"Flagged" => "Позначені",
"Unflagged" => "Без почначки",
"Containing" => "Що містять",
"filter" => "фільтр",
"sender" => "відправник",
"subject" => "тема",
"date" => "дата",
"flagged" => "позначено",
"No messages to display" => "Немає повідомлень для показу",
"Broadcast message" => "Передати повідомлення",
"Message Broadcast" => "Розсилка повідомлення",
"edit template" => "редагувати шаблон",
"Group" => "Група",
"All users" => "Всі користувачі",
"Lowest" => "Найнижчий",
"Low" => "Низький",
"Normal" => "Звичайний",
"High" => "Високий",
"Very High" => "Дуже високий",
"send" => "відіслати",
"Compose message" => "Скласти повідомлення",
"Compose Message" => "Нове повідомлення",
"To" => "До",
"CC" => "Копія",
"BCC" => "Скрита копія",
"Mark as read" => "Позначити як прочитані",
"Mark as unread" => "Позначити як непрочитане",
"Mark as flagged" => "Зняти прапорець",
"Mark as unflagged" => "Позначити прапорцем",
"mark" => "позначити",
"Mailbox" => "Поштова скриня",
"Compose" => "Створити",
"Broadcast" => "Передати",
"Read message" => "Прочитати повідомлення",
"Prev" => "Назад",
"Next" => "Далі",
"replyall" => "відповісти",
"Flag this message" => "Виставити прапорець для цього листа",
"Cc" => "Копія",
"no" => "ні",
"replied" => "відповів(ла)",
"Move module up" => "Посунути модуль вгору",
"Move module down" => "Посунути модуль донизу",
"Move module to opposite side" => "Пересунути модуль на протилежний бік",
"remove" => "забрати",
"Admin Menu" => "Адмініструвати меню",
"Live support" => "Підтримка живцем",
"Banning" => "Заборони",
"Users" => "Користувачі",
"Groups" => "Групи",
"Cache" => "Кеш",
"Modules" => "Модулі",
"Links" => "Посилання",
"Hotwords" => "Горячі слова",
"RSS modules" => "Модулі RSS",
"Menus" => "Меню",
"Polls" => "Опити",
"Backups" => "Резервні копії",
"Mail notifications" => "Поштові сповіщення",
"Search stats" => "Статистика пошуків",
"Chat" => "Балачки",
"Categories" => "Категорії",
"Banners" => "Гасла",
"Edit templates" => "Редагувати шаблони",
"Admin drawings" => "Адмініструвати діаграми",
"Dynamic content" => "Динамічний вміст",
"Cookies" => "Коржики",
"Mail-in" => "Вхідна пошта",
"Content templates" => "Шаблони вмісту",
"HTML pages" => "Сторінки HTML",
"Shoutbox" => "'Вголос'",
"External wikis" => "Зовнішні Вікі",
"Syntax highlighting" => "Підсвітка синтаксису",
"Menu" => "Меню",
"Contact us" => "Зв'яжіться з нами",
"Stats" => "Статистика",
"Games" => "Ігри",
"Calendar" => "Календар",
"MyMenu" => "МоєМеню",
"MyTiki" => "Мій Тікі",
"Preferences" => "Уподобання",
"Tasks" => "Задачі",
"Bookmarks" => "Закладки",
"Newsreader" => "Новини",
"Webmail" => "Веб-пошта",
"Notepad" => "Нотатник",
"My files" => "Мої файли",
"User menu" => "Меню користувача",
"Mini calendar" => "Мікі календар",
"My watches" => "За чим я слідкую",
"Workflow" => "Робочий потік",
"Admin processes" => "Адмініструвати процеси",
"Monitor processes" => "Монітор процесів",
"Monitor activities" => "Монітор активності",
"User processes" => "Процеси користувача",
"User activities" => "Активність користувача",
"WikiMenu" => "ВікіМеню",
"Last changes" => "Останні зміни",
"Rankings" => "По популярності",
"List pages" => "Перелічити сторінки",
"Orphan pages" => "Сторінки-сироти",
"Sandbox" => "Пісочниця",
"Print" => "Друк",
"Send pages" => "Відіслати сторінки",
"Received pages" => "Отримані сторінки",
"Structures" => "Структури",
"Image Galleries" => "Галереї зображень",
"Galleries" => "Галереї",
"Upload image" => "Вивантажити зображення",
"System gallery" => "Системна галерея",
"Articles home" => "Домашня сторінка статей",
"Submit article" => "Подати статтю",
"View submissions" => "Переглянути подання",
"Edit article" => "Редагувати статтю",
"Send articles" => "Надіслати статті",
"Received articles" => "Отримані статті",
"Admin topics" => "Адміністрування темs",
"List blogs" => "Список журналів",
"Create/Edit blog" => "Журнал: новий/змінити",
"Admin posts" => "Редагувати публікації",
"List forums" => "Список форумів",
"Admin forums" => "Редагувати форуми",
"Submit a new link" => "Подати нове посилання",
"Browse directory" => "Переглянути теку",
"Admin directory" => "Адмініструвати каталог",
"File Galleries" => "Галереї файлів",
"List galleries" => "Список галерей",
"FAQs" => "ЧАПи",
"List FAQs" => "Список ЧАПів",
"Admin FAQs" => "Адмініструвати ЧАПи",
"Layer management" => "Керуванння рівнями",
"Quizzes" => "Вікторини",
"List quizzes" => "Перелічити опити",
"Quiz stats" => "Статистика контрольних",
"Admin quiz" => "Адмініструвати контрольні",
"Surveys" => "Опити",
"List surveys" => "Список опитів",
"Admin surveys" => "Адмін. опити",
"Newsletters" => "Випуски новин",
"Send newsletters" => "Надіслати листки новин",
"Admin newsletters" => "Адмініструвати листки новин",
"Charts" => "Графіки",
"Admin" => "Адмін",
"Debugger console" => "Консоль відладки",
"Theme control" => "Керування темами",
"Drawings" => "Графіка",
"Edit languages" => "Редагувати мови",
"Click here to manage your personal menu" => "Натисніть тут для установок свого персонального меню",
"User Menu" => "Меню користувача",
"Recently visited pages" => "Недавно відвідувані сторінки",
"Monday" => "Понеділок",
"Tuesday" => "Вівторок",
"Wednesday" => "Середа",
"Thursday" => "Четвер",
"Friday" => "П'ятниця",
"Saturday" => "Субота",
"Sunday" => "Неділя",
"Filter" => "Фільтр",
"Today" => "Сьогодні",
"top" => "вершина",
"Received objects" => "Отримані об'єкти",
"Pages:" => "Сторінки:",
"Last Sites" => "Останні майданчики",
"Directory Stats" => "Статистика каталогу",
"Sites" => "Майданчики",
"Sites to validate" => "Майданчики для перевірки",
"Searches" => "Пошуків",
"Visited links" => "Відвідані посилання",
"Top Sites" => "Найпопулярніші майданчики",
"Featured links" => "Цікаві посилання",
"Top topics" => "Найпопулярніші теми",
"Last forum topics" => "Найновіші теми форуму",
"Most commented forums" => "Форуми з найбільшою кількістю коментарів",
"Most read topics" => "Найбільш читані теми",
"Most visited forums" => "Найбільш відвідувані форуми",
"Google Search" => "Пошуків на Google",
"Last articles" => "Нові статті",
"Last blog posts" => "Останні публікації журналів",
"Last" => "Останні",
"Last Created blogs" => "Журнали, створені останніми",
"Last Created FAQs" => "ЧАПи, створені останніми",
"Last Created Quizzes" => "Контрольні, створені останніми",
"Last modified file galleries" => "Галереї, що змінювались останніми",
"Last Files" => "Останні файли",
"Last galleries" => "Останні галереї",
"Last Modified Items" => "Пункти, що змінювались останніми",
"Last Modified blogs" => "Журнали, що змінювались останніми",
"Last submissions" => "Останні подання",
"Last Items" => "Останні пункти",
"Open operator console" => "Відкртити консоль оператора",
"Online users" => "Активні користувачі",
"We have" => "Ми маємо",
"online users" => "активних користувачів",
"logged as" => "зареєстрований(а) як",
"Logout" => "Вийти",
"user" => "користувач",
"Remember me" => "Пам'ятати мене",
"register" => "зареєструвати",
"I forgot my pass" => "Я забув мій пароль",
"standard" => "звичайний",
"secure" => "безпечний",
"stay in ssl mode" => "залишатися в режимі ssl",
"Tiki Logo" => "Логотип Тікі",
"You have" => "Ви маєте",
"new messages" => "нові повідомлення",
"new message" => "нове повідомлення",
"You have 0 new messages" => "Ви маєте 0 новий повідомлень",
"Waiting Submissions" => "Очікування подань",
"submissions waiting to be examined" => "Подання, що мають бути перевіреними",
"Old articles" => "Старі статті",
"Send a message to" => "Послати повідомлення до",
"Random Pages" => "Довільні сторінки",
"Register as a new user" => "Зареєструвати як нового користувача",
"Your email could not be validated; make sure you email is correct and click register below." => "Адресу Вашої електронної пошти неможливо перевірити. Будь ласка, переконайтесь, що її вказано вірно натисніть на посилання реєстрації нижче.",
"Your registration code:" => "Ваш реєстраційний код:",
"Random Image" => "Випадкове зображення",
"Username" => "Ім'я користувача",
"Passcode to register (not your user password)" => "Пароль для реєстрації (не пароль користувача)",
"Registration code" => "Реєстраційний код",
"Password" => "Пароль",
"Repeat password" => "Пароль ще раз",
"Email" => "Ел. пошта",
"Generate a password" => "Сгенерувати пароль",
"Search" => "Пошук",
"in:" => "в:",
"Entire Site" => "Весь майданчик",
"Wiki Pages" => "Сторінки Вікі",
"Image Gals" => "Галереї зображень",
"Images" => "Зображення",
"Blog Posts" => "Публікації журналів",
"go" => "вперед",
"Search Wiki PageName" => "Шукати НазвуСторінки Вікі",
"Read More" => "Читати далі",
"Since your last visit on" => "З того часу, як Ви відвідали о ",
"click to edit" => "клацність щоб змінити",
"Language" => "Мова",
"Most Active blogs" => "Найбільш активні журнали",
"Top articles" => "Найпопулярніші статті",
"Top File Galleries" => "Найпопулярніші галереї файлів",
"Top games" => "Найпопулярніші ігри",
"Top galleries" => "Найпопулярніші галереї",
"Top Images" => "Найпопулярніші зображення",
"Top Pages" => "Напопулярніші сторінки",
"Top Quizzes" => "Найпопулярніші контрольні",
"Top Visited FAQs" => "Найбільш відвідувані ЧАПи",
"My blogs" => "Мої журннали",
"cache" => "кеш",
"My galleries" => "Мої галереї",
"My Pages" => "Мої сторінки",
"User tasks" => "Завдання користувача",
"done" => "готово",
"del" => "видалити",
"online user" => "активний користувач",
"vote" => "голосувати",
"Sent editions" => "Розіслані відання",
"find" => "шукати",
"users" => "користувачі",
"sent" => "розіслано",
"use" => "викор",
"secs" => "сек",
"cached" => "кешовано",
"print" => "друк",
"create pdf" => "створити pdf",
"Save to notepad" => "Записати в нотатник",
"monitor this page" => "слідкувати за цією сторінкою",
"stop monitoring this page" => "припинити слідкування за цією сторінкою",
"backlinks" => "зворотні посилання",
"Previous page" => "Попередня стор",
"Next page" => "Наступна стор",
"First page" => "Перша стор",
"page" => "стор.",
"Last page" => "Остання стор",
"last modification" => "останні зміни",
"To edit the copyright notices" => "Щоб редагувати запис авторських прав",
"click here" => "натисніть тут",
"The content on this page is licensed under the terms of the" => "Вміст цієї сторінки підлягає ліцензуванню на умовах ",
"The original document is available at" => "Оригінал документу знаходиться на",
"rename" => "змінити назву",
"unlock" => "відімкнути",
"lock" => "замкнути",
"perms" => "дозволи",
"history" => "історія",
"similar" => "подібно",
"undo" => "відкат",
"slides" => "слайди",
"export" => "експорт",
"discuss" => "обговорити",
"add comment" => "додати коментар",
"1 comment" => "1 коментар",
"comments" => "коментарі",
"attach file" => "долучити файл",
"1 file attached" => "1 файл долучено",
"{\$atts_cnt} files attached" => "{\$atts_cnt} файлів долучено",
"Page generated in" => "Сторінка згенерована за",
"The newsletter was sent to {\$sent} email addresses" => "Листок новин надіслано за {\$sent} поштовими адресами",
"This newsletter will be sent to {\$subscribers} email addresses." => "Цей листок новин буде надіслано за {\$subscribers} поштовими адресами.",
"Prepare a newsletter to be sent" => "Підготувати листок новин для відправки",
"Newsletter" => "Листок новин",
"Apply template" => "Вживати шаблон",
"none" => "ніякого",
"Data" => "Дані",
"Send Newsletters" => "Надіслати листки",
"This is" => "Це",
"by the" => "за",
"Tiki community" => "Громада Tiki",
"Last Changes" => "Останні зміни",
"attachments" => "долучення",
"User files" => "Файли користувача",
"Favorites" => "Улюблені",
"home" => "домашня",
"chat" => "балачки",
"contact us" => "зверніться до нас",
"stats" => "статистика",
"categories" => "категорії",
"last changes" => "останні зміни",
"rankings" => "популярність",
"list pages" => "список сторінок",
"orphan pages" => "сторінки-сироти",
"sandbox" => "пісочниця",
"received pages" => "отримані сторінки",
"structures" => "структури",
"Articles Home" => "Домашня сторінка статей",
"Create/Edit Blog" => "Створити/редагувати журнал",
"Browse Directory" => "Переглянути каталог",
"List Quizzes" => "Список контрольних",
"List Surveys" => "Список опитувань",
"Prefs" => "Установки",
"MyFiles" => "Мої файли",
"back to homepage" => "повернутись до домашньої сторінки",
"This page is being edited by" => "Ця сторінка редагуєтся",
"Proceed at your own peril" => "Продовжуйте на свій власний розсуд",
"Description" => "Опис",
"My Footnotes" => "Примітки",
"Copyright" => "Авторські права",
"Year:" => "Рік:",
"Authors:" => "Автори:",
"Allow HTML" => "Дозволити HTML",
"Spellcheck" => "Перевірка правопису",
"Import page" => "Імпортувати сторінку",
"export all versions" => "експортувати всі версії",
"Upload picture" => "Вивантажити малюнок",
"no cache" => "без кешу",
"minute" => "хвилина",
"hour" => "година",
"License" => "Ліцензія",
"Important" => "Важливо",
"Minor" => "Незначне",
"cancel edit" => "скасувати редагування",
"No attachments for this page" => "Немає долучень до цієї сторінки",
"My Tiki" => "Мій Tiki",
"User Pages" => "Сторінки користувача",
"List pages where I am a creator" => "Перелічити сторіки, розробником яких є я",
"by creator" => "по розробнику",
"List pages where I am a modificator" => "Перелічити сторіки, які я змінив",
"by modificator" => "по редактору",
"User Galleries" => "Галереї користувача",
"Assigned items" => "Призначені пункти",
"Unread Messages" => "Непрочитані повідомлення",
"User Blogs" => "Журнали користувача",
"left/right" => "ліворуч/праворуч",
"Unassign module" => "Зняти призначення з модуля",
"debugger console" => "консоль відладки",
"Mini Calendar" => "Невеличкий календар",
"Edit mapfiles" => "Редагувати файли мап",
"switch" => "зміна",
"on:" => "о:",
"reads" => "читань",
"Article image" => "Зображення до статті",
"Topic image" => "Графіка для теми",
"Refresh" => "Поновити",
"Find:" => "Знайти:",
"Sort posts by:" => "Упорядкувати за:",
"posted by" => "опубліковано",
"read more" => "читати далі",
"pages" => "сторінок",
"Permalink" => "Пермалінк",
"referenced by" => "посилання з",
"references" => "посилання",
"view comments" => "дивитись коментарі",
"email this post" => "послати поштою",
"Viewing blog post" => "Перегляд публікації журналу",
"Return to blog" => "Повернутись в журнал",
"Blog name" => "Назва журналу",
"User Bookmarks" => "Закладки користувачів",
"wiki help" => "поміч вікі",
"Features" => "Можливості",
"General" => "Загальне",
"Home Blog" => "Домашній журнал",
"Home Blog (main blog)" => "Домашній журнал (головний журнал)",
"ok" => "гаразд",
"Blog features" => "Можливості журнала",
"Blog level comments" => "Коментарі до журналу",
"Post level comments" => "Коментарі до повідомлень",
"Spellchecking" => "Правопис",
"Default ordering for blog listing" => "Стандартне сортування для списків журналів",
"Creation date (desc)" => "Дата створення (спад)",
"Last modification date (desc)" => "Остання дата зміни (спад)",
"Blog title (asc)" => "Заголовок (зрост)",
"Number of posts (desc)" => "Кількість публікацій (спад)",
"Visits (desc)" => "Відвідувань (спад)",
"Activity (desc)" => "Активність (спад)",
"Change preferences" => "Змінити установки",
"Blog listing configuration (when listing available blogs)" => "Конфігурування переліку персональних журналів (при показі активних журналів)",
"Disabled" => "Заборонено",
"Plain text" => "Звичайний текст",
"Link to user information" => "Посилання на інформацію про користувача",
"User avatar" => "Картинка користувача",
"Blog comments settings" => "Установки для коментарів до журналів",
"Default number of comments per page" => "Стандартна кількість коментарів на сторінці",
"Comments default ordering" => "Стандарте сортування коментарів по",
"Points" => "Балів",
"CMS features" => "Можливості CMS ",
"Submissions" => "Подання",
"Use templates" => "Вживати шаблони",
"Maximum number of articles in home" => "Максимальна кількість статей в домашньому каталозі",
"Article comments settings" => "Установки коментарів до статей",
"Topic" => "Тема",
"Img" => "Зображення",
"Country" => "Країна",
"Last login" => "Останній раз реєструвався",
"Set features" => "Встановити можливості",
"Number of columns per page when listing categories" => "Кількість стовпчиків на сторінці в переліку категорій",
"Links per page" => "Посилань на сторінці",
"Validate URLs" => "Перевіряти URLи",
"Method to open directory links" => "Як відкривати посилання з каталогу",
"replace current window" => "заміняти поточне вікно",
"new window" => "нове вікно",
"inline frame" => "в рамці цього вікна",
"Tiki sections and features" => "Розділи Тікі і можливості",
"Workflow engine" => "Рушій керування робочим потоком",
"Live Support" => "Супровід",
"Live support system" => "Система активного супроводу",
"Help System" => "Система помочі",
"Show Category Path" => "Показувати маршрут категорії",
"Show Babelfish Translation URLs" => "Показувати URL'и для перекладу Babelfish ",
"Show Category Objects" => "Показувати об'єкти категорій",
"Show Babelfish Translation Logo" => "Показувати логотип перекладу Babelfish",
"Show Module Controls" => "Показувати засоби керування модулями",
"Tiki Calendar" => "Календар Tiki",
"Content Features" => "Можливості керування змістом",
"Edit Templates" => "Редагувати шаблони",
"Hotwords in New Windows" => "Горячі Слова в новому вікні",
"Edit CSS" => "Редагування CSS",
"Custom Home" => "Власна домашня сторінка",
"HTML Pages" => "Сторінки HTML ",
"Dynamic Content System" => "Система динамічного наповнення",
"Allow Smileys" => "Дозволити хихоньки",
"AutoLinks" => "АвтоПосилання",
"Administration Features" => "Можливості адміністрування",
"Banning System" => "Система заборон",
"Banning system" => "Система заборон",
"Debugger Console" => "Консоль відладки",
"Communications (send/receive objects)" => "Комунікація (відсилсння/отримання об'єктів)",
"Theme Control" => "Керування темами",
"Contact Us" => "Зверніться до нас",
"User Features" => "Можливості надані користувачам",
"User Preferences Screen" => "Екран установок користувача",
"Users can Configure Modules" => "Користувачі можуть конфіґурувати модулі",
"User Watches" => "Нагляд за користувачами",
"User Tasks" => "Завдання користувача",
"User Messages" => "Повідомлення користувача",
"User Files" => "Файли користувача",
"User Notepad" => "Записник користувача",
"General Layout options" => "Загальні опції для вигляду",
"Left column" => "Лівий стовпчик",
"Layout per section" => "Вигляд залежить від розділу",
"Right column" => "Правий стовпчик",
"Admin layout per section" => "Адміністрування вигляду по розділам",
"Top bar" => "Горішня секція",
"Bottom bar" => "Нижня секція",
"Home Gallery (main gallery)" => "Домашня (головна) галерея",
"Galleries features" => "Властивості галерей",
"Use database to store files" => "Користуватися базою для зберігання файлів",
"Use a directory to store files" => "Зберігати файли в каталогах",
"Directory path" => "Маршрут до каталогу",
"please read" => "прочитайте, будь ласка",
"Gallery listing configuration" => "Конфігурація показу списку галереї",
"File galleries comments settings" => "Установки коментарів галереї файлів",
"Home Forum (main forum)" => "Домашній (головний) форум",
"Accept wiki syntax" => "Сприймати синтаксис Вікі",
"Forum quick jumps" => "Швидкі переходи по форуму",
"Ordering for forums in the forum listing" => "Порядок показу форумів у списку форумів",
"Creation Date (desc)" => "Дата створення (спад)",
"Topics (desc)" => "Теми (спад)",
"Threads (desc)" => "Низки (спад)",
"Last post (desc)" => "Остання публ. (спад)",
"Name (desc)" => "Ім'я (спад)",
"Name (asc)" => "Ім'я (зрост)",
"Forum listing configuration" => "Конфіґурація списку форумів",
"Topics" => "Теми",
"Posts per day" => "Публікацій на день",
"Use database to store images" => "Зберігати зображення в базі",
"Use a directory to store images" => "Зберігати зображення в файловій системі",
"Library to use for processing images" => "Бібліотека для обробки зображень",
"Uploaded image names must match regex" => "Назви файлів вивантажених зображень повинні відповідати рег. виразу",
"Uploaded image names cannot match regex" => "Назви файлів вивантажених зображень не повинні відповідати рег. виразу",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Видаляти зображення в системній галереї якщо вони не використовуються в сторінках Вікі, статтях чи журнальних записах",
"All galleries" => "Всі галереї",
"images" => "зображеннях",
"Image galleries comments settings" => "Установки коментарів для галерей зображень",
"General Preferences" => "Загальні установки",
"Theme" => "Тема",
"Slideshows theme" => "Тема для показу слайдів",
"Use group homepages" => "Користуватись домашніми сторінками для груп",
"Use URI as Home Page" => "Для домашньої сторінки використовувати URI",
"Home page" => "Домашня сторінка",
"Custom home" => "Власна домашня сторінка",
"Use database for translation" => "Для перекладів користуватися базою даних",
"Record untranslated" => "Записувати неперекладене",
"OS" => "ОС",
"Unix" => "Юнікс",
"Windows" => "Віндовс",
"Unknown/Other" => "Невідома/інша",
"General Settings" => "Загальні установки",
"Disallow access to the site (except for those with permission)" => "Заборонити доступ до майданчику (за виключенням тих, хто отримав дозвіл)",
"Message to display when site is closed" => "Повідомлення, яке показується, коли майданчик закрито",
"Disallow access when load is above the threshold (except for those with permission)" => "Заборонити доступ до майданчику, коли навантаження більше за норму (за виключенням тих, хто отримав дозвіл)",
"Max average server load threshold in the last minute" => "Макс навантаження сервера в останню хвилину",
"Message to display when server is too busy" => "Повідомлення при надто завантаженому сервері",
"Open external links in new window" => "Відкривати зовнішні посилання в новому вікні",
"Display modules to all groups always" => "Показувати модулі для всіх груп завжди",
"Use cache for external pages" => "Для зовнішніх сторінок користуватися кешем",
"Use cache for external images" => "Для зовнішніх графічних зображень користуватися кешем",
"Display menus as folders" => "Показувати меню у вигляді тек",
"Tikiwiki.org help" => "Поміч Tikiwiki.org ",
"Use gzipped output" => "Використовувати gzip для вивод",
"Count admin pageviews" => "Рахувати перегляди сторінок адміністратором",
"Server name (for absolute URIs)" => "Назва сервера (для абсолютних URI)",
"No" => "Ні",
"Yes" => "Так",
"Browser title" => "Заголовок у переглядачі тенет",
"Temporary directory" => "Тимчасова тека",
"Sender Email" => "Електонна пошта відправника",
"Contact user" => "Користувач для контактів",
"contact feature disabled" => "можливість контакту заборонена",
"Store session data in database" => "Зберігати дані сесій в базі даних",
"Session lifetime in minutes" => "Протяжність сесії в хвилинах",
"Use proxy" => "Вживати проксі",
"Proxy Host" => "Хост проксі",
"Proxy port" => "Порт проксі",
"Maximum number of records in listings" => "Максимальне число записів у списках",
"Date and Time Formats" => "Формат дати та часу",
"Long date format" => "Довгий формат дати",
"Short date format" => "Короткий формат дати",
"Long time format" => "Довгий формат часу",
"Short time format" => "Короткий формат часу",
"Date and Time Format Help" => "Поміч з форматів дати та часу",
"Change admin password" => "Змінити пароль адміністратора",
"New password" => "Новий пароль",
"Change password" => "Змінити пароль",
"Reg users can change language" => "Зареєстровані користувачі можуть змінювати мову",
"Edit or ex/import Languages" => "Редагувати ім/експортувати мови",
"port" => "порт",
"path" => "маршрут",
"groups" => "групи",
"Contact" => "Контакт",
"Admin groups" => "Адмініструвати групи",
"Admin users" => "Адмін. користувачів",
"User registration and login" => "Реєстрація і вхід в систему",
"Authentication method" => "Метод автентикації",
"Just Tiki" => "Просто Тікі",
"Web Server" => "Веб сервер",
"Tiki and PEAR::Auth" => "Тікі і PEAR::Auth",
"Tiki and HTTP Auth" => "Тікі і HTTP Auth",
"Use WebServer authentication for Tiki" => "Використовувати автентикацію веб-серввера для Тікі",
"Users can register" => "Користувачі можуть реєструватись",
"Create a group for each user <br />(with the same\nname as the user)" => "Створювати групу для кожного користувача<br />(з такою ж назвою\nяк і ім'я користувача)",
"Request passcode to register" => "Запитувати пароль для реєстрації",
"Prevent automatic/robot registration" => "Запобігає автоматичній робот-реєстрації",
"Validate users by email" => "Перевіряти користувачів поштою",
"Store plaintext passwords" => "Зберігати паролі у відкритій формі",
"Reg users can change theme" => "Зареєстровані користувачі можуть змінювати тему",
"Force to use chars and nums in passwords" => "Примусити використовувати літери і цифри в паролях",
"Minimum password length" => "Мінімальна довжина пароля",
"Password invalid after days" => "Пароль недійсний після днів",
"Require HTTP Basic authentication" => "Вимагає автентикацію HTTP Basic",
"Allow secure (https) login" => "Дозволити безпечний (https) вхід у систему",
"Require secure (https) login" => "Вимагати безпечний (https) вхід у систему",
"HTTP server name" => "Назва сервера HTTP",
"HTTP port" => "Порт HTTP",
"HTTP URL prefix" => "Префікс HTTP URL",
"HTTPS server name" => "Назва сервера HTTPS",
"HTTPS port" => "Порт HTTPS",
"HTTPS URL prefix" => "Префікс HTTPS URL",
"Remember me feature" => "Запам'ятовувати мої можливості",
"Only for users" => "Тільки для користувачів",
"Users and admins" => "Користувачі і адміни",
"Duration:" => "На протязі:",
"day" => "день",
"week" => "тижд",
"month" => "місяць",
"Create user if not in Tiki?" => "Створювати користувача, якщо не в Тікі?",
"Create user if not in Auth?" => "Створювати користувача, якщо не в Auth?",
"Just use Tiki auth for admin?" => "Використовувати тільки Tiki auth для адміністраторів?",
"LDAP User Attribute" => "Атрибут User LDAP",
"full path to mapfiles" => "повна доріжка до файлів мап",
"default mapfile" => "стандартна мапа",
"Wiki Page for Help" => "Сторінка Вікі для помочі",
"Wiki Page for Comments" => "Сторінка Вікі для коментарів",
"<b>Feed</b>" => "<b>Потік</b>",
"<b>enable/disable</b>" => "<b>дозволити/заборонити</b>",
"<b>Max number of items</b>" => "<b>Максимальна кількість пунктів</b>",
"Feed for Articles" => "Потік для статей",
"Feed for Weblogs" => "Потік для журналів",
"Feed for Image Galleries" => "Потік для галерей зображень",
"Feed for File Galleries" => "Потік для галерей файлів",
"Feed for the Wiki" => "Потік для Вікі",
"Feed for individual Image Galleries" => "Потоки для окремих галерей зображень",
"Feed for individual File Galleries" => "Потоки для окремих галерей файлів",
"Feed for individual weblogs" => "Потоки для окремих журналів ",
"Feed for forums" => "Потоки для форумів",
"Feed for individual forums" => "Потоки для  окремих форумів",
"Full Text Search" => "Повно текстовий пошук",
"SearchStats" => "Шукати в статистиках",
"Content" => "Зміст",
"Publish" => "Опублікувати",
"Path" => "Маршрут",
"change" => "змінити",
"Quota (Mb)" => "Квота (Mb)",
"Use database to store userfiles" => "Зберігати файли користувачів у базі",
"Use a directory to store userfiles" => "Зберігати файли користувачів у файловій системі",
"Allow viewing HTML mails?" => "Дозволити перегляд пошти в HTML?",
"Maximum size for each attachment" => "Максимальний розмір поштового долучення",
"restore" => "відновити",
"Export Wiki Pages" => "Експортувати сторінки Вікі",
"Export" => "Експорт",
"Remove unused pictures" => "Стерти зображення, які не використовуються",
"Wiki Home Page" => "Домашня сторінка Вікі",
"Wiki Discussion" => "Дискусії Вікі",
"Discuss pages on forums" => "Обговорювати сторінки на форумах",
"complete" => "завершити",
"Creator" => "Створив",
"Last version" => "Остання версія",
"Status" => "Статус",
"Versions" => "Версії",
"Backlinks" => "Зворотні зв'язки",
"full" => "повні",
"Wiki Features" => "Можливості Вікі",
"Undo" => "Відкат",
"PDF generation" => "Створення PDF",
"mins" => "хв",
"Pictures" => "Графіка",
"Use page description" => "Користуватися описами сторінок",
"Show page title" => "Показувати заголовки сторінок",
"Cache wiki pages (global)" => "Кешувати сторінки Вікі (глобально)",
"Individual cache" => "Індивідуальний кеш",
"Users can lock pages (if perm)" => "Користувачі можуть замикати сторінки (якщо дозволено)",
"Use WikiWords" => "Вживати WikiWords",
"Link plural WikiWords to their singular forms" => "Встановлювати посилання від WikiWords в множині на їхні форми в однині",
"Automonospaced text" => "Авто моноширний текст",
"Tables syntax" => "Синтаксис таблиць",
"|| for rows" => "|| для рядків",
"\\n for rows" => "\\n для рядків",
"Page creators are admin of their pages" => "Створювачі сторінок є їх адміністраторам",
"Wiki History" => "Історія Wiki",
"Maximum number of versions for history" => "Максимальна кількість версій в історії",
"Never delete versions younger than days" => "Ніколи не стирати версії молодші за днів",
"Copyright Management" => "Менеджмент прав копіювання",
"Enable Feature" => "Дозволити можливість",
"License Page" => "Сторінка ліцензії",
"Submit Notice" => "Подати сповіщення",
"Enable watches on comments" => "Дозволити слідкування за коментарями",
"Wiki attachments" => "Долучення до Вікі",
"View tpl" => "Переглянути шаблон",
"admin banning tpl" => "шабл. заборон адмін.",
"Add or edit a rule" => "Додати чи редагувати правило",
"Rule title" => "Заголовок правила",
"Username regex matching" => "Імені користувача за регулярним виразом",
"IP regex matching" => "IP за регулярним виразом",
"Banned from sections" => "Заборонені в розділах",
"check / uncheck all" => "позначити/зняти позн. з усіх",
"Rule activated by dates" => "Правило активізується за датами",
"Rule active from" => "Правило вступає в дію з",
"Rule active until" => "Правило діє до",
"Custom message to the user" => "Власне повідомлення користувачеві",
"Rules" => "Правила",
"User/IP" => "Користувач/IP",
"Sections" => "Розділи",
"Admin Calendars" => "Адмініструвати календарі",
"List of Calendars" => "Список календарів",
"loc" => "розм",
"cat" => "катег",
"lang" => "мова",
"prio" => "пріо",
"permissions" => "дозволи",
"Create/edit Calendars" => "Створити/редагувати календарі",
"Custom Locations" => "Власні розміщення",
"yes" => "так",
"Custom Categories" => "Власні категорії",
"Custom Languages" => "Власні мови",
"Custom Priorities" => "Власні пріоритери",
"admin categories" => "категорії адмін.",
"admin categories tpl" => "шабл. категорій адмін.",
"Current category" => "Поточна категорія",
"Child categories" => "Дочірні категорії",
"Edit this category:" => "Редагувати цю категорію:",
"create new" => "створити нову",
"Add new category" => "Додати нову категорію",
"Parent" => "Батьківська",
"Objects in category" => "Об'єкти цієї категорії",
"type" => "тип",
"Add objects to category" => "Додати об'єкти до категорії",
"image gal" => "гал зобр",
"file gal" => "гал файлів",
"Admin chart items" => "Адмініструвати пункти діаграм",
"charts" => "діаграми",
"edit chart" => "ред діагр",
"Add or edit an item" => "Додати чи редагувати пункт",
"update" => "поновити",
"Chart items" => "Діаграма пунктів",
"No items defined yet" => "Ще не визначені пункти",
"Admin charts" => "Адміністрування діаграм",
"Add or edit a chart" => "Додати чи адмін діаграму",
"Active" => "Активні",
"Users can suggest new items" => "Користувачі можуть пропонувати нові пункти",
"Auto validate user suggestions" => "Автоматично перевіряти пропозиції користувачів",
"Ranking shows" => "Покази популярності",
"All items" => "Всі пункти",
"Top 10 items" => "10 найпопулярніших",
"Top 20 items" => "20 найпопулярніших",
"Top 40 items" => "40 найпопулярніших",
"Top 50 items" => "50 найпопулярніших",
"Top 100 items" => "100 найпопулярніших",
"Top 250 items" => "250 найпопулярніших",
"Voting system" => "Система голосування",
"Vote items" => "Пункти голосування",
"Rank 1..5" => "Популярність 1..5",
"Rank 1..10" => "Популярність 1..10",
"Ranking frequency" => "Частота популярності",
"Realtime" => "В живому часі",
"Each 5 minutes" => "Кожні 5хв",
"Daily" => "Щоденно",
"Weekly" => "Щотижня",
"Monthly" => "Щомісяця",
"Show Average" => "Показувати середне",
"Show Votes" => "Показувати голосуShow vOTEs",
"Use Cookies for unregistered users" => "Для зареєстрованих користувачів користуватися коржиками",
"Users can vote again after" => "Користувачі можуть знову приймати участь в голосуваннях після",
"Anytime" => "Будь-коли",
"5 minutes" => "5 хвилин",
"1 day" => "1 день",
"1 week" => "1 тиждень",
"1 month" => "1 місяць",
"Items" => "Пункти",
"Ranks" => "Популярність",
"No charts defined yet" => "Ще не визначено діаграм",
"Chat Administration" => "Адміністрація балачок",
"Create/edit channel" => "Створити/редагувати канал",
"Refresh rate" => "Частота поновлення",
"second" => "секунда",
"Chat channels" => "Канали балачок",
"active" => "активні",
"Admin templates" => "Адміністрація шаблонів",
"admin content templates" => "шаблони адм. наповнення",
"Edit this template:" => "Редагувати цей шаблон:",
"Create new template" => "Створити новий шаблон",
"use in cms" => "вживати в cms",
"use in wiki" => "вживати в вікі",
"use in newsletters" => "вживати в листках новин",
"use in HTML pages" => "вживати в сторінках HTML",
"template" => "шаблон",
"Templates" => "Шаблони",
"last modif" => "ост зміни",
"sections" => "розділи",
"Admin cookies" => "Адмінстрування коржиків",
"Create/edit cookies" => "Створити/редагувати коржики",
"Cookie" => "Коржики",
"Upload Cookies from textfile" => "Завантажити коржики з текст.файлу",
"Upload from disk:" => "Завантажити з диску:",
"upload" => "завантажити",
"Remove all cookies" => "Видалитк всі коржики",
"cookie" => "коржик",
"admin Drawings tpl" => "Адмініструвати шаблони графічного редактора",
"Available drawings" => "Існуючі діаграми",
"Ver" => "Вер",
"Admin external wikis" => "Адміністувати зовнішні вікі",
"Create/Edit External Wiki" => "Створити/редагувати зовнішній Вікі",
"extwiki" => "зовнвікі",
"Admin Forums" => "Адмініструвати форуми",
"Edit this Forum:" => "Редагувати цей форум:",
"Create New Forum" => "Створити новий форум",
"There are individual permissions set for this forum" => "Для цього форуму встановлені індивідуальні дозволи",
"Show description" => "Показати опис",
"Prevent flooding" => "Запобігати \"затопленню\"",
"Minimum time between posts" => "Мінімальний час між повідомленнями",
"min" => "хв",
"Topics per page" => "Тем на сторінку",
"Section" => "Розділ",
"Create new" => "Створити новий",
"Moderator user" => "Модератор",
"Moderator group" => "Група модераторів",
"Password protected" => "Захищено паролем",
"Topics only" => "Тільки теми",
"All posts" => "Всі публікації",
"Forum password" => "Пароль форума",
"Default ordering for topics" => "Стандартне сортування тем",
"Date (desc)" => "Дата (спад)",
"Date (asc)" => "Дата (зрост)",
"Score (desc)" => "Бали  (спад)",
"Replies (desc)" => "Відповіді (спад)",
"Reads (desc)" => "Проглядів (спад)",
"Title (desc)" => "Заголовок (спад)",
"Title (asc)" => "Заголовок (зрост)",
"Default ordering for threads" => "Стандартне сортування низок",
"Send this forums posts to this email" => "Надсилати публікації цього форуму на дану адресу",
"Prune unreplied messages after" => "Стирати повідомлення, на які не було відповіді після",
"Prune old messages after" => "Стирати старі повідомлення після",
"Topic list configuration" => "Конфігурація списку тем",
"Display last post titles" => "Показати заголовки останніх повідомлень",
"no display" => "не показувати",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Перенаправляти повідомлення в цей форму на адресу електронної пошти в форматі, який може вживатись для відсилання назад на адресу форуму",
"Originating e-mail address for mails from this forum" => "Вихідна електронна адреса для листів з цього форуму",
"Add messages from this email to the forum" => "Додавати листки з цієї адреси до форуму",
"POP3 server" => "Сервер POP3",
"Use topic smileys" => "Вживати хихоньки теми",
"Show topic summary" => "Показувати підсумок теми",
"User information display" => "Показувати інформацію користувача",
"avatar" => "картинка",
"flag" => "прапорець",
"online" => "активний",
"Approval type" => "Тип затвердження",
"All posted" => "Всі публікації",
"Queue anonymous posts" => "Анонімні листи класти в чергу",
"Queue all posts" => "Всі листи класти в чергу",
"Attachments" => "Долучення",
"No attachments" => "Без долучень",
"Everybody can attach" => "Долучати можуть всі",
"Only users with attach permission" => "Тільки ті, кому дозволено долучати",
"Moderators and admin can attach" => "Адміни і модератори можуть долучати",
"Store attachments in:" => "Зберігати долучення в:",
"Database" => "Базі даних",
"Max attachment size (bytes)" => "Макс розмір долучення (байтів)",
"topics" => "теми",
"age" => "вік",
"ppd" => "с/день",
"last post" => "ост.лист",
"Admin Hotwords" => "Адмініструвати 'горячі' слова",
"admin hotwords" => "адм. горячі слова",
"Add Hotword" => "Додати 'горяче' слово",
"Word" => "Слово",
"Add" => "Додати",
"admin HTML page dynamic zones" => "адм. динамічні зони сторінок HTML ",
"Admin HTML pages" => "Адмініструвати сторінки HTML",
"Edit this page" => "Редагувати цю сторінку",
"View page" => "Переглянути сторінку",
"Edit zone" => "Редагувати зону",
"Zone" => "Зона",
"Dynamic zones" => "Динамічні зони",
"zone" => "зона",
"content" => "зміст",
"Mass update" => "Масове поновлення",
"Create new HTML page" => "Створити нову сторінку HTML",
"Edit this HTML page:" => "Редагувати цю сторінку HTML:",
"Page name" => "Назва сторінки",
"Dynamic" => "Динамічний",
"Static" => "Статичий",
"Refresh rate (if dynamic) [secs]" => "Частота поновлення (для дин.)[сек]",
"list repositories" => "показати всі сховища",
"view repository" => "переглянути сховище",
"Start page" => "Початкова сторінка",
"CSS file" => "файл CSS ",
"Available Repositories" => "Наявні сховища",
"Start" => "Початок",
"CSS File" => "Файл CSS",
"Edit rules" => "Редагувати правила",
"Edit Rules for Repository:" => "Редагувати правила для сховища:",
"configure repositories" => "настроїти сховища",
"view/hide copy rules dialog" => "показати/сховати діалог для правил",
"copy rules" => "копіювати правила",
"Source repository" => "Сховище вихідних матеріалів",
"Copy" => "Копія",
"Replace" => "Заміна",
"Regex" => "Рег. вираз",
"Case sensitive" => "З врахуванням малих/великих літер",
"Preview options" => "Переглянути опції",
"Code preview" => "Попередній перегляд коду",
"Preview Results" => "Попередній перегляд результатів",
"Rules List" => "Список правил",
"Case" => "Великі/Малі",
"Admin layout" => "Адмініструвати вигляд",
"layout options" => "опції вигляду",
"Generate positions by hits" => "Генерувати позиції з переглядів",
"List of featured links" => "Список рекомендованих посилань",
"title" => "заголовок",
"position" => "положення",
"Add Featured Link" => "Додати рекомендоване посилання",
"Edit this Featured Link:" => "Редагувати дане рекомендоване посилання:",
"Create new Featured Link" => "Створити нове рекомендоване посилання",
"Position" => "Положення",
"disables the link" => "деактивує посилання",
"Link type" => "Тип посилання",
"replace current page" => "замінити поточну сторінку",
"framed" => "рамками",
"open new window" => "в новому вікні",
"admin Webmail" => "адмін. Webmail",
"Account name" => "Назва рахунку",
"POP server" => "Сервер POP",
"Port" => "Порт",
"SMTP server" => "Сервер SMTP",
"SMTP requires authentication" => "Для SMTP потрібна автентикація",
"List menus" => "Список меню",
"Edit this menu" => "Редагувати це меню",
"Edit menu options" => "Редагувати пункти меню",
"Some useful URLs" => "Деякі корисні URLи",
"Permissions" => "Дозволи",
"section" => "розділ",
"option" => "пункт",
"Home Page" => "Домівка",
"Home Image Gal" => "Домашня галерея зображень",
"Home Image Gallery" => "Домашня галерея зображень",
"Home File Gal" => "Домашня гал. файлів",
"Home File Gallery" => "Домашня галерея файлів",
"User preferences" => "Установки користувачів",
"User prefs" => "Уст. корист.",
"List image galleries" => "Показати список галерей зображень",
"Upload" => "Вивантажити",
"Gallery Rankings" => "Ранги популярності Галереї",
"Browse a gallery" => "Переглянути галерею",
"All articles" => "Всі статті",
"Submit" => "Подати",
"List Blogs" => "Список журналів",
"Create blog" => "Створити журнал",
"File galleries" => "Галереї файлів",
"View a forum" => "Переглянути форум",
"View a thread" => "Переглянути низку",
"View a FAQ" => "Переглянути ЧАП",
"Take a quiz" => "Контрольна",
"Stats for a Quiz" => "Статистика для контрольної",
"Preview menu" => "Попередній перегляд меню",
"Menu options" => "Пункти меню",
"group" => "група",
"Admin Menus" => "Редагувати меню",
"admin menu builder" => "будувач адмін. меню",
"Edit this Menu:" => "Редагувати це меню:",
"Create new Menu" => "Створити нове меню",
"dynamic collapsed" => "динамічне стиснене",
"dynamic extended" => "динамічно розшир",
"fixed" => "фіксоване",
"options" => "пункти",
"Admin Modules" => "Адмініструвати модулі",
"admin modules" => "адмін. модулі",
"assign module" => "назначити модуль",
"left modules" => "ліві модулі",
"right modules" => "праві модулі",
"edit/create" => "ред./створити",
"clear cache" => "чистити кеш",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Примітка 1</b>: якщо ви дозволяєте своїм користувачам настроювати модулі, \nтоді назначені модулі не будуть показані на екрані до тих пір,   \nпоки Ви не настроїте їх з MyTiki->modules.<br />\n<b>Примітка 2</b>: Коли Ви назначаєте модулі для груп, пересвідчіться, \nщо Ви вимкнулу пукт 'display modules to all groups always'\nfrom Admin->General\n(показувати всі модулі всім групам з Адміністрація->Загальне)",
"User Modules" => "Модулі користувачів",
"assign" => "назначити",
"Assign new module" => "Назначити новий модуль",
"Edit this assigned module:" => "Редагувати цей назначений модуль:",
"Module Name" => "Назва модуля",
"left" => "лівий",
"right" => "правий",
"Order" => "Порядок",
"Cache Time" => "Час кешування",
"Rows" => "Рядки",
"Parameters" => "Параментри",
"Visibility" => "Видимість",
"Displayed for the eligible users with no personal assigned modules" => "Видиме для користувачів з дозволеним переглядом без назначених модулів",
"Displayed now for all eligible users even with personal assigned modules" => "Видиме для користувачів з дозволеним переглядом, навіть якщо вони мають назначені персонально модулі",
"Displayed now, can't be unassigned" => "Видиме в даний момент, не можна відмінити",
"Not displayed until a user chooses it" => "Не видимий поки користувач не вибере його",
"Assigned Modules" => "Назначені модулі",
"Left Modules" => "Ліві модулі",
"order" => "порядок",
"rows" => "рядки",
"Right Modules" => "Праві модулі",
"Create new user module" => "Створити новий модуль користувача",
"Edit this user module:" => "Редагувати цей модуль користувача:",
"Use wysiwyg editor" => "Редактор wysiwyg",
"Use normal editor" => "Звичайний редактор",
"create/edit" => "створ./ред.",
"Objects that can be included" => "Об'єкти, що можна включити",
"Available polls" => "Настроєні опити",
"use poll" => "використовувти опит",
"Random image from" => "Довільне зображення з",
"use gallery" => "використовувати галерею",
"Dynamic content blocks" => "Блоки динамічного вмісту",
"use dynamic  content" => "вживати дин. вміст",
"use rss module" => "вживати модулі rss",
"use menu" => "вживати меню",
"Banner zones" => "Зони для транспарантів",
"use banner zone" => "вживати зони транспарантів",
"Admin newsletter subscriptions" => "Редагувати підписки на листки новин",
"list newsletters" => "перелік листків",
"admin newsletters" => "редагувати листки новин",
"send newsletters" => "надсилати листки новин",
"Add a subscription newsletters" => "Додати листки за підпискою",
"Subscriptions" => "Підписки",
"subscribed" => "підписані",
"Create/edit newsletters" => "Створити/ред, листки",
"There are individual permissions set for this newsletter" => "Для цього листка новин встановлені індивідуальні дозволи",
"Users can subscribe/unsubscribe to this list" => "Користувачі можуть підписатися чи відписатися з цієї розсилки",
"Users can subscribe any email address" => "Користувачі можуть підписати будь-яку адресу",
"Add unsubscribe instructions to each newsletter" => "Додати інструкції по відписці до кожного випуску листка новин",
"Validate email addresses" => "Перевірити електронну адресу",
"editions" => "випуски",
"last sent" => "надіслано останній раз",
"subscriptions" => "підписки",
"EMail notifications" => "Сповіщення ел. поштою",
"admin Email Notifications" => "адмін. Сповіщення ел. поштою",
"Add notification" => "Додати сповіщення",
"Event" => "Подія",
"A user registers" => "Реєстрації користувача",
"A user submits an article" => "Користувач надав статтю",
"Any wiki page is changed" => "Будь-яка сторінка Вікі змінена",
"use admin email" => "вживати пошту адмін.",
"event" => "подія",
"object" => "об'єкт",
"Admin Polls" => "Адмініструвати опити",
"List polls" => "Перелік опитів",
"Edit this poll" => "Редагувати цей опит",
"Preview poll" => "Попередній перегляд опиту",
"Edit or add poll options" => "Редагувати чи додати пункти опиту",
"Option" => "Пункт",
"Poll options" => "Пункти опиту",
"votes" => "голоси",
"admin polls" => "адмін. опити",
"Set last poll as current" => "Встановити цей опит як головний",
"Close all polls but last" => "Закрити всі описти крім останнього",
"Activate all polls" => "Активізувати всі опити",
"Create/edit Polls" => "Створити/ред. опити",
"PublishDate" => "Дата публ.",
"Category" => "Категорія",
"Admin RSS modules" => "Адмініструвати модулі RSS",
"admin RSS modules" => "адмін. модулів RSS",
"Content for the feed" => "Вміст для потоку",
"Edit this RSS module:" => "Редагувати модуль RSS:",
"show feed title" => "показати заголовок потоку",
"show publish date" => "показати дату публікації",
"Rss channels" => "Канали Rss",
"Last update" => "останнє поновнлення",
"show pubdate" => "показати дату пуб.",
"Filename" => "Назва файла",
"export pages" => "експортувати сторінки",
"Destroy the structure leaving the wiki pages" => "Знищувати структури, що виходять за межі сторінок вікі",
"Destroy the structure and remove the pages" => "Знищити структуру і прибрати сторінки",
"Create new structure" => "Створити нову структуру",
"Use single spaces to indent structure levels" => "Для відступів у рівнях структур використовувати одинокі пропуски",
"tree" => "дерево",
"Edit survey questions" => "Редагувати питяння опитів",
"survey stats" => "стат. опистів",
"this survey stats" => "стат. цього опиту",
"edit this survey" => "ред. цей опит",
"admin surveys" => "адмін. опити",
"Create/edit questions for survey" => "Створити/ред. запитання для опиту",
"Question" => "Запитання",
"One choice" => "Один варіант",
"Multiple choices" => "Багато варіантів",
"Short text" => "Короткий текст",
"Rate (1..5)" => "Популярність (1..5)",
"Rate (1..10)" => "Популярність (1..10)",
"Options (if apply)" => "Пункти(якщо є)",
"Questions" => "Запитання",
"question" => "запитання",
"list surveys" => "списток опитів",
"Edit this Survey:" => "Ред. цей опит:",
"There are individual permissions set for this survey" => "Для цього опиту встановлені індивідуальні дозволи",
"status" => "стан",
"questions" => "запитання",
"files" => "файлах",
"Admin Topics" => "Редагувати теми",
"Create a new topic" => "Створити нову тему",
"Topic Name" => "Назва теми",
"Upload Image" => "Вивантажити графіку",
"List of topics" => "Список тем",
"Active?" => "Активні?",
"Articles (subs)" => "Статті (subs)",
"topic image" => "зображення до теми",
"Activate" => "Активізувати",
"Deactivate" => "Деактивізувати",
"Import" => "Імпорт",
"admin Trackers tpl" => "шаблони адміністрування супроводження",
"created" => "створено",
"items" => "пункти",
"fields" => "поля",
"downloads" => "звантажень",
"version" => "версія",
"admin groups" => "адмін. групи",
"Add new group" => "Створити групу",
"List" => "Список",
"List of existing groups" => "Список існуючих груп",
"Number of displayed rows" => "Кількість рядків, що показуються одночасно",
"Includes" => "Включення",
"Include" => "Включити",
"admin" => "адмін",
"Edit item" => "Редагувати пункт",
"admin users" => "адмін. користувачів",
"Add a new user" => "Додати користувача",
"Batch Upload Results" => "Результат одночасного додавання",
"Added users" => "Додані користувачі",
"Rejected users" => "Відкинуті користувачі",
"Reason" => "Причина",
"Never" => "Ніколи",
"Pass" => "Пароль",
"Again" => "Ще раз",
"Overwrite" => "Переписати",
"Review" => "Огляд",
"Assign permissions to group" => "Назначити дозволи для групи",
"Edit Article" => "Редагувати статтю",
"edit article tpl" => "редагувати шаблон статті",
"Back to groups" => "Повернутися до груп",
"Group Information" => "Інформація про групу",
"Desc" => "Опис",
"Create level" => "Створити рівень",
"all permissions in level" => "всі дозволи в рівні",
"all" => "всі",
"level" => "рівень",
"Assign user" => "Назн. користувача",
"to groups" => "до групи",
"User Information" => "Інформація користувача",
"Default Group" => "Головна група",
"to" => "до",
"backlinks to" => "зворотнє посилання",
"No backlinks to this page" => "Немає посиланнь на цю сторінку",
"admin backups" => "адмін. рез. копій",
"admin admin tpl" => "шабл. адмін. рез. копій",
"List of available backups" => "Список зроблених рез. копій",
"Restoring a backup" => "Відновлення рез. копії",
"Warning!" => "Увага!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Відновлення резервної копію знищує всі дані у Ваші  базі даних Тікі. Всі таблиці будуть замінені на таблиці з резервної копії.",
"Click here to confirm restoring" => "Натистіт тут щоб підтвердити відновлення",
"Create new backup" => "Створити нову копію",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Створення резервної копії може зайняти досить довгий час. Якщо процес не закінчено, Ви побачите порожній екран. В цьому випадку Вам потрібно буде збільшити максимальний час для виконаня скрипту у файлі  php.ini на сервері",
"Upload a backup" => "Вивантажити рез. копію",
"Upload backup" => "Вивантажити рез. копію",
"Browse gallery" => "Переглянути галерею",
"Upload from disk" => "Вивантажити з диску",
"Process" => "Процес",
"Edit Post" => "Редагувати публікацію",
"view blog" => "переглянути журнал",
"list blogs" => "список журналів",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "Зауваження: якщо Ви хочете використати зображення для своєї публікації, збережіть її спочатку\n і після цього Ви зможете додати/редагувати зображення. Використовуйте бирки &lt;img&gt; для включення зображення вивантаженого на сервер в своїй публікації.\n Або Ви можете скористуватись редактором WYSIWYG, в такому випадку включіть URL зображення в текс. ",
"Use ...page... to separate pages in a multi-page post" => "Щоб відділяти сторінки в довгих публікаціях, скористайтесь биркою ...page...",
"Upload image for this post" => "Вивантажити зображення для цієї публікації",
"Trash" => "Смітник",
"(comma separated list of URIs)" => "(список URL, розділених комами)",
"save and exit" => "запис та вийти",
"Image galleries" => "Галереї зображень",
"search category" => "шукати в категорії",
"deep" => "в глибину",
"Objects" => "Об'єкти",
"Browsing Gallery" => "Перегляд галереї",
"edit gallery" => "редагувати галерею",
"rebuild thumbnails" => "перебудувати піктограми",
"upload image" => "вивантажити зображення",
"list gallery" => "список галерей",
"Sort Images by" => "Впорадкувати зображення за",
"original size" => "початковий розмір",
"rotate right" => "повернути праворуч",
"rotate" => "поворот",
"popup" => "спливаюче",
"Browsing Image" => "Перегляд зобраення",
"return to gallery" => "повернутися в галерею",
"edit image" => "редагувати зображення",
"first image" => "перше зображення",
"smaller" => "менше",
"bigger" => "більше",
"prev image" => "попер. зобаження",
"Popup window" => "Спливаюче вікно",
"popup window" => "спливаюче вікно",
"next image" => "наст. зображення",
"last image" => "останнє зображення",
"stop" => "стоп",
"Image Name" => "Назва зображення",
"Image size" => "Розмір зображення",
"imagescale" => "масштаб зображ.",
"Move image" => "Перемістити зображення",
"You can view this image in your browser using" => "Ви можете побачити це зображення в своєму переглядачі, скористувавшись",
"End" => "Кінець",
"details" => "деталі",
"Hours" => "Години",
"h" => "г",
"Group Calendars" => "Календарі групи",
"Tools Calendars" => "Календарі інструментів",
"Duration" => "Тривання",
"Location" => "Розташування",
"Organized by" => "Згрупований за",
"Participants" => "Учасники",
"Tentative" => "План",
"Confirmed" => "Затверджено",
"Cancelled" => "Скасовано",
"Edit Calendar Item" => "Редагувати запис календаря",
"or create a new category" => "або створити нову категорію",
"or create a new location" => "чи створити нове розташування",
"comma separated usernames" => "список імен, розділених комами",
"comma separated username:role" => "розділені комами username:role",
"with roles" => "з ролями",
"Chair" => "Головуючий",
"Optional" => "Необов'язково",
"duplicate" => "дублювати",
"import" => "імпорт",
"permission" => "дозволи",
"No individual permissions global permissions apply" => "Немає індивідуальних дозволів, діють глобальні",
"Assign permissions" => "Надати дозволи",
"to group" => "групі",
"Change password enforced" => "Примусова зміна паролю",
"Old password" => "Старий пароль",
"Again please" => "Ще раз",
"Welcome to the Tiki Chat Rooms" => "Ласкаво просимо до кімнати балачок Тікі",
"Please select a chat channel" => "Виберіть, будь ласка, канал для балачок",
"Nickname" => "Псевдо",
"enter chat room" => "ввійти в кімнату",
"Chatroom" => "Кімната балачок",
"Browser not supported" => "Цей переглядач не підтримується",
"Active Channels" => "Активні канали",
"Users in this channel" => "Користувачі в цьомау каналі",
"Channel Information" => "Інформація про канал",
"Channel" => "Канал",
"Ratio" => "Відношення",
"Use :nickname:message for private messages" => "Для приватних повідомлень користуйтесь формою :псевдо:повідомлення",
"Use [URL|description] or [URL] for links" => "Вживайте [URL|опис] або [URL] для посилань",
"Create PDF" => "Створити PDF",
"PDF Settings" => "Установки PDF",
"Font" => "Шрифт",
"Textheight" => "Висота тексту",
"Height of top Heading" => "Висота верхнього Заголовку",
"Height of mid Heading" => "Висота середнього Заголовку",
"Height of inner Heading" => "Висота внутрішнього заголовку",
"Select Wiki Pages" => "Вибрати сторінки Вікі",
"add page" => "додати сторінку",
"remove page" => "забрати сторінку",
"reset" => "скинути",
"Send a message to us" => "Пошліть нам листа",
"Contact us by email" => "Зв'язатися з нами поштою",
"Structure" => "Структура",
"Tiki Debugger Console" => "Консоль відладки Тікі",
"Close" => "Закрити",
"Current URL" => "Поточний URL",
"Command" => "Команда",
"exec" => "вик.",
"Type <code>help</code> to get list of available commands" => "Введіть <code>help</code> щоб отримати список наявних команд",
"Add a new site" => "Додати новий майданчик",
"Site added" => "Майданчик додано",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Цей майданчик додано і, можливо, він потребуватиме перевірки адмініатратором, перш, ніж він з'явиться в списках",
"Add or edit a site" => "Додати чи редагувати майданчик",
"Is valid" => "Діючий",
"Directory Administration" => "Адміністрація каталогу",
"admin directory tpl" => "шабл. адмін. теки",
"Statistics" => "Статистика",
"There are" => "Є",
"invalid sites" => "недіючі майданчики",
"valid sites" => "діючі майданчики",
"Users have visited" => "Відвідано користувачами",
"sites from the directory" => "майданчиків з цього каталогу",
"Users have searched" => "Користувачі проводили пошук",
"times from the directory" => "разів в цьому каталозі",
"Admin sites" => "Адмін. майданчики",
"Admin category relationships" => "Адмініструвати співвідношення категорій",
"Validate links" => "перевірити посилання",
"Settings" => "Установки",
"browse" => "перегляд",
"related" => "відноситься",
"sites" => "майданчики",
"validate" => "перевірити",
"Admin directory categories" => "Адмініструвати категорії каталогу",
"admin directory categories tpl" => "шабл. адмін. тек категорій",
"Parent category" => "Батьківська категорія",
"Add a directory category" => "Додати категорію каталогу",
"Edit this directory category" => "Редагувати категорію цього каталогу",
"Children type" => "Дочірній тип",
"Most visited sub-categories" => "Найчастіше відвідувані під-категорії",
"Category description" => "Опис категорії",
"Random sub-categories" => "Довільні під-категорії",
"Maximum number of children to show" => "Максимальне число видимих дочірніх пунктів",
"Allow sites in this category" => "Дозволити майданчики в цій категорії",
"Show number of sites in this category" => "Показувати кількість майданчиків в цій категорії",
"Editor group" => "Група редакторів",
"Subcategories" => "Підкатегорії",
"allow" => "дозволити",
"count" => "рахунок",
"editor" => "редактор",
"relate" => "віднести",
"Admin related categories" => "Редагувати співвідності категорії",
"Admin Directory Related " => "Мають відношення до Адмін. теки ",
"Add a related category" => "Додати співвідносну категорію",
"Mutual" => "Взаємно",
"Related categories" => "Співвідносні категорії",
"country" => "країна",
"new sites" => "нові майданчики",
"cool sites" => "'кльові' майданчики",
"add a site" => "додати майданчик",
"any" => "будь-який",
"in entire directory" => "в цілому каталозі",
"in current category" => "в цій категорії",
"search" => "шукати",
"Sort by" => "Упорядкувати за",
"name (desc)" => "назва(спад)",
"name (asc)" => "назва(зрост)",
"hits (desc)" => "перегляд (спад)",
"hits (asc)" => "перегляд (зрост)",
"creation date (desc)" => "було створено (спад)",
"creation date (asc)" => "було створено (зрост)",
"last updated (desc)" => "поновлено (спад)",
"last updated (asc)" => "поновлено (зрост)",
"sort" => "впорядкувати",
"Added" => "Додано",
"Last updated" => "Поновлення",
"Total categories" => "Всього категорій",
"Total links" => "Всього посилань",
"Links to validate" => "Посилань для перевірки",
"Searches performed" => "Виконано пошуків",
"Total links visited" => "Всього відвідано посилань",
"Directory ranking" => "Популярність каталогу",
"Search results" => "Результати пошуку",
"Validate sites" => "Перевірка майданчиків",
"Validate Sites" => "Перевіряти майданчики",
"directory validate sites tpl" => "шаблони перевірки майданчиків у каталозі",
"list articles" => "список статтей",
"view articles" => "перегляду статей",
"Author Name" => "Ім'я автора",
"Own Image" => "Власне зображення",
"Use own image" => "Вживати власне зображення",
"Float text around image" => "Плаваючий текст навколо зображення",
"Own image size x" => "Розмір зображення (x)",
"Own image size y" => "Розмір зображення (y)",
"Heading" => "Заголовок",
"Body" => "Тіло",
"Use ...page... to separate pages in a multi-page article" => "Вживайте ...page... для розділу сторінок в статті на кілька сторінок",
"Edit or create banners" => "Редагувати чи створити транспарант",
"List banners" => "Список транспарантів",
"URL to link the banner" => "URL, на який вказує транспарант",
"Client" => "Клієнт",
"create zone" => "створити зону",
"Show the banner only between these dates" => "Показувати транспарант тільки між цими ддатами",
"From date" => "Від дати",
"To date" => "До дати",
"Use dates" => "Користуватися датами",
"Show the banner only in this hours" => "Показувати транспарант тільки в ці години",
"Show the banner only on" => "Показувати транспарант тільки",
"Mon" => "Пон",
"Tue" => "Вів",
"Wed" => "Сер",
"Thu" => "Чтв",
"Fri" => "Птн",
"Sat" => "Суб",
"Sun" => "Нед",
"Select ONE method for the banner" => "Виберіть ОДИН метод для транспаранта",
"Use HTML" => "Вживвати HTML",
"HTML code" => "Код HTML",
"Use image" => "Вживати зображення",
"Image:" => "Зображення:",
"Current Image" => "Поточне зображення",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Вживати зображення зґенероване з URL (з URL буде зпрошене зображення. Для кожного виразу буде використовуватись окремий URL)",
"Use text" => "Вживати текст",
"Text" => "Текст",
"save the banner" => "записати транспарант",
"Edit Blog" => "Редагувати журнал",
"edit blog tpl" => "ред. шаблон журналу",
"Current heading" => "Поточний титул",
"There are individual permissions set for this blog" => "Для цього журналу встановлені індивідуальні дозволи",
"Number of posts to show" => "Скільки публікацій показувати",
"Allow other user to post in this blog" => "Дозволити публікації в цьому журналі іншим користувачам",
"Use titles in blog posts" => "Вживати заголовки в публкаціях журналу",
"Allow search" => "Дозволити пошук",
"Allow comments" => "Дозволити коментарі",
"Blog heading" => "Заголовок журналу",
"Cancel" => "Скасувати",
"try" => "випробувати",
"display" => "показати",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Файли, назви яких містять -{\$user} можуть змінюватися користувачами, інші можна тільки скопіювати і використовувати як зразок.",
"Show Plugins Help" => "Показати підказку по модулям",
"some text" => "деякий текст",
"Creates a box with the data" => "Створює рамку з даними в ній",
"Box content" => "Вміст рамки",
"Title bar" => "Колонтитул",
"creates a title bar" => "створює колонтитул",
"Colored text" => "Кольоровий текст",
"Lists" => "Списки",
"for numbered lists" => "для нумерованих списків",
"for definiton lists" => "для визначень",
"Wiki References" => "Установки Вікі",
"page|desc" => "стор|опис",
"for wiki references" => "для установок вікі",
"External links" => "Зовнішні посилання",
"Tables" => "Таблиці",
"creates a table" => "створює таблицю",
"displays an image" => "показує зображення",
"height width desc link and align are optional" => "висота ширина опис посилання та вирівнювання необов'язкові",
"Non cacheable images" => "Некешовані зображення",
"makes a horizontal rule" => "створює горизонтальну риску",
"Multi-page pages" => "Сторіни за багатьох сторінок",
"RSS feeds" => "Потоки RSS",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Буде замінено поточним вмістом динамічного блоку з id=n",
"Non parsed sections" => "Не оброблені розділи",
"Misc" => "Різне",
"Show Text Formatting Rules" => "Показати правила форматування тексту",
"No description available" => "Немає опису",
"bold" => "напів-жирний",
"italic" => "курсив",
"underline" => "підкреслення",
"table" => "таблиця",
"external link" => "зовнішнє посилання",
"heading1" => "заголовок1",
"title bar" => "колонтитул",
"box" => "рамка",
"dynamic content" => "динамічний вміст",
"center text" => "відцентрований текст",
"colored text" => "кольоровий текст",
"dynamic variable" => "динамічна змінна",
"special chars" => "спеціальні символи",
"special characters" => "спеціальні символи",
"Edit Image" => "Редагувати зображення",
"Edit successful!" => "Редаагування успішне!",
"The following image was successfully edited" => "Наступне зображення було відредаговано успішно",
"Image Description" => "Опис зображення",
"Edit and create Languages" => "Редагувати та створити мови",
"Im- Export Languages" => "Ім/Експортувати мови",
"Edit and create languages" => "Редагувати та створити мови",
"Create Language" => "Створити мову",
"Shortname" => "Коротка назва",
"like" => "схоже",
"Longname" => "Довга назва",
"Select the language to edit" => "Виберіть мову для редагування",
"Add a translation" => "Додати переклад",
"Edit translations" => "Редагувати переклад",
"Translate recorded" => "Перекладати записане",
"Original" => "Ориґінал",
"Translation" => "Переклад",
"translate" => "перекласти",
"reset table" => "скинути таблицю",
"Program dynamic content for block" => "Програмувати динамічний вміст для блоку",
"create new block" => "створити новий блок",
"Return to block listing" => "Повернутися до списку блоків",
"Block description: " => "Опис блоку: ",
"Create or edit content" => "Створити чи редагувати вміст",
"You are editing block:" => "Ви редагуєте блок:",
"Publishing date" => "Дата публікації",
"Publishing Date" => "Дата публікації",
"Edit question options" => "Редагувати пункти запитання",
"list quizzes" => "список контрольних",
"quiz stats" => "статистика контрольних",
"this quiz stats" => "статистика даного опитування",
"Create/edit options for question" => "Створити/редагувати пункти для запитання",
"points" => "бали",
"Admin quizzes" => "Адмініструвати контрольні",
"admin quizzes tpl" => "шаблони адміністрування контрольних",
"Create/edit quizzes" => "Створити/редагувати контрольні",
"There are individual permissions set for this quiz" => "Для даної контрольної встановлені індивідуальні дозволи",
"Quiz can be repeated" => "Контрольну можна повторити",
"Store quiz results" => "Записувати результати контрольної",
"Questions per page" => "Запитань на сторінку",
"Quiz is time limited" => "Час для контрольної обмежений",
"Maximum time" => "Максимальний час",
"results" => "результати",
"Edit quiz questions" => "Редагувати запитання контрольної",
"Create/edit questions for quiz" => "Створити/редагувати запитання для контрольної",
"Answer" => "Відповідь",
"Results" => "Результати",
"answer" => "відповідь",
"You will remove" => "Ви видалите",
"and its subpages from the structure, now you have two options:" => "та всі її дочірні сторінки із структури, Ви маєте два варіанти:",
"Remove only from structure" => "Видалити тільки із структури",
"Remove from structure and remove page too" => "Видалити із структури і видалити сторінки також",
"Page alias" => "Псевдо сторінки",
"Previous" => "Попередній",
"After page" => "Після сторінки",
"create page" => "створити сторінку",
"Use pre-existing page" => "Вживати попередньо створену сторінку",
"edit submissions tpl" => "шабл редагування подань",
"list submissions" => "список подань",
"EditTemplates" => "РедШаблони",
"EditTemplates tpl" => "шаблон РедШаблони",
"Template listing" => "Список шаблонів",
"Available templates" => "Існуючі шаблони",
"Template" => "Шаблон",
"Edit a topic" => "Редагувати тему",
"Browse" => "Переглянути",
"Admin FAQ" => "Адмініструвати ЧАПи",
"View FAQ" => "Переглянути ЧАП",
"Edit this FAQ" => "Редагувати цей ЧАП",
"new question" => "нове запитання",
"Edit FAQ questions" => "Редагувати запитання ЧАП",
"Use a question from another FAQ" => "Використати запитання з іншого ЧАП",
"FAQ questions" => "Питання ЧАП",
"Suggested questions" => "Запропоновані питання",
"approve" => "затвердити",
"No suggested questions" => "Немає запровонованих запитань",
"configure listing" => "конфіґурувати список",
"Create a file gallery" => "Створити галерею файлів",
"Edit this file gallery:" => "Редагувати дану галерею файлів:",
"create new gallery" => "створити нову галерею",
"There are individual permissions set for this file gallery" => "Для даної галереї файлів встановлені індивідуальні дозволи",
"Gallery is visible to non-admin users?" => "Чи дозволяється перегляд галереї для не-адміністраторів?",
"Listing configuration" => "Конфіґурація списку",
"icon" => "піктограма",
"Name-filename" => "Назва/Назва файлу",
"Filename only" => "Тільки назва файлу",
"Max description display size" => "Максимальний розмір для показу опису",
"Max Rows per page" => "Макс число рядків на сторінку",
"Other users can upload files to this gallery" => "Інші користувачі можуть вивантажувати файли в цю галерею",
"You can access the file gallery using the following URL" => "Ви можете переглядати цю галерею за таким URL",
"Available File Galleries" => "Існуючи галереї файлів",
"Message queue for" => "Черга повідомлень для",
"back to forum" => "назад до форуму",
"Edit queued message" => "Редагувати повідомлення в черзі",
"topic" => "тема",
"make this a thread of" => "зробити це гілкою теми",
"None, this is a thread message" => "Ніякої, це повідомлення в низці",
"summary" => "підсумок",
"normal" => "звичайний",
"announce" => "оголошення",
"hot" => "гаряче",
"save and approve" => "записати і затвердити",
"List of messages" => "Список повідомлень",
"new topic" => "нова тема",
"no summary" => "без підсумку",
"No messages queued yet" => "Ще немає повідомлень у черзі",
"reject" => "відмовити",
"accept" => "прийняти",
"Real Name" => "Справжнє ім'я",
"Admin process activities" => "Адмініструвати активність процесів",
"Add or edit an activity" => "Додати чи редагувати активність",
"start" => "старт",
"end" => "кінець",
"activity" => "активність",
"split" => "розділити",
"join" => "об'єднання",
"standalone" => "самостійний",
"interactive" => "інтерактивно",
"Add transitions" => "Додати переходи",
"Add transition from:" => "Додати переходи з:",
"Add transition to:" => "Додати переходи до:",
"roles" => "ролі",
"No roles associated to this activity" => "З даною активністю не пов'язано ролей",
"Add role" => "Додати роль",
"add new" => "додани нову",
"add role" => "додати роль",
"Process activities" => "Активності процесів",
"Interactive" => "Інтарактивний",
"Automatic" => "Автоматичний",
"Auto routed" => "Авто маршрутизація",
"Manual" => "Вручну",
"route" => "маршрут",
"(no roles)" => "(немає ролей)",
"No activities defined yet" => "Ще не визначені активності",
"Process Transitions" => "Переходи процесів",
"List of transitions" => "Список переходів",
"From:" => "Від:",
"Origin" => "Витік",
"No transitions defined yet" => "Ще не визначені переходи",
"Add a transition" => "Додати перехід",
"This process is invalid" => "Цей процес недійсний",
"List of processes" => "Список процесів",
"Inactive" => "Неактивний",
"act" => "дія",
"val" => "вел",
"active process" => "активні процеси",
"invalid" => "недійстий",
"invalid process" => "недійсний процес",
"valid process" => "дійсний процес",
"activities" => "активність",
"graph" => "графік",
"No processes defined yet" => "Ще не визначено процеса",
"Admin instance" => "Адмініструвати зразок",
"Process:" => "Процес:",
"Instance" => "Зразок",
"Workitems" => "Пункти завдання",
"exception" => "виключення",
"completed" => "закінчено",
"aborted" => "скасовано",
"Owner" => "Власник",
"Send all to" => "Відіслати все до",
"Don't move" => "Не рухати",
"Activities" => "Активності",
"Started" => "Початий",
"Properties" => "Властивості",
"Property" => "Властивість",
"Value" => "Величина",
"Add property" => "Додати властивість",
"value" => "величина",
"Galaxia Admin Processes" => "Адміністративний процес Galaxia",
"Galaxia Admin Processes tpl" => "Адміністративний процес Galaxia  tpl",
"Add or edit a process" => "Додати чи редагувати процес",
"Process Name" => "Назва процесу",
"ver:" => "вер:",
"is active?" => "активний?",
"Admin process roles" => "Адмініструвати ролі процесів",
"Add or edit a role" => "Додатч чи редагувати роль",
"Process roles" => "Ролі процесів",
"No roles defined yet" => "Ще не визначені ролі",
"Map users to roles" => "Співвіднести користувачів і ролі",
"Map" => "Мапа",
"Roles" => "Ролі",
"map" => "відношення",
"Map groups to roles" => "Співвіднести групи і ролі",
"Operation" => "Дія",
"Warning" => "Попередження",
"No roles are defined yet so no roles can be mapped" => "Ролі ще не визначені, тому не можна зробити співвіднесення",
"List of mappings" => "Список відношень",
"No mappings defined yet" => "Ще не визначені відношення",
"Admin process sources" => "Адмініструвати джерела процесів",
"select source" => "вибрати джерело",
"Shared code" => "Спільний код",
"Set next user" => "Встановит наступного користувача",
"Get property" => "Отримати властивість",
"Set property" => "Встановити властивість",
"Complete" => "Повністю",
"Process form" => "Форма процеса",
"Set Next act" => "Встановити наступну дію",
"admin processes" => "адмініструвати процеси",
"admin activities" => "адмініструвати активності",
"admin roles" => "адмініструвати ролі",
"edit this process" => "редагувати цей процес",
"Galaxia Monitor Activities" => "Монітор активності Galaxia",
"Galaxia Monitor Activities tpl" => "Шаблон монітора активності Galaxia",
"List of activities" => "Список активності",
"proc" => "проц",
"auto" => "авто",
"monitor" => "монітор",
"monitor processes" => "монітор процеси",
"monitor activities" => "монітор активності",
"Galaxia Monitor Processes" => "Монітор процесів Galaxia",
"Galaxia Monitor Processes tpl" => "Шаблони монітора процесів Galaxia",
"Invalid" => "Недійсний",
"processes" => "процеси",
"exceptions" => "виключення",
"activate" => "активізувати",
"User Activities" => "Активність користувача",
"Galaxia User Activities" => "Дії користувачів Galaxia",
"Galaxia User Activities tpl" => "Шаблони дій користувачів Galaxia",
"process" => "процес",
"user processes" => "процеси користувача",
"user activities" => "активність користувача",
"Galaxia User Processes" => "Процеси користувачів Galaxia",
"Galaxia User Processes tpl" => "Шаблони процесів користувачів Galaxia",
"galleries tpl" => "шаблони галерей",
"Create a gallery" => "Створити галерею",
"Edit this gallery:" => "Редагувати цю галерею:",
"There are individual permissions set for this gallery" => "Для даної галереї встановлені індивідуальні дозволи",
"Images per row" => "Зображень на рядок",
"Thumbnails size X" => "Розмір піктограми X",
"Thumbnails size Y" => "Розмір піктограми Y",
"Image ID" => "ID зображення",
"Filesize" => "Розмір файла",
"Available scales" => "Встановлені масштаби",
"No scales available" => "Масштаби не встановлені",
"Other users can upload images to this gallery" => "Інші користувачі можуть вивантажувати зображення в цю галерею",
"You can access the gallery using the following URL" => "Ви можете мати доступ до цієї галереї за таким URL",
"Available Galleries" => "Наявні галереї",
"Imgs" => "Зобр",
"Im- Export languages" => "Ім(Екс)порт мов",
"Select the language to Import" => "Виберіть мову для імпорту",
"Select the language to Export" => "Виберіть мову для експорту",
"Overwrite existing pages if the name is the same" => "Заміняти існуючі сторінки, які мають таку ж назву",
"Previously remove existing page versions" => "Попередньо стерти існуючі версії сторінок",
"result" => "результат",
"Weeks" => "Тижнів",
"Search by Date" => "Пошук за датою",
"Found" => "Знайдено",
"LastChanges" => "ОстанніЗміни",
"hist" => "істор",
"rollback" => "відкат",
"source" => "джерело",
"Pages like" => "Схожі сторінки",
"No pages found" => "Сторінки не знайдені",
"List Articles" => "Перелік статей",
"list articles tpl" => "шабл. переліку статей",
"edit new article" => "редагувати нову статтю",
"AuthorName" => "Ім'яАвтора",
"admin Banners" => "адмін. Гасла",
"admin Banners tpl" => "шабл. адмін. гасел",
"Create banner" => "Створити транспарант",
"Method" => "Метод",
"Use Dates?" => "Вживати дати?",
"Clicks" => "Клацань",
"create new blog" => "створити новий журнал",
"Last Modified" => "Останні зміни",
"admin cache" => "адмін. кеш",
"admin cache tpl" => "шабл. адмін. кешу",
"Dynamic content system" => "Система динамічного вмісту",
"admin DynamicContent tpl" => "шабл. адмін. ДинамічнийВміст",
"Create or edit content block" => "Створити чи редагувати блок вмісту",
"Available content blocks" => "Присутні блоки вмісту",
"Current ver" => "Поточна версія",
"Next ver" => "Наступна версія",
"Old vers" => "Стара версія",
"Program" => "Програма",
"list faqs tpl" => "шабл. списку ЧАПів",
"Edit this FAQ:" => "Редагувати цей ЧАП:",
"Create new FAQ" => "Створити новий ЧАП",
"Create New FAQ:" => "Створити новий ЧАП:",
"Users can suggest questions" => "Користувачі можуть пропонувати питання",
"Available FAQs" => "Наявні ЧАП'и",
"Listing Gallery" => "Список галереї",
"upload file" => "вивантажити файл",
"Edit a file using this form" => "Редагувати файл вживаючи цю форму",
"Gallery Files" => "Файли галереї",
"move selected files" => "перемістити вибрані файли",
"delete selected files" => "видалити вибрані файли",
"Move to" => "Перемістити в",
"browse gallery" => "переглянути галерею",
"Gallery Images" => "Зображення галереї",
"All games are from" => "Всі ігри з",
"visit the site for more games and fun" => "відвідайте майданчик для більшого вибору ігор і для задоволення",
"Upload a game" => "Вивантажити гру",
"Upload a new game" => "Вивантажити нову гру",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Піктограма (якщо гра зветься foo.swf піктограма повинна мати назву foo.swf.gif чи foo.swf.png чи foo.swf.jpg)",
"Edit game" => "Редагувати гру",
"Played" => "Зіграно",
"times" => "разів",
"If you can't see the game then you need a flash plugin for your browser" => "Якщо Ви не можете бачити гру, Вам потрібно встановити модуль програвача flash у Вашому переглядачі",
"list posts tpl" => "шабл. списку повідомлень",
"edit blog" => "редагувати журнал",
"Blog Title" => "Заголовок журналу",
"edit new submission" => "редагувати нові подання",
"Approve" => "Затвердити",
"Survey stats" => "Статистика опитувань",
"adm" => "адм",
"List Movies" => "Перелічити фільми",
"Choose a movie" => "Вибрати фільм",
"Display" => "Показати",
"Last mod" => "Змінювалось",
"Last author" => "Останній автор",
"Last ver" => "Остання версія",
"Vers" => "Верс",
"admin live support tpl" => "адмін шаблонів живого супроводу",
"Open client window" => "Відкрити вікто клієнта",
"Generate HTML" => "Генерувати HTML",
"Support tickets" => "Квитки на супровід",
"Online operators" => "Активні оператори",
"Operator" => "Оператори",
"Add an operator to the system" => "Додати оператора до системи",
"Operators must be tiki users" => "Оператори повинні бути користувачами Тікі",
"set as operator" => "встановити оператором",
"Chat started" => "Балачка почата",
"User:" => "Користувач:",
"Operator:" => "Оператор:",
"Live support:User window" => "Супровід:Вікно",
"Request live support" => "Запросити живий супровід",
"Request support" => "Запросити супровід",
"Open a support ticket instead" => "Відкрити квиток на супровід, замість",
"Your request is being processed" => "Ваш запит в обробці",
"cancel request and exit" => "скасувати запит і вийти",
"cancel request and leave a message" => "скасувати запит і залишити повідомлення",
"Live support:Console" => "Живий супровід: Консоль",
"Support requests" => "Запити на супровід",
"Requested" => "Запрошено",
"Accept" => "Прийнято",
"Join" => "Приєднатися",
"back to admin" => "повернутися до адміністрування",
"started" => "почато",
"reason" => "причина",
"msgs" => "повідомлення",
"Remove old events" => "Видалити старі події",
"duration" => "тривання",
"Add or edit event" => "Додати чи редагувати подію",
"Mini Calendar: Preferences" => "Міні календар: Уподобання",
"Calendar Interval in daily view" => "Діапазон календаря при перегляді днями",
"Start hour for days" => "Починати з години в перегляді днями",
"End hour for days" => "Закінчувати на годині в перегляді днями",
"Reminders" => "Нагадування",
"no reminders" => "без нагадувань",
"Import CSV file" => "Імпорт файлу CSV",
"Or enter path or URL" => "Або введіть маршрут чи URL",
"add topic" => "додати тему",
"my tiki tpl" => "шаблон мого тікі",
"My pages" => "Мої сторінки",
"My items" => "Мої пункти",
"My tasks" => "Мої задачі",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Дякуємо за Вашу підписку. Скоро Ви отримаєте листа для підтрвердежння Вашої підписку. До того часу поки Ви не затвердите підписку, листки новин не будуть надсилатися.",
"Your email address was removed from the list of subscriptors." => "Ваша адреса видалена із списку підписників.",
"Subscription confirmed!" => "Підписку підтверджено!",
"Subscribe to newsletter" => "Підписатися на листок новин",
"Email:" => "Пошта:",
"Subscribe" => "Підписатися",
"Select news group" => "Вибрати групу новин",
"Back to servers" => "Повернутися до серверів",
"Msgs" => "Листи",
"Save position" => "Зберегти положення",
"Reading article from" => "Перегляд статті з",
"Back to list of articles" => "Повернутися до списку статей",
"First" => "Перша",
"Newsgroup" => "Група новин",
"Configure news servers" => "Настроїти сервери новин",
"Configure Newsreader" => "Настроїти читання новин",
"configure newsreader server tpl" => "Шаблон конфігурації сервера читання новин",
"Select a news server to browse" => "Вибрати сервер новин для перегляду",
"server" => "сервер",
"Add or edit a news server" => "Додати чи редагувати сервер новин",
"News server" => "Сервер новин",
"Notes" => "Нотатки",
"quota" => "квота",
"Write a note" => "Занести нотатку",
"No notes yet" => "Ще немає нотаток",
"merge selected notes into" => "об'єднати вибрані нотатки в",
"Reading note:" => "Читання нотатки:",
"List notes" => "Список нотаток",
"Write note" => "Записати нотатку",
"wiki create" => "створити вікі",
"wiki overwrite" => "перезаписати вікі",
"Assign permissions to " => "Надати дозволи для ",
"back" => "назад",
"Current permissions for this object" => "Дозволи для об'єкту на даний момент",
"Assign permissions to this object" => "Надати дозволи для цього об'єкту",
"Published" => "Опубліковано",
"Votes" => "Голосів",
"Orphan Pages" => "Сторінки-сироти",
"Assign permissions to page" => "Назначити дозволи для сторінки",
"Current permissions for this page" => "Дозволи сторінки на даний момент",
"remove from this page" => "прибрати з цієї сторінки",
"remove from this structure" => "прибрати з цієї структури",
"this page" => "ця сторінка",
"this structure" => "ця структура",
"Send email notifications when this page changes to" => "Надсилати повідомлення поштою, коли ця сторінка зміниться на",
"add email" => "додати пошту",
"Notifications" => "Сповіщення",
"Pick your avatar" => "Виберіть собі аватар",
"Your current avatar" => "Ваш сучасний аватар",
"Pick avatar from the library" => "Виберіть аватар з бібліотеки",
"Show all" => "Показати всі",
"Avatar Image" => "Фото",
"random" => "довільно",
"Upload your own avatar" => "Вивантажити власний аватар",
"lastModif" => "останніЗміни",
"Average" => "Середнє",
"View Results" => "Див. результати",
"Vote poll" => "Голосувати в опитуванні",
"Other Polls" => "Інші опитування",
"Print multiple pages" => "Друкувати кілька сторінок",
"Print Wiki Pages" => "Друкувати сторінки Вікі",
"clear" => "очистити",
"Quiz result stats" => "Статистика результатів контрольної",
"Quiz" => "Контрольна",
"Time" => "Час",
"User answers" => "Відповіді користувачів",
"Stats for quizzes" => "Статистика контрольних",
"taken" => "участь",
"Av score" => "Сер. бал",
"Av time" => "Сер. час",
"Stats for quiz" => "Статист. контрольних",
"clear stats" => "обнилити стат.",
"Stats for this quiz Questions " => "Статистика по питанням цієї контрольної",
"Top 10" => "10 найвищих",
"Top 20" => "20 найвищих",
"Top 50" => "50 найвищих",
"Top 100" => "100 найвищих",
"Received Articles" => "Отримані статті",
"received articles tpl" => "шаблон отриманих новин",
"Edit received article" => "Редагувати отримані статті",
"Use Image" => "Використати зображення",
"Image x size" => "Розмір по x",
"Image y size" => "Розмір по y",
"Image name" => "Назва зображення",
"Accept Article" => "Прийняти статтю",
"Site" => "Майданчик",
"received pages tpl" => "шаблон отриманих сторінок",
"Edit received page" => "Редагувати отриману сторінку",
"last" => "останній",
"I forgot my password" => "Я забув мій пароль",
"send me my password" => "надіслати мені пароль",
"Return to HomePage" => "Повернутися до Домашньої сторінки",
"Remove page" => "Видалити сторінку",
"You are about to remove the page" => "Ви збираєтесь видалити сторінку",
"permanently" => "назавжди",
"Remove all versions of this page" => "Видалити всі версії даної сторінки",
"Rename page" => "Змінити назву сторінки",
"Rollback page" => "До попередньої версії",
"to_version" => "до_версії",
"Search Stats" => "Шукати статистику",
"search stats tpl" => "шаблон статистик пошуків",
"searched" => "провадився пошук",
"Search in" => "Пошук в",
"galleries" => "галереях",
"blog posts" => "записах журналів",
"articles" => "статтях",
"Simple search" => "Простий пошук",
"No pages matched the search criteria" => "Нема сторінок, що відповідають критеріям пошуку",
"Send blog post" => "Надіслати публікацію журнала",
"A link to this post was sent to the following addresses:" => "Посилання на цю публікацію було надіслане за такими адресами:",
"Send post to this addresses" => "Надіслати публікацію на ці адреси",
"List of email addresses separated by commas" => "Список поштових адрес, розділених комами",
"Send objects" => "Відіслати об'єкти",
"admin send objects tpl" => "шаблон адміністрування відсилання об'єктів",
"Transmission results" => "Результати пересилання",
"Send objects to this site" => "Надіслати об'єкти на цей майданчик",
"site" => "майданчик",
"password" => "пароль",
"Send Wiki Pages" => "Надіслати сторінки Вікі",
"Send Articles" => "Надіслати статті",
"add article" => "додати статтю",
"Post or edit a message" => "Опублікувати чи редагувати повідомлення",
"Site Stats" => "Статистика майданчика",
"Days online" => "Днів неперервної роботи",
"Total pageviews" => "Всього переглядів сторінок",
"Average pageviews per day" => "Середня кількість переглядів на день",
"Best day" => "Найкращий день",
"Worst day" => "Найгірший день",
"Wiki Stats" => "Статистика Вікі",
"Size of Wiki Pages" => "Розмір сторінок Вікі",
"Mb" => "МБ",
"Average page length" => "Середня довжина сторінки",
"bytes" => "байт",
"Average versions per page" => "Середня кількість версій на сторінку",
"Visits to wiki pages" => "Відвідувань сторінок Вікі",
"Average links per page" => "Середня кількість посилань на сторінку",
"Image galleries Stats" => "Статистика гарелей зображень",
"Average images per gallery" => "Середня кількість зображень на сторінку",
"Total size of images" => "Загальний розмір зображень",
"Average image size" => "Середній розмір зображення",
"Visits to image galleries" => "Відвідувань до галерей зображень",
"File galleries Stats" => "Статистика галерей файлів",
"Average files per gallery" => "В середньому файлів на галерею",
"Total size of files" => "Сумарний розмір файлів",
"Average file size" => "Середній розмір файла",
"Visits to file galleries" => "Відвідувань галерей файлів",
"Total reads" => "Всього переглядів",
"Average reads per article" => "Середня кількість переглядів статті",
"Total articles size" => "Сумарний розмір статей",
"Average article size" => "Середній розмір статті",
"Forum Stats" => "Статистика форуму",
"Total topics" => "Всього тем",
"Average topics per forums" => "Середня кількість тем на форум",
"Total threads" => "Всього дискусій",
"Average threads per topic" => "Середня кількість дискусій на тему",
"Visits to forums" => "Відвідувань форумів",
"Blog Stats" => "Статистика журналів",
"Weblogs" => "Веб-журнали",
"Total posts" => "Всього поблікацій",
"Average posts per weblog" => "Середня кількість повідомлень в журналі",
"Total size of blog posts" => "Сумарний розмір публікацій журналів",
"Average posts size" => "Середній розмір публікації",
"Visits to weblogs" => "Відвідувань веб-журналів",
"Poll Stats" => "Статистика опитувань",
"Total votes" => "Всього надано голосів",
"Average votes per poll" => "Середня кількість голосів на опитування",
"Faq Stats" => "Статистика ЧАП'ів",
"Total questions" => "Всього запитань",
"Average questions per FAQ" => "Середня кількість питань на ЧАП",
"User Stats" => "Статистика користувачів",
"User bookmarks" => "Закладки користувачів",
"Average bookmarks per user" => "Середня кількість закладок на користувача",
"Quiz Stats" => "Статистика контрольних",
"Average questions per quiz" => "Середня кількість питань на контрольну",
"Average quiz score" => "Середній бал контрольних",
"Average time per quiz" => "Середній час на контрольну",
"Object" => "Об'єкт",
"Usage chart" => "Діаграма використання",
"Stats for surveys" => "Статистика опитувань",
"Survey" => "Огляди",
"Stats for survey" => "Статистика опитування",
"Stats for this survey Questions " => "Статистика для цього питання опитування",
"Time Left" => "Часу залишилось",
"send answers" => "надіслати відповіді",
"Result" => "Результат",
"Theme Control Center: categories" => "Центр керування темами: категорії",
"ThemeControl" => "Керування темами",
"ThemeControl tpl" => "шаблон Керування темами",
"Theme is selected as follows" => "Тема вибрана наступним чином",
"If a theme is assigned to the individual object that theme is used." => "Якщо окремому об'єкту призначена тема, то вона буде використана.",
"If not then if a theme is assigned to the object's category that theme is used" => "Якщо ні, тоді буде використана тема, призначена категорії, до якої належить об'єкт",
"If not then a theme for the section is used" => "Якщо немає, тоді буде використана тема призначена для розділу",
"If none of the above was selected the user theme is used" => "Якщо нічого з переліченого не знайдено, тоді буде використовуватися тема користувача",
"Finally if the user didn't select a theme the default theme is used" => "І нарешті, якщо користувач не встановив для себе особистої теми, буде використовуватися стандартна",
"Control by Sections" => "Керування розділами",
"Assign themes to categories" => "Назначити теми категоріям",
"Assigned categories" => "Призначені категорії",
"theme" => "тема",
"Theme Control Center: Objects" => "Центр керування темами: Об'єкти",
"ThemeControl Objects" => "Об'єкти КеруванняТемами",
"theme control objects tpl" => "шаблон об'єктів керування темами",
"Control by Categories" => "Керування по категоріям",
"Assign themes to objects" => "Призначити теми об'єктам",
"Assigned objects" => "Призначені об'єкти",
"Theme Control Center: sections" => "Центр керування темами: розділи",
"theme control sections tpl" => "шаблон розділів керування темами",
"Assign themes to sections" => "Призначити теми розділам",
"Assigned sections" => "Призначені розділи",
"Upload File" => "Вивантажити файл",
"File Title" => "Заголовок файлу",
"Now enter the file URL" => "Тепер введіть URL файла",
" or upload a local file from your disk" => "чи вивантажте його з локального диску",
"The following file was successfully uploaded" => "Цей файл був успішно вивантажений",
"You can download this file using" => "Ви можете звантажити цей файл за ",
"You can include the file in an HTML/Tiki page using" => "У HTML чи Вікі файл можна включити таким виразом",
"Image Gallery tpl" => "Шабл. Галереї фото",
"Now enter the image URL" => "Введіть URL зображення",
" or upload a local image from your disk" => "або вивантажте зображення з локального диску",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Піктограма (необов'язково, відміняє автоматичне генерування піктограми)",
"Upload successful!" => "Вивантаження успішне",
"The following image was successfully uploaded" => "Це зображення було успішно відвантажено",
"Thumbnail" => "Піктограма",
"Image ID thumb" => "Піктогр. ID зображення",
"User assigned modules" => "Призначені користувачу модулі",
"User Assigned Modules" => "Назначені користувачеві модулі",
"User Assigned Modules tpl" => "Шаблон модулів призначених користувачеві",
"Restore defaults" => "Відновити стандартні",
"move to right column" => "пересунути в правий стовпчик",
"unassign" => "відмінити призначення",
"move to left column" => "пересунути в лівий стовпчик",
"Assign module" => "Призначити модуль",
"Module" => "Модуль",
"Column" => "Стовпчик",
"User Bookmarks tpl" => "Шаблон закладок користувача",
"Current folder" => "Поточна тека",
"Folders" => "Теки",
"remove folder" => "видалити теку",
"refresh cache" => "поновити кеш",
"Admin folders and bookmarks" => "Адмініструвати теки і закладки",
"Add or edit folder" => "Додати чи редагувати теку",
"Add or edit a URL" => "Додати чи редагувати URL",
"Avatar" => "Аватар",
"Personal Wiki Page" => "Особиста сторінка Вікі",
"Displayed time zone" => "Часовий пояс, що показується",
"Send me a message" => "Пошліть мені листа",
"User Preferences" => "Уподобання користувача",
"UserPreferences tpl" => "Шаблон установок користувача",
"Pick user Avatar" => "Вибрати аватар користувача",
"HomePage" => "Домашня сторінка",
"Your personal Wiki Page" => "Ваша особиста сторінка Вікі",
"Is email public? (uses scrambling to prevent spam)" => "Поштова адреса відкрита? (для запобігання спаму буде спотворена)",
"Number of visited pages to remember" => "Пам'ятати число останній відвіданих сторінок",
"Local" => "Місцевий",
"User information" => "Інформація користувача",
"private" => "особиста",
"public" => "відкрита",
"Messages per page" => "Листів на сторінку",
"Allow messages from other users" => "Дозволити повідомлення від інших користувачів",
"Send me an email for messages with priority equal or greater than" => "Надсилати мені повідомлення з пріоритетом рівним чи більшим за",
"Tasks per page" => "Завдань на сторінку",
"My messages" => "Мої повідомлення",
"User Tasks tpl" => "Шаблон задач користувача",
"Percentage completed" => "Відсоток завершеного",
"priority" => "пріоритет",
"No tasks entered" => "Не введено завдань",
"May need to refresh twice to see changes" => "Можливо потрібно освіжити вигляд, щоб побачити зміни",
"Add top level bookmarks to menu" => "Додати закладки найвищого рівня до меню",
"Mode" => "Режим",
"replace window" => "замінити вікно",
"no comments" => "нема коментарів",
"Banner stats" => "Статистика транспарантів",
"Create new banner" => "Створити новий транспарант",
"Banner Information" => "Інформація про транспарант",
"Click ratio" => "Відношення клацань",
"Weekdays" => "Робочі дні",
"mon" => "пон",
"tue" => "вів",
"wed" => "сер",
"thu" => "чет",
"fri" => "птн",
"sat" => "суб",
"sun" => "нед",
"Banner raw data" => "Сирі дані транспаранта",
"Cached" => "Кешовано",
"This is a cached version of the page." => "Це кешована версія сторінки.",
"Click here to view the Google cache of the page instead." => "Щоб побачити кешовану сторінку на Google, клацніть тут.",
"viewed" => "переглянуто",
"edit items" => "редагувати пункти",
"list charts" => "список діаграм",
"last chart" => "остання діаграма",
"previous chart" => "попередня діаграма",
"Chart created" => "Діаграма створена",
"next chart" => "наступна діаграма",
"item" => "пункт",
"chg" => "змн",
"avg" => "срд",
"Next chart will be generated on" => "Наступна діаграма буде згенерована на:",
"Select something to vote on" => "Виберіть що небудь для голосування",
"Item information" => "Інформація про пункт",
"Chart" => "Діаграма",
"Permanency" => "Постійність",
"Dif" => "Різн",
"Best Position" => "Найкраще положення",
"Vote this item" => "Проголосуйте за цей пункт",
"Highest" => "Найвищий",
"view faq" => "див. ЧАП",
"view faq tpl" => "шабл. перегляду ЧАП",
"admin menus tpl" => "шабл. адмін. меню",
"Q" => "З",
"A" => "В",
"Forum List" => "Список форумів",
"Edit Forum" => "Редагувати форум",
"monitor this forum" => "моніторинг цього форуму",
"stop monitoring this forum" => "зупинити моніторинг цього форуму",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Ваше повідомлення покладене в чергу на затвердження. \nПовідомлення буде опубліковане після тогоо, як адміністратор затвердить його.",
"You have to enter a title and text" => "Потрібно ввести заголовок і текст",
"post new comment" => "опублікувати новий коментар",
"Summary" => "Підсумок",
"HTML tags are not allowed inside comments" => "Всередині коментарів не дозволяються бирки HTML ",
"moderator actions" => "дії цензора",
"move selected topics" => "пересунути вибрані теми",
"unlock selected topics" => "відімкнути вибрані теми",
"lock selected topics" => "замкнути вибрані теми",
"delete selected topics" => "видалити вибрані теми",
"merge" => "об'єднати",
"merge selected topics" => "об'єднати вибрані теми",
"queued messages:" => "повідомлення в черзі:",
"Merge into topic" => "Об'єднати в тему",
"No topics yet" => "Ще немає тем",
"topics in this forum" => "теми цього форуму",
"Show posts" => "Показати публікації",
"Last hour" => "Остання година",
"Last 24 hours" => "Останнні 24 години",
"Last 48 hours" => "Останні 48 годин",
"Jump to forum" => "Перейти до форуму",
" unread private messages" => "непрочитаних приватних повідомлень",
"prev topic" => "попередня тема",
"next topic" => "наступна тема",
"monitor this topic" => "слідкувати за цією темою",
"stop monitoring this topic" => "припинити слідкування за цією темою",
"Comments below your current threshold" => "Коментарі, які не пройшли через пропускний погіш",
"IRC log" => "журнал IRC",
"Select" => "Вибрати",
"Show All" => "Показати все",
"Insert new item" => "Вставити новий пункт",
"View item" => "Переглянути пункт",
"Add a comment" => "Додати коментар",
"Attach a file to this item" => "Долучити файл до цього пункту",
"No attachments for this item" => "Цей пункт не має долучень",
"Webmail Doc" => "Документація Веб-пошти",
"settings" => "установки",
"mailbox" => "скринька",
"compose" => "створити",
"contacts" => "контакти",
"Contacts" => "Контакти",
"Add new mail account" => "Додати новий поштовий рахунок",
"User accounts" => "Рахунки користувачів",
"account" => "рахунок",
"View All" => "Дивитись всі",
"Msg" => "Лст",
"clip" => "вирізка",
"back to mailbox" => "повернутися до скриньки",
"full headers" => "всі заголовки",
"normal headers" => "звичайні заголовки",
"reply all" => "відповідь всім",
"forward" => "переслати",
"Create/edit contacts" => "Створити/ред контакти",
"First Name" => "Ім'я",
"Last Name" => "Прізвище",
"select from address book" => "вибрати з записника",
"cc" => "копія",
"bcc" => "приватна копія",
"Use HTML mail" => "Вживати HTML в листах",
"The following addresses are not in your address book" => "Ці адреси не знайдені у Вашому записнику",
"add contacts" => "додати контакти",
"Attachment 1" => "Долучення 1",
"Attachment 2" => "Долучення 2",
"Attachment 3" => "Долучення 3",
"Address book" => "Записник",
"General preferences and settings" => "Загальні установки та конфіґурація",
"Wiki settings" => "Установки Вікі",
"Poll comments settings" => "Установки коментарів опитувань",
"Forums settings" => "Установки форумів",
"No chart indicated" => "Не вказано графіків",
"Upload failed" => "Вивантаження неуспішне",
"No page indicated" => "Не вказано сторінки",
"The passwords don't match" => "Паролі не співпадають",
"Password should be at least" => "Пароль повинен бути хоча б",
"characters long" => "символів завдовжки",
"Your admin password has been changed" => "Ваш пароль адміністратора було змінено",
"DATE-of" => "з",
"Tag already exists" => "Бирка вже існує",
"Tag not found" => "Не знайдено бирку",
"No repository" => "Немає сховища",
"Search is mandatory field" => "Поле пошуку обов'язкове",
"No menu indicated" => "Не вказане меню",
"No newsletter indicated" => "Не вказано бюлетня",
"No poll indicated" => "Не вказано опитування",
"page not added (Exists)" => "сторінка не додана (Існує)",
"No survey indicated" => "Не вказано огляд",
"No tracker indicated" => "Не вказаний тракер",
"Group already exists" => "Група вже існує",
"No records were found. Check the file please!" => "Не знайдено записів. Перевірте файл, будь ласка!",
"User login is required" => "Ім'я користувача вимагається",
"Password is required" => "Пароль обов'язковий",
"Email is required" => "Адреса ел. пошти обов'язкова",
"User is duplicated" => "Подвійний користувач",
"User already exists" => "Користувач вже існує",
"The passwords dont match" => "Паролі не співпадаються",
"Password must contain both letters and numbers" => "Пароль повинен складатися з літер і цифр",
"Permission denied you cannot view this section" => "Немає дозволу, Ви не можете переглядати цей роздів",
"Unknown group" => "Невідома група",
"Group doesnt exist" => "Неіснуюча група",
"Unknown user" => "Неіснуючий користувач",
"User doesnt exist" => "Користувач не існує",
"Permission denied you cannot view backlinks for this page" => "Немає дозволу: Вам не дозволено встановлювати зворотні посилання",
"The page cannot be found" => "Сторінка не знайдена",
"Permission denied you cannot post" => "Немає дозволу: Вам не дозволено публікувати",
"Permission denied you cannot edit this post" => "Немає дозволу: Вам не дозволено редагувати повідомлення",
"You can't post in any blog maybe you have to create a blog first" => "Ви не можете публікувати в жодному з журналів -- можливо спочатку Вам потрібно створити журнал",
"Top visited blogs" => "Журнали з найчастішими відвідуванням",
"Last posts" => "Останні повідомлення",
"Top active blogs" => "Найактивніші журнали",
"No blogId specified" => "Не вказано blogId",
"TOP" => "ВЕРШИНА",
"Permission denied you cannot access this gallery" => "Немає дозволу: доступ до галереї заборонений",
"No gallery indicated" => "Не вказано галереї",
"Permission denied you cannot view this page" => "Немає дозволу: не можна дивитись цю сторінку",
"Permission denied you can not view this section" => " Вам не дозволено переглядати цей розділ. Немає дозволу",
"Permission denied you cannot remove images from this gallery" => "Немає дозволу: Ви не можете стирати зображення з цієї галереї",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Немає дозволу: Ви не можете перебудовувати піктограми в цій галереї",
"Permission denied you cannot rotate images in this gallery" => "Немає дозволу: Ви не можете перевертати зображення в цій галереї",
"No image indicated" => "Не вказано зображення",
"Permission denied you cannot move images from this gallery" => "Немає дозволу: Ви не можете переміщати зображення з цієї галереї",
"Permission denied you cannot view the calendar" => "Немає дозволу: Вам не дозволено дивитись календар",
"event without name" => "подія без назви",
"You can not use the same password again" => "Не можна використовувати той же пароль",
"Invalid old password" => "Старий пароль невірний",
"Permission denied to use this feature" => "Немає дозволу на користування цією функцією",
"No channel indicated" => "Не вказаний канал",
"No nickname indicated" => "Не вказане псевдо",
"Top authors" => "Найпопулярніші автори",
"Message sent to" => "Повідомлення надіслане до ",
"This feature has been disabled" => "Ця функція неактивізована",
"Must enter a name to add a site" => "Щоб додати адресу майданчика потрібно ввести назву",
"Must enter a url to add a site" => "Щоб додати адресу майданчика потрібно ввести адресу (URL)",
"URL already added to the directory. Duplicate site?" => "Такий URL вже існує в директорії. Додати ще один?",
"Must select a category" => "Потрібно вибрати категорію",
"No site indicated" => "Не вказано майданчика",
"You can not download files" => "Ви не можете звантажувати файли",
"Permission denied you cannot edit this article" => "Немає дозволу: Вам не дозволено редагувати цю статтю",
"You do not have permissions to edit banners" => "Немає дозволу: Вам не дозволено редагувати плакати",
"Banner not found" => "Не знайдено плакат",
"You do not have permission to edit this banner" => "Ви не маєте дозволу для редагування цього плаката",
"Permission denied you cannot create or edit blogs" => "Немає дозволу: Вам не дозволено редагувати чи створювати журнали",
"Permission denied you cannot edit this blog" => "Немає дозволу: Вам не дозволено редагувати цей журнал",
"You do not have permission to write the style sheet" => "Вам не надано дозволу на редагування таблиць стилів",
"Invalid request to edit an image" => "Некоректний запит на редагування зображення",
"Permission denied you cannot edit images" => "Немає дозволу: Ви не можете редагувати зображення",
"Permission denied you can edit images but not in this gallery" => "Немає дозволу: Ви можете редагувати зображення, але не в цій галереї",
"Failed to edit the image" => "Неможливо редагувати зображення",
"Shortname must be 2 Characters" => "Коротка назва має складатися з 2 символів ",
"You must provide a longname" => "Ви повинні надати довгу назву",
"Language created" => "Мова створена",
"No content id indicated" => "Не вказано ID змісту ",
"No question indicated" => "Не вказано запитання",
"No quiz indicated" => "Не вказано вікторину",
"No structure indicated" => "Не вказано структуру",
"Permission denied you cannot send submissions" => "Немає дозволу: Ви не можете робити подання",
"Permission denied you cannot edit submissions" => "Немає дозволу: Ви не можете редагувати подання",
"You have to create a topic first" => "Вам потрібно спочатку створити тему",
"You do not have permission to do that" => "У Вас немає дозволу робити це",
"You do not have permission to read the template" => "У Вас немає дозволу читати шаблон",
"No topic id specified" => "Не вказано ID теми ",
"Invalid topic id specified" => "Вказано некоректну ID теми ",
"Article not found" => "Стаття не знайдена",
"Permission denied you cannot edit this page" => "Немає дозволу: Ви не можете редагувати цю сторінку",
"page imported" => "сторінку імпортовано",
"created from import" => "створено з імпортованого",
"You cannot edit this page because it is a user personal page" => "Ви не можете редагувати цю сторінку, бо це персональна сторінка користувача",
"The SandBox is disabled" => "Чернетка заборонена",
"Cannot edit page because it is locked" => "Не можливо редагувати цю сторінку оскільки вона замкнена",
"Permission denied you cannot create galleries and so you cant edit them" => "Немає дозволу: Ви не можете створювати галереї, отже і не можете редагувати також",
"Permission denied you cannot edit this gallery" => "Немає дозволу: Ви не можете редагувати цю галерею",
"Permission denied you cannot remove this gallery" => "Немає дозволу: Ви не можете стирати цю галерею",
"Top visited file galleries" => "Найчастіше відвідувані галереї файлів",
"Most downloaded files" => "Файли, що найчастіше звантажуються",
"Last files" => "Найновіші файли",
"No galleryId specified" => "Не вказано galleryId ",
"No forum indicated" => "Не вказано форуму",
"Forum posts" => "Публікації форуму",
"No forumId specified" => "Не вказано forumId",
"Invalid username" => "Ім'я користувача невірне",
"No process indicated" => "Не вказаний процес",
"Activity name already exists" => "Назва активності вже існує",
"indicates if the process is active. Invalid processes cant be active" => "вказує, що процес вже активізовано. Некоректні процеси не можуть бути активними",
"No instance indicated" => "Не вказано екземпляру",
"No activity indicated" => "Не вказана активність",
"The process name already exists" => "Назва процесу вже існує",
"Process already exists" => "Процес вже існує",
"You cant execute this activity" => "Ви не можете виконувати цю дію",
"No user indicated" => "Не вказано користувача",
"No item indicated" => "Не вказано пункт",
"Top images" => "Найпопулярніші зображення",
"Last images" => "Найновіші зображення",
"overwriting old page" => "переписую стару сторінку",
"page created" => "сторінка створена",
"No repository given" => "Не дано назви сховища",
"Permission denied you cannot view pages like this page" => "Немає дозволу: Ви не можете переглядати сторінки подібні до цієї",
"Permission denied you cannot remove articles" => "Немає дозволу: Ви не можете стирати статті",
"Permission denied you cannot remove banners" => "Немає дозволу: Ви не можете стирати плакати",
"Permission denied you cannot remove this blog" => "Немає дозволу: Ви не можете стерти цей журнал",
"Permission denied you cannot remove files from this gallery" => "Немає дозволу: Ви не можете стирати файли з цієї галереї",
"Permission denied you can't upload files so you can't edit them" => "Немає дозволу: Ви не можете вивантажувати файли сюди, отже не можете також і редагувати їх",
"Permission denied you cannot edit this file" => "Немає дозволу: Ви не можете редагувати цей файл",
"The thumbnail name must be" => "Назва піктограми повинна",
"You cannot admin blogs" => "Ви не можете адмінструвати журнали",
"Permission denied you cannot remove submissions" => "Немає дозволу: Ви не можете стирати подання",
"Permission denied you cannot approve submissions" => "Немає дозволу: Ви не можете затверджувати подання",
"Permission denied you cannot view pages" => "Немає дозволу: Ви не можете переглядати сторінки",
"Permission denied you cannot remove pages" => "Немає дозволу: Ви не можете стирати сторінки",
"changed" => "змінена",
"You do not have permissions to view the maps" => "У Вас немає дозволів для перегляду мап",
"mapfile name incorrect" => "Невірна назва файлу мапи",
"This mapfile already exists" => "Цей  файл мапи же існує",
"You do not have permission to delete the mapfile" => "У Вас немає дозволів для стирання файлу мапи",
"You do not have permission to read the mapfile" => "У Вас немає дозволів для перегляду файлу мапи",
"You do not have permissions to view the layers" => "У Вас немає дозволів для перегляду шарів",
"Could not upload the file" => "Не вдалось вивантажити файл",
"You do not have permissions to delete a file" => "У Вас немає дозволів для стирання файлу",
"File not found" => "Не знайдено файл",
"You do not have permissions to create a directory" => "У Вас немає дозволів для створення теки",
"The Directory is not empty" => "Тека не порожня",
"You do not have permissions to delete a directory" => "У Вас немає дозволів для стирання теки",
"Must be logged to use this feature" => "Потрібно зареєструватись, щоб користуватись цим",
"Welcome at Hawiki" => "Ласкаво просимо до Hawiki",
"This TikiWiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Цей майданчик ТікіВікі підготовлений для доступу з багатьох мобільних пристроїв, таких, наприклад, як телефони WAP, персональні інформаційні системи (PDA), пристрої i-mode  та інші.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "Ви можете переглядати цей майданчик з Вашого портативного пристрою у переглядачі інтернет сторінок, якщо спрямуєте його за цим URL:",
"About" => "Про",
"You must log in to use this feature" => "Вам потрібно зареєструватись, щоб користуватись цим",
"You do not have permission to view other users data" => "У Вас немає дозволу для доступу до даних інших користувачів",
"You must be logged in to subscribe to newsletters" => "Вам потрібно зареєструватись щоб підписуватись на листки новин",
"No server indicated" => "Не вказано сервер",
"Cannot connect to" => "Неможливо з'єднатись з",
"Missing information to read news (server,port,username,password,group) required" => "Відсутня інформація для читання новин (сервер, порт, ім'я користувача, пароль, група)",
"Cannot get messages" => "Неможливо прочитати повідомлення",
"No note indicated" => "Не вказана замітка",
"merged note:" => "об'єднані замітки:",
"File is too big" => "Файл завеликий",
"created from notepad" => "створено з нотатника",
"No name indicated for wiki page" => "Не вказана назва для сторінки вікі",
"Page already exists" => "Сторінка вже існує",
"Permission denied you cannot assign permissions for this page" => "Немає дозволу: Ви не можете назначати дозволи доступу цієї сторінки",
"Not enough information to display this page" => "Недостатньо інформації для показу цієї сторінки",
"Permission denied you cannot browse this page history" => "Немає дозволу: Ви не можете переглядати історію сторінки",
"No article indicated" => "Не вказана стаття",
"Article is not published yet" => "Стаття ще не опублікована",
"No post indicated" => "Не вказане повідомлення",
"Blog not found" => "Журнал не знайдено",
"No pages indicated" => "Не вказані сторінки",
"No result indicated" => "Не вказаний результат",
"Permision denied" => "Немає дозволу",
"Wrong registration code" => "Код реєстрації некоректний",
"Username is too long" => "Задовге ім'я користувача",
"Username cannot contain whitespace" => "Ім'я користувача не може містити пропуски",
"Wrong passcode you need to know the passcode to register in this site" => "Невірний пароль: щоб отримати доступ до цього майданчику Вам потрібно знати фразу-пропуск",
"Invalid email address. You must enter a valid email address" => "Некоректна адреса ел. пошти. Вам потрібно ввести справжню адресу.",
"to the registered email address for" => "на зареєстровану адресу для ",
"Invalid or unknown username" => "Невірне чи невідоме ім'я користувача",
"Permission denied you cannot remove versions from this page" => "Немає дозволу: Ви не можете стирати версії з цієї сторінки",
"Cannot rename page maybe new page already exists" => "Неможливо змінити назву сторінки. Можливо нова сторінка вже існує",
"Permission denied you cannot rollback this page" => "Немає дозволу: Ви не можете відкотити версію цієї сторінки",
"Post recommendation at" => "Опублікувати рекомендації на ",
" successfully sent" => " успішно відіслано ",
" not sent" => " не відіслано",
"You do not have permission to edit messages" => "У Вас немає дозволу редагувати повідомлення",
"Page must be defined inside a structure to use this feature" => "Щоб користуватись цією функцією, сторінка повинна бути визначена всередині структури",
"You cannot take this quiz twice" => "Цю вікторину не можна проходити двічі",
"You cannot take this survey twice" => "Цей огляд не можна проходити двічі",
"Please create a category first" => "Будь ласка, спершу створіть категорію",
"Invalid filename (using filters for filenames)" => "Некоретна назва файлу (використовуються фільтри для назв файлів)",
"No permission to upload zipped file packages" => "Немає дозволу на вивантаження файлів пакунків у форматі ZIP",
"Cannot read file" => "Не читається файл",
"Permission denied you cannot upload files" => "Немає дозволу: Вам не дозволено вивантажувати файли",
"Permission denied you can upload files but not to this file gallery" => "Немає дозволу: Вам дозволено вивантажувати файли, але не в цій галереї",
"Error processing zipped image package" => "Помилка обробки файлу в форматі ZIP",
"No permission to upload zipped image packages" => "Немає дозволу на вивантаження файлів пакунків у форматі ZIP",
"Permission denied you cannot upload images" => "Немає дозволу: Вам не дозволено вивантажувати зображення",
"Permission denied you can upload images but not to this gallery" => "Немає дозволу: Вам дозволено вивантажувати зображення, але не в цій галереї",
"Cannot get image from URL" => "Неможливо отримати зображення з URL",
"cannot process upload" => "неможливо продовжити вивантаження",
"No url indicated" => "Не вказаний URL",
"You are not logged in and no user indicated" => "Ви не зареєстровані і не вказане ім'я користувача",
"The passwords did not match" => "Паролі не співпадають",
"Cannot upload this file not enough quota" => "Неможливо вивантажити цей файл: недостатня квота",
"No banner indicated" => "Не вказаний плакат",
"No blog indicated" => "Журнал не вказаний",
"Permission denied you cannot remove the post" => "Немає дозволу: Вам не дозволено стирати публікацію",
"No cache information available" => "Немає інформації про кеш",
"No faq indicated" => "ЧАП не вказаний",
"You are not permitted to remove someone else\\'s post!" => "Вам не дозволено стирати чужі повідомлення!",
"Wrong password. Cannot post comment" => "Пароль невірний. Неможливо опублікувати повідомлення.",
"Please wait 2 minutes between posts" => "Будь ласка, зачекайте 2 хвилини між публікаціями",
"No thread indicated" => "Не вказана низка",
"Your email address has been removed from the list of addresses monitoring this tracker" => "Адреса Вашої електронної пошти видалена з списку адрес доступних для моніторингу",
"Your email address has been added to the list of addresses monitoring this tracker" => "Ваша поштова адреса додана до списку адрес нагляду за цим тракером",
"Cancel monitoring" => "Відміниьи моніторинг",
"Monitor" => "Монітор",
"Your email address has been removed from the list of addresses monitoring this item" => "Адреса Вашої електронної пошти видалена з списку адрес, які наглядають за цим пунктом",
"Your email address has been added to the list of addresses monitoring this item" => "Адреса Вашої електронної пошти додана до списку адрес, які наглядають за цим пунктом",
"No subject" => "Без теми",
"Your email was sent" => "Ваш лист відправлено",
"Top pages" => "Найпопулярніші сторінки",
"Last pages" => "Найновіші сторінки",
"###end###"=>"###end###");
?>
