# Copyright (C) 2003 by Intevation GmbH
# Authors:
# Jan-Oliver Wagner <jan@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
Extend Thuban with a sample Hello World to demonstrate simple
extensions.
"""

__version__ = '$Revision: 1.1 $'

# use _() already now for all strings that may later be translated
from Thuban import _

# Thuban has named commands which can be registered in the central
# instance registry.
from Thuban.UI.command import registry, Command

# The instance of the main menu of the Thuban application
# See Thuban/UI/menu.py for the API of the Menu class
from Thuban.UI.mainwindow import main_menu

def hello_world_dialog(context):
    """Just raise a simple dialog to greet the world.

    context -- The Thuban context.
    """
    context.mainwindow.RunMessageBox(_('Hello World'), _('Hello World!'))


# create a new command and register it
registry.Add(Command('hello_world', _('Hello World'), hello_world_dialog,
                     helptext = _('Welcome everyone on this planet')))

# find the extensions menu (create it anew if not found)
extensions_menu = main_menu.find_menu('extensions')
if extensions_menu is None:
    extensions_menu = main_menu.InsertMenu('extensions', _('E&xtensions'))

# finally bind the new command with an entry in the extensions menu
extensions_menu.InsertItem('hello_world')
