/*
 *  Copyright (C) 2000 by Marco G"otze.
 *
 *  This code is part of the ThoughtTracker source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#ifndef FONTDLG_H_INCLUDED
#define FONTDLG_H_INCLUDED

#include <string>

#include <gtk--/fontselection.h>

#include "thoughttracker.h"

class TTFontDialog : public Gtk::FontSelectionDialog {
  public:
    TTFontDialog(Gtk::Window *transient, const string &title = 0);
    virtual ~TTFontDialog() {};

    /* runs the dialog modally and returns the chosen font or a zero-length
       string */
    virtual string run();

  private:
    int done;  // 0 = no, 1 = OK, 2 = Cancel

    /* handles buttons */
    virtual void btn_ok() { done = 1; };
    virtual void btn_cancel() { done = 2; };

    /* handles "delete" events */
    virtual int delete_event_impl(GdkEventAny *event) {
      done = 2;
      return 0;
    }
};

#endif  /* FONTDLG_H_INCLUDED */

