/***************************************************************************
                             th-job.h
                             --------
    begin                : Tue Nov 09 2004
    copyright            : (C) 2004 by Tim-Philipp Mller
    email                : tim centricular net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _th_job_h_included_
#define _th_job_h_included_

#include <glib-object.h>

#define TH_TYPE_JOB             (th_job_get_type())
#define TH_JOB(obj)             (G_TYPE_CHECK_INSTANCE_CAST (obj,  TH_TYPE_JOB, ThJob))
#define TH_JOB_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST (klass,   TH_TYPE_JOB, ThJobClass))
#define TH_IS_JOB(obj)          (G_TYPE_CHECK_INSTANCE_TYPE (obj,  TH_TYPE_JOB))
#define TH_IS_JOB_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), TH_TYPE_JOB))

typedef enum
{
	TH_PICTURE_SIZE_XSMALL = 0,   /* 1/8, 0.125, e.g.  96 x  72  */
	TH_PICTURE_SIZE_SMALL,        /* 1/4, 0.250, e.g. 192 x 144  */
	TH_PICTURE_SIZE_MEDIUM_SMALL, /* 1/2, 0.500, e.g. 384 x 288  */
	TH_PICTURE_SIZE_MEDIUM_LARGE, /* 2/3, 0.666, e.g. 512 x 384  */
	TH_PICTURE_SIZE_LARGE,        /* 3/4, 0.750, e.g. 576 x 432  */
	TH_PICTURE_SIZE_XLARGE,       /* 5/6, 0.833, e.g. 640 x 480  */
	TH_PICTURE_SIZE_FULL          /* 1/1, 1.000, e.g. 768 x 576  */
} ThPictureSize;


typedef struct _ThJob        ThJob;
typedef struct _ThJobClass   ThJobClass;
typedef struct _ThJobPrivate ThJobPrivate;

struct _ThJob
{
	GObject        object;
	
	ThJobPrivate  *priv;
};

struct _ThJobClass
{
	GObjectClass  parent_class;
	
	void        (*out_of_disk_space) (ThJob *job);
};

/* functions */

GType         th_job_get_type (void) G_GNUC_CONST;

ThJob        *th_job_new (const gchar *device,
                          const gchar *title_id,
                          guint        title, 
                          guint        len_secs, 
                          guint        num_chapters, 
                          guint        raw_size_x, 
                          guint        raw_size_y);

gboolean      th_job_save_config (ThJob *job);

gboolean      th_job_run (ThJob *j, GError **err);

void          th_job_cancel (ThJob *j, gboolean remove_partial_file);

gboolean      th_job_get_effective_picture_size (ThJob         *job, 
                                                 ThPictureSize  picsize, 
                                                 guint         *p_width, 
                                                 guint         *p_height);

void          th_job_get_file_size_range (ThJob *job, gdouble *p_min_size, gdouble *p_max_size);

void          th_job_set_filename_from_disc_title (ThJob *j, const gchar *disc_title);

void          th_job_add_audio_stream (ThJob *j, guint aid, const gchar *pad_name, const gchar *lang, const gchar *description);

gboolean      th_job_get_audio_stream (ThJob *j, guint n, guint *p_aid, const gchar **p_lang, const gchar **p_desc);

gchar        *th_job_get_default_title (ThJob *j);

#endif /* _th_job_h_included_ */

