/***************************************************************************
                             th-yuvscale.h
                             -------------
    begin                : Wed Jan 12 2005
    copyright            : (C) 2005 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   GStreamer plugin that scales our yuv picture with a bilinear          *
 *   scaling algorithm, using code from the MLT project                    *
 *                                                                         *
 ***************************************************************************/


#ifndef _th_yuvscale_h_included_
#define _th_yuvscale_h_included_

#include <gst/gst.h>

/* pixops structs */
typedef struct _PixopsFilter PixopsFilter;
typedef struct _PixopsFilterDimension PixopsFilterDimension;

struct _PixopsFilterDimension
{
  gint     n;
  gdouble  offset;
  gdouble *weights;
};

struct _PixopsFilter
{
  PixopsFilterDimension x;
  PixopsFilterDimension y;
};

typedef void (*PixopsProcessFunc) (guchar         *dest_buf,
                                   int             dest_width,
                                   int             dest_height,
                                   int             dest_rowstride,
                                   const guchar   *src_buf,
                                   int             src_width,
                                   int             src_height,
                                   int             src_rowstride,
                                   gdouble         scale_x,
                                   gdouble         scale_y,
                                   int            *filter_weights);


#define TH_TYPE_YUVSCALE          (th_yuvscale_get_type())
#define TH_YUVSCALE(obj)          (G_TYPE_CHECK_INSTANCE_CAST((obj),TH_TYPE_YUVSCALE,ThYuvScale))
#define TH_YUVSCALE_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST((klass),TH_TYPE_YUVSCALE,ThYuvScale))
#define TH_IS_YUVSCALE(obj)       (G_TYPE_CHECK_INSTANCE_TYPE((obj),TH_TYPE_YUVSCALE))
#define TH_IS_YUVSCALE_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE((klass),TH_TYPE_YUVSCALE))

typedef struct _ThYuvScale       ThYuvScale;
typedef struct _ThYuvScaleClass  ThYuvScaleClass;

struct _ThYuvScale 
{
	GstElement element;

	GstPad   *sinkpad, *srcpad;

	/* video state */
	gboolean   inited;

	gint       to_width;
	gint       to_height;
	
	gint       from_width;
	gint       from_height;

	PixopsProcessFunc  process_func; /* NULL if the generic function is to be used */  
  PixopsFilter       filter;
	gint              *filter_weights;
	gdouble            scale_x;
	gdouble            scale_y;
	
	gboolean   passthru;
	gfloat     framerate;

	/* private */
	gint       from_buf_size;
	gint       to_buf_size;
};

struct _ThYuvScaleClass 
{
  GstElementClass element_class;
};

GType         th_yuvscale_get_type (void) G_GNUC_CONST;

#endif /* _th_yuvscale_h_included_ */
