/***************************************************************************
                            th-device-tracker.h
                            -------------------
    begin                : Thu Oct 14 2004
    copyright            : (C) 2004 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _th_device_tracker_h_included_
#define _th_device_tracker_h_included_

#include <libhal.h>
#include <glib-object.h>

#include <dbus/dbus-glib-lowlevel.h>
/* dbus-glib >= 0.30 */
#ifdef DBUS_TYPE_PENDING_CALL
# define USE_NEW_DBUS_HAL_API
# warning ****************************************************************
# warning *
# warning *  It seems like you are using dbus >= 0.30 and hal >= 0.5.0
# warning *
# warning *  Please be advised that this code has not been tested with
# warning *   this configuration yet, it has just been fixed to compile.
# warning *
# warning *  Please let me know whether DVD drive detection works on
# warning *   your system, and please do send the log as well (so I
# warning *   can see whether the drives were actually detected via
# warning *   HAL or using the backup methods). Thanks!
# warning *
# warning ****************************************************************
#endif

#ifdef USE_NEW_DBUS_HAL_API
# define hal_ctx_get_user_data(ctx)                  libhal_ctx_get_user_data(ctx)
# define hal_ctx_set_user_data(ctx,user_data)        libhal_ctx_set_user_data(ctx,user_data)
# define hal_device_exists(ctx,udi)                  libhal_device_exists(ctx,udi,NULL)
# define hal_device_property_exists(ctx,udi,key)     libhal_device_property_exists(ctx,udi,key,NULL)
# define hal_device_get_property_string(ctx,udi,key) libhal_device_get_property_string(ctx,udi,key,NULL)
# define hal_device_get_property_uint64(ctx,udi,key) libhal_device_get_property_uint64(ctx,udi,key,NULL)
# define hal_device_get_property_bool(ctx,udi,key)   libhal_device_get_property_bool(ctx,udi,key,NULL)
# define hal_device_query_capability(ctx,udi,key)    libhal_device_query_capability(ctx,udi,key,NULL)
# define hal_free_string(s)                          libhal_free_string(s)
# define hal_free_string_array(str_arr)              libhal_free_string_array(str_arr)
# define hal_get_all_devices(ctx,p_num_devices)      libhal_get_all_devices(ctx,p_num_devices,NULL)
# define DBUS_INTERFACE_ORG_FREEDESKTOP_LOCAL        DBUS_INTERFACE_LOCAL
#endif

#define TH_TYPE_DEVICE_TRACKER            (th_device_tracker_get_type ())
#define TH_DEVICE_TRACKER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TH_TYPE_DEVICE_TRACKER, ThDeviceTracker))
#define TH_IS_DEVICE_TRACKER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TH_TYPE_DEVICE_TRACKER))
#define TH_DEVICE_TRACKER_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TH_TYPE_DEVICE_TRACKER, ThDeviceTrackerIface))

typedef struct _ThDeviceTracker      ThDeviceTracker;       /* dummy typedef */
typedef struct _ThDeviceTrackerIface ThDeviceTrackerIface;

struct _ThDeviceTrackerIface
{
	GTypeInterface  g_iface;
	
	/* vfFuncs */
	void          (*set_context)    (ThDeviceTracker *tracker, LibHalContext *ctx);
	
	void          (*device_added)   (ThDeviceTracker *tracker, const gchar *udi);
	
	void          (*device_removed) (ThDeviceTracker *tracker, const gchar *udi);
	
	void          (*new_cap)        (ThDeviceTracker *tracker, const gchar *udi, const gchar *cap);
	
	void          (*lost_cap)       (ThDeviceTracker *tracker, const gchar *udi, const gchar *cap);
	
	void          (*prop_mod)       (ThDeviceTracker *tracker, 
	                                 const gchar     *udi, 
	                                 const gchar     *prop, 
	                                 gboolean         is_removed, 
	                                 gboolean         is_added);
	
#ifndef USE_NEW_DBUS_HAL_API

	void          (*dev_condition)  (ThDeviceTracker *tracker, 
	                                 const gchar     *udi, 
	                                 const gchar     *cond_name,
	                                 DBusMessage     *msg);
#else

	void          (*dev_condition)  (ThDeviceTracker *tracker, 
	                                 const gchar     *udi, 
	                                 const gchar     *cond_name,
	                                 const gchar     *cond_detail);

#endif /* USE_NEW_DBUS_HAL_API */
};

GType th_device_tracker_get_type       (void) G_GNUC_CONST;

void  th_device_tracker_set_context    (ThDeviceTracker *tracker, 
	                                      LibHalContext   *ctx);
	
void  th_device_tracker_device_added   (ThDeviceTracker *tracker, 
	                                      const gchar     *udi);
	
void  th_device_tracker_device_removed (ThDeviceTracker *tracker, 
	                                      const gchar     *udi);
	
void  th_device_tracker_new_cap        (ThDeviceTracker *tracker, 
	                                      const gchar     *udi, 
	                                      const gchar     *cap);
	
void  th_device_tracker_lost_cap       (ThDeviceTracker *tracker, 
	                                      const gchar     *udi, 
	                                      const gchar     *cap);
	
void  th_device_tracker_prop_mod       (ThDeviceTracker *tracker, 
	                                      const gchar     *udi, 
	                                      const gchar     *prop, 
	                                      gboolean         is_removed, 
	                                      gboolean         is_added);
	
#ifndef USE_NEW_DBUS_HAL_API

void  th_device_tracker_dev_condition  (ThDeviceTracker *tracker, 
	                                      const gchar     *udi, 
	                                      const gchar     *cond_name,
	                                      DBusMessage     *msg);
#else

void  th_device_tracker_dev_condition  (ThDeviceTracker *tracker, 
	                                      const gchar     *udi, 
	                                      const gchar     *cond_name,
	                                      const gchar     *cond_detail);

#endif /* USE_NEW_DBUS_HAL_API */

#endif /* _th_device_tracker_h_included_ */

