/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2014 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PDBSTATS_SEEN
#define PDBSTATS_SEEN

#include "pdbMalloc.h"

void
CheckVars(CdsArray *cdsA);

void
CalcDf(CdsArray *cdsA);

double
VarianceCds(CdsArray *cdsA);

double
VarianceCdsNu(CdsArray *cdsA);

void
WriteTransformations(CdsArray *cdsA, char *outfile_name);

void
Bfacts2PrVars(CdsArray *cdsA, int coord);

double
CalcPRMSD(CdsArray *cdsA);

double
CalcMLRMSD(CdsArray *cdsA);

double
SqrCdsDist(const Cds *cds1, const int atom1,
           const Cds *cds2, const int atom2);

double
SqrCdsDistMahal2(const Cds *cds1, const int atom1,
                 const Cds *cds2, const int atom2,
                 const double weight);

void
CalcNormResiduals(CdsArray *cdsA);

void
CalcNormResidualsLS(CdsArray *cdsA);

double
FrobTerm(CdsArray *cdsA);

double
CalcMgLogLCov(CdsArray *cdsA);

double
CalcMgLogL(CdsArray *cdsA);

double
CalcParamNum(CdsArray *cdsA);

void
CalcVar(CdsArray *cdsA);

double
TrCdsInnerProd(Cds *cds, const int len);

double
TrCdsInnerProdWt(Cds *cds, const int len, const double *w);

double
TrCdsInnerProd2(Cds *cds1, Cds *cds2, const int len);

double
TrCdsInnerProdWt2(Cds *cds1, Cds *cds2, const int len, const double *w);

void
UnbiasMean(CdsArray *scratchA);

void
CalcStats(CdsArray *incdsA);

void
CalcPreStats(CdsArray *cdsA);

#endif
