/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2009 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef MULTIPOSE_SEEN
#define MULTIPOSE_SEEN

#include "Coords.h"

void
SuperPose2Anchor(CoordsArray *scratchA, CoordsArray *baseA, char *anchorf_name);

void
CalcTranslationsIp(CoordsArray *scratchA, Algorithm *algo);

double
CalcRotations(CoordsArray *cdsA);

double
CalcScaleFactorsML(CoordsArray *cdsA);

double
CalcScaleFactorsMLConstr(CoordsArray *cdsA);

double
CalcScaleFactorsMLLogNorm(CoordsArray *cdsA);

double
CalcScaleFactorsML2(CoordsArray *cdsA);

double
CalcScaleFactorsMLGoodall(CoordsArray *cdsA);

double
CalcScaleFactors(CoordsArray *cdsA);

void
ScaleCoordsArray(CoordsArray *cdsA);

int
CheckConvergenceInner(CoordsArray *cdsA, const double precision);

int
CheckConvergenceOuter(CoordsArray *cdsA, int round, const double precision);

double
SuperPoseArray2Orig(CoordsArray *cdsA, CoordsArray *targetA, double *sumdev);

void
HierarchVars(CoordsArray *cdsA);

void
LedoitWolfShrinkVar(CoordsArray *cdsA, int method);

void
LedoitWolfShrinkCov(CoordsArray *cdsA, int method);

int
MultiPose_pth(CoordsArray *baseA);

int
MultiPose(CoordsArray *baseA);

void
RotPrincAxes(CoordsArray *cdsA);

void
SuperJack(CoordsArray *baseA);

void
CalcWts(CoordsArray *cdsA);

void
CalcWtsFinal(CoordsArray *cdsA);

double
SuperPose(Coords *coords1, Coords *coords2, double **rotmat, double *trans,
          double *, double *, double *);

#endif
